USE master;
GO

CREATE DATABASE DB_INDEX
GO

USE DB_INDEX
GO

CREATE TABLE T_SERVICE_SRV
(
	SRV_ID            smallint IDENTITY(1,1) NOT NULL PRIMARY KEY,
	SRV_LIBELLE       varchar(36) NULL
);

SET IDENTITY_INSERT T_SERVICE_SRV ON;
INSERT INTO T_SERVICE_SRV (SRV_ID, SRV_LIBELLE) VALUES 
(1,	'Commercial'),
(2,	'Comptabilit'),
(3,	'Direction'),
(4,	'Entretien'),
(5,	'Marketing'),
(6,	'Production'),
(7,	'RH');
SET IDENTITY_INSERT T_SERVICE_SRV OFF;

CREATE TABLE dbo.T_SEX
(
	SEX_ID            smallint IDENTITY(1,1) NOT NULL PRIMARY KEY,
	SEX_LIBELLE       char(5) NOT NULL
);

SET IDENTITY_INSERT T_SEX ON;
INSERT INTO T_SEX (SEX_ID, SEX_LIBELLE) VALUES 
(1,	'Femme'),
(2,	'Homme');
SET IDENTITY_INSERT T_SEX OFF;

CREATE TABLE T_EMPLOYEE_EMP
(
	EMP_ID            int IDENTITY(1,1) NOT NULL PRIMARY KEY,
	EMP_NOM           char(32) NOT NULL,
	EMP_PRENOM        varchar(25) NULL,
	EMP_TITRE         char(8) NULL,
	EMP_ADRESSE1      varchar(38) NULL,
	EMP_ADRESSE2      varchar(38) NULL,
	EMP_ADRESSE3      varchar(38) NULL,
	EMP_CP            char(8) NULL,
	EMP_VILLE         varchar(32) NULL,
	EMP_TEL           char(20) NULL,
	EMP_GSM           char(20) NULL,
	EMP_DATE_ENTREE   datetime NULL,
	EMP_INDICE        float NULL,
	EMP_SALAIRE       int NULL,
	EMP_MATRICULE     uniqueidentifier NULL DEFAULT (newid()),
    SRV_ID            SMALLINT NULL REFERENCES T_SERVICE_SRV (SRV_ID),
    SEX_ID            SMALLINT NULL REFERENCES T_SEX (SEX_ID)
);
GO

SET DATEFORMAT YMD;
SET IDENTITY_INSERT T_EMPLOYEE_EMP ON;
INSERT INTO T_EMPLOYEE_EMP (EMP_ID, EMP_NOM, EMP_PRENOM, EMP_TITRE, EMP_ADRESSE1, EMP_ADRESSE2, EMP_ADRESSE3, EMP_CP, EMP_VILLE, EMP_TEL, EMP_GSM, EMP_DATE_ENTREE, EMP_INDICE, EMP_SALAIRE, EMP_MATRICULE, SRV_ID, SEX_ID) VALUES
(1, 'CHABAUD', 'Daniel', 'M.', '8 Rue Sophie Germain', NULL, NULL, '83990', 'SAINT TROPEZ', '03-67-91-92-88', '03-83-18-53-63', '1947-07-30 00:00:00.000', 0.0703981, 20800, '77CE754F-1762-4DCD-9775-444A7D33EB53', 6, 2),
(2, 'BAILLY', 'Jean-Franois', 'M.', '198 Rue de Guise', NULL, NULL, '75001', 'PARIS', '05-57-75-70-22', '05-37-41-72-73', '1947-04-07 00:00:00.000', 0.174587, 21100, 'C7B1B212-AD20-4BFE-9C83-F65726767321', 6, 2),
(3, 'FAYOLLE', 'Olivier', 'M.', '1 Rue de l''Arme Patton', NULL, NULL, '75006', 'PARIS', '03-52-47-65-45', '03-12-28-10-01', '1957-09-11 00:00:00.000', 0.385781, 4000, 'FC96E21F-FCDB-46AF-B1BF-4AE16F779321', 6, 2),
(4, 'COCINO', 'Grard', 'M.', 'Rue Victor Laugier', NULL, NULL, '28130', 'PIERRES', '01-80-84-68-77', '01-56-20-13-53', '1952-09-06 00:00:00.000', NULL, 16200, '5D2C580A-5DA1-4F58-84AD-BFD94331D907', 6, 2),
(5, 'FRANQUINET', 'Florent', 'M.', '34 Rue Sainte Anne', NULL, NULL, '06000', 'NICE', '01-29-00-64-89', '01-80-24-49-76', '1955-02-20 00:00:00.000', 0.906727, 23700, '8443BA5B-FC80-4085-8B18-0EBC18A1811F', 7, 2),
(6, 'MALATERRE', 'Arnaud', 'M.', '3 Rue Crbillon', NULL, NULL, '75009', 'PARIS', '04-65-30-80-42', '04-39-81-94-01', '1969-09-29 00:00:00.000', 0.509682, 16600, '2BBA9FAA-C41D-49D6-BEF1-CBB0C01FC016', 6, 2),
(7, 'MDARD', 'Jacques', 'M.', '1 Place de l''Ancienne Mairie', NULL, NULL, '17300', 'ROCHEFORT', '01-57-18-76-96', '01-00-82-93-53', '1942-08-18 00:00:00.000', 0.903911, NULL, '2074CF9A-35E7-4FC1-9A43-71C5CDED7E9D', 6, 2),
(8, 'AUZENAT', 'Michel', 'M.', '23 Rue Meyerbeer', NULL, NULL, '75018', 'PARIS', '03-68-38-27-87', '03-83-38-36-69', '1952-04-05 00:00:00.000', 0.349174, 1500, '16EEBC53-1143-4A47-9387-6A8A64FBBAE4', 6, 2),
(9, 'CHTCHEPINE', 'Dominique', 'M.', '19 Rue de Lige', NULL, NULL, '75005', 'PARIS', '03-97-97-36-65', '03-33-06-80-49', '1933-07-18 00:00:00.000', 0.154876, 19400, '3C44AECA-D235-4CBF-A7E5-2A70D47214E9', 6, 2),
(10, 'LE GUILLARD', 'Alain', 'M.', '53 Rue du Docteur Peltier', NULL, NULL, '75011', 'PARIS', '00-24-68-47-60', '00-42-98-16-91', '1958-12-17 00:00:00.000', 0.963045, 1100, '3077A01A-170E-4B69-8AA4-18B97B35E47C', 6, 2),
(11, 'GARREAU', 'Paul', 'M.', '19 Rue Damrmont', NULL, NULL, '75014', 'PARIS', '02-82-83-90-04', '02-39-39-54-46', '1934-07-04 00:00:00.000', 0.191483, 8500, '3768CF5E-F78B-4AE8-A250-3F595936FDEA', 6, 2),
(12, 'LECUYER', 'Lionel', 'M.', '22 Rue du Pot de Fer', NULL, NULL, '35400', 'SAINT MALO', '03-22-76-99-53', '03-23-93-21-79', '1953-02-14 00:00:00.000', 0.157692, 13200, '67EF2FE9-8915-4AAA-B3FD-4CB32C272CE6', 4, 2),
(13, 'PRA-LETTRY', 'Emmanuel', 'M.', '27 Bis Rue Godefroy Cavaignac', NULL, NULL, '44400', 'REZ', '02-56-43-28-46', '02-06-03-77-42', '1968-01-28 00:00:00.000', 0.802538, 11100, '3DDF5976-B88B-42B6-A86A-C695BB988262', 6, 2),
(14, 'SILLET', 'Jacques', 'M.', '77 Ter Rue de la Tombe Issoire', NULL, NULL, '38860', 'LES DEUX ALPES', '00-96-82-22-01', '00-16-16-45-72', '1942-01-20 00:00:00.000', 0.205562, 10700, '034BA83A-72CE-4AA2-B148-1164CE3264A0', 6, 2),
(15, 'TROLLAT', 'Herv', 'M.', '10 Rue Ville Ppin', NULL, NULL, '75017', 'PARIS', '01-56-94-18-03', '01-91-41-00-60', '1950-11-19 00:00:00.000', 0.349174, 1400, 'C7E117AD-DC6F-4CD3-A020-46FB783471CA', 6, 2),
(16, 'BOUCHET', 'Michel', 'M.', '99 Rue Aristide Briand', NULL, NULL, '07300', 'TOURNON', '01-05-30-97-28', '01-57-33-20-87', '1945-05-27 00:00:00.000', 0.87012, 21800, '70C88388-08E2-4098-ACFD-B1560089840E', 6, 2),
(17, 'LEBAILLIF', 'Christian', 'M.', 'Le Mas de Prgentil', NULL, NULL, '44620', 'LA MONTAGNE', '04-14-38-27-38', '04-44-19-73-62', '1955-01-17 00:00:00.000', 0.185851, 14700, '02129B64-20EB-4247-BFA8-0D19F541B7E5', 6, 2),
(18, 'DU HAUT CILLY', 'Guy', 'M.', '29 Rue Brochant', NULL, NULL, '14640', 'VILLERS SUR MER', '03-43-52-59-30', '03-81-21-09-34', '1937-02-06 00:00:00.000', 0.551921, 14500, 'F94A43DF-5118-4233-A566-2B0C7C8B54E3', 6, 2),
(19, 'GALLACIER', 'Nolle', 'Mme.', '18 Rue Marc Sauzet', NULL, NULL, '75008', 'PARIS', '05-33-82-83-96', '05-82-62-65-52', '1939-01-10 00:00:00.000', 0.349174, 14400, 'FF729354-6938-4F9F-A066-7A6210AAB8C7', 7, 1),
(20, 'PICOT', 'Dominique', 'M.', 'Centre Commercial des Grands', 'Prs', NULL, '35500', 'VITR', '02-52-49-31-52', '02-68-00-76-72', '1955-02-18 00:00:00.000', 0.664558, 22500, 'EB3FACC5-5926-495F-879A-6094F2BEF1CC', 6, 2),
(21, 'BEAUNEE', 'Pierre', 'M.', '28 Rue Marchal Foch', NULL, NULL, '31800', 'SAINT GAUDENS', '05-13-09-77-01', '05-03-25-96-93', '1910-04-11 00:00:00.000', 0.385781, 24700, '31E7D4A6-867A-4347-A0B5-DADB0890AE0F', 6, 2),
(22, 'VERNET', 'Daniel', 'M.', '7 Rue Roy', NULL, NULL, '91330', 'YERRES', '03-34-06-23-46', '03-34-77-58-58', '1947-08-07 00:00:00.000', 0.177403, NULL, 'B44B235D-0173-431E-B079-6544A3963B4C', 6, 2),
(23, 'ALBERT', 'Christian', 'M.', '7 Bd Saint Martin', NULL, NULL, '38630', 'LES AVENIRES', '04-41-94-00-99', '04-07-54-73-65', '1948-11-17 00:00:00.000', 0.15206, 20600, '390290F3-3E72-4C0F-AE84-47C09B56F68A', 6, 2),
(24, 'HESS', 'Lucette', 'Mme.', '10/12 Rue Thiers', NULL, NULL, '75014', 'PARIS', '00-59-19-45-72', '00-22-58-67-86', '1934-08-30 00:00:00.000', 0.909543, NULL, 'F2EA88D8-A7CF-42F0-AE80-E5046464A1FD', 6, 1),
(25, 'CHATON', 'Grard', 'M.', '56 Avenue Pasteur', NULL, NULL, '75006', 'PARIS', '02-96-15-97-85', '02-38-28-07-99', '1938-12-31 00:00:00.000', 0.737772, 7900, '52DCF6FA-D819-47DD-B65E-F0894E85F2FD', 6, 2),
(26, 'PLATONOFF', 'Philippe', 'M.', 'CURTILLE', NULL, NULL, '57000', 'METZ', '00-73-50-36-60', '00-59-88-01-14', '1960-03-29 00:00:00.000', 0.971493, 10100, '3FD04982-D7C5-4A46-ADBC-49311EC1FECE', 4, 2),
(27, 'LETERRIER', 'Monique', 'Mme.', '34 Rue Daguerre', NULL, NULL, '92411', 'COURBEVOIE CEDEX', '02-20-73-13-16', '02-06-77-73-56', '1945-08-26 00:00:00.000', 0.796906, NULL, '6121AE48-482E-4E38-9BA7-ED6FB6A37DF7', 6, 1),
(28, 'MONTEIL', 'Jean', 'M.', '5 Carrefour de l''Odon', NULL, NULL, '06400', 'CANNES', '00-16-00-47-27', '00-78-70-02-46', '1935-03-23 00:00:00.000', 0.50405, 0, 'EA987AAA-4595-43AC-921F-F2BE37141A86', 6, 2),
(29, 'SPITHAKIS', 'Jean-Paul', 'M.', '1 Avenue Foch', NULL, NULL, '31300', 'TOULOUSE', '03-06-92-64-58', '03-00-38-33-77', '1956-03-31 00:00:00.000', 0.0337911, 3200, 'BC1FD234-2CB3-4232-A912-0B99D27D8ACC', 6, 2),
(30, 'ORELL', 'Olivier', 'M.', '30 Rue Edith Cavell', NULL, NULL, '83000', 'TOULON', '04-13-89-76-65', '04-10-96-76-32', '1956-01-27 00:00:00.000', 0.673005, 6000, '880AA7E8-70B7-4B39-B6AE-CAE0AFEA86B6', 6, 2),
(31, 'MARTINET', 'Carmen', 'Mme.', '" Le Lrina " - 63 La Croisette', NULL, NULL, '33510', 'ANDERNOS', '00-45-29-25-43', '00-89-75-91-37', '1946-10-24 00:00:00.000', 0.0535025, 3800, 'FEBD0E42-1352-4A05-9BCD-8680E9DDBACE', 6, 1),
(32, 'RAY', 'Yannick', 'M.', '1 Rue du Pont Saint Pierre', NULL, NULL, '91720', 'MAISSE', '01-44-15-45-86', '01-76-96-33-82', '1939-12-20 00:00:00.000', 0.687085, 20700, '4BEA7C33-11FE-4DA4-8F25-F2469C3B5D7F', 6, 2),
(33, 'TARSAC', 'Ren', 'M.', '7 Rue Corneille', NULL, NULL, '71640', 'GIVRY', '03-12-26-04-58', '03-12-62-23-17', '1942-08-14 00:00:00.000', 0.185851, NULL, '69CC6912-644D-487E-96F8-D185EC311270', 1, 2),
(34, 'COULOMB', 'Renaud', 'M.', '192 Bd de la Rpublique', NULL, NULL, '92200', 'NEUILLY', '04-58-40-11-51', '04-68-43-44-75', '1963-01-01 00:00:00.000', 0.501234, 18600, '0856F905-C570-43C7-AB8E-919AD2E7155A', 6, 2),
(35, 'SAVY', 'Jean-Claude', 'M.', '55 Grande Rue', NULL, NULL, '83100', 'TOULON', '05-52-00-72-62', '05-71-95-99-45', '1942-10-03 00:00:00.000', 0, 16000, 'BD1AA05E-653C-4B04-A164-728D3367CC5F', 6, 2),
(36, 'DAVID', 'Jacqueline', 'Mme.', '16 Avenue de Mortires', NULL, NULL, '75016', 'PARIS', '02-65-97-67-91', '02-69-68-98-39', '1922-09-19 00:00:00.000', 0.121085, 20000, 'D63EE719-63E9-4030-A472-DD4C19F90F64', 6, 1),
(37, 'FORGEOT', 'Jean-Bernard', 'M.', '3 Rue du Gnral Henrion Bertier', NULL, NULL, '86000', 'POITIERS', '00-59-98-08-35', '00-61-13-29-11', '1949-09-13 00:00:00.000', 0.123901, 18600, '3AA3E81C-A0EA-49B7-ABE0-4485B7EE6BB5', 6, 2),
(38, 'BERGER', 'Jean-Pierre', 'M.', '1 Rue F. Pelloutier', NULL, NULL, '75116', 'PARIS', '01-48-64-38-29', '01-84-95-55-28', '1946-10-16 00:00:00.000', 0.889831, 6000, '62E862F9-7D0F-43D5-B3FA-BF116F3CB3D9', 6, 2),
(39, 'DOUBLET', 'Thierry', 'M.', '17 Avenue Thophile Gautier', NULL, NULL, '55000', 'BAR LE DUC', '01-73-71-41-56', '01-14-18-01-12', '1961-03-02 00:00:00.000', 0.416756, 24900, 'F1E7441E-5EF1-4514-8707-BE1C1383FC2A', 6, 2),
(40, 'MATHIEU', 'Grard', 'M.', '3 Rue Alsace-Lorraine', NULL, NULL, '83320', 'CARQUEIRANNE', '05-19-61-05-22', '05-18-77-14-70', '1940-02-24 00:00:00.000', 0.461811, 15000, '72C73735-FAB4-4745-BAF1-DAD02BDDFB93', 1, 2),
(41, 'MOURGUES', 'Jacqueline', 'Mme.', 'C/O RICHARD ELLIS', '28/32 Avenue Victor Hugo', NULL, '92600', 'ASNIERES', '02-63-04-33-73', '02-31-52-86-63', '1953-01-14 00:00:00.000', 0.73214, 10700, '62FD30E8-968D-437B-B490-B1A5C5BC5279', 6, 1),
(42, 'PIERROT', 'Robert', 'M.', '103 Bd de la Rochelle', NULL, NULL, '11370', 'PORT LEUCATE', '02-63-48-18-70', '02-06-27-73-92', '1933-02-11 00:00:00.000', 0.447732, 800, '208A7F1E-9705-411A-ACF8-B3300DB77A6E', 6, 2),
(43, 'FRANQUEBALME', 'Daniel', 'M.', 'Port des Salettes', NULL, NULL, '02000', 'LAON', '01-62-72-70-31', '01-35-17-46-47', '1929-08-31 00:00:00.000', 0.602607, NULL, 'B0431590-51B5-44B2-9E06-6E9D3A7C8F6A', 6, 2),
(44, 'ZAMPIERO', 'Annick', 'Mme.', '36 Rue Bapst', NULL, NULL, '13410', 'LAMBESC', '02-89-25-41-38', '02-83-85-83-86', '1945-01-19 00:00:00.000', 0.988389, 22900, '17206F9A-7A7C-4A08-8CEA-E6859EED1745', 6, 1),
(45, 'PASCOT', 'Vincent', 'M.', 'Centre Commercial Aphrodite', 'Village - Lot 956', NULL, '97400', 'SAINT DENIS', '02-91-71-77-82', '02-64-13-27-00', NULL, 0.332279, 6500, '9F5A27C7-7D04-4FCB-B2A2-A1EE0D9B27C2', 6, 2),
(46, 'MECHRI', 'Pierre', 'M.', '6 Avenue Carnot', NULL, NULL, '93200', 'SAINT DENIS', '00-75-36-74-60', '00-04-61-20-83', '1950-08-11 00:00:00.000', 0.309751, NULL, 'E4374472-F508-40EC-A807-86F7F047FBA8', 6, 2),
(47, 'THIERY', 'Fathy', 'M.', '14 Route d''Aix', NULL, NULL, '75001', 'PARIS', '02-56-23-75-48', '02-21-20-92-33', '1950-02-19 00:00:00.000', 0.861672, 21800, '10DF12EF-D398-4750-92BC-68B157AF06CF', 5, 2),
(48, 'ROURE', 'Marie-Louise', 'Mme.', '140 Rue Jean Chatel', NULL, NULL, '59800', 'LILLE', '04-02-10-81-21', '04-14-70-74-06', '1938-01-04 00:00:00.000', 0.456179, 5500, 'F4BBAEC7-1EE2-4CA8-B279-A93B65D02E33', 6, 1),
(49, 'VILLE', 'Jean-Paul', 'M.', '42 Bd Jules Guesde', NULL, NULL, '69007', 'LYON', '05-15-91-63-33', '05-74-03-61-61', '1956-09-13 00:00:00.000', 0.749035, 18200, 'BD240A4F-685D-42D8-8E58-16907CD19B6B', 6, 2),
(50, 'NOCENTINI', 'Alain', 'M.', '14 Rue de Richelieu', NULL, NULL, '75015', 'PARIS', '00-65-41-48-09', '00-77-53-44-14', '1945-01-22 00:00:00.000', 0.481523, 1200, '26456752-578E-4AA1-9AB3-90FDFE576B8C', 6, 2),
(51, 'LAYANI', 'Lionel', 'M.', '194 Bis Rue de Solfrino', NULL, NULL, '06400', 'CANNES', '05-32-11-87-45', '05-48-85-32-17', '1964-05-18 00:00:00.000', 0.622319, 10100, '9E0FE8E5-270D-4E3A-A1D0-17D383500DE6', 6, 2),
(52, 'RECHUL', 'Jacques', 'M.', '266 Rue de Crqui', NULL, NULL, '31000', 'TOULOUSE', '00-11-59-84-79', '00-90-97-50-45', '1932-04-20 00:00:00.000', 0.264697, 5100, '7FCF543C-697C-40B5-AE2A-F2186ACD33CB', 6, 2),
(53, 'DE CONINCK', 'Patricia', 'Mme.', '15 Rue Franois Mouthon', NULL, NULL, '95670', 'MARLY LA VILLE', '03-06-49-05-50', '03-81-74-30-21', '1957-10-13 00:00:00.000', 0.588528, 13000, '5D085CCD-4246-4F62-A29A-66C14ED1C564', 6, 1),
(54, 'LEI', 'Alain', 'M.', '46 Rue d''Antibes', NULL, NULL, '34920', 'LE CRES', '02-61-68-82-53', '02-29-88-96-88', '1956-07-30 00:00:00.000', 0.363254, 7100, 'E682E63D-782E-4E4B-9C24-7AAF5FF8B5E7', 2, 2),
(55, 'MICHEL', 'Fernand', 'M.', '22 Rue Maurice Fonvielle', NULL, NULL, '75008', 'PARIS', '02-84-73-58-01', '02-05-46-94-83', '1936-11-04 00:00:00.000', 0.0901095, 18600, '8D9C575F-F84B-40C9-8894-B1B84FCEF271', 6, 2),
(56, 'BOURA', 'Andr', 'M.', '139 Avenue Henri Barbusse', NULL, NULL, '13005', 'MARSEILLE', '04-15-95-40-17', '04-57-80-46-21', '1953-07-07 00:00:00.000', 0.168955, 9300, '6600CEDB-5836-491D-AE1F-77F3DEF93D5D', 6, 2),
(57, 'CARDONA', 'Philippe', 'M.', '8 Rue Joseph Reboul', NULL, NULL, '75116', 'PARIS', '01-05-24-96-82', '01-95-73-46-24', '1957-12-30 00:00:00.000', 0.630767, 1900, '615DDB45-BDBC-4465-BA4E-152CBACD93E6', 6, 2),
(58, 'THOMASSE', 'Jean-Claude', 'M.', '112 Bd Haussmann', NULL, NULL, '34000', 'MONTPELLIER', '03-67-18-23-33', '03-05-35-03-88', '1961-09-05 00:00:00.000', 0.194299, 2300, 'FB35230E-3408-42EF-A9E2-724706620FB1', 6, 2),
(59, 'MOURIES', 'Nathalie', 'Mme.', '122 Rue Ferrari', NULL, NULL, '61000', 'ALENCON', '04-58-66-29-73', '04-83-15-21-90', '1966-04-24 00:00:00.000', 0.726508, 1400, 'F455A3F9-2BBE-46AF-B933-F62A5101937B', 6, 1),
(60, 'MARTIN', 'Jean-Pierre', 'M.', '66 Avenue Klber', NULL, NULL, '94500', 'CHAMPIGNY SUR MARNE', '01-94-38-00-31', '01-49-58-62-09', '1956-01-01 00:00:00.000', 0.0337911, 18600, '57B25D8F-D33C-4597-A110-A580A5306D24', 6, 2),
(61, 'BENZAQUI', 'Jol', 'M.', '14 Rue Andr Michel', NULL, NULL, '49300', 'CHOLET', '03-81-45-10-54', '03-35-04-87-47', '1953-01-08 00:00:00.000', 0.0112637, 19500, '11D9FBAC-F040-4DC9-978D-71C8B69A1D3D', 1, 2),
(62, 'ROUSSILLON', 'Alain', 'M.', '5 Rue des Tisons', NULL, NULL, '75008', 'PARIS', '05-34-61-55-28', '05-77-96-17-25', '1958-12-23 00:00:00.000', 0.937702, 4700, 'E41F7235-3956-4D6F-AF9A-3688D87444F5', 6, 2),
(63, 'FARGETTON', 'Denis', 'M.', '71 Bd de Stalingrad', NULL, NULL, '16300', 'BARBEZIEUX', '02-43-71-13-03', '02-88-07-72-20', '1940-03-19 00:00:00.000', 0.340727, 17300, 'F8876C2D-FF49-4345-BC76-18D345A39E87', 6, 2),
(64, 'LEPERCQ', 'Jean-Claude', 'M.', '62 Rue Nationale', NULL, NULL, '45390', 'PUISEAUX', '03-73-96-97-28', '03-73-67-85-91', '1942-10-16 00:00:00.000', 0.0422388, 14900, 'C1B4FB14-392B-47A9-9CEA-F11336892690', 6, 2),
(65, 'OLIVI', 'Hubert', 'M.', '101 Rue de Miromesnil', NULL, NULL, '02600', 'VILLERS COTTERETS', '00-02-00-07-66', '00-92-10-63-66', '1939-11-16 00:00:00.000', 0.481523, 4900, '1CE462C9-2F87-4A2C-BE9A-F86D5A728F64', 6, 2),
(66, 'CASTAREDE', 'Jean-Jacques', 'M.', '46 Rue Victor Hugo', NULL, NULL, '31000', 'TOULOUSE', '05-48-21-06-23', '05-38-05-82-08', '1962-03-31 00:00:00.000', 0.546289, 18600, '24FC3E10-756A-4F8D-AC5A-B2C08444B4D4', 6, 2),
(67, 'LOTARD', 'Jean-Paul', 'M.', '3 Rue de Paris', NULL, NULL, '33000', 'BORDEAUX', '02-49-13-94-67', '02-35-68-36-53', '1945-10-29 00:00:00.000', 0.901095, 24400, 'FD9EAC47-C5AF-434D-B841-F8A4D41353FD', 6, 2),
(68, 'LALANDE', 'Colette', 'Mme.', '4 Rue Alexandre Dumas', NULL, NULL, '31320', 'CASTANET TOLOSAN', '01-37-64-22-29', '01-18-02-56-05', '1948-03-15 00:00:00.000', 0.920807, 20800, 'B0AD4614-CC5F-47F5-90A5-8F92BA852104', 1, 1),
(69, 'BAVEREL', 'Frdric', 'M.', '44 Rue Bayard', NULL, NULL, '74440', 'TANINGES', '02-01-34-41-32', '02-49-26-42-93', '1961-09-25 00:00:00.000', 0.948966, 21800, 'E84810D9-6FB8-4218-A2A1-F63322276399', 6, 2),
(70, 'NOEL', 'Rgis', 'M.', '39 Rue Tastet', NULL, NULL, '21700', 'NUITS SAINT GEORGES', '05-92-25-71-99', '05-38-35-74-11', '1939-08-25 00:00:00.000', 0.478707, NULL, '0524FB74-E45A-435A-97EE-E12B9068AE34', 6, 2),
(71, 'THIRIOT', 'Jacky', 'M.', '8 Rue Georges Vallerey', NULL, NULL, '54890', 'CHAMBLAY', '00-90-36-84-72', '00-94-04-84-81', '1945-03-23 00:00:00.000', 0.799722, 6900, 'C63D2840-A34B-4187-83B6-F9FDE5CEA60F', 6, 2),
(72, 'BERTRAND', 'Christophe', 'M.', 'Rsidence Le Pralyseen', 'LE PRAZ DE LYS', NULL, '81000', 'ALBI', '05-38-86-95-96', '05-21-89-80-76', '1963-05-20 00:00:00.000', 0.591344, 2100, '7AA1470B-7B3C-422A-A6BB-B10CD37336A7', 6, 2),
(73, 'BACQU', 'Michel', 'M.', '5 Rue Sonoys', NULL, NULL, '94120', 'FONTENAY SOUS BOIS', '03-62-29-11-79', '03-86-03-28-45', '1940-07-27 00:00:00.000', 0.225274, 13400, 'E0FE701D-8370-46C6-A421-D5A7064FD603', 6, 2),
(74, 'COUASSE', 'Franois', 'M.', '13 Rue de la Gare', NULL, NULL, '21000', 'DIJON', '01-85-40-82-39', '01-24-89-58-72', '1930-06-14 00:00:00.000', 0.177403, 16100, '10C5A3ED-1B61-4C1F-B4B7-9B7F084A638B', 6, 2),
(75, 'JOLY', 'Christophe', 'M.', '29 Lices Georges Pompidou', NULL, NULL, '75116', 'PARIS', '00-19-42-48-72', '00-81-40-30-47', '1959-07-17 00:00:00.000', 0.073214, 6900, 'A545E9C3-056A-4476-A03A-9812B9ABC80C', 5, 2),
(76, 'BENATTAR', 'Pierre', 'M.', '23 Rue Mauconseil', NULL, NULL, '81300', 'GRAULHET', '00-33-66-02-72', '00-19-33-28-91', '1964-07-17 00:00:00.000', 0.27596, 7200, '673EAB55-DB4F-4253-B0BF-1E9F26A90A82', 6, 2),
(77, 'VOILQUIN', 'Michle', 'Mme.', '16 Rue du Chteau', NULL, NULL, '75007', 'PARIS', '05-64-11-43-24', '05-84-88-76-45', '1949-08-20 00:00:00.000', 0.239353, NULL, '821B8E90-268C-4C8C-A8F3-155488501DE8', 6, 1),
(78, 'LEAL', 'Jany', 'Mme.', '20 Rue Lonard de Vinci', NULL, NULL, '75015', 'PARIS', '00-29-14-39-85', '00-13-19-60-54', '1949-11-18 00:00:00.000', 0.827881, 500, '44872DCB-9493-451C-8688-D5081CDEE5C6', 6, 1),
(79, 'BENATTAR', 'Bernard', 'M.', '60 Place du Jourdain', NULL, NULL, '26000', 'VALENCE', '05-62-72-88-74', '05-68-07-38-04', '1970-02-15 00:00:00.000', 0.0506866, 21400, '924C0AA4-508B-4D94-B8BF-77906081631D', 6, 2),
(80, 'AIACH', 'Alexandre', 'M.', '11 Rue Surcouf', NULL, NULL, '75015', 'PARIS', '02-87-05-59-06', '02-91-23-09-85', '1963-11-23 00:00:00.000', 0.687085, 12500, 'FDA73DE6-4689-44F2-9ADB-10F8A77B6279', 6, 2),
(81, 'GAL', 'Fabrice', 'M.', '41/43 Rue de Cronstadt', NULL, NULL, '75003', 'PARIS', '02-92-59-78-33', '02-55-40-66-41', '1958-02-16 00:00:00.000', 0.126716, 16200, '1DE3EB43-3E5B-49BA-84AC-98ADB3CA0285', 6, 2),
(82, 'CHAMBON', 'Edith', 'Mme.', 'Passage de l''Ourcq', NULL, NULL, '06300', 'NICE', '02-87-77-44-70', '02-94-01-13-48', '1959-04-11 00:00:00.000', 0.675821, 14000, '18F36F04-746D-4FF7-A3D4-DD7710A9A53F', 2, 1),
(83, 'DUQUESNAY', 'Jacques', 'M.', '54 Rue de la Convention', NULL, NULL, '63000', 'CLERMONT FERRAND', '00-37-28-16-83', '00-17-41-07-57', '1945-01-23 00:00:00.000', 0.740588, 7900, '29E7B84B-EC11-4AA9-AEC0-8BFD2734BD79', 6, 2),
(84, 'CHEVALLIER-CHANTEPIE', 'Yans', 'M.', '20 Rue des Francs Bourgeois', NULL, NULL, '97200', 'FORT DE FRANCE', '05-72-07-71-31', '05-04-38-54-41', '1949-10-20 00:00:00.000', 0.419572, 16900, '518A7B4F-6FE9-49ED-B43D-6F977E94B9E3', 6, 2),
(85, 'JEAN', 'Henri', 'M.', '7 Quai des Deux Emmanuel', NULL, NULL, '03150', 'SAINT GERAND LE PUY', '05-32-63-80-81', '05-04-74-47-90', '1943-08-17 00:00:00.000', 0.799722, NULL, '685EA9A9-742F-4213-8825-FF156585814A', 6, 2),
(86, 'TRIERWEILER', 'Anita', 'Mme.', '122 Bd Lavoisier', NULL, NULL, '91480', 'VARENNES JARCY', '01-00-13-22-08', '01-22-45-88-56', '1956-11-03 00:00:00.000', 0.960229, 8200, 'D74370CE-4D50-4231-8D25-E8C7CC11DA5D', 6, 1),
(87, 'GRANDJEAN', 'Yves', 'M.', 'Croix de Bellevue', NULL, NULL, '84160', 'CUCURON', '02-77-85-66-38', '02-70-21-62-30', '1952-04-12 00:00:00.000', 0.242169, 15500, 'FC83B9A4-1FC9-492D-96DC-A7BA632E20B7', 6, 2),
(88, 'BLESTEL', 'Graldine', 'Mme.', 'LE PRAT', NULL, NULL, '69006', 'LYON', '05-64-32-30-31', '05-53-47-48-62', '1966-01-09 00:00:00.000', 0.0703981, 4600, '8BE74EA7-7566-42B1-8E74-22FA723DE930', 6, 1),
(89, 'COULON', 'Christian', 'M.', 'La Grande Ferme', NULL, NULL, '06800', 'CAGNES SUR MER', '00-83-28-36-89', '00-17-12-01-28', '1956-11-27 00:00:00.000', 0.143612, 9800, '32D97ED1-CDC9-4948-9A28-322CB9A563C3', 3, 2),
(90, 'GERAUD', 'Stphane', 'M.', 'Rue du Moulin  Huile', NULL, NULL, '75017', 'PARIS', '00-27-69-06-13', '00-07-95-83-15', '1966-05-12 00:00:00.000', 0.858856, 400, '5079C8BC-C2DE-4ABF-9527-EB87E9A55536', 6, 2),
(91, 'HARARI', 'Christiane', 'Mme.', '7 Bd des Brotteaux', NULL, NULL, '43000', 'LE PUY EN VELAY', '00-05-07-60-72', '00-33-63-30-92', NULL, 0.577264, 2900, '26542987-FB08-4F9E-BF4F-5304D0D6FF8C', 6, 1),
(92, 'OFFRANC', 'Max', 'M.', '33 Bd Marchal Juin', NULL, NULL, '06800', 'CAGNES SUR MER', '00-15-86-88-66', '00-68-73-16-27', '1938-05-19 00:00:00.000', 0.965861, 11100, 'FF2D6DA5-AE45-4408-A95D-31020DF27894', 6, 2),
(93, 'GRIMA', 'Claude', 'M.', '23 Rue Nollet', NULL, NULL, '97122', 'BAIE MAHAULT', '04-18-19-15-88', '04-81-89-71-54', '1964-11-02 00:00:00.000', 0.754667, 13800, 'D85911A9-899C-49A5-BA87-50ECC1E5F10B', 6, 2),
(94, 'DUSSAULT', 'Anne', 'Mme.', '29 Bis Bd Carnot', NULL, NULL, '80000', 'AMIENS', '03-14-08-16-52', '03-96-22-99-33', '1956-03-31 00:00:00.000', 0.278776, 12500, 'E932D56C-3103-464E-B13E-BE5191264AE1', 6, 1),
(95, 'POUQUET', 'Janine', 'Mme.', '32 Bd Marchal Juin', NULL, NULL, '92190', 'MEUDON', '00-08-25-41-31', '00-50-69-38-41', '1937-08-22 00:00:00.000', 0.0337911, NULL, '33B7D6BA-3FF4-43C4-8C72-D883A6D13978', 6, 1),
(96, 'HOMERY', 'Philippe', 'M.', '1 Rue Ferdinand Forest', NULL, NULL, '07100', 'ANNONAY', '04-16-88-95-11', '04-56-11-42-21', '1943-07-03 00:00:00.000', 0.323831, 9100, '4C3B2086-8374-40BF-ADE1-198D032A2621', 7, 2),
(97, 'PATIENT', 'Henry', 'M.', '72 Rue des Jacobins', NULL, NULL, '75002', 'PARIS', '05-51-11-42-44', '05-02-30-95-47', '1932-11-01 00:00:00.000', 0.0647662, 6200, 'AC9E359A-7FA0-47E4-9B6D-9F27808BC2F5', 6, 2),
(98, 'BERTHET', 'Grard', 'M.', '24 Place Henri Brousse', NULL, NULL, '97300', 'CAYENNE', '03-63-71-71-68', '03-29-48-02-98', '1947-11-08 00:00:00.000', 0.391413, 22900, '38695318-BA92-45FC-939A-4D8C87D8B894', 6, 2),
(99, 'MARC', 'Claude', 'M.', '4 Place de la Libert', NULL, NULL, '30000', 'NIMES', '00-65-91-56-32', '00-69-74-71-36', '1947-03-14 00:00:00.000', 0.225274, 18900, '79E751DE-AA7F-476C-8144-5097B6728493', 6, 2),
(100, 'MAUREL', 'Olivier', 'M.', '22 Rue Dalayrac', NULL, NULL, '39220', 'PRMANON', '01-88-17-77-81', '01-59-60-11-19', '1963-08-17 00:00:00.000', 0.315383, NULL, '9CD7517A-360A-4E20-A3CE-B58F392B0508', 6, 2),
(101, 'BRUNEL', 'Franoise', 'Mme.', 'Immeuble Guran', '7 Rue Samuel Lubin', NULL, '31000', 'TOULOUSE', '00-63-53-65-12', '00-89-81-06-33', '1952-05-04 00:00:00.000', 0.630767, 5100, 'CB49CC8C-D3B8-44A6-96CE-FB274E2293BF', 6, 1),
(102, 'MARTIN', 'Alain', 'M.', '1 Place du March', NULL, NULL, '30000', 'NIMES', '05-45-42-25-92', '05-00-56-29-07', '1958-04-11 00:00:00.000', 0, 15100, 'CD1790C0-A4D6-4A9D-B682-94C6710EF0DF', 6, 2),
(103, 'DUPREZ', 'Dominique', 'M.', 'Rue de la Croix de la Teffe', NULL, NULL, '13160', 'CHATEAURENARD EN PROVENCE', '00-57-44-08-26', '00-02-58-68-87', '1943-04-04 00:00:00.000', 0.715244, 12600, '9BDB92B9-7888-4D35-91B7-1F1EFEED13C6', 4, 2),
(104, 'LECOMTE-SWETCHINE', 'Pascal', 'M.', '2 Rue Alexandre Fourtanier', NULL, NULL, '74400', 'CHAMONIX', '04-38-11-15-11', '04-03-78-51-80', '1954-09-07 00:00:00.000', 0.281592, 6500, '941DB05B-CD0B-48A0-80CA-4A0810F4968C', 6, 2),
(105, 'BOUCHARD', 'Didier', 'M.', '3 Rue Saint Castor', NULL, NULL, '92100', 'BOULOGNE', '02-29-59-91-60', '02-11-80-07-87', '1943-02-25 00:00:00.000', 0.0281592, 7100, '1A6744A6-7D2C-44AE-89D8-6DC5131F08F9', 6, 2),
(106, 'PFISTER', 'Vronique', 'Mme.', '4 Place Victoire', NULL, NULL, '14470', 'COURSEULLES SUR MER', '02-29-93-33-37', '02-49-19-45-45', '1962-11-12 00:00:00.000', 0.929254, 17700, '3821CC2A-8EE8-4D0D-BB0A-2DD15A573E49', 6, 1),
(107, 'CSUTOROS', 'Paul', 'M.', '305 Rue Joseph Vallot', NULL, NULL, '75008', 'PARIS', '02-56-61-09-01', '02-21-64-18-63', '1939-12-15 00:00:00.000', 0.999652, 16100, '09D2E3E3-585B-47EE-B1DC-EF217206A798', 6, 2),
(108, 'PLOUVIER', 'Jean-Claude', 'M.', '79 Bis Rue Marcel Dassault', NULL, NULL, '35330', 'MAURE DE BRETAGNE', '02-24-80-45-12', '02-91-36-71-50', NULL, 0.281592, 24400, '88C92770-3FA6-4EB2-9FFD-42C96C634617', 6, 2),
(109, 'MOUSSAY', 'Franoise', 'Mme.', '13 Place du March', NULL, NULL, '75008', 'PARIS', '04-77-65-67-04', '04-55-42-78-33', '1933-01-27 00:00:00.000', 0.349174, 10200, 'D2E7399E-DCCE-4FEF-969E-945544F98129', 6, 1),
(110, 'SAPIEN', 'Nicole', 'Mme.', '50 Avenue des Champs lyses', NULL, NULL, '14000', 'CAEN', '03-09-31-70-20', '03-31-23-12-65', '1948-11-01 00:00:00.000', 0.588528, 24000, 'FB107EC4-B568-45C9-B6C9-6F8A87BC52AB', 7, 1),
(111, 'GAILLARD', 'Philippe', 'M.', '68 Rue de Guer', NULL, NULL, '75003', 'PARIS', '04-54-52-37-33', '04-88-93-91-63', '1946-04-20 00:00:00.000', 0.988389, 14100, '72828BB4-F964-484C-9BD9-F584B485DA3F', 6, 2),
(112, 'FAVREUX', 'Xavier', 'M.', '51 Rue d''Amsterdam', NULL, NULL, '75012', 'PARIS', '02-02-43-05-15', '02-53-00-35-80', '1963-07-21 00:00:00.000', 0.523762, 21800, '2F260258-4068-4438-9E40-540F7A42C1A7', 6, 2),
(113, 'DUBOSQ', 'Vronique', 'Mme.', '4 Rue Saint-Michel', NULL, NULL, '80000', 'AMIENS', '00-30-60-24-71', '00-39-10-04-38', '1959-06-16 00:00:00.000', 0.822249, 2600, '22B24FDA-F431-462E-BCAB-51D70209CABC', 6, 1),
(114, 'CHEVALLIER', 'Robert', 'M.', '16 Rue du Parc Royal', NULL, NULL, '02000', 'LAON', '03-45-75-67-60', '03-47-45-85-63', '1948-09-14 00:00:00.000', 0.0872936, 24000, '9BAF2D36-7370-45B1-9174-76CD815E1F8B', 6, 2),
(115, 'MORET', 'Didier', 'M.', '250 Rue de Charenton', NULL, NULL, '92290', 'CHATENAY MALABRY', '04-78-09-27-70', '04-17-51-15-50', NULL, 0.191483, 1000, '9621AAA3-7E39-4C36-A9AC-E8E5A57CC5FB', 6, 2),
(116, 'BLOC', 'Vianney', 'M.', '22 Rue des Jacobins', NULL, NULL, '75011', 'PARIS', '00-43-73-47-39', '00-01-47-61-42', '1970-04-13 00:00:00.000', 0.101373, 3100, '74927EF4-F04E-4634-984D-BBF18367BFF7', 6, 2),
(117, 'NEYRET', 'Patrice', 'M.', '7 Bd Pierre Brossolette', NULL, NULL, '75007', 'PARIS', '05-44-79-71-43', '05-20-98-12-29', '1949-06-10 00:00:00.000', 0.185851, 19000, '32C4F86A-5B1F-473B-B03B-8AADBA1A986C', 4, 2),
(118, 'LE BRAS', 'Patrick', 'M.', '7 Centrale Parc', NULL, NULL, '38000', 'GRENOBLE', '04-27-51-47-56', '04-29-95-49-96', '1937-12-13 00:00:00.000', 0.0535025, 15400, 'C138FB53-F513-4766-BE22-58D14A3D32D7', 6, 2),
(119, 'BOYER', 'Patrick', 'M.', '127 Rue de la Roquette', NULL, NULL, '95240', 'CORMEILLES EN PARISIS', '01-92-05-86-14', '01-20-84-05-49', '1948-08-20 00:00:00.000', 0.833513, NULL, 'EA5077C0-2C44-4A95-8E07-518DB09D6FD5', 6, 2),
(120, 'BLANCHE', 'Evelyne', 'Mme.', '23 Rue Vaneau', NULL, NULL, '92400', 'COURBEVOIE', '04-93-26-01-22', '04-71-24-31-70', '1944-08-02 00:00:00.000', 0.692717, NULL, '87B234DE-2FF7-412A-84F0-5E53D85039EF', 6, 1),
(121, 'DE LA RIVIERE', 'Bernard', 'M.', '5 Rue Lesdiguires', NULL, NULL, '73550', 'MERIBEL LES ALLUES', '01-05-58-40-85', '01-36-41-73-92', '1957-05-24 00:00:00.000', 0.0422388, 22600, '11554BCD-BB38-48B9-B291-025F81A0B483', 6, 2),
(122, 'LUGLI', 'Ghislaine', 'Mme.', '14 Bd Clmenceau', NULL, NULL, '33120', 'ARCACHON', '01-25-00-88-90', '01-56-11-70-60', '1956-07-23 00:00:00.000', 0.456179, 14700, '5A8D87C4-39DB-43ED-9477-609553381F5B', 6, 1),
(123, 'PONS', 'Jacques', 'M.', '3 Rue Madiraa', NULL, NULL, '80100', 'ABBEVILLE', '00-89-68-82-52', '00-48-39-44-10', '1946-03-11 00:00:00.000', 0.948966, 18100, '1EBE7729-5E5F-4A85-9222-89CDDD749353', 6, 2),
(124, 'MEGLIO', 'Vronique', 'Mme.', 'Rsidence Le Merylis', NULL, NULL, '31000', 'TOULOUSE', '01-32-16-49-80', '01-89-45-77-09', '1958-07-18 00:00:00.000', 0.712428, 11300, '92223BDB-8FE7-4D9F-98A1-43468051226F', 1, 1),
(125, 'AYMES', 'Ren', 'M.', '332 Bd de la Plage', NULL, NULL, '75011', 'PARIS', '01-66-22-24-08', '01-96-31-75-18', '1925-12-19 00:00:00.000', 0.453363, 7100, '82F00778-B400-4385-A534-82E9F6A60386', 6, 2),
(126, 'CANESSA', 'Michel', 'M.', '31 Rsidence Saint Gilles', NULL, NULL, '84000', 'AVIGNON', '05-67-42-32-17', '05-72-18-63-60', '1946-09-29 00:00:00.000', 0.284408, 11300, 'F7E432D5-561E-4BD4-9363-27DC8CCAA599', 6, 2),
(127, 'GOLLNISCH', 'Andr', 'M.', '2 Avenue Paul Sjourn', NULL, NULL, '83000', 'TOULON', '05-04-76-18-14', '05-49-28-31-83', '1937-12-29 00:00:00.000', 0.763115, 19300, 'DA921F65-D3CE-4865-A0AA-6A71B5260898', 6, 2),
(128, 'FRANCOITE', 'Patrick', 'M.', '95 Rue de Montreuil', NULL, NULL, '69002', 'LYON', '01-81-55-74-74', '01-11-79-47-30', '1945-01-10 00:00:00.000', 0.51813, 4200, '917264C3-622A-4E96-BE15-7194EC25261C', 6, 2),
(129, 'DEMAINE', 'Philippe', 'M.', '6 Rue Frdric Mistral', NULL, NULL, '31600', 'EAUNES', '04-65-25-20-52', '04-24-65-20-71', '1966-07-07 00:00:00.000', 0.337911, 20100, 'F7EC535C-250A-4C55-84FB-ECE4C085EDDB', 6, 2),
(130, 'MORAS', 'Bernard', 'M.', '351 Avenue de la Rpublique', NULL, NULL, '18000', 'BOURGES', '00-38-68-43-90', '00-32-23-74-22', '1944-05-04 00:00:00.000', 0.839145, 10800, '7769B310-3F19-4E7C-A8EA-DECAB07C4B27', 6, 2),
(131, 'THIOLLET', 'Jean-Marie', 'M.', '3 Rue Poulaillerie', NULL, NULL, '24000', 'PRIGUEUX', '00-64-01-68-99', '00-08-33-87-26', '1951-07-28 00:00:00.000', 0.174587, 23000, 'F3E59E42-36AB-4F77-B75F-199DFA48A52B', 1, 2),
(132, 'BONNAUD', 'Michel', 'M.', '420 Chemin de Cantalause', NULL, NULL, '83700', 'SAINT RAPHAEL', '05-94-72-07-81', '05-53-91-52-36', '1943-01-09 00:00:00.000', 0.751851, 18900, '2C2CA615-BFE2-4901-AC47-6E89FAE6198F', 6, 2),
(133, 'GAC', 'Jacques', 'M.', '3 Rue Barbs', NULL, NULL, '75008', 'PARIS', '04-14-42-41-16', '04-54-13-04-57', '1952-03-04 00:00:00.000', 0.104189, 24400, '67749064-F78C-4FE7-9420-ED4FC70DAD35', 6, 2),
(134, 'BULIT', 'Rosette', 'Mme.', '12 Rue Gambetta', NULL, NULL, '95470', 'EZANVILLE', '03-16-45-29-96', '03-82-64-60-06', '1932-07-12 00:00:00.000', 0.318199, 7000, 'ACF6255F-4ABE-4AF3-9DEE-0A9216400212', 6, 1),
(135, 'BOULAY', 'Arlette', 'Mme.', '14 Rue Henri Vadon', NULL, NULL, '47000', 'AGEN', '05-39-99-48-61', '05-46-13-72-04', '1941-05-13 00:00:00.000', 0.315383, 2700, 'B1561D8A-37D9-4DB1-A1A8-367693A95F9F', 6, 1),
(136, 'DRAHONNET', 'Laurent', 'M.', '58 Rue de l''Arcade', NULL, NULL, '92110', 'CLICHY', '05-05-68-19-60', '05-29-81-60-63', '1962-04-23 00:00:00.000', 0.0337911, 20400, '65FE004A-479D-4CC6-BC08-4C4F95C66998', 6, 2),
(137, 'BERNARD', 'Christian', 'M.', '14 Grande Rue', NULL, NULL, '94140', 'ALFORTVILLE', '03-95-10-63-35', '03-52-29-90-16', '1953-03-26 00:00:00.000', 0.709612, 4100, 'DC10CC67-D580-491E-974C-9C6A88796887', 6, 2),
(138, 'BARBERA', 'Huguette', 'Mme.', 'Place Pelletan', NULL, NULL, '75017', 'PARIS', '04-28-56-60-19', '04-20-42-59-57', '1938-12-04 00:00:00.000', 0.819433, 11600, 'CE1DA3A5-963F-4894-8E8B-0F29A43243B9', 5, 1),
(139, 'HOLL', 'Lucien', 'M.', '110 Bd Jean Jaurs', NULL, NULL, '06000', 'NICE', '02-16-18-90-16', '02-95-51-43-70', '1960-09-13 00:00:00.000', 0.036607, 10100, '4EB69078-93E9-4F4C-B5BD-642C89E31141', 6, 2),
(140, 'LANNOYE', 'Gabrielle', 'Mme.', '130 Rue Paul Vaillant Couturier', NULL, NULL, '69003', 'LYON', '01-91-68-73-57', '01-09-57-82-76', '1935-02-18 00:00:00.000', 0.751851, 19400, '81F9015A-D065-4400-B123-212EE8BFF417', 6, 1),
(141, 'KRUG', 'Philippe', 'M.', '35 Rue Henri Rochefort', NULL, NULL, '95520', 'OSNY', '05-43-83-04-56', '05-93-71-36-77', '1949-08-05 00:00:00.000', 0.292856, NULL, '5B287BAB-6E98-409E-BB78-5A2EA5F5FD2C', 6, 2),
(142, 'DI GALANTE', 'Francis', 'M.', '30 Rue Htel des Postes', NULL, NULL, '68100', 'MULHOUSE', '01-00-78-73-09', '01-97-20-06-56', '1936-05-13 00:00:00.000', 0.822249, 13500, 'C4567DC3-7BC1-469E-8FD4-DB90B54E4035', 6, 2),
(143, 'BANCAL', 'Odette', 'Mme.', '9 Rue Antoine Laviolette', NULL, NULL, '30300', 'BEAUCAIRE', '01-30-35-25-82', '01-29-88-71-64', '1955-08-14 00:00:00.000', 0.211194, NULL, '311EF926-B8E9-408D-B8C4-74E5FAD1F99E', 6, 1),
(144, 'CHARDONNET', 'Pierre-Louis', 'M.', '10 Chausse Jules Csar', NULL, NULL, '06400', 'CANNES', '04-87-21-28-37', '04-24-53-83-71', '1944-11-05 00:00:00.000', 0.93207, 10400, '261FAA6F-1504-48B6-97CA-C00FF71B7859', 6, 2),
(145, 'MARCHESE', 'Jean', 'M.', '46 Rue des Trois Rois', NULL, NULL, '64100', 'BAYONNE', '05-15-29-59-78', NULL, '1943-11-29 00:00:00.000', 0.191483, 18600, '0B21F38A-97D5-4123-B49D-1A903F6ACB3D', 2, 2),
(146, 'DUCROT', 'Lydia', 'Mme.', '27 Bd du Marchal Foch', NULL, NULL, '97400', 'SAINT DENIS', '00-12-79-56-00', '00-44-81-60-53', '1938-01-20 00:00:00.000', 0.611055, 13000, '332DA35B-DBD1-44C2-8DA7-64258E386E1D', 6, 1),
(147, 'ROCHE', 'Herv', 'M.', 'Le Gray d''Albion', '17 La Croisette', NULL, '75017', 'PARIS', '05-93-52-09-19', '05-59-04-91-68', '1943-09-22 00:00:00.000', 0.774379, 13000, '19A9AA21-7A33-4768-B0D2-13C70D1984FD', 6, 2),
(148, 'PROUILLAC', 'Herv', 'M.', '" Espace Rive Gauche "', '66 Alle des Marines', NULL, '87430', 'VERNEUIL SUR VIENNE', '03-91-85-71-33', '03-59-89-20-91', '1952-09-25 00:00:00.000', 0.0844777, 10100, '65930BFD-2A9E-4D8E-A7E9-947EFFF9D689', 6, 2),
(149, 'BASTIDE', 'Philippe', 'M.', 'Immeuble Arc en Ciel', 'Angle des Rues Ruisseau des', 'Noirs et de Caen', '92100', 'BOULOGNE', '04-07-76-26-84', '04-23-16-61-88', '1953-04-06 00:00:00.000', 0.582896, 1000, '3D33B519-6DE3-4098-9644-9C8DD7EDBBF9', 6, 2),
(150, 'TIMSIT', 'Jean-Maurice', 'M.', '47 Rue Navier', '107 Quai des tats Unis', NULL, '06300', 'NICE', '04-31-95-63-44', '04-30-79-22-44', '1953-03-17 00:00:00.000', 0.706796, 24600, '3CC77D28-3F04-46AD-BEB1-0211F4676AC2', 6, 2),
(151, 'CORDEZ', 'Andr', 'M.', '" Les Places "', NULL, NULL, '75018', 'PARIS', '04-01-21-68-06', '04-70-56-94-43', '1931-01-01 00:00:00.000', 0.917991, 1800, 'E07F67C6-59C4-4C23-91B2-D1BF689F31B3', 6, 2),
(152, 'BISMUTH', 'Ccile', 'Mme.', '6 Villa Pauline', NULL, NULL, '75019', 'PARIS', '04-44-14-38-12', '04-86-58-18-32', '1949-10-26 00:00:00.000', 0.0844777, 3100, '0F29E6F9-3B88-4D38-9C09-EAFE727FAC58', 1, 1),
(153, 'JACQUEMIN', 'Joseph', 'M.', 'Rsidence Le Beau Rivage', NULL, NULL, '75008', 'PARIS', '01-80-20-85-96', '01-22-09-33-85', '1956-04-22 00:00:00.000', 0.318199, 17400, '6912F1C1-B5C5-46D8-9797-5FC6A7103D4A', 6, 2),
(154, 'SMADJA', 'Pascal', 'M.', '20 Rue de la Fontaine du But', NULL, NULL, '02000', 'LAON', '02-90-51-84-90', '02-91-28-74-05', '1961-04-16 00:00:00.000', 0.0112637, 7400, '110859B0-ECA9-4ABB-BCE7-D9A23D5F9DEB', 6, 2),
(155, 'ENDERS', 'Max', 'M.', '37 Rue Miguel Hidalgo', NULL, NULL, '75016', 'PARIS', '01-57-70-30-84', '01-91-51-83-53', '1932-10-25 00:00:00.000', 0.250617, 18100, 'D3EC0B7F-A81B-4188-91C7-46A336473DAA', 6, 2),
(156, 'TOURNIEROUX', 'Sylvie', 'Mme.', '102 Rue du Faubourg Saint Honor', NULL, NULL, '75015', 'PARIS', '05-94-96-96-01', '05-95-96-07-43', '1945-04-23 00:00:00.000', 0.701165, 1100, '5755B2CC-6A5D-4966-B78E-CFFF9C66F59D', 6, 1),
(157, 'ARNALDI', 'Hubert', 'M.', '87 Rue Pasteur', NULL, NULL, '87000', 'LIMOGES', '05-68-25-22-71', '05-16-49-65-48', '1952-06-06 00:00:00.000', 0.487155, 10100, '5A4EB0D8-0EDA-42C1-9B4A-74E96D3C6D01', 6, 2),
(158, 'MERCIER', 'Josette', 'Mme.', '85 Rue Chardon Lagache', NULL, NULL, '83000', 'TOULON', '03-98-02-67-87', '03-50-88-06-37', '1945-03-16 00:00:00.000', 0.0760299, 4800, '9A4C9427-BD51-4B79-8C41-5ED0F7731988', 6, 1),
(159, 'BAILLARD', 'Laurence', 'Mme.', '56 Place Saint Charles', NULL, NULL, '75015', 'PARIS', '03-66-87-28-37', '03-43-01-81-58', '1951-03-22 00:00:00.000', 0.501234, 3600, '09A40B04-0C9C-4814-905C-9451CF69681E', 1, 1),
(160, 'BORDES', 'Jean-Luc', 'M.', '22 Bd Gambetta', NULL, NULL, '21000', 'DIJON', '05-33-07-22-77', '05-39-06-78-77', '1956-09-26 00:00:00.000', 0.242169, 10200, '5F86DBEB-E76A-4DBD-85A7-533DFE286E6D', 6, 2),
(161, 'APPERE', 'Jean-Louis', 'M.', 'L''Imprator I', '40 Avenue Franois Cuzin', NULL, '06400', 'CANNES', '04-48-61-18-20', '04-74-89-48-25', '1936-11-07 00:00:00.000', 0.0563184, 2100, '74DE3EA1-6643-44A9-B19B-31D10C1C7C0E', 6, 2),
(162, 'DANTARD', 'Loc', 'M.', '41/43 Rue de Constadt', NULL, NULL, '29200', 'BREST', '05-40-58-62-19', '05-36-88-49-32', '1964-01-13 00:00:00.000', 0.115453, 1300, '5344D166-C740-4845-BF49-36BFCF0173C7', 6, 2),
(163, 'RIMBERT', 'Marc', 'M.', '5/7 Rue Monge', NULL, NULL, '75008', 'PARIS', '01-20-43-21-46', '01-96-15-89-84', '1948-07-03 00:00:00.000', 0.647662, 2800, 'F3AD6921-73AB-47D9-935F-7385E2E4EBC4', 6, 2),
(164, 'ILJINE', 'Jean-Pierre', 'M.', '39 Avenue du Roi Albert', 'Rsidence Hinata', NULL, '95120', 'ERMONT', '01-98-08-23-11', '01-90-10-34-41', '1944-12-09 00:00:00.000', 0.143612, 19000, '98D85790-B5CB-4CF2-8819-F1CBD74C59A3', 6, 2),
(165, 'BOUTEMY', 'Vra', 'Mme.', '28 Rue Monge', NULL, NULL, '75008', 'PARIS', '05-34-92-91-66', '05-98-71-80-95', '1912-07-05 00:00:00.000', 0.895463, 17500, 'E1922F8E-3F69-4AD1-B6A1-71A8D599AF13', 6, 1),
(166, 'POIROT', 'Jacques', 'M.', '38 Avenue Pierre 1 er de Serbie', NULL, NULL, '83360', 'PORT GRIMAUD', '04-96-84-09-82', '04-72-62-29-10', '1948-07-26 00:00:00.000', 0.326647, 21000, 'B8924312-B5DB-44F8-87A9-A4F7E30C41FF', 5, 2),
(167, 'MEUNIER', 'Grard', 'M.', '86 Rue du Gnral Leclerc', NULL, NULL, '94270', 'LE KREMLIN BICETRE', '00-46-65-85-24', '00-76-71-27-32', '1950-05-16 00:00:00.000', 0.763115, 800, '20E326A7-86F0-43C2-872C-04C581632A3F', 6, 2),
(168, 'BORIES', 'Franois', 'M.', '11 Rue de La Botie', NULL, NULL, '24360', 'PIGUT-PLUVIERS', '01-69-19-82-94', '01-31-73-05-80', '1947-07-30 00:00:00.000', 0.30412, 8200, 'E2BADFA2-176E-439D-B5E4-7B22232087EF', 6, 2),
(169, 'CHAMPETIER DE RIBES', 'Jean', 'M.', '1 Place des Artisans', NULL, NULL, '66160', 'LE BOULOU', '01-62-46-99-99', '01-65-75-71-94', '1922-02-17 00:00:00.000', 0.377334, 23900, '1611C6B9-053D-4F90-8454-D3CC9E3BEAD3', 6, 2),
(170, 'JEANMAIRE', 'Rosine', 'Mme.', '12 Bis Avenue du Docteur Lacroix', NULL, NULL, '75017', 'PARIS', '03-30-68-67-52', '03-94-24-31-68', '1950-09-18 00:00:00.000', 0.163323, 14700, '3256A387-B8DE-4E58-B238-76511B8BB103', 6, 1),
(171, 'LAURENT', 'Sophie', 'Mme.', '5 Place de la Rpublique', NULL, NULL, '77140', 'NEMOURS', '01-44-01-22-01', '01-08-53-88-62', '1966-03-28 00:00:00.000', 0.960229, 1700, '95804512-4511-4E4E-AF2D-8520E1344ABF', 6, 1),
(172, 'AMOROS', 'Bernard', 'M.', '28 Avenue du Gnral De Gaulle', NULL, NULL, '91100', 'CORBEIL ESSONNES', '00-91-57-72-02', '00-42-22-37-18', '1924-05-27 00:00:00.000', 0.287224, 16800, 'CC71D9FE-3A51-4109-9FF7-522E63C8E536', 6, 2),
(173, 'SEYNE', 'Jos', 'M.', '12 Rue Brmontier', NULL, NULL, '75009', 'PARIS', '05-87-27-10-88', '05-82-20-63-18', '1951-06-07 00:00:00.000', 0.0703981, 19700, '97EF13A6-0D23-4510-934D-10BA50DB3258', 2, 2),
(174, 'ROSSET', 'Jean-Claude', 'M.', '29 Rue des Tanneurs', NULL, NULL, '30900', 'NIMES', '02-25-86-96-93', '02-58-01-14-53', '1942-04-12 00:00:00.000', 0.388597, 24900, '4E1963DC-E058-42E4-A975-0E62D622F0BF', 6, 2),
(175, 'HUCKEL', 'Stphan', 'M.', '92 Bd Henri Dunant', NULL, NULL, '75008', 'PARIS', '04-74-41-64-70', '04-94-82-59-56', '1954-04-13 00:00:00.000', 0.402677, 13400, '84267D49-F231-4CDC-998C-C6D20B58DA90', 6, 2),
(176, 'BRIOT', 'Alexis', 'M.', '3 Rue Victor Mass', NULL, NULL, '67170', 'GEUDERTHEIM', NULL, '05-37-78-08-18', '1970-11-29 00:00:00.000', 0.0647662, 6900, 'E88F2D9A-5613-4DA2-B084-6135915AA0F8', 6, 2),
(177, 'CHAUVET', 'Sylvain', 'M.', '23 Avenue Jean Jaurs', NULL, NULL, '75008', 'PARIS', '01-77-67-08-67', '01-40-22-10-52', '1953-02-23 00:00:00.000', 0.0450548, 5900, 'A15B3CD8-ACF7-4042-B274-C5754605E8A2', 6, 2),
(178, 'LE MOEL', 'Paul', 'M.', '31 Place de la Madeleine', NULL, NULL, '05000', 'GAP', '05-98-34-04-76', '05-78-62-37-95', '1945-12-08 00:00:00.000', 0.771563, 20400, '304E4ED0-5BAB-4D72-A6F4-476A1CDA8091', 6, 2),
(179, 'BLAY', 'Yannick', 'M.', '10 Rue du Chteau d''Eau', NULL, NULL, '56100', 'LORIENT', '01-85-77-55-70', '01-18-60-93-15', '1942-06-17 00:00:00.000', 0.709612, 24200, '55BE3341-A0D9-45E9-BA47-C24C4909FD4D', 6, 2),
(180, 'GUTH', 'Jean-Louis', 'M.', '6 Avenue Franklin Roosevelt', NULL, NULL, '26600', 'TAIN L''HERMITAGE', '00-91-20-53-01', '00-66-22-63-99', '1958-05-02 00:00:00.000', 0.123901, 16900, '31868DBF-247F-4DAF-9EE5-90F805C8E7FD', 3, 2),
(181, 'POISSON', 'Lucien', 'M.', '36 Bis Rue Carnot', NULL, NULL, '67660', 'BETSCHDORF', '01-02-16-35-46', '01-92-52-94-45', '1939-10-14 00:00:00.000', 0.00844777, 7400, 'E2AD9500-380E-4A97-91E4-89C2BA3FC84A', 6, 2),
(182, 'AXELROUD', 'Jean-Paul', 'M.', '5 Rue du Marchal Foch', NULL, NULL, '61340', 'PRAUX DU PERCHE', '01-12-66-32-36', '01-97-63-88-12', '1939-08-22 00:00:00.000', 0.757483, NULL, '9EDE5B0A-9DD3-4245-A0C8-23C3E0629398', 6, 2),
(183, 'TONIOL', 'Patrick', 'M.', 'Place de la Rpublique', 'LA ROCHE DE GLUN', NULL, '67000', 'STRASBOURG', '04-44-98-44-46', '04-58-53-66-38', '1946-07-14 00:00:00.000', 0.765931, 7500, '7956E286-5ED9-4C09-ADB0-E8CDF9E7A390', 6, 2),
(184, 'LEMERLE', 'Christian', 'M.', '14 Rue Adelade', NULL, NULL, '31140', 'AUCAMVILLE', '02-86-68-79-19', '02-72-22-08-35', '1947-10-29 00:00:00.000', 0.15206, 11000, 'DFA57416-C8BF-4D63-8F2B-0455006EDC3D', 6, 2),
(185, 'ESCALIER', 'Henri', 'M.', 'Rue Alexandre Hubert', NULL, NULL, '97430', 'LE TAMPON', '00-19-64-99-05', '00-61-49-98-81', '1932-07-23 00:00:00.000', 0.802538, 16000, '848111E7-398B-40BA-8513-6D54A95AE538', 6, 2),
(186, 'KIM', 'Yves', 'M.', '22 Rue du Bain aux Plantes', NULL, NULL, '25000', 'BESANCON', '03-61-80-09-55', '03-82-81-42-59', '1955-08-06 00:00:00.000', 0.354806, NULL, 'C733C470-BF9D-45BA-BA27-2EBDCBE756CA', 6, 2),
(187, 'DELEGLISE', 'Laurent', 'M.', '31 Route de Fronton', NULL, NULL, '75013', 'PARIS', '00-55-39-79-35', '00-36-55-80-55', '1956-04-22 00:00:00.000', 0.219642, 13700, '2FD44783-AFFE-4C9F-8953-2158A81081D1', 7, 2),
(188, 'DU PARC', 'Huguette', 'Mme.', '217 Rue Jules Bertaut', NULL, NULL, '84100', 'ORANGE', '01-97-17-49-21', '01-92-46-20-27', '1940-10-03 00:00:00.000', 0.326647, 23400, 'DF6A0254-2BC3-438A-8795-B608636C92B1', 6, 1),
(189, 'GABILLAT', 'Robert', 'M.', '33 Grande Rue', NULL, NULL, '21000', 'DIJON', '01-96-98-01-90', '01-52-50-84-74', '1950-04-22 00:00:00.000', 0.27596, 400, 'A0BB6C02-F6E6-458C-A6C2-FE4DCA7BD4F5', 6, 2),
(190, 'BURGET', 'Jrme', 'M.', 'Tour Abeille', '23 Avenue d''Ivry', NULL, '69486', 'LYON CEDEX 03', '04-13-96-82-94', '04-75-51-74-43', '1955-04-15 00:00:00.000', 0.943334, 21300, '6CF006F3-AE34-4B40-AD7A-B73151C42D3B', 6, 2),
(191, 'CHAILLOUX', 'Lucien', 'M.', '52 Cours Aristide Briand', NULL, NULL, '68870', 'BARTENHEIM LA CHAUSSE', '02-09-27-60-85', NULL, '1938-07-27 00:00:00.000', 0.247801, 12800, 'CF952BEA-6F39-4F1D-A1D2-809A1EE38B27', 6, 2),
(192, 'BARAT-DUPONT', 'Thierry', 'M.', '19 Bd de Brosses', NULL, NULL, '17000', 'LA ROCHELLE', '04-48-07-45-64', '04-69-77-44-37', '1961-06-29 00:00:00.000', 0.763115, 15400, 'A45AD306-9CAE-4098-8E85-8B449B5F4E17', 6, 2),
(193, 'DUFRESNE', 'Paulin', 'M.', '21 Avenue Georges Pompidou', NULL, NULL, '75019', 'PARIS', '03-18-82-62-56', '03-24-74-21-36', '1922-01-28 00:00:00.000', 0.79409, 3800, 'CE371D1D-7277-4878-89E1-5B3707D16F25', 6, 2),
(194, 'GIRAUD', 'Vronique', 'Mme.', '36 Rue de la Libration', 'Le Danica B', NULL, '75008', 'PARIS', '00-24-86-42-89', '00-29-33-36-89', '1958-06-19 00:00:00.000', 0.450548, 19000, 'B87E9CF2-D75A-4872-B0F1-50F8ED63BEA1', 4, 1),
(195, 'CHEMINAT', 'Stphane', 'M.', '3 Rue du Temple', NULL, NULL, '73150', 'VAL D''ISERE', '00-08-69-65-58', '00-45-47-86-54', '1964-09-13 00:00:00.000', 0.230906, 8700, '625FC17D-EF7E-465E-B5D4-9FAA862913EF', 6, 2),
(196, 'QUATREMAIN', 'Paul', 'M.', '54 Bis Rue David d''Angers', NULL, NULL, '69009', 'LYON', '01-32-08-56-46', '01-94-88-77-74', '1947-01-28 00:00:00.000', 0.611055, 21400, 'F0C8B3EB-CBF0-4E83-AD5E-DCDA52A0765C', 6, 2),
(197, 'MAZEROLLE', 'Marie-Franoise', 'Mme.', '56 Rue de Courcelles', NULL, NULL, '75013', 'PARIS', NULL, '00-06-99-90-13', '1945-12-06 00:00:00.000', 0.658926, 6800, '5D89FEA5-DCDB-402C-92F5-50C2B99990E7', 6, 1),
(198, 'LAMBERT', 'Didier', 'M.', 'Le Dme', NULL, NULL, '75018', 'PARIS', '03-11-58-55-33', '03-02-81-61-17', '1955-02-15 00:00:00.000', 0.622319, 1100, '8F4233C2-E661-4DA1-9724-AE9C9B7E4B07', 6, 2),
(199, 'GALLEZOT', 'Michel', 'M.', '3 Rue de la Claire', NULL, NULL, '91530', 'LE VAL SAINT GERMAIN', '03-59-16-53-66', '03-96-77-49-30', '1936-10-20 00:00:00.000', 0.833513, 12300, 'E5FF38CB-5DCA-453E-978F-DC589C03B0A6', 6, 2),
(200, 'VALENCE', 'Yves', 'M.', '55 Rue de Tolbiac', NULL, NULL, '83136', 'MOUNES LES MONTRIEUX', '00-62-90-07-50', '00-49-00-13-52', '1946-08-30 00:00:00.000', 0.140796, NULL, '667E49EA-C85C-4B4C-B181-64D98EC41968', 6, 2),
(201, 'RIVIERE', 'Didier', 'M.', '81 Rue Lamarck', NULL, NULL, '78500', 'SARTROUVILLE', '00-46-87-75-86', '00-25-04-79-30', '1965-08-17 00:00:00.000', 0.892647, NULL, '64E2765C-D249-4BD0-BACE-6202F459A715', 7, 2),
(202, 'LEVY', 'Jean-Franois', 'M.', '66 Rue du Village', NULL, NULL, '97400', 'SAINT DENIS', '03-53-74-06-79', '03-65-32-70-95', '1958-07-20 00:00:00.000', 0.0675821, 17000, '5AEAF779-CAB1-443A-890B-01970399F6FB', 6, 2),
(203, 'MARTIN', 'Marc', 'M.', '11 Place de l''glise', NULL, NULL, '14100', 'LISIEUX', '02-12-19-87-93', '02-89-30-69-18', '1955-12-30 00:00:00.000', 0.211194, 24300, '530F1AD8-6A0B-4571-BE56-3F0FF6AE946C', 6, 2),
(204, 'LESAUVAGE', 'Thierry', 'M.', '54 Avenue Jean Jaurs', NULL, NULL, '35000', 'RENNES', '04-26-87-35-80', '04-84-94-40-85', '1958-10-27 00:00:00.000', 0.771563, 12000, '69DD5510-1916-4B7E-B04D-25B09E5D3A88', 6, 2),
(205, 'BROUD', 'Mireille', 'Mme.', '16 Ter Rue Jean Chatel', NULL, NULL, '38000', 'GRENOBLE', '05-36-80-24-05', '05-66-27-63-21', '1943-05-22 00:00:00.000', 0.585712, 20200, '379991EB-64A9-4F02-BFEC-FC03F77B5A00', 6, 1),
(206, 'AMBRIGOT', 'Bernard', 'M.', '22 Rue Henry Chron', NULL, NULL, '06600', 'ANTIBES', '04-46-48-46-24', '04-18-18-79-12', '1934-01-13 00:00:00.000', 0.729324, 200, 'C5D2595E-EC3E-4EB0-8B5F-23C5F03A48E5', 6, 2),
(207, 'DURAND', 'Ren', 'M.', '2 Rue d''Isly', NULL, NULL, '73000', 'CHAMBRY', '02-48-82-93-62', '02-40-11-51-55', NULL, 0.461811, NULL, 'C7B7141D-6DC6-440B-AEB2-97D3CD997D95', 6, 2),
(208, 'SABATHIER', 'Pierre-Louis', 'M.', '1 Cours Berriat', NULL, NULL, '92200', 'NEUILLY', '03-21-98-68-44', '03-97-74-70-69', '1961-10-13 00:00:00.000', 0.00281592, 9800, 'C220EDC4-0525-45BD-996A-6290F94382E9', 4, 2),
(209, 'POLIZZI', 'Michel', 'M.', '13 Bd Albert 1er', NULL, NULL, '33000', 'BORDEAUX', '01-26-68-12-46', '01-11-44-83-52', '1935-06-28 00:00:00.000', 0.354806, 23900, '12CA429F-3328-4A99-9729-3D595612C153', 6, 2),
(210, 'CHAMBEYRON', 'Antoine', 'M.', 'Le Clos Lemenc', '160 Avenue d''Aix', NULL, '30900', 'NIMES', '01-42-25-74-19', '01-08-54-76-47', '1950-10-23 00:00:00.000', 0.0535025, 10900, 'BD946445-E29C-4C27-A33F-97C6CA80B30E', 6, 2),
(211, 'LEROY', 'Georges', 'M.', '25 Rue de L''Eglise', NULL, NULL, '92300', 'LEVALLOIS PERRET', '01-91-79-70-27', '01-21-45-18-68', '1921-02-15 00:00:00.000', 0.909543, 24600, 'E55A3F2B-A437-4A43-A7E5-1F7AF569FA57', 6, 2),
(212, 'SAUBAT', 'Jean-Franois', 'M.', '56 Rue du Temps Pass', NULL, NULL, '92250', 'LA GARENNE COLOMBES', '03-22-06-98-45', '03-09-75-76-36', '1951-09-14 00:00:00.000', 0.0591344, 1300, '97170EA4-9160-4BC4-A9FD-7274746CE55B', 6, 2),
(213, 'SARTORI', 'Laurent', 'M.', '724 Avenue du Marchal Juin', NULL, NULL, '64000', 'PAU', '02-42-99-37-05', '02-98-75-29-41', '1969-10-11 00:00:00.000', 0.58008, 20000, '37C0FE74-E032-46D6-A554-4FA0E66F32D4', 6, 2),
(214, 'VAUTRIN', 'Marc', 'M.', '69 Rue Louise Michel', NULL, NULL, '75005', 'PARIS', '00-72-96-39-84', '00-83-95-19-12', '1959-07-26 00:00:00.000', 0.250617, 7600, 'DB54C025-69B2-4FAB-9FD2-00F475DB2977', 6, 2),
(215, 'NAZARIAN', 'Claude', 'M.', '12 Avenue Joseph Froment', NULL, NULL, '78600', 'LE MESNIL LE ROI', '01-48-84-82-09', '01-65-69-80-01', '1934-06-15 00:00:00.000', 0.0506866, 4000, '52C53F03-439B-42E5-B424-3315DDE209B3', 1, 2),
(216, 'PACAUD', 'Roger', 'M.', 'Rue Gachet', 'Palais des Pyrnes', NULL, '38350', 'LA MURE', '00-61-79-52-59', '00-93-68-54-17', '1950-08-13 00:00:00.000', 0.917991, NULL, '6E19BD4C-6D8A-4B77-A718-10A00E168B57', 6, 2),
(217, 'FABERES', 'Grard', 'M.', '16 Rue Larrey', NULL, NULL, '83300', 'DRAGUIGNAN', '00-84-24-71-79', '00-23-05-03-72', '1952-03-02 00:00:00.000', 0.273144, 900, 'B7225A34-430B-4E2D-917E-3F03BFCC1582', 6, 2),
(218, 'ROULLIN', 'Jean', 'M.', '42 Chemin de la Gravillire', NULL, NULL, '83000', 'TOULON', '05-13-64-30-49', '05-88-43-25-70', '1920-07-29 00:00:00.000', 0.889831, 3600, 'DFC28727-F0D7-46E1-941E-54AFD3769AB5', 6, 2),
(219, 'MAILLARD', 'Robert', 'M.', '15 Rue du Breuil', NULL, NULL, '83510', 'LORGUES', '00-35-99-91-03', '00-63-28-53-35', '1942-08-11 00:00:00.000', 0.960229, NULL, 'FA8D839B-1450-4CD2-97F8-0593E37B41D6', 6, 2),
(220, 'CLEMENT', 'Jean-Michel', 'M.', '20 Rue Labat', NULL, NULL, '54500', 'VANDOEUVRE LES NANCY', '02-50-86-54-13', '02-53-01-18-02', '1952-01-28 00:00:00.000', 0.726508, 10500, '9F5874DB-5145-4026-8BC8-117817ED0B75', 6, 2),
(221, 'FERRY', 'Jean-Luc', 'M.', '6 Rue Paulin Gurin', NULL, NULL, '54000', 'NANCY', '04-31-69-05-05', '04-04-97-35-89', NULL, 0.875752, 19100, '23A9CEDF-9DB4-47B5-AF1D-AD517876EFE5', 6, 2),
(222, 'DANIEL', 'Bruno', 'M.', '2618 Route de Draguignan', NULL, NULL, '77300', 'FONTAINEBLEAU', '01-18-38-55-23', '01-08-83-01-17', '1963-06-02 00:00:00.000', 0.430836, 900, '9DED34DB-4341-4BC3-A1B8-7D472D3313BC', 1, 2),
(223, 'RABANT', 'Pierre-Jean', 'M.', '3 Rue Jacquard', NULL, NULL, '88000', 'EPINAL', '02-52-17-35-63', '02-19-66-88-94', '1966-05-07 00:00:00.000', 0.923622, 12700, '5C4FB820-DE40-4CC4-9ED7-07604C6EE9A1', 6, 2),
(224, 'REBY', 'Pascal', 'M.', '101 Bd d''Haussonville', NULL, NULL, '92170', 'VANVES', NULL, '04-70-09-35-49', '1945-06-22 00:00:00.000', 0.281592, 14400, '75DD50B3-1825-410C-8FDB-CCEA459C1C0F', 6, 2),
(225, 'VERGNAUD', 'Michel', 'M.', '14 Rue de Montebello', NULL, NULL, '92150', 'SURESNES', '05-12-54-50-52', NULL, '1946-03-13 00:00:00.000', 0.306936, 14300, 'FEAD423D-E81B-4BD7-906E-B090BB6850F6', 6, 2),
(226, 'GOUELLAIN', 'Guy', 'M.', '9 Rue de la Comdie', NULL, NULL, '94500', 'CHAMPIGNY SUR MARNE', '03-67-84-14-61', '03-40-15-54-72', '1932-09-25 00:00:00.000', 0.0197115, 23400, 'EE94110B-70F4-4916-B0C7-343595350DEB', 6, 2),
(227, 'SENARD', 'Victor', 'M.', '56 Rue Jean Bleuzen', NULL, NULL, '95780', 'LA ROCHE GUYON', '00-72-39-90-29', '00-95-12-67-81', '1923-02-05 00:00:00.000', 0.109821, 10900, '052EE2DC-220A-4AFE-ACF9-C562602D08BC', 6, 2),
(228, 'IBERRAKEN', 'Patrick', 'M.', '5 Rue de Verdun', NULL, NULL, '75009', 'PARIS', '05-69-75-28-63', '05-77-42-02-12', '1950-08-24 00:00:00.000', 0.872936, NULL, '01C8E41C-3E8E-45F7-BF81-8AA2F7B61132', 6, 2),
(229, 'GENET', 'Jacqueline', 'Mme.', '131 Avenue du Gnral De Gaulle', NULL, NULL, '08000', 'CHARLEVILLE MZIERES', '05-73-13-52-09', NULL, '1943-01-11 00:00:00.000', 0.80817, 17100, '406CB9B8-1FEF-4E58-86F2-C4E58920292B', 5, 1),
(230, 'DUBREUIL', 'Eric', 'M.', '171 Route de la Valle Haute', 'Isle', NULL, '75008', 'PARIS', '03-34-15-79-00', '03-61-22-08-35', '1947-10-03 00:00:00.000', 0.48997, 9300, '54B5DB2E-FAE7-45E6-AD8A-1F0232938138', 6, 2),
(231, 'GOUACHE', 'Daniel', 'M.', '48 Rue Lafayette', NULL, NULL, '31400', 'TOULOUSE', '04-99-90-86-18', '04-19-05-92-97', '1953-06-12 00:00:00.000', 0.0788458, 10900, '1E04E656-344A-4A95-92EF-4A6C9C11E64F', 6, 2),
(232, 'DE PRAT', 'Michel', 'M.', '24 Rue de Mantoue', NULL, NULL, '75013', 'PARIS', '00-45-44-83-78', '00-59-75-15-24', '1957-12-04 00:00:00.000', 0.960229, 24800, '385DE77F-7C94-4A32-82E2-3FDB268B632F', 6, 2),
(233, 'CELSO', 'Bernard', 'M.', '14 Avenue Matignon', NULL, NULL, '75008', 'PARIS', '02-32-76-92-49', '02-95-27-68-89', '1933-09-27 00:00:00.000', 0.298488, 6200, '6734C135-9633-4B95-80D2-3AB446E572A6', 6, 2),
(234, 'VAUDELIN', 'Grard', 'M.', '90 Rue des 36 Ponts', NULL, NULL, '01460', 'MONTRAL LA CLUSE', '05-78-36-33-95', '05-42-24-96-60', '1945-07-15 00:00:00.000', 0.250617, 18300, 'D75FE1ED-5F14-4048-8BB0-23D873DBCBA6', 6, 2),
(235, 'TROUCHARD', 'Lucien', 'M.', '39 Avenue des Gobelins', NULL, NULL, '78220', 'VIROFLAY', '04-48-40-07-59', '04-47-67-36-38', NULL, 0.768747, 5400, '2D08022C-712A-448E-82E6-0AEB2F0B62B4', 6, 2),
(236, 'GRIT', 'Frdrique', 'Mme.', '10 Rue de Duras', NULL, NULL, '52100', 'SAINT DIZIER', '02-51-34-49-03', '02-61-91-74-30', '1960-09-27 00:00:00.000', 0.382965, 23900, '213587BB-2049-48EF-94E8-D36CAB324D1F', 2, 1),
(237, 'ABECASSIS', 'Albert', 'M.', '" La Rsidence du Parc "', NULL, NULL, '85160', 'SAINT JEAN DE MONTS', '01-46-32-02-14', '01-27-92-56-35', '1944-06-16 00:00:00.000', 0.65611, 5200, '8A50626C-A347-422D-ACCD-1B1D5564C028', 6, 2),
(238, 'LE RESTE', 'Roger', 'M.', '52 Rue Rieussec', NULL, NULL, '75017', 'PARIS', '01-30-45-91-64', '01-11-81-50-46', '1966-11-02 00:00:00.000', 0.94615, 800, '3F16149D-7011-49F4-A0CA-AB7CF8CEDD71', 6, 2),
(239, 'BLONDIN', 'Luc', 'M.', '38 Avenue du Docteur Mougeot', NULL, NULL, '56000', 'VANNES', '04-81-99-55-34', '04-84-16-58-39', '1946-01-07 00:00:00.000', 0.563184, 14100, '554A0F4B-BD09-42D9-8C89-2615F0B0FB6D', 6, 2),
(240, 'BENOIST', 'Guy', 'M.', '31 Esplanade de la Mer', NULL, NULL, '34000', 'MONTPELLIER', '00-04-34-53-42', '00-27-10-28-64', '1950-10-04 00:00:00.000', 0.481523, 9100, '13CECA81-A54A-4C08-90EC-1C5C2D139058', 6, 2),
(241, 'MADAR', 'Maurice', 'M.', '54 Rue Jouffroy d''Abbans', NULL, NULL, '51100', 'REIMS', '00-62-84-75-23', '00-43-87-96-19', '1935-06-12 00:00:00.000', 0.653294, 12600, 'C1184C15-55A8-42B9-AC2E-1723C100AF7B', 6, 2),
(242, 'SIBOURG', 'Alain', 'M.', '8 Rue Lesage', NULL, NULL, '75015', 'PARIS', '02-77-42-31-32', '02-72-81-21-04', '1965-04-17 00:00:00.000', 0.343542, 1500, 'D4245151-A1F1-431D-9AF8-DAF7D56CDD9B', 6, 2),
(243, 'DUSSAUSSOY', 'Robert', 'M.', '17 Rue Boussairolles', NULL, NULL, '13005', 'MARSEILLE', '03-83-60-72-30', '03-97-46-59-66', '1944-07-31 00:00:00.000', 0.87012, 6100, '8AEA71D1-BCBE-4440-B3B6-2CDB6CC0D9DC', 1, 2),
(244, 'MULLER', 'Bernard', 'M.', '7 Rue Marie Stuart', NULL, NULL, '75017', 'PARIS', NULL, '03-76-90-93-29', '1938-11-02 00:00:00.000', 0.411125, 800, 'DEE91F9D-DF25-4260-BA74-B6712ACBDEFB', 6, 2),
(245, 'GUIDON', 'Serge', 'M.', '51 Rue Dombasle', NULL, NULL, '67100', 'STRASBOURG', '02-63-92-20-76', '02-43-20-53-66', '1962-10-25 00:00:00.000', 0.219642, 21200, '4C63C3F1-2AAA-4CDF-8BF3-5B9BDE770556', 6, 2),
(246, 'BOUCHERIE', 'Jean-Michel', 'M.', '110 Rue Sainte Ccile', NULL, NULL, '73000', 'BARBERAZ', '00-33-53-29-04', '00-44-75-46-93', '1967-12-20 00:00:00.000', 0.867304, 17400, 'D0DB4274-E76C-4783-AE76-641EC588C27C', 6, 2),
(247, 'COURSEAU', 'Michel', 'M.', '40/42 Rue Fortuny', NULL, NULL, '91260', 'JUVISY SUR ORGE', '04-81-15-45-78', '04-51-34-16-42', '1923-02-13 00:00:00.000', 0.371702, 7400, 'ABE177BE-BB4E-47A4-BA67-559C53FC92CF', 6, 2),
(248, 'COZETTE', 'Rodolphe', 'M.', '49 Avenue Jean Jaurs', NULL, NULL, '95870', 'BEZONS', '04-64-85-37-38', '04-54-07-44-61', '1963-04-07 00:00:00.000', 0.681453, 7300, '66CCBC28-B5FA-458E-AB3F-FD32B910721D', 6, 2),
(249, 'VERGNES', 'Stphane', 'M.', 'Immeuble Omga', '53 Rue de la Rpublique', NULL, '14600', 'HONFLEUR', '05-94-90-08-68', '05-85-10-49-45', '1964-02-09 00:00:00.000', 0.650478, 3200, '4B9C6748-01BF-44A2-9574-19143BEC5AD2', 6, 2),
(250, 'BOBILLON', 'Josiane', 'Mme.', '36 Rue Montessuy', NULL, NULL, '31000', 'TOULOUSE', '04-23-52-20-27', '04-25-07-84-45', '1948-04-05 00:00:00.000', 0.357622, 23100, 'EDAB69BB-5BDA-44B6-8079-212B69600D19', 1, 1),
(251, 'GUY', 'Pierre', 'M.', '134 Rue Edouard Vaillant', NULL, NULL, '69002', 'LYON', '05-52-27-08-51', NULL, '1935-01-29 00:00:00.000', 0.948966, 17900, 'F4229B6B-2034-4561-AB5E-61CBB2CC6CE0', 6, 2),
(252, 'CHAUVET', 'Bruno', 'M.', '8 Rue du Dauphin', NULL, NULL, '75015', 'PARIS', '02-17-11-14-59', '02-69-42-45-51', '1956-04-01 00:00:00.000', 0.903911, 20000, '826FF84F-9041-4AF5-AFF8-DE697F2E05A1', 6, 2),
(253, 'NOURY', 'Christian', 'M.', '44 Rue Bayard', NULL, NULL, '93170', 'BAGNOLET', '01-67-39-89-24', '01-46-60-02-30', '1958-12-28 00:00:00.000', 0.765931, 23600, '94CA3CDA-97E8-49AE-B261-022690EA4F69', 6, 2),
(254, 'FAURE', 'Thrse', 'Mme.', '6 Place des Jacobins', NULL, NULL, '49100', 'ANGERS', '02-28-96-53-46', '02-55-91-41-26', '1943-11-20 00:00:00.000', 0.35199, 7500, '16A8103D-2BCC-4C0E-9D37-BD364526CAD2', 6, 1),
(255, 'PARRA', 'Renaud', 'M.', '6 Bd Pasteur', NULL, NULL, '06250', 'MOUGINS', '04-90-50-90-62', '04-35-32-62-20', '1958-07-10 00:00:00.000', 0.929254, 6600, '4BFECB04-1AE4-469C-9DBF-81FB61699DEC', 6, 2),
(256, 'VUILLOT', 'Claude', 'M.', '2 Rue Raoul Berton', NULL, NULL, '83120', 'SAINTE MAXIME', '01-88-16-33-33', '01-09-33-62-13', '1944-06-14 00:00:00.000', 0.00844777, 8300, 'EF2F5931-FB6A-43CA-83AE-AD497A40D553', 6, 2),
(257, 'BOUVIER', 'Jacky', 'M.', '41 Rue des Lices', NULL, NULL, '39200', 'SAINT CLAUDE', '04-16-04-88-68', '04-38-07-38-48', '1937-09-23 00:00:00.000', 0.340727, 19700, '30DAA438-9346-422D-BFCA-4B3289EF7D6E', 5, 2),
(258, 'DELCAMBRE', 'Jacques', 'M.', '351 Avenue de Saint Basile', NULL, NULL, '49124', 'SAINT BARTHLMY D''ANJOU', '01-18-50-50-74', '01-03-45-10-11', '1954-08-23 00:00:00.000', 0.743403, NULL, '6B1C8133-D39A-4AD3-AA5E-8937260DA3D5', 6, 2),
(259, 'SATRE', 'Arnaud', 'M.', '13 Avenue Charles De Gaulle', '" Les Arcades du Casino "', NULL, '77300', 'FONTAINEBLEAU', '02-17-41-82-77', '02-85-08-86-60', '1963-01-27 00:00:00.000', 0.321015, 19600, '56411181-6678-4343-B37B-94259293A0F7', 6, 2),
(260, 'ROUSSEL', 'Rene', 'Mme.', '11 Bis Rue Mercire', NULL, NULL, '69500', 'BRON', '05-06-02-23-12', '05-81-85-65-28', '1942-11-20 00:00:00.000', 0.8842, 3000, '51C595D8-283F-474E-A40D-E7702282E054', 6, 1),
(261, 'ROGER', 'Grard', 'M.', '16 Route d''Angers', NULL, NULL, '44350', 'GUERANDE', '05-38-00-67-15', '05-45-83-69-68', '1956-01-22 00:00:00.000', 0.723692, 21900, 'AB102FA5-461D-4EBD-A1A9-A7A9AE2C1709', 6, 2),
(262, 'LO BONO', 'Sylvie', 'Mme.', '32 Rue de la Cloche', NULL, NULL, '66700', 'ARGELES SUR MER', '02-20-60-25-38', '02-05-78-95-79', '1959-09-08 00:00:00.000', 0.698349, 19300, '8DD620C0-4218-449F-B048-FBC8732BC45F', 6, 1),
(263, 'DE BROCA', 'Vincent', 'M.', '178 Avenue Franklin Roosevelt', NULL, NULL, '06110', 'LE CANNET', '04-94-04-28-14', '04-29-81-49-96', '1950-07-27 00:00:00.000', 0.0647662, 7400, '6CFD32C2-2E1D-4EC6-9C00-495A2BB08C88', 6, 2),
(264, 'DESSALIEN', 'Bernard', 'M.', '3 Rue Vannetaise', NULL, NULL, '83300', 'DRAGUIGNAN', '02-24-87-39-21', '02-36-94-29-26', '1949-10-17 00:00:00.000', 0.982757, 21300, 'FE0B875C-AD30-43AC-B0A0-9ABCED16D438', 2, 2),
(265, 'CHOLLET', 'Gilbert', 'M.', '22 Bd de la Mer', NULL, NULL, '69007', 'LYON', NULL, '05-29-57-41-15', '1941-07-30 00:00:00.000', 0.0929254, 17600, 'C79F7FD3-7FB1-4532-88EC-4048C7D3DB9B', 6, 2),
(266, 'OBARA', 'Jean-Louis', 'M.', '15 Bis Rue des Moulires', NULL, NULL, '85100', 'LES SABLES D''OLONNE', '00-70-76-64-66', '00-03-37-09-99', '1945-08-13 00:00:00.000', 0.608239, NULL, 'AACA891D-031E-4C2E-AEA1-E42A358E0254', 6, 2),
(267, 'PITOISET', 'Franois', 'M.', '17 Rue Labat', NULL, NULL, '60400', 'NOYON', '00-40-77-61-80', '00-23-10-27-92', '1961-07-08 00:00:00.000', 0.737772, 20700, '2ABF3FD4-B723-4093-B9CF-ECF4A115834F', 6, 2),
(268, 'BAILLY', 'Jean-Franois', 'M.', '42 Rue de l''Universit', NULL, NULL, '57050', 'LONGEVILLE LES METZ', '05-24-17-70-05', '05-14-91-38-86', '1954-05-23 00:00:00.000', 0.695533, 19800, 'BEC47541-BA39-40FC-9AF0-9D65583A169A', 6, 2),
(269, 'ARCIDIACO', 'Olivier', 'M.', '2 Rue de la Passerelle', NULL, NULL, '75006', 'PARIS', '03-02-19-60-78', '03-08-08-22-89', '1957-09-11 00:00:00.000', 0.988389, 1600, '563AF1AC-8A18-4B67-B316-7B6278B87633', 6, 2),
(270, 'FOUCHER', 'Pascal', 'M.', '17 Rue de Paris', NULL, NULL, '57000', 'METZ', '03-13-21-92-84', '03-69-46-88-67', '1954-05-26 00:00:00.000', 0.599791, 4900, '54106FF7-13DF-4142-A130-5B7ACF1C0EF2', 6, 2),
(271, 'LA ROSA', 'Franoise', 'Mme.', '39 Rue du Pr Gourna', NULL, NULL, '85330', 'NOIRMOUTIER', '02-66-56-10-95', '02-22-32-72-90', '1940-01-14 00:00:00.000', 0.636398, 600, 'D76FC3D1-EB94-487C-990A-C271ACEEDE4D', 3, 1),
(272, 'SIMEONE', 'Jean-Marie', 'M.', '2 Rue Crbillon', NULL, NULL, '93190', 'LIVRY GARGAN', '04-58-37-39-99', '04-26-41-24-93', '1969-07-08 00:00:00.000', 0.13798, 24900, 'E23B3E98-3232-4175-A4DD-12FAE26B8BBA', 6, 2),
(273, 'GILLIG', 'Marie-Louise', 'Mme.', '3 Avenue De Lattre de Tassigny', NULL, NULL, '75005', 'PARIS', NULL, '02-87-31-31-52', NULL, 0.588528, 20500, 'FC585761-A4E2-4F3B-917A-C0DD4B88496D', 6, 1),
(274, 'BARB', 'Xavier', 'M.', 'L''Etier du Moulin', 'Place de la Pre aux Ducs', NULL, '67000', 'STRASBOURG', '04-62-16-68-87', '04-69-89-41-37', '1948-01-16 00:00:00.000', 0.965861, 9100, 'B2D396EC-BE7E-44C4-8A4D-9C32056C9447', 6, 2),
(275, 'DESPRS', 'Annie', 'Mme.', '83 Avenue Aristide Briand', NULL, NULL, '83000', 'TOULON', '05-93-19-35-87', '05-23-17-63-05', '1953-01-18 00:00:00.000', 0.675821, 4900, 'F53ED84A-E09E-49E8-A573-5D84BF7D226F', 6, 1),
(276, 'MORLINO', 'Henry', 'M.', '5 Rue Paillet', NULL, NULL, '38200', 'VIENNE', '01-03-85-61-90', '01-19-05-51-25', '1937-02-12 00:00:00.000', 0.912359, 6100, '2513F8FD-5EC9-4D15-A550-86407BB0C98E', 6, 2),
(277, 'PATUREAU-MIRAND', 'Charles', 'M.', '10 Rue Charles Gerhardt', NULL, NULL, '34340', 'MARSEILLAN PLAGE', '05-47-94-50-58', '05-77-62-97-61', '1945-07-08 00:00:00.000', 0.763115, 13400, 'C1BA64E5-C18B-4C21-A586-7A67DB1B8809', 6, 2),
(278, 'RALLU', 'Charles', 'M.', '2293 Avenue Joseph Gasquet', NULL, NULL, '85400', 'LUON', '03-74-80-68-18', '03-34-63-67-46', '1959-07-01 00:00:00.000', 0.912359, 23500, '2CF184E5-B411-415D-9FE5-2E7321BE0614', 7, 2),
(279, 'MARS', 'Philippe', 'M.', '37 Cours Brillier', NULL, NULL, '60500', 'CHANTILLY', '01-62-39-23-04', '01-71-88-10-72', '1951-04-11 00:00:00.000', 0.560369, 21600, 'B2B3C5E1-1EE9-445E-A87B-40964C5B5574', 6, 2),
(280, 'BLOTAS', 'Ren', 'M.', '9 Rue Georges Brassens', 'Rsidence Les Mas de la Plage', NULL, '39700', 'ORCHAMPS', '04-95-70-14-66', '04-59-03-57-66', '1937-06-21 00:00:00.000', 0.596975, 12800, '161FB2EF-E669-41D4-A93B-F04C20F2929A', 6, 2),
(281, 'OHAYON', 'Claude', 'M.', '81 Rue Georges Clmenceau', NULL, NULL, '50160', 'TORIGNI SUR VIRE', '04-01-32-06-38', '04-37-67-49-53', '1938-11-25 00:00:00.000', 0.670189, 23100, '963F97FF-1C1F-4D83-A71B-AC41CC43FD0A', 6, 2),
(282, 'COFFANI', 'David', 'M.', '13 Avenue Aumont', NULL, NULL, '75011', 'PARIS', '03-22-31-95-44', '03-07-16-91-87', '1957-04-06 00:00:00.000', 0.0872936, 8900, '98F1EBE2-78E4-41CD-8903-E1B2CBBDF5D9', 6, 2),
(283, 'DE BEAUREPAIRE', 'Henri', 'M.', 'EVANS', NULL, NULL, '69400', 'VILLEFRANCHE SUR SAONE', '00-01-66-10-00', '00-44-07-06-21', '1944-04-24 00:00:00.000', 0.59416, 24500, 'BADBF965-AE55-496D-85B6-97BA9EA387D4', 6, 2),
(284, 'CROS', 'Caroline', 'Mme.', '30 Rue de la Rpublique', NULL, NULL, '18000', 'BOURGES', '01-70-60-04-16', '01-42-80-89-79', '1956-03-17 00:00:00.000', 0.673005, 10200, '2825FAC2-AAA2-44E1-89D8-622179136C88', 6, 1),
(285, 'FROUDKINE', 'Patrick', 'M.', '20 Rue de la Pierre Leve', NULL, NULL, '34000', 'MONTPELLIER', '01-61-21-64-68', '01-19-24-45-66', '1964-06-29 00:00:00.000', 0.411125, 10400, 'FACEFFDB-EBED-4802-9834-197F47068C1E', 4, 2),
(286, 'BENILSI', 'Jean-Pierre', 'M.', '874 Bd Burdeau', NULL, NULL, '75017', 'PARIS', '01-75-41-13-37', '01-58-68-33-34', '1946-04-16 00:00:00.000', 0.19993, 23400, '32CE0B20-E1F2-409E-B16B-3D4A846CE1C0', 6, 2),
(287, 'DE BARROS', 'Georges', 'M.', '25 Rue des Cordeliers', NULL, NULL, '30000', 'NIMES', '00-79-37-43-23', '00-12-21-04-93', '1947-06-25 00:00:00.000', 0.929254, 21100, 'F175D64A-E52C-4AAB-95E3-A9AE42605C6F', 6, 2),
(288, 'LAPOUYADE', 'Bruno', 'M.', '3 Rue de la Posie', NULL, NULL, '94700', 'MAISONS ALFORT', '02-18-05-36-68', '02-01-96-48-31', '1964-06-05 00:00:00.000', 0.484339, 14000, 'E8EC9F19-CA68-445F-BBE3-9709DECA7495', 6, 2),
(289, 'GUBIAN', 'Jean-Pierre', 'M.', '33 Rue Fortuny', NULL, NULL, '44300', 'NANTES', '00-72-39-45-14', '00-17-00-21-77', '1947-01-19 00:00:00.000', 0.29004, 17700, '7B384AAE-5A48-4D5B-A42B-BFBF669BF929', 6, 2),
(290, 'DEWERPE', 'Eric', 'M.', '10 Rue Auguste', NULL, NULL, '95160', 'MONTMORENCY', '01-33-77-57-45', '01-60-73-80-78', '1961-02-09 00:00:00.000', 0.456179, 18400, 'FE95F545-E94C-4648-BCE0-6DA0119AEB89', 6, 2),
(291, 'GUINOT', 'Michle', 'Mme.', '73 Avenue du Gnral De Gaulle', NULL, NULL, '06300', 'NICE', '03-86-22-89-90', '03-21-99-22-67', '1944-01-03 00:00:00.000', 0.895463, 22400, '4141D55D-D7FE-4B5F-94C5-F27B7CD9BE15', 6, 1),
(292, 'PASCOLINI', 'Philippe', 'M.', '328 Route de Sainte Luce', NULL, NULL, '78160', 'MARLY LE ROI', '01-89-42-16-52', '01-54-65-23-95', '1958-03-18 00:00:00.000', 0.166139, 13700, 'B0E75BE8-A3D1-4DA7-B74F-3551A521E9F1', 7, 2),
(293, 'FAVRO-BERTRANDO', 'Jean-Pierre', 'M.', '6 Rue de Clairvaux', NULL, NULL, '92100', 'BOULOGNE', '02-35-87-71-60', '02-16-03-36-87', '1961-02-09 00:00:00.000', 0.0788458, 6400, '0E1FE6C7-32BB-441C-B23D-95A5B8670956', 6, 2),
(294, 'LE LAN', 'Daniel', 'M.', '6 Rue de Rivoli', NULL, NULL, '13240', 'SEPTEMES LES VALLONS', '05-02-39-67-78', '05-17-68-82-17', '1953-10-20 00:00:00.000', 0.557553, 5400, '81E25C06-4FC4-4025-BCD3-B6FA90B2F960', 6, 2),
(295, 'MICHELIN', 'Serge', 'M.', 'Centre Commercial des Grandes', 'Terres', NULL, '22220', 'TRGUIER', '03-79-96-09-01', '03-84-88-48-19', '1951-12-12 00:00:00.000', 0.163323, 11100, '956A03A5-1397-486F-A914-B528B987D164', 6, 2),
(296, 'ARVIEUX', 'Annie', 'Mme.', '8 Rue de l''Est', NULL, NULL, '69410', 'CHAMPAGNE AU MONT D''OR', '00-22-22-67-06', '00-94-23-63-97', '1948-03-02 00:00:00.000', 0.785642, 6300, '867C3FDE-B41A-4CEB-B7BE-8D38ABCD2E90', 6, 1),
(297, 'SAHUQUET', 'Raoul', 'M.', '39 Avenue du 8 Mai 1945', NULL, NULL, '24000', 'PRIGUEUX', '05-61-41-07-24', '05-42-81-76-49', '1921-04-17 00:00:00.000', 0.734956, 12200, 'AEC51D22-2681-4BF1-B6E9-67D559DD4C0F', 6, 2),
(298, 'HEUTY', 'Daniel', 'M.', '18 Place du Martray', NULL, NULL, '30132', 'CAISSARGUES', '00-57-93-62-53', '00-05-10-18-71', '1955-07-05 00:00:00.000', 0.0253433, 6300, 'D6213DF2-6198-49DE-8433-5332A72AC146', 6, 2),
(299, 'DUMOULIN', 'Franois', 'M.', '9 Chemin de Saint-Andr', NULL, NULL, '64210', 'BIDART', '03-45-85-34-47', '03-33-05-30-26', '1927-10-04 00:00:00.000', 0.188667, 12900, '81ADF293-3479-48C3-BB56-5419C000EBD7', 4, 2),
(300, 'MATUZAC', 'Daniel', 'M.', '36 Bd Lakanal', NULL, NULL, '78300', 'POISSY', '05-67-25-56-80', NULL, '1948-04-22 00:00:00.000', 0.35199, 3400, '5B538660-B709-426B-9AAF-E4896E24F7FC', 6, 2),
(301, 'DESPORT', 'Annie', 'Mme.', 'Centre Commercial Les Portes', 'de Mirman', 'Chemin de Bellevue', '33120', 'ARCACHON', '03-68-41-45-54', '03-20-27-91-52', '1942-09-11 00:00:00.000', 0.633582, 4900, '7477F2BB-98FF-435D-9592-38F292BAB027', 6, 1),
(302, 'LACASSIN', 'Pierre', 'M.', 'Avenue du Gnral De Gaulle', 'GUTHARY', NULL, '75009', 'PARIS', '01-23-66-23-40', '01-26-85-89-15', '1946-08-08 00:00:00.000', 0.664558, NULL, 'AC014A7E-FB60-475B-AEFC-9C6DF4B490E0', 6, 2),
(303, 'HOSTETTER', 'Emile', 'M.', '23 RN 13', 'Route de Quarante Sous', NULL, '30900', 'NIMES', '05-64-21-12-86', '05-59-51-69-50', '1949-07-23 00:00:00.000', 0.785642, 4200, '505AAF58-AA45-41A4-9281-84451418AC9C', 6, 2),
(304, 'KOT', 'Pascale', 'Mme.', '41 Avenue du Gnral De Gaulle', NULL, NULL, '13100', 'AIX EN PROVENCE', '04-90-87-60-02', '04-02-35-73-36', '1973-04-02 00:00:00.000', 0.822249, 22000, '79741EF0-D5AE-434C-A8C9-3363662FF18C', 6, 1),
(305, 'KLONOWSKI', 'Emmanuel', 'M.', '24 Rue Godot de Mauroy', NULL, NULL, '94100', 'SAINT MAUR DES FOSSS', '04-50-70-27-88', '04-19-93-29-42', '1961-08-07 00:00:00.000', 0.140796, NULL, '744C8DE3-00F8-49F0-B3DC-3841C08E39B6', 6, 2),
(306, 'OBARA', 'Maria', 'Mme.', '353 Chemin du Quartier d''Espagne', NULL, NULL, '75011', 'PARIS', '05-90-73-39-78', '05-84-98-17-82', '1934-07-29 00:00:00.000', 0.844777, 7200, 'FFD57C08-E6D3-43A9-A0D3-C0B2336FAAE3', 1, 1),
(307, 'VALENCE', 'Franois', 'M.', '29 Rue Emeric David', NULL, NULL, '60400', 'NOYON', '00-64-20-20-27', '00-43-60-31-92', '1961-07-08 00:00:00.000', 0.664558, 8500, '4A6B3BD3-EC81-4FF7-911D-C6E0336DA5D5', 6, 2),
(308, 'TARLEZ', 'Didier', 'M.', '17 Bis Rue du Chemin Vert', NULL, NULL, '78800', 'HOUILLES', '00-26-37-76-67', '00-37-03-69-79', '1965-08-17 00:00:00.000', 0.50405, NULL, '934D54EF-FB6B-4A80-83EE-A676F4C9766B', 6, 2),
(309, 'RADET-LAFAILLE', 'Marie-Jos', 'Mme.', '118 Rue du Chemin Vert', NULL, NULL, '75018', 'PARIS', '02-01-70-97-56', '02-44-86-28-86', '1952-01-05 00:00:00.000', 0.875752, 22500, '5923075B-8D85-4CE3-80EC-24A0CD6BC0FB', 6, 1),
(310, 'LALART', 'Corinne', 'Mme.', '3 Place Saint Barthlmy', NULL, NULL, '75018', 'PARIS', '03-84-52-74-91', '03-15-87-60-23', '1960-04-22 00:00:00.000', 0.371702, 8700, 'D37F9BAB-1828-4A84-B915-9BBA648D7A79', 6, 1),
(311, 'AMARA', 'Arnaud', 'M.', '4 Avenue Charles De Gaulle', NULL, NULL, '14150', 'OUISTREHAM-RIVA BELLA', '03-08-29-57-56', '03-10-19-39-46', '1962-08-21 00:00:00.000', 0.337911, NULL, '66BF3186-F749-4422-A56D-7C25D947CF76', 6, 2),
(312, 'CHICOT', 'Hamid', 'M.', '16 Place de la Chapelle', NULL, NULL, '75015', 'PARIS', '00-34-23-35-46', '00-27-91-14-61', '1944-03-14 00:00:00.000', 0.121085, 22800, '376B052B-D962-4A90-A863-66354419B41D', 6, 2),
(313, 'NICAUD', 'Olivier', 'M.', '105 Rue Lamarck', NULL, NULL, '69004', 'LYON', '03-37-66-67-69', '03-53-80-51-53', '1962-11-16 00:00:00.000', 0.636398, 21200, '42FCE764-75DF-478D-96A5-A2CC797E622A', 1, 2),
(314, 'DANTZER', 'Michel', 'M.', '1 Rue de la Mer', NULL, NULL, '75008', 'PARIS', '01-84-51-50-30', '01-02-14-80-13', '1952-11-11 00:00:00.000', 0.230906, 8500, '571BACCB-B58F-4872-94D6-E89243580449', 6, 2),
(315, 'EDERY', 'Jean-Marie', 'M.', '35 Rue Falguire', NULL, NULL, '67000', 'STRASBOURG', '00-42-90-09-37', NULL, '1948-07-16 00:00:00.000', 0.768747, 9800, '895BBA89-15EC-44D9-BFE3-92E1D05BBBDF', 6, 2),
(316, 'MAURES', 'Sam', 'M.', '85 Bd de la Croix Rousse', NULL, NULL, '93250', 'VILLEMOMBLE', '03-22-12-03-88', '03-93-24-96-70', '1938-02-17 00:00:00.000', 0.954598, 22500, 'B3C6D943-614D-42BC-AB84-F4657AC957E6', 6, 2),
(317, 'ZIRAH', 'Francis', 'M.', '39 Rue d''Amsterdam', NULL, NULL, '33200', 'BORDEAUX', NULL, '04-99-85-24-24', '1957-04-10 00:00:00.000', 0.988389, 19300, '0127B207-1957-476A-815B-5B0D81B78317', 6, 2),
(318, 'LEMOING', 'Paul', 'M.', '1 Rue du Dme', NULL, NULL, '75002', 'PARIS', '00-31-95-85-45', '00-98-90-59-16', '1923-12-10 00:00:00.000', 0.523762, 19100, '25E0C968-F7A3-40CD-9F3D-5F3E75FD06F6', 6, 2),
(319, 'CORDONNIER', 'Jean-Claude', 'M.', '2 Bd Andr', NULL, NULL, '06220', 'LE GOLFE JUAN', '01-72-23-23-58', '01-27-76-40-06', '1937-02-20 00:00:00.000', 0.284408, 1400, 'D68B9858-06D1-49A2-B285-7360588D2B43', 6, 2),
(320, 'DUVAL', 'Jacques', 'M.', '295 Avenue de la Rpublique', NULL, NULL, '67000', 'STRASBOURG', '02-22-40-44-22', '02-11-45-25-10', '1950-09-16 00:00:00.000', 0.675821, 21000, '07B2908D-3985-48B3-BF92-6C0B43EB171F', 5, 2),
(321, 'SARTIRIOLI-BOCCACCIO', 'Marc', 'M.', '19 Rue de Choiseul', NULL, NULL, '14150', 'OUISTREHAM-RIVA BELLA', '03-18-74-26-01', '03-65-81-91-31', '1954-03-04 00:00:00.000', 0.340727, 25000, '309103B6-F174-4CF0-A1BC-C69671CB1C88', 6, 2),
(322, 'BRIFFAUD', 'Paul', 'M.', '405 Chemin des Courcettes', NULL, NULL, '06700', 'SAINT LAURENT DU VAR', '01-19-78-59-01', '01-83-33-01-99', '1952-01-16 00:00:00.000', 0.94615, 11100, 'A6CF4F00-A638-4E40-827A-1E81C50DF45F', 6, 2),
(323, 'BIED', 'Gilles', 'M.', '44 Rue Wimpheling', NULL, NULL, '81500', 'LAVAUR', '04-41-88-59-75', '04-70-09-70-08', '1950-04-14 00:00:00.000', 0.380149, 7000, 'E8B6EC30-BF6F-4EA8-AB8B-1DE74CBF66BE', 6, 2),
(324, 'HODENCQ', 'Franoise', 'Mme.', '98 Rue de la Mer', NULL, NULL, '83700', 'SAINT RAPHAEL', '01-57-03-24-26', '01-20-64-10-83', '1943-06-06 00:00:00.000', 0.335095, 2100, '2A2EAB8E-0E62-4A68-92EC-63AC834A8FDB', 6, 1),
(325, 'HEMERY', 'Jean-Max', 'M.', '915 Avenue du Gnral De Gaulle', NULL, NULL, '77400', 'LAGNY', '04-35-18-59-49', '04-60-67-36-63', '1942-11-25 00:00:00.000', 0.777195, 9300, '4E39C80F-052F-4C8E-8D15-7E3092438FE1', 6, 2),
(326, 'MARCHAND', 'Jean-Pol', 'M.', '8 Route de Castres', NULL, NULL, '36300', 'RUFFEC LE CHATEAU', '01-11-30-55-78', '01-70-59-22-01', '1944-07-20 00:00:00.000', 0.827881, 13600, '09D32CDC-BF67-483A-889A-C3C79D564679', 6, 2),
(327, 'LCOLE', 'Guy', 'M.', 'Rsidence Bagatelle', '295 Avenue du Gnral Leclerc', NULL, '21000', 'DIJON', '03-08-00-74-91', '03-28-29-75-14', '1943-06-23 00:00:00.000', 0.413941, 22400, '7A2E7BA4-23AE-427F-BA77-A27C164122B3', 2, 2),
(328, 'PETIT', 'Nadine', 'Mme.', '3 Chemin Neuf', 'GOUVERNES', NULL, '31000', 'TOULOUSE', '04-60-27-37-77', '04-61-08-14-20', '1956-05-06 00:00:00.000', 0.537841, 21200, '663FED31-9ADD-4BD5-94FD-7EAD5D013648', 6, 1),
(329, 'MALLEN', 'Jean-Marie', 'M.', 'Lieu-Dit l''Epineau', NULL, NULL, '77150', 'FEROLLES-ATTILY', '01-69-78-84-56', '01-99-44-71-67', '1940-07-01 00:00:00.000', 0.974309, 9200, '51682EAC-369D-49DF-B725-629DDB463C7A', 6, 2),
(330, 'CRASTUS', 'Viviane', 'Mme.', '68 Rue des Godrans', NULL, NULL, '82300', 'CAUSSADE', '03-10-33-19-82', '03-78-05-96-26', '1955-06-18 00:00:00.000', 0.920807, 11800, '77D6F758-8BC0-4AF3-B8B9-434C252DEFD0', 6, 1),
(331, 'FETY', 'Antoine', 'M.', '6 Alle Paul Sabatier', NULL, NULL, '94500', 'CHAMPIGNY SUR MARNE', '03-63-06-83-57', '03-00-58-13-01', '1956-07-22 00:00:00.000', 0.771563, 17300, '0190FB10-F7E2-47AB-85E6-AF5FAB3F4DDE', 6, 2),
(332, 'GAUTIER', 'Arnaud', 'M.', '12 Alle de Champagne', NULL, NULL, '44000', 'NANTES', '04-50-40-91-05', '04-76-68-90-38', '1962-10-19 00:00:00.000', 0.827881, 24600, '1C7D563F-0478-453D-A1EE-D2AACE15BA13', 6, 2),
(333, 'METTETAL', 'Dominique', 'Mme.', '21 Bd Didier Rey', NULL, NULL, '14130', 'PONT L''VEQUE', '04-09-22-36-89', NULL, '1952-11-04 00:00:00.000', 0.430836, 20600, 'DD70992A-46B5-4293-81BD-0133B8EAFD88', 6, 1),
(334, 'DALON', 'Luc', 'M.', '23 Rue Jean Jaurs', NULL, NULL, '69380', 'CHASSELAY', '04-03-50-20-75', '04-08-39-58-05', '1956-05-24 00:00:00.000', 0.143612, 7700, '257949D2-6968-4ED3-8304-6CC884D7CB0A', 1, 2),
(335, 'DELAYRE', 'Jean-Yves', 'M.', '13 Rue Jean-Jacques Rousseau', NULL, NULL, '69005', 'LYON', '04-21-10-08-10', '04-56-19-82-37', '1958-04-09 00:00:00.000', 0.157692, 25000, 'DFE9328C-2814-4F1E-8C0A-003DCCC4E6EB', 6, 2),
(336, 'PINKWASSER', 'Henri', 'M.', '22/24 Rue Hamelin', NULL, NULL, '66210', 'LES ANGLES', '01-11-76-56-61', '01-21-59-37-72', '1946-09-24 00:00:00.000', 0.354806, 17900, '918355EA-33F9-4EAB-AB8F-035B035A0ABF', 6, 2),
(337, 'CAVALLO', 'Andr', 'M.', 'Chteau du Plantin', NULL, NULL, '06400', 'CANNES', '02-37-67-59-95', '02-05-16-77-52', '1945-11-11 00:00:00.000', 0.979941, 10200, '1DFC7269-3689-46D0-8477-C708B0F1483A', 6, 2),
(338, 'COHEN', 'Michle', 'Mme.', '116 Rue Saint Georges', NULL, NULL, '77380', 'ROISSY EN BRIE', '03-75-71-88-53', '03-85-74-42-16', NULL, 0.284408, 3800, '6A71B5CC-FC97-4E70-8E3E-FBD8C315025B', 6, 1),
(339, 'PIPAR', 'Jacques', 'M.', 'Rsidence La Matte', NULL, NULL, '75008', 'PARIS', '05-23-13-51-36', '05-75-34-26-79', '1936-12-19 00:00:00.000', 0.183035, 13600, '61A47CBC-4E0B-4A57-B566-A2F1247CB24A', 6, 2),
(340, 'BEAUCHAMP', 'Laurent', 'M.', '2 Rond Point Duboys d''Angers', NULL, NULL, '06110', 'LE CANNET ROCHEVILLE', '02-44-13-23-65', '02-20-87-89-92', '1972-06-12 00:00:00.000', 0.29004, 7100, 'C8A0F25E-8DBC-4D65-841C-48BA586942D6', 6, 2),
(341, 'SKILLINGTON', 'Michel', 'M.', '23 Avenue Gnral Leclerc', NULL, NULL, '78310', 'MAUREPAS', '05-74-13-89-33', '05-03-28-74-83', '1938-05-06 00:00:00.000', 0.337911, 23600, '9DF46EDA-D96D-422E-B967-4C74D77DE084', 1, 2),
(342, 'GRAVANS', 'Hugo', 'M.', '31 Rue Boissy d''Anglas', NULL, NULL, '83360', 'GRIMAUD', '04-25-45-68-28', NULL, '1951-04-28 00:00:00.000', 0.51813, 17900, 'C5C3B2FF-29DB-47B2-8FBF-17EC852E9335', 6, 2),
(343, 'MORENO', 'Jean-Paul', 'M.', '30 Bis Rue Louis Icard', NULL, NULL, '61200', 'ARGENTAN', '05-28-47-34-60', '05-08-27-35-66', '1960-01-15 00:00:00.000', 0.78001, 10100, '5572F29B-F78A-4818-908C-8A22F169FF6E', 6, 2),
(344, 'VEDECHE', 'Louis', 'M.', '28 Alle du Bourbonnais', NULL, NULL, '31400', 'TOULOUSE', '05-07-66-79-01', NULL, '1942-05-16 00:00:00.000', 0.850408, 5500, 'F8EA8FC5-5390-4609-8CCE-D5D642E640C1', 6, 2),
(345, 'POTRAT', 'Christian', 'M.', 'La Fons Couverte - CD 558', NULL, NULL, '42800', 'RIVE DE GIER', '02-08-70-39-75', '02-49-91-64-38', '1956-09-07 00:00:00.000', 0.689901, 18600, '167D74FE-C126-4D11-9BE1-CD3893217669', 6, 2),
(346, 'PORRET', 'Michel', 'M.', '20 Rue Etienne Panthou', NULL, NULL, '06300', 'NICE', '05-00-55-71-98', '05-54-71-91-11', '1949-11-08 00:00:00.000', 0.478707, 15300, '189D1580-FE5C-4C83-A09E-9F35C15CC5B8', 6, 2),
(347, 'MAERTEN', 'Christophe', 'M.', '5 Avenue Crampel', NULL, NULL, '38000', 'GRENOBLE', '01-60-16-16-74', '01-28-57-35-32', '1953-05-11 00:00:00.000', 0.839145, 22500, 'CDAD5C12-A57C-4107-ACBB-45D64882E571', 6, 2),
(348, 'DI MARTINO', 'Didier', 'M.', '48 Rue Jean Jaurs', NULL, NULL, '26000', 'VALENCE', '03-81-72-02-33', '03-09-14-33-36', '1955-06-12 00:00:00.000', 0.87012, 4100, 'CCC5BE03-4518-4700-9290-8A67A2B71347', 5, 2),
(349, 'LAGIER', 'Evelyne', 'Mme.', '5 Rue Auguste Gal', NULL, NULL, '13012', 'MARSEILLE', '02-49-05-92-61', '02-71-93-19-27', '1964-07-27 00:00:00.000', 0.861672, 6600, '335BF8D1-D9EB-4442-8ED2-49F0638135DE', 6, 1),
(350, 'BAUDEL', 'Jacques', 'M.', '20 Rue Saint Joseph', NULL, NULL, '25300', 'PONTARLIER', '01-28-90-76-55', '01-58-93-40-82', '1938-04-20 00:00:00.000', 0.689901, 6500, '4A85CF58-BA07-4998-B886-1F4095A82C09', 6, 2),
(351, 'ROLLAND', 'Didier', 'M.', '44/49 Avenue Victor Hugo', NULL, NULL, '75015', 'PARIS', '04-70-31-83-73', '04-40-61-16-30', '1956-02-24 00:00:00.000', 0.734956, 4200, '6CF9090B-89DB-4662-9820-AC5B5262F5D4', 6, 2),
(352, 'BOMPARD', 'Henri', 'M.', 'Actipole 12', 'Impasse Gaston de Flotte', NULL, '77320', 'LA FERT GAUCHER', '01-10-46-60-02', '01-40-48-71-85', '1953-09-08 00:00:00.000', 0.360438, 7200, '73AC0A47-2C8B-48F6-A03F-CBAF20EF936B', 6, 2),
(353, 'PLAIN', 'Michle', 'Mme.', '7 Place Morand', NULL, NULL, '26100', 'ROMANS', '02-04-17-71-00', '02-30-27-27-43', '1956-03-20 00:00:00.000', 0.453363, 14400, '59145602-492E-485C-B0FE-61AA0EE553DC', 6, 1),
(354, 'MALINGE', 'Denis', 'M.', '1 Rue Lon Lhermitte', NULL, NULL, '92500', 'RUEIL MALMAISON', '00-69-56-40-52', '00-39-92-65-50', '1947-01-10 00:00:00.000', 0.326647, 9200, '690F3151-39C2-4D68-A2DD-8301DBCF9D16', 6, 2),
(355, 'PREVAL-VLEMINX', 'Jacques', 'M.', '1 Bis Avenue des Allis', NULL, NULL, '49300', 'CHOLET', '03-44-28-85-52', '03-32-31-86-51', '1945-12-07 00:00:00.000', 0.264697, 1900, '90C8E893-8EAF-4547-9110-0A4D8E4BFA10', 2, 2),
(356, 'RIGAL', 'Philippe', 'M.', '2 Rue Solfrino', NULL, NULL, '80300', 'ALBERT', '02-34-59-07-28', '02-88-92-40-00', '1964-12-23 00:00:00.000', 0.343542, 21400, '0B1BC134-CA7A-4B3A-8C51-5281075B299B', 6, 2),
(357, 'GIROUX', 'Michel', 'M.', '1 Rue de la Libration', NULL, NULL, '78640', 'VILLIERS SAINT FRDRIC', '02-22-61-04-80', '02-16-30-16-52', '1943-06-09 00:00:00.000', 0.923622, 4800, '27188722-C6FF-40AF-B56F-B0B5023C7185', 6, 2),
(358, 'DE VRIENDT', 'Michel', 'M.', '3 Bis Rue du Commerce', NULL, NULL, '77173', 'CHEVRY-COSSIGNY', '03-61-06-62-03', '03-31-97-27-25', '1952-06-23 00:00:00.000', 0.8842, 1700, '85AB673F-1754-44E1-A0EE-5ECE66371482', 6, 2),
(359, 'PELTIER', 'Herv', 'M.', '6 Rue Lamarck', NULL, NULL, '02190', 'PROVISEUX', '04-91-68-69-94', '04-47-77-01-34', '1956-09-27 00:00:00.000', 0.960229, 18600, 'DD78DEFF-02C4-4640-A7DA-B536C140C5E8', 6, 2),
(360, 'BLONDEAU', 'Daniel', 'M.', '24 Place du Pontel', NULL, NULL, '77000', 'MELUN', '01-74-87-79-37', '01-44-43-02-14', '1955-03-01 00:00:00.000', 0.349174, 16600, '6F34FB93-8E60-4A75-A7AF-8F99965F73C4', 6, 2),
(361, 'CHARBONNEAU', 'Jean', 'M.', '24 Rue Charles Path', NULL, NULL, '03200', 'VICHY', '02-36-19-54-40', NULL, NULL, 0.456179, 24800, '01260599-655B-406E-BFA4-FFFED31C797F', 6, 2),
(362, 'RICHARD', 'Franois-Xavier', 'M.', 'PLESNOY', NULL, NULL, '78220', 'VIROFLAY', '04-02-31-81-14', '04-59-61-98-84', '1958-01-06 00:00:00.000', 0.0140796, 22300, '6B974D9E-211D-42FF-9B09-DF27C309767B', 3, 2),
(363, 'LUCAS', 'Joseph', 'M.', '1 Avenue Gallini', NULL, NULL, '75017', 'PARIS', '03-23-26-54-29', '03-99-94-57-77', '1924-07-22 00:00:00.000', 0.568816, 2500, 'D5262429-52D8-482C-845A-C7F709AB7072', 6, 2),
(364, 'PERRON', 'Michel', 'M.', '68 Rue de Paris', NULL, NULL, '44100', 'NANTES', '05-94-82-64-93', '05-12-84-72-60', '1946-10-19 00:00:00.000', 0.763115, 400, '3864F8B5-27C4-4931-AA1D-20D4604FF984', 6, 2),
(365, 'DELIGNE', 'Vincent', 'M.', '48 Rue de Jouy', NULL, NULL, '94420', 'LE PLESSIS TRVISE', '01-61-68-71-91', '01-50-13-81-12', '1970-09-11 00:00:00.000', 0.872936, 16500, 'CA556998-BC52-48A5-A01C-DD1A66AE8953', 6, 2),
(366, 'JEANNE', 'Hubert', 'M.', '43 Rue Laugier', NULL, NULL, '62000', 'ARRAS', '03-98-64-19-74', '03-56-58-17-52', '1948-02-18 00:00:00.000', 0.898279, 19500, 'D8A87EEA-7376-4EA7-91D9-D075FE2CB1D1', 6, 2),
(367, 'KERMARREC', 'Didier', 'M.', '14 Bis Rue Basile Valentin', NULL, NULL, '75015', 'PARIS', '00-76-15-12-33', '00-83-16-10-64', '1947-06-29 00:00:00.000', 0.751851, 2300, '53595955-2E8C-4ABB-8588-4154202B2003', 6, 2),
(368, 'PAURD', 'Alain', 'M.', '1/3 Avenue Jean Charcot', NULL, NULL, '22000', 'SAINT BRIEUC', '03-71-62-42-84', '03-34-69-26-62', '1946-07-19 00:00:00.000', 0.377334, 16500, 'EA3F56BE-A8ED-408F-A9E6-2E6B6C97AC6E', 6, 2),
(369, 'BARCO', 'Aline', 'Mme.', '4 Rue Paul Adam', NULL, NULL, '97410', 'SAINT PIERRE', '03-47-95-85-43', '03-64-21-17-67', '1940-10-04 00:00:00.000', 0.509682, 20600, 'EDB8AA4D-A1A5-4BD1-AD3C-3254BFA96B33', 7, 1),
(370, 'LEGRAND', 'Roger', 'M.', '46 Rue Lacordaire', NULL, NULL, '75008', 'PARIS', '00-04-47-89-83', '00-55-85-84-95', '1937-09-16 00:00:00.000', 0.864488, 2600, 'D648F2A9-073D-4269-82D2-32C2714EAF69', 6, 2),
(371, 'CHAMOND', 'Gilbert', 'M.', '11 Rue de Goudic', NULL, NULL, '74420', 'HABERE-POCHE', '02-88-43-77-93', '02-88-31-16-75', '1939-08-10 00:00:00.000', 0.0168955, NULL, '7EE6F739-C2CF-4F86-B2E1-3BD62CEAEBF8', 6, 2),
(372, 'POULAT', 'Jean-Yves', 'M.', '42 Rue Auguste Babet', NULL, NULL, '38100', 'GRENOBLE', NULL, '02-09-29-41-84', '1954-01-04 00:00:00.000', 0.954598, 6300, 'D76ADF4F-833A-4E46-8026-4D2125B2CB8D', 6, 2),
(373, 'GARCIA', 'Guy', 'M.', '50 Avenue des Champs Elyses', NULL, NULL, '69260', 'CHARBONNIERES LES BAINS', '05-29-90-66-41', '05-85-25-39-21', '1950-11-12 00:00:00.000', 0.174587, 2200, '3B8DF4E0-0BEC-4A3E-B19C-7C139F8ABD3F', 6, 2),
(374, 'DUBROCA', 'Aim', 'M.', 'Les Ronzes', NULL, NULL, '75015', 'PARIS', '04-33-29-98-85', '04-27-33-97-24', '1941-08-27 00:00:00.000', 0.532209, NULL, '0BD82918-82D1-4132-93AA-73AA07810B88', 6, 2),
(375, 'MIQUEL', 'Pierre-Yves', 'M.', '33 Avenue Jean Perrot', NULL, NULL, '59790', 'RONCHIN', '05-54-74-94-20', '05-89-47-55-66', '1959-11-15 00:00:00.000', 0.0703981, 14300, '200A7E24-BF8B-4A3D-9F08-A013E904BE95', 6, 2),
(376, 'BIJASSON', 'Henri', 'M.', '100 Route de Paris', NULL, NULL, '77500', 'CHELLES', '04-63-30-37-75', '04-02-21-13-81', '1949-06-07 00:00:00.000', 0.281592, 14500, '289B5AB5-4805-4B4E-984D-A3733D9D3313', 4, 2),
(377, 'TOUBOUL', 'Jean', 'M.', '55 Bd de Grenelle', NULL, NULL, '91000', 'EVRY', '01-83-38-97-08', '01-88-70-55-36', '1939-03-22 00:00:00.000', 0.109821, 17600, '05868A23-FE0D-4615-A942-818E952044F8', 6, 2),
(378, 'PAILH', 'Aline', 'Mme.', '1 Rue Notre Dame', NULL, NULL, '06000', 'NICE', '05-93-80-49-16', '05-26-12-60-76', '1958-11-27 00:00:00.000', 0.788458, 16100, '0B3A7698-7883-41AF-8EA0-F8B70A991AC1', 6, 1),
(379, 'MUSART', 'Jean-Louis', 'M.', '148 Avenue de Claye', NULL, NULL, '81000', 'ALBI', '05-13-96-43-15', NULL, '1955-05-04 00:00:00.000', 0.726508, 11400, '4F7C48A8-012B-4DE3-9DF6-83011BA5D333', 6, 2),
(380, 'DELEUZE', 'Maurice', 'M.', '19 Bd des Coquibus', NULL, NULL, '77450', 'ESBLY', '00-63-90-38-82', '00-03-65-58-14', '1920-05-10 00:00:00.000', 0.197115, 12700, '3818BA9C-D27F-456F-B22D-5BDECE5836DF', 6, 2),
(381, 'CLAVIER', 'Sandrine', 'Mme.', '24 Rue Meyerbeer', NULL, NULL, '93420', 'VILLEPINTE', '05-35-77-79-80', '05-82-92-66-72', '1969-12-26 00:00:00.000', 0.295672, 100, '5E1852D2-BE6A-4D6A-8013-F257ACA10771', 6, 1),
(382, 'DURU', 'Philippe', 'M.', '29 Bd Paul Bodin', NULL, NULL, '37000', 'TOURS', '03-88-24-63-87', '03-98-87-25-34', '1951-02-28 00:00:00.000', 0.605423, 16600, 'E9FA5645-E912-4A8E-9051-075C057E5E32', 6, 2),
(383, 'PARISEY', 'Bernard', 'M.', '40 Rue du Gnral Leclerc', NULL, NULL, '93000', 'BOBIGNY', '04-17-79-64-40', '04-46-67-36-65', '1943-02-16 00:00:00.000', 0.701165, 22400, '731230B4-7AD2-4E12-8137-480FDDABCA70', 7, 2),
(384, 'SERREAU', 'Jean-Paul', 'M.', '218 Bd Robert Ballanger', NULL, NULL, '92140', 'CLAMART', '05-83-07-70-89', '05-71-96-48-21', '1960-06-10 00:00:00.000', 0.253433, 2200, 'C3C5A688-6352-4087-94B2-B94677C642BA', 6, 2),
(385, 'LABROSSE', 'Patrick', 'M.', '44 Rue Victor Hugo', NULL, NULL, '28240', 'LA LOUPE', '02-36-67-55-64', '02-27-34-34-06', '1955-03-17 00:00:00.000', 0.80817, 20500, '3F70F965-C620-413E-B436-791E08DE60DD', 6, 2),
(386, 'DI BIASIO', 'Bernard', 'M.', '7 Place du 11 Novembre 1918', NULL, NULL, '69003', 'LYON', '02-05-82-88-91', '02-71-44-29-51', '1945-05-27 00:00:00.000', 0.318199, 24800, 'C7888491-821C-4D1D-A835-E8DDB29D19AB', 6, 2),
(387, 'DE SAINT MARTIN', 'Alain', 'M.', '111 Avenue Jean Jaurs', NULL, NULL, '43750', 'VALS PRES LE PUY', '03-48-01-25-43', '03-51-67-77-83', '1947-05-22 00:00:00.000', 0.73214, 900, 'CB920A6D-7CF3-4690-BCFE-911B063DDD8F', 6, 2),
(388, 'VALETTE', 'Brigitte', 'Mme.', '4 Rue de Chartres', NULL, NULL, '49000', 'ANGERS', '04-47-89-91-99', '04-48-28-08-14', '1931-07-26 00:00:00.000', 0.940518, 400, '17DB642C-CC81-443A-A564-0B2B29E026A3', 6, 1),
(389, 'GONNET', 'Andr', 'M.', '61 Avenue Rockefeller', NULL, NULL, '92140', 'CLAMART', '04-12-58-56-44', '04-40-83-43-81', '1948-07-27 00:00:00.000', 0.481523, 14000, 'D82474FB-0C5C-4700-88AA-B168B233FE60', 6, 2),
(390, 'DAIM', 'Richard', 'M.', '9 Rue Charles Massot', NULL, NULL, '91290', 'ARPAJON', '05-49-13-70-98', '05-74-12-20-88', '1961-03-22 00:00:00.000', 0.720876, 12300, 'D84CCF9B-7285-4FE5-A35E-0E18BFBED57E', 4, 2),
(391, 'SUCH', 'Franoise', 'Mme.', '20 Rue Rabelais', NULL, NULL, '17570', 'LES MATHES', '00-35-14-05-04', '00-32-59-50-54', '1950-09-05 00:00:00.000', 0.540657, 21400, 'BFE18AA9-CF63-498C-AD55-259D235ACAAF', 6, 1),
(392, 'SIOU', 'Georges', 'M.', '27 Rue Pierre et Marie Curie', NULL, NULL, '06400', 'CANNES', '01-52-40-57-51', '01-19-65-86-40', '1930-07-16 00:00:00.000', 0.264697, 9700, 'DBA4BD2E-A343-4FDB-9DD2-B8929B944F02', 6, 2),
(393, 'LE BERRE', 'Bernard', 'M.', '31 Bd Abel Cornaton', NULL, NULL, '75008', 'PARIS', '04-23-03-94-52', '04-75-11-56-88', '1948-10-27 00:00:00.000', 0.0985573, 10700, '0C79BD68-0C25-432C-BCCE-EA673218CB86', 6, 2),
(394, 'FAYOLLE', 'Gildas', 'M.', 'Rsidence Les Trmires', 'Bd des Rgates', 'LA PALMYRE', '29940', 'LA FORET FOUESNAN', '03-60-92-48-79', '03-35-45-10-65', '1960-05-22 00:00:00.000', 0.867304, 12200, 'FB1BF7E7-E6E8-47AC-9D59-39ED3C34C2A8', 6, 2),
(395, 'CARPENTIER-GRYNTUS', 'Grard', 'M.', '49 Rue Flix Faure', NULL, NULL, '78910', 'OSMOY', '02-36-83-97-15', '02-64-45-50-18', '1952-09-06 00:00:00.000', 0.703981, 16600, '1B51706A-7C44-4C68-8AC2-D00A1C48CC7C', 6, 2),
(396, 'BARD', 'Monique', 'Mme.', '66 Avenue des Champs lyses', 'Lot 74', NULL, '41000', 'BLOIS', '05-01-35-43-95', '05-82-05-02-85', '1944-01-17 00:00:00.000', 0.402677, 11400, '79D15269-D925-4F8F-9DC5-51FF6399396C', 6, 1),
(397, 'KFOURY', 'Michel', 'M.', '7 Place de l''Eglise', NULL, NULL, '21000', 'DIJON', '00-66-50-84-56', '00-26-43-65-78', '1954-02-24 00:00:00.000', 0.00844777, 2600, '0E588C31-F34E-4C01-8B40-D27C8CCC2E66', 1, 2),
(398, 'DREUILLE', 'Martine', 'Mme.', '6 Rue du Pr Clos', NULL, NULL, '75116', 'PARIS', '00-34-07-16-56', '00-39-27-61-17', '1950-01-10 00:00:00.000', 0.109821, 24100, '3C325D27-68DA-4FCF-9B5F-9C3E4F49A597', 6, 1),
(399, 'RIVIERE', 'Jean-Louis', 'M.', '6 Quai Villebois Mareuil', NULL, NULL, '34500', 'BZIERS', '02-95-95-02-15', '02-97-61-07-15', '1958-04-03 00:00:00.000', 0.658926, 15600, '7EB00649-10BD-40D1-A54E-5CFF4B77E863', 6, 2),
(400, 'MAEGERLIN', 'Jean-Luc', 'M.', '5 Bd de la Trmouille', NULL, NULL, '78570', 'ANDRESY', '00-72-66-71-47', '00-16-55-62-98', '1944-04-10 00:00:00.000', 0.667374, 9100, 'E0B2C35D-4DA3-4D6C-88D2-68AAA54EF0FA', 6, 2),
(401, 'HAMARD', 'Georges', 'M.', '17 Rue Galile', NULL, NULL, '13210', 'SAINT RMY DE PROVENCE', '04-27-02-89-68', NULL, '1938-11-20 00:00:00.000', 0.0591344, 14400, '8E000179-B3DB-45ED-874D-0EFA085A1B5B', 6, 2),
(402, 'THIERY', 'Jacqueline', 'Mme.', '19 Rue Louis Bausset', NULL, NULL, '78860', 'SAINT NOM LA BRETECHE', '00-76-45-75-22', '00-98-84-45-60', '1945-01-25 00:00:00.000', 0.909543, 11200, 'D5D9F486-7B0A-4CD1-B3EF-3F88A3E7231D', 6, 1),
(403, 'FROG', 'Jean-Marie', 'M.', '3 Manoir de Denouval', NULL, NULL, '59800', 'LILLE', '00-84-01-77-95', '00-83-84-21-43', '1934-05-10 00:00:00.000', 0.895463, 17300, '51C00DA7-3F43-4036-AB91-58EE375046E8', 6, 2),
(404, 'STUFFEL', 'Christian', 'M.', '39 Bd Victor Hugo', NULL, NULL, '06400', 'CANNES', '02-94-87-43-15', '02-17-55-68-19', '1953-07-26 00:00:00.000', 0.101373, 11200, '4BB500B7-DD78-4299-9FF8-F3A2C8764989', 1, 2),
(405, 'OUTELDAIT', 'Jean-Claude', 'M.', 'R.N. 307', 'Lieu dit " La Tuilerie "', NULL, '67000', 'STRASBOURG', '00-61-00-60-85', '00-17-14-75-41', '1929-04-01 00:00:00.000', 0.118269, 12700, '764F9742-F275-4453-97EA-D16CADF9CAA8', 6, 2),
(406, 'BERTIN', 'Kamel', 'M.', '25 Rue du Faisan', NULL, NULL, '75011', 'PARIS', '01-07-63-77-24', '01-22-94-70-64', '1952-08-07 00:00:00.000', 0.73214, NULL, 'E5B1F6DB-7E7E-47CB-9995-2DDD1A0140C5', 6, 2),
(407, 'GIO', 'Philippe', 'M.', '20 Rue Latour Maubourg', NULL, NULL, '75116', 'PARIS', '01-29-90-83-51', '01-83-94-76-49', '1949-05-05 00:00:00.000', 0.121085, 19500, 'F271C236-9D36-4EF6-BA23-1D738734986A', 6, 2),
(408, 'SCHEYDER', 'Maurizio', 'M.', '1 Place de l''Homme de Fer', NULL, NULL, '05100', 'MONTGENEVRE', '03-35-17-80-53', '03-82-68-16-82', '1958-12-14 00:00:00.000', 0.940518, 10500, '7F2F9769-B6D4-49FE-A5D4-E12CAAED5F47', 6, 2),
(409, 'ROBINE', 'Grard', 'M.', '14 Rue Richard Lenoir', NULL, NULL, '93350', 'LE BOURGET', '00-20-96-40-78', '00-83-95-51-02', '1947-09-19 00:00:00.000', 0.168955, 5400, 'F524CE65-53D2-4A42-AC67-566AABFF18FE', 6, 2),
(410, 'JIBERT', 'Lucien', 'M.', '23 Avenue Marceau', NULL, NULL, '94450', 'LIMEIL BREVANNES', '05-09-54-73-20', '05-10-24-05-73', '1945-06-18 00:00:00.000', 0.574448, 19400, '6CAFC756-4FE8-4D32-9D8E-E147427E5A38', 6, 2),
(411, 'DAILLY', 'Lucien', 'M.', 'Rsidence Le Praya', NULL, NULL, '75016', 'PARIS', '00-26-25-76-93', '00-21-63-77-00', '1949-05-21 00:00:00.000', 0.453363, 6600, 'C909BE47-D419-4360-B348-EDE9FFBAB892', 5, 2),
(412, 'LAMEZEC', 'Gilbert', 'M.', '6 Bis Rue Anizan Cavillon', NULL, NULL, '75015', 'PARIS', NULL, '05-20-71-46-82', '1943-04-13 00:00:00.000', 0.653294, 11300, '41C74343-7A90-4D33-B188-CD43186F140D', 6, 2),
(413, 'GRABOWSKI', 'Cyril', 'M.', '2 Avenue de Verdun', NULL, NULL, '78200', 'MANTES LA JOLIE', '03-99-65-32-94', '03-94-08-83-07', '1968-05-30 00:00:00.000', 0.872936, 24200, '471DD7B1-796C-49C9-9374-F7F70EB0D7A7', 6, 2),
(414, 'GONNET', 'Michel', 'M.', '10 Rue Pergolse', NULL, NULL, '75015', 'PARIS', '02-50-31-04-03', '02-88-50-11-49', '1955-05-21 00:00:00.000', 0.847593, 10200, 'D0C9D9F5-7D2F-4F47-942A-CCF66AD50934', 6, 2),
(415, 'MILESY', 'Bernard', 'M.', '150 Rue de Vaugirard', NULL, NULL, '34280', 'LA GRANDE MOTTE', '03-20-15-63-74', '03-29-04-31-30', '1944-10-19 00:00:00.000', 0.839145, 8600, '4B2CB27E-B18B-4C31-ACA2-BD43329BDE3E', 6, 2),
(416, 'ROCA', 'Ginette', 'Mme.', '9/11 Place Armand Cassan', NULL, NULL, '75007', 'PARIS', '01-77-02-40-14', '01-03-28-96-37', '1925-07-01 00:00:00.000', 0.419572, 9800, 'E3BFAD41-0EF2-4B01-A7B8-14A961209FDE', 6, 1),
(417, 'SARTIRIOLI-BOCCACCIO', 'Etienne', 'M.', '5 Rue de l''Amiral Roussin', NULL, NULL, '66000', 'PERPIGNAN', '01-97-60-36-59', '01-51-65-71-34', '1949-05-13 00:00:00.000', 0.132348, 24200, '7DAD788D-8B06-45F6-BE69-D5290532BF46', 6, 2),
(418, 'BRUNET', 'Paul', 'M.', 'Rsidence Incas', '422 Avenue de Melgueil', NULL, '06700', 'SAINT LAURENT DU VAR', '00-05-01-82-55', '00-24-18-26-42', '1952-01-16 00:00:00.000', 0.85604, 25000, '5FE906E0-1C6F-40CD-B426-D61F6BD22A88', 2, 2),
(419, 'METRAL', 'Claudette', 'Mme.', '8 Rue d''Estres', NULL, NULL, '92120', 'MONTROUGE', '03-65-38-38-06', '03-02-81-44-43', '1936-03-14 00:00:00.000', 0.326647, 6300, 'F94D1409-183D-42FF-8467-90D525740D46', 6, 1),
(420, 'LAUNAY', 'Maryline', 'Mme.', '15 Rue du Lieutenant Pruneta', NULL, NULL, '06250', 'MOUGINS', '04-72-17-41-02', '04-12-76-35-27', '1957-02-28 00:00:00.000', 0.816617, 500, '4F95F17B-DD35-45BE-9941-6F54CF907C63', 6, 1),
(421, 'BOUTAREL', 'Jean-Pierre', 'M.', 'Quartier Les Iscles', NULL, NULL, '75017', 'PARIS', '04-83-96-46-41', '04-81-12-50-34', '1950-07-11 00:00:00.000', 0.960229, 6700, 'EE260343-CD31-475D-B13D-DA89D0B92210', 6, 2),
(422, 'LACHKAR', 'Andr', 'M.', '99 Bis Avenue Verdier', NULL, NULL, '97110', 'POINTE A PITRE', '04-30-11-55-75', '04-29-56-14-78', '1931-08-30 00:00:00.000', 0.225274, NULL, '6329C675-F3D9-4D70-8F79-1F10F0CBF088', 6, 2),
(423, 'PERROT', 'Serge', 'M.', '62 Rue des Lombards', NULL, NULL, '78430', 'LOUVECIENNES', '03-37-06-55-66', '03-86-49-43-12', '1947-11-25 00:00:00.000', 0.563184, 6900, 'D1116373-CEA0-4632-BB57-A3122273FBD0', 6, 2),
(424, 'MICHEL', 'Gisle', 'Mme.', '68 Bis Bd Pereire', NULL, NULL, '63000', 'CLERMONT FERRAND', '04-12-98-13-39', '04-08-20-16-58', '1951-03-26 00:00:00.000', 0.430836, 7300, 'C9A4C051-C15E-4CF2-9782-961CCE788179', 6, 1),
(425, 'COHEN', 'Nicole', 'Mme.', '10 Rue Nozires', NULL, NULL, '60600', 'CLERMONT', NULL, '00-28-99-91-10', '1945-02-23 00:00:00.000', 0.78001, 20900, 'B18D3FE7-5852-41E1-875A-0D4A53732404', 1, 1),
(426, 'BENOIT', 'Liliane', 'Mme.', '11 A Quai Conti', NULL, NULL, '75002', 'PARIS', '03-92-51-32-85', '03-06-44-66-26', '1944-10-15 00:00:00.000', 0.613871, 21300, 'AE920D7D-382A-42F2-B534-D354057BA9D9', 6, 1),
(427, 'MELLONE', 'Alain', 'M.', '15 Bd Pochet Lagaye', NULL, NULL, '92380', 'GARCHES', '02-54-77-40-34', '02-31-28-96-69', '1945-05-20 00:00:00.000', 0.208378, 24400, '6FA73EAC-1343-47D8-8978-B1A72F56D434', 6, 2),
(428, 'BONNET', 'Xavier', 'M.', '6 Rue du Gnral De Gaulle', NULL, NULL, '92200', 'NEUILLY', '01-94-17-99-52', '01-65-69-64-42', '1964-01-13 00:00:00.000', 0.588528, 6000, '5093E2C5-8B66-4EC5-B42A-6D104BC199DB', 6, 2),
(429, 'NARDELLI', 'Lionel', 'M.', '39 Rue de Palestro', NULL, NULL, '69570', 'DARDILLY', '01-65-89-98-83', '01-11-57-65-37', '1971-01-14 00:00:00.000', 0.771563, 22200, 'B40ED99E-DA95-4A95-BA37-8727E4BDF1B1', 6, 2),
(430, 'BONSIRVEN', 'Claude', 'M.', '77 Rue du 19 Janvier', NULL, NULL, '83400', 'HYERES', '01-70-90-24-21', '01-00-71-33-39', '1938-05-04 00:00:00.000', 0.960229, 19600, '05DC1820-F130-4EB8-B54E-9C092186E17F', 6, 2),
(431, 'KUTA', 'Jean-Claude', 'M.', '60 Bd Vital Bouhot', NULL, NULL, '87000', 'LIMOGES', '00-94-51-89-18', '00-13-96-87-41', '1943-02-09 00:00:00.000', 0.253433, 300, 'BF40A37D-5250-412A-BFF2-0D37236C3B29', 6, 2),
(432, 'LE BRAS', 'Richard', 'M.', '18 Place de l''glise', NULL, NULL, '01540', 'VONNAS', '03-34-70-37-11', '03-86-97-76-36', '1965-04-22 00:00:00.000', 0.509682, 3300, '933B3187-E2D4-431C-8BC3-4B3674BECB9E', 1, 2),
(433, 'HURON', 'Jean-Pierre', 'M.', '15 Avenue des Iles d''Or', NULL, NULL, '44000', 'NANTES', '00-14-81-72-23', '00-37-29-12-81', '1945-07-29 00:00:00.000', 0.729324, 18300, 'D9F682F0-C861-4833-809E-AD8FFAFC3D24', 6, 2),
(434, 'PENSIERI', 'Grard', 'M.', '220 Rue Franois Perrin', NULL, NULL, '77500', 'CHELLES', '03-92-63-88-04', '03-79-69-94-08', '1953-05-13 00:00:00.000', 0.143612, 6500, '5755C856-CDB7-45FF-842B-82BF687D7DC4', 6, 2),
(435, 'GASC', 'Jean-Pierre', 'M.', '" Les Plaines "', NULL, NULL, '75116', 'PARIS', '05-08-72-63-95', '05-25-42-08-55', '1944-04-02 00:00:00.000', 0.673005, 20100, '8D6A9DE5-1865-4F59-AF0C-08015869B750', 6, 2),
(436, 'LEGER', 'Denis', 'M.', '24 Rue du Calvaire', NULL, NULL, '38460', 'SAINT ROMAIN DE JALIONAS', '01-00-16-79-69', '01-72-90-72-55', '1966-11-02 00:00:00.000', 0.112637, 13600, '6997F4E0-0385-45AB-BD61-A985E0702F3E', 6, 2),
(437, 'RIGAUD', 'Christian', 'M.', '21 Avenue de la Rsistance', NULL, NULL, '75012', 'PARIS', '04-60-32-70-65', '04-91-44-35-59', '1938-09-10 00:00:00.000', 0.94615, 20600, 'E66BD89A-8622-494F-8A09-4C8F79BEC3B2', 6, 2),
(438, 'BEHAR', 'Valry', 'M.', '64 Rue de Longchamp', NULL, NULL, '78460', 'CHEVREUSE', NULL, '02-38-64-16-78', '1958-12-12 00:00:00.000', 0.79409, 2100, '259CA1F8-5D67-4E59-B5E0-215129917CC8', 6, 2),
(439, 'TESTANIERE', 'Maurice', 'M.', '14 Chemin du Revolat', NULL, NULL, '75015', 'PARIS', '01-26-38-35-64', '01-64-72-46-19', '1939-12-10 00:00:00.000', 0.470259, 19000, '8462953D-82C1-4EAE-9E29-595D57238786', 5, 2),
(440, 'BARRIE', 'Grard', 'M.', '74 Rue du Faubourg Saint Antoine', NULL, NULL, '84400', 'APT', NULL, '04-04-75-86-86', '1954-05-21 00:00:00.000', 0.419572, 22700, 'B2238A57-FB68-4DD7-8CF1-95E900F4AA0B', 6, 2),
(441, 'ROUBY', 'Nicolas', 'M.', '23 Route de la Brosse', NULL, NULL, '81000', 'ALBI', '01-83-34-43-45', '01-54-01-09-76', '1972-06-17 00:00:00.000', 0.994021, 3700, '719E7971-9777-4FDA-BF4E-9359DDF0CBC6', 6, 2),
(442, 'THOMAS', 'Michelle', 'Mme.', '25 Bd Garibaldi', NULL, NULL, '83260', 'LA CRAU', '01-59-66-24-87', '01-55-67-57-86', '1945-03-31 00:00:00.000', 0.898279, 1600, '64F3CDC9-1342-4E5E-B564-CEC9BBA7BE90', 6, 1),
(443, 'KLEIN', 'Michel', 'M.', '61 Quai de la Libert', NULL, NULL, '29110', 'CONCARNEAU', '05-61-48-86-94', '05-63-04-30-29', '1948-09-11 00:00:00.000', 0.692717, 10700, '2774DD05-FBE6-4287-9955-182B4CA74056', 6, 2),
(444, 'LESIGNE', 'Norbert', 'M.', '9 Avenue Gambetta', NULL, NULL, '83600', 'FRJUS', '00-59-02-52-98', '00-44-25-19-13', '1947-09-01 00:00:00.000', 0.48997, 19100, '6B726B0B-53AE-4E03-823C-1BA2CE7D1F08', 6, 2),
(445, 'GOUDIN', 'Jacques', 'M.', '6 Place Victor Hugo', NULL, NULL, '14117', 'ARROMANCHES LES BAINS', '02-69-32-07-42', '02-16-29-25-62', '1942-12-23 00:00:00.000', 0.118269, 4800, '41D70AB3-117E-4C01-BFB4-49C79F635534', 6, 2),
(446, 'CROUZET', 'Grard', 'M.', '17 Avenue de la Gare', NULL, NULL, '94210', 'LA VARENNE SAINT HILAIRE', '03-19-34-13-47', '03-61-68-64-87', '1949-05-04 00:00:00.000', 0.720876, 13900, 'E1A8071D-D13D-49AB-A8FC-CAFE46D2C1E7', 2, 2),
(447, 'MAINGUY', 'Nicole', 'Mme.', '11 Quartier Latin', 'PORT FRJUS', NULL, '92200', 'NEUILLY', '05-01-39-40-57', '05-90-74-50-43', '1930-03-11 00:00:00.000', 0.256249, 6700, '882B22DD-7D7A-48D7-898A-0EBA27EA4DF4', 6, 1),
(448, 'HYE', 'Philippe', 'M.', '26 Rue Franois Carpentier', NULL, NULL, '44600', 'SAINT NAZAIRE', '01-23-08-14-44', '01-31-51-09-95', NULL, 0.458995, 1700, '11292037-95DF-4C42-8506-1F8BCF4F9C43', 6, 2),
(449, 'BINETTI', 'Jean', 'M.', '22 Rue Parmentier', NULL, NULL, '94800', 'VILLEJUIF', '05-99-33-95-59', '05-73-50-81-51', '1934-10-27 00:00:00.000', 0.447732, 6100, 'DB0BFD2C-4176-4C75-AE60-E1EF1D012CBF', 6, 2),
(450, 'OIKNINE', 'Frdrique', 'Mme.', '41 Rue Ybry', NULL, NULL, '83000', 'TOULON', '01-52-58-95-96', '01-85-35-96-79', '1970-02-12 00:00:00.000', 0.563184, 16600, '2E4128C4-A500-445B-8F0D-D4A7C6CD0B0C', 6, 1),
(451, 'ANCELIN', 'Charles', 'M.', '89 Avenue de la Rpublique', NULL, NULL, '67000', 'STRASBOURG', '00-65-17-74-66', '00-12-91-58-89', '1966-10-02 00:00:00.000', 0.0140796, 6200, '2A9A41C8-19ED-466B-B5A5-8C2D10007E9E', 6, 2),
(452, 'REGNIER', 'Frdrique', 'Mme.', '42 Avenue de Paris', NULL, NULL, '44800', 'SAINT HERBLAIN', '02-27-00-56-49', '02-37-53-04-31', '1962-04-04 00:00:00.000', 0.985573, 10000, '59A92394-4C94-4C2C-BB5B-8A9F38A474D9', 6, 1),
(453, 'ADRIEN', 'Claudine', 'Mme.', '981 Avenue Franois Nardi', 'La Pinde', NULL, '27500', 'PONT AUDEMER', '01-31-14-64-33', '01-55-50-47-73', '1956-01-07 00:00:00.000', 0.723692, 8100, '7EBFB7A6-CF57-4D5F-B41A-D4D2644F480C', 3, 1),
(454, 'SIMONET', 'Lucien', 'M.', '26 Avenue de la Marseillaise', NULL, NULL, '92160', 'ANTONY', '05-01-35-16-95', '05-43-95-65-59', '1937-08-21 00:00:00.000', 0.270329, NULL, '17783DA7-1958-4650-A048-F9420577BF51', 6, 2),
(455, 'GRAMMATICO', 'Richard', 'M.', 'Centre Commercial "Les Arcades"', '6 Bis Place de la Paix', NULL, '42330', 'SAINT GALMIER', '00-50-95-33-75', '00-33-88-01-26', '1970-05-21 00:00:00.000', 0.222458, 22300, '7BE3F678-ED15-4718-A7B4-DF1722C06DB1', 6, 2),
(456, 'NICOLAS', 'Marc', 'M.', '3 Rue Paul Clmencin', NULL, NULL, '06000', 'NICE', '03-81-63-04-29', '03-87-45-83-05', '1957-09-11 00:00:00.000', 0.881384, 12500, '7D5EFB31-D096-45BC-8FBC-5D12B60D609D', 6, 2),
(457, 'GARCIA', 'Pierre', 'M.', '82 Avenue Aristide Briand', NULL, NULL, '85100', 'LES SABLES D''OLONNE', '03-30-02-73-41', '03-34-64-49-48', '1932-10-15 00:00:00.000', 0.771563, 16000, '1933A4A0-16F0-4A5B-9E8E-534BB1BF758B', 6, 2),
(458, 'HOCHBERG', 'Herv', 'M.', '12 Place Aristide Briand', NULL, NULL, '75008', 'PARIS', '05-18-81-92-99', '05-60-42-78-63', '1947-09-28 00:00:00.000', 0.481523, 11100, '51C29236-9F90-4493-93D3-A3F377AE3048', 6, 2),
(459, 'DUGU', 'Nathalie', 'Mme.', '4 Avenue Saint Jean Baptiste', NULL, NULL, '75017', 'PARIS', '04-99-45-69-92', '04-31-57-73-34', '1963-03-07 00:00:00.000', 0.639214, 24800, 'D8225BC6-D0FE-491C-89EB-2CCE31322688', 6, 1),
(460, 'BOUVIER', 'Jean', 'M.', '6 Rue Achille Duclos', NULL, NULL, '14000', 'CAEN', '01-91-17-29-98', '01-52-46-34-71', '1937-07-15 00:00:00.000', 0.858856, 6300, '2BCB9941-0163-404E-8683-43DAE88BDC5C', 7, 2),
(461, 'GUITARD', 'Michel', 'M.', '75 Rue du Rocher', NULL, NULL, '83140', 'SIX FOURS LES PLAGES', '01-61-69-05-25', '01-32-45-71-25', '1946-09-15 00:00:00.000', 0.298488, 19100, '4736CACA-04F4-459F-9216-571F64A25AE1', 6, 2),
(462, 'LPINAY', 'Evelyne', 'Mme.', '44 Rue Jouffroy d''Abbans', NULL, NULL, '33300', 'BORDEAUX', '02-35-73-53-25', '02-94-53-72-80', '1951-02-26 00:00:00.000', 0.937702, 10300, 'C3B99D71-5023-4D84-A277-01A5EEFA9CF5', 6, 1),
(463, 'BORREL', 'Guy', 'M.', '39 Rue de la Dlivrande', NULL, NULL, '75008', 'PARIS', NULL, NULL, '1936-01-02 00:00:00.000', 0.836329, 17500, '69A2C6FB-E1EA-4F65-8523-898491B87092', 6, 2),
(464, 'BARRA', 'Jean-Pierre', 'M.', '41 Rue de la Rpublique', NULL, NULL, '64200', 'BIARRITZ', '01-48-76-79-18', '01-32-73-75-91', '1947-02-18 00:00:00.000', 0.554737, 17400, '7296F16B-8C42-4246-B106-2781B67EE088', 6, 2),
(465, 'COLOMBAIN', 'Andra', 'Mme.', '81 Bis Avenue Emile Counord', NULL, NULL, '75015', 'PARIS', '02-12-46-46-86', '02-23-52-26-98', '1947-06-18 00:00:00.000', 0.405493, 13000, 'F569FE11-6A90-44BF-B84A-19CBB8359ACF', 6, 1),
(466, 'PICARD', 'Grard', 'M.', '89 Rue de Monceau', NULL, NULL, '91130', 'RIS ORANGIS', '03-50-69-04-30', '03-47-75-96-52', '1937-01-26 00:00:00.000', 0.895463, 23400, '0CA7BBCE-69B0-432E-ACBF-AAF957F6424F', 6, 2),
(467, 'PATUREAU-MIRAND', 'Marie-Thrse', 'Mme.', '5 Avenue Foch', NULL, NULL, '92130', 'ISSY LES MOULINEAUX', '01-97-17-09-08', '01-91-74-81-46', '1943-01-01 00:00:00.000', 0.619503, 7300, 'DA935D4B-847F-4707-AB80-CD227F47BDB9', 4, 1),
(468, 'AGID', 'Charles', 'M.', '8 Square Desnouettes', NULL, NULL, '45110', 'CHATEAUNEUF SUR LOIRE', '03-36-39-40-18', '03-16-39-32-48', '1959-07-01 00:00:00.000', 0.906727, 12400, '23EC6224-D311-4673-AA7A-A3D6AC3FFC41', 6, 2),
(469, 'GENET', 'Jacques', 'M.', '48 Avenue de la Libration', NULL, NULL, '06000', 'NICE', '03-16-21-72-46', '03-90-48-80-89', '1965-01-21 00:00:00.000', 0.129532, 19000, 'EB1DC8F3-1C0F-4B8A-BB8A-909576F115A4', 6, 2),
(470, 'TASSIN DE MONTAIGU', 'Eric', 'M.', '8 Rue Claude Matrat', NULL, NULL, '75008', 'PARIS', '04-79-47-79-24', '04-76-45-16-97', '1947-10-03 00:00:00.000', 0.577264, 18700, '9957EEBC-46FB-4AC2-9B8E-AE2D867BC33E', 6, 2),
(471, 'FOUCHER', 'Foulques', 'M.', '1 Rue De Lattre de Tassigny', NULL, NULL, '53400', 'CRAON', '04-23-20-96-81', '04-73-08-60-63', '1945-05-06 00:00:00.000', 0.994021, 11800, '07740340-631B-49B9-93D5-FD236B7440B9', 6, 2),
(472, 'VARDI', 'Paul', 'M.', '6 Avenue de Sude', NULL, NULL, '75012', 'PARIS', '00-98-02-35-89', '00-45-00-54-31', '1919-11-05 00:00:00.000', 0.802538, 8400, 'B047271F-FA86-4556-9ACC-E287E273467E', 6, 2),
(473, 'TROUPEL', 'Michal', 'M.', '14 Avenue Matignon', NULL, NULL, '75008', 'PARIS', '01-02-23-12-45', NULL, '1942-12-06 00:00:00.000', 0.979941, 2200, 'AA4F8002-FAEF-412C-973C-B885C124D88A', 6, 2),
(474, 'GOICHON', 'Huguette', 'Mme.', 'La Motte Daudier', NULL, NULL, '30000', 'NIMES', '01-29-34-46-41', '01-57-60-86-02', '1939-10-19 00:00:00.000', 0.149244, 9400, '4CE37E40-A8AE-43A2-9599-6353C9960454', 7, 1),
(475, 'DENIS', 'Brigitte', 'Mme.', '43 Rue Claude Decaen', NULL, NULL, '33000', 'BORDEAUX', '01-28-85-04-60', '01-76-10-41-70', '1956-01-22 00:00:00.000', 0.827881, 13400, '4071D0A4-B4CF-4DB8-8A9C-96C41B922CD1', 6, 1),
(476, 'DESJOUR', 'Georges', 'M.', '38 Avenue Marceau', NULL, NULL, '31000', 'TOULOUSE', '02-52-01-47-32', '02-59-07-33-43', '1937-09-24 00:00:00.000', 0.948966, 4500, '09559100-2F97-4E54-B783-64878715EF4D', 6, 2),
(477, 'DUPARC', 'Marie-Hlne', 'Mme.', '4 Rue Cit Foulc', NULL, NULL, '44380', 'PORNICHET', '00-35-56-44-79', '00-51-29-25-73', '1957-01-15 00:00:00.000', 0.895463, 21000, '5D56DBED-33BB-4192-A8C7-CD5690C12823', 6, 1),
(478, 'SABBAN', 'Denis', 'M.', '95 Rue Notre Dame', 'NIAFLES', NULL, '75018', 'PARIS', '05-98-28-40-83', '05-17-44-69-15', '1988-05-07 00:00:00.000', 0.734956, 14000, '05E358C2-EF55-4E46-9A55-F1D2628AEB18', 6, 2),
(479, 'FIEVET', 'Patrick', 'M.', '2 Alles Paul Feuga', NULL, NULL, '75008', 'PARIS', '01-81-30-27-71', '01-68-15-96-15', '1953-05-22 00:00:00.000', 0.93207, 5100, '0269B258-72DC-451A-81E0-310D0FEB4153', 6, 2),
(480, 'CHARRY', 'Claude', 'M.', '50 Avenue du Gnral De Gaulle', NULL, NULL, '78800', 'HOUILLES', '03-79-32-99-36', '03-21-80-87-15', '1937-03-17 00:00:00.000', 0.940518, 22500, '3F1BAE6C-90BC-45C6-A2A4-D012EC963E9B', 6, 2),
(481, 'MET', 'Fabrice', 'M.', '37 Rue Doudeauville', NULL, NULL, '92200', 'NEUILLY', '03-19-43-10-52', '03-82-70-80-86', '1963-07-20 00:00:00.000', 0.71806, 5000, '5AAEC67B-3340-48FD-9EE7-0C949D96AB5B', 4, 2),
(482, 'BOURGEOIS', 'Patrick', 'M.', '37/39 Rue de la Bienfaisance', NULL, NULL, '56100', 'LORIENT', '02-51-49-36-12', '02-70-65-99-89', '1957-04-17 00:00:00.000', 0.616687, 21500, '17CB4146-AA81-4FD8-89DB-AED83F2DCD72', 6, 2),
(483, 'VASSEUR', 'Franoise', 'Mme.', '33 Bd Jean Jaurs', NULL, NULL, '75011', 'PARIS', '02-49-51-96-90', '02-65-66-02-24', '1966-07-23 00:00:00.000', 0.073214, 20600, '1DEA7586-3B89-486F-9C6F-32073E88F1C2', 6, 1),
(484, 'MENCIERE', 'Alain', 'M.', '27 Rue Chauveau', NULL, NULL, '80000', 'AMIENS', '01-83-02-21-91', '01-93-88-43-10', '1948-03-28 00:00:00.000', 0.836329, 16100, '5573A9C8-CAFE-427C-955A-F0DAB3B3F3FB', 6, 2),
(485, 'FUMAGALLI', 'Brigitte', 'Mme.', '7 Bd Gnral Leclerc', NULL, NULL, '78200', 'MANTES LA JOLIE', '00-49-24-46-21', '00-89-50-55-41', '1955-02-09 00:00:00.000', 0.408309, 19900, '8EA0E7A4-4595-46A5-AC6D-314F79970F4F', 6, 1),
(486, 'VIVES', 'Christine', 'Mme.', '37 Rue Lon Frot', NULL, NULL, '75014', 'PARIS', '00-57-17-02-79', '00-80-39-53-87', '1960-08-02 00:00:00.000', 0.104189, NULL, 'B040A1CB-BCAD-40E7-9F3D-42680B776BD8', 6, 1),
(487, 'LE NORMAND', 'Gilles', 'M.', '150 Rue Valentin Hay', NULL, NULL, '34500', 'BZIERS', '01-14-62-20-86', '01-83-04-34-17', '1957-08-30 00:00:00.000', 0.19993, NULL, 'B14BDC45-8719-425F-AC19-93A7968C88F8', 6, 2),
(488, 'LIAGRE', 'Marc', 'M.', '6 Rue Gambetta', NULL, NULL, '75008', 'PARIS', NULL, '00-78-13-87-26', '1952-03-08 00:00:00.000', 0.458995, 23900, '5D460E15-FCF6-490E-9ADA-1EE39623A02A', 1, 2),
(489, 'LUX', 'Christian', 'M.', '157 Rue d''Alsia', NULL, NULL, '75004', 'PARIS', '02-26-42-87-44', '02-86-51-01-22', '1944-07-24 00:00:00.000', 0.501234, 21800, 'C9F234AD-8E2C-4736-8DBC-F64BD9580F2C', 6, 2),
(490, 'DELOS', 'Grard', 'M.', '5/7 Place de la Victoire', NULL, NULL, '67000', 'STRASBOURG', '00-68-73-08-23', '00-76-45-45-02', '1941-12-08 00:00:00.000', 0.51813, 21900, '95A9E44C-A405-4388-A0B0-2F4D2C151C69', 6, 2),
(491, 'HIRIBARREN', 'Jacques', 'M.', '16 Rue Christophe Colomb', NULL, NULL, '75017', 'PARIS', '00-97-36-51-41', '00-17-40-11-33', '1927-09-09 00:00:00.000', 0.954598, 9500, '9A2082D3-48BD-4592-83F8-680030BB818E', 6, 2),
(492, 'BOUCHAIN', 'Marie', 'Mme.', '16 Rue des Tournelles', NULL, NULL, '64700', 'HENDAYE', '04-80-68-29-95', '04-53-67-88-36', '1972-11-06 00:00:00.000', 0.101373, 23000, '6B97594C-8398-42FF-BCBD-AF7D59AC721D', 6, 1),
(493, 'GENOT', 'Philippe', 'M.', '4 Rue du Gnral de Castelnau', NULL, NULL, '75016', 'PARIS', '00-16-56-12-47', '00-67-25-83-57', '1947-01-13 00:00:00.000', 0.723692, 18400, '2F5E71D6-E3C5-4A25-BD2E-B44E29C00BD3', 6, 2),
(494, 'MARTORELL', 'Lucette', 'Mme.', '12 Rue du Dbarcadre', NULL, NULL, '75012', 'PARIS', '03-38-30-80-20', '03-53-48-59-52', '1945-10-04 00:00:00.000', 0.374518, 20600, 'C227CA45-000D-4076-AB1D-1D4B4CBF3367', 6, 1),
(495, 'TRINQU', 'Marie-Bernadette', 'Mme.', 'Rsidence Port Hendaye', NULL, NULL, '31000', 'TOULOUSE', '05-13-32-50-38', '05-62-17-51-09', '1958-04-13 00:00:00.000', 0.180219, 12700, '6D0DD873-B68D-4201-894C-8A22F8A40940', 1, 1),
(496, 'DAMONTE', 'Michel', 'M.', '83 Rue Michel-Ange', NULL, NULL, '31000', 'TOULOUSE', '00-59-49-07-37', '00-30-79-31-06', '1953-10-04 00:00:00.000', 0.734956, 2600, 'DCDA986D-DA01-4248-9A8D-71F0A73076C2', 6, 2),
(497, 'DE CLAUSEL DE COUSSERGUES', 'Georges', 'M.', '14 Rue d''Aligre', NULL, NULL, '06110', 'LE CANNET', '05-10-76-41-50', '05-32-55-53-19', '1928-07-15 00:00:00.000', 0.447732, 14000, '59BA483C-9200-4A9C-B823-5C80B26901C6', 6, 2),
(498, 'GOY MARTIN GRANDE Y RUIZ', 'Alain', 'M.', '29 Alles Franois Verdier', NULL, NULL, '34000', 'MONTPELLIER', '00-84-47-96-86', '00-82-40-00-14', '1942-04-30 00:00:00.000', 0.433652, 24700, '09467B07-2732-47A8-B40F-1946D27D6BCA', 6, 2),
(499, 'EBOSSE MBAPPE', 'Jos', 'M.', '21 Alles Franois Verdier', NULL, NULL, '34000', 'MONTPELLIER', '02-32-63-91-48', '02-59-41-12-25', '1943-11-04 00:00:00.000', 0.329463, 11000, '9FEFCA6C-BA14-450E-BABB-EC0EA35678E5', 6, 2),
(500, 'LABBE', 'Zacharie', 'M.', '107 Bd Paul Doumer', NULL, NULL, '75015', 'PARIS', '05-92-45-89-47', '05-23-40-32-90', '1943-03-10 00:00:00.000', 0.171771, 13600, 'EC736750-A678-4DF2-9DED-9EBF9567617F', 6, 2),
(501, 'DE DOUVILLE MAILLEFEU', 'Alain', 'M.', '47 Quai du Verdanson', NULL, NULL, '91590', 'LA FERT ALAIS', '00-93-08-20-14', '00-67-21-72-22', '1940-08-18 00:00:00.000', 0.377334, NULL, '38FE20F0-1982-4FD5-ABBA-F56865645398', 6, 2),
(502, 'BAILLY', 'Thierry', 'M.', '21 Bd Louis Blanc (Lot n9)', NULL, NULL, '14470', 'COURSEULLES SUR MER', '04-28-53-43-07', NULL, '1943-08-08 00:00:00.000', 0.960229, NULL, 'EF91319E-4E4A-4702-8C89-A5CC523B7D76', 5, 2),
(503, 'BEHA', 'Nol', 'M.', '366 Ter Rue de Vaugirard', NULL, NULL, '39000', 'LONS LE SAUNIER', '02-10-86-67-07', '02-50-48-99-15', '1954-12-25 00:00:00.000', 0.968677, 4200, '7ED56FB4-B853-46C0-9057-B30C79645E86', 6, 2),
(504, 'CLERC', 'Franois', 'M.', '4 Place du March', NULL, NULL, '75008', 'PARIS', '03-10-36-80-20', '03-09-65-92-71', '1958-05-06 00:00:00.000', 0.988389, 2100, '5560A741-CF1C-493D-A663-73EAACEE8B1C', 6, 2),
(505, 'FONVIELLE', 'Yves', 'M.', '8 Place du March', NULL, NULL, '25000', 'BESANCON', NULL, '01-61-74-46-00', '1958-11-11 00:00:00.000', 0.253433, 11700, '98B7A77F-445A-4FE0-9341-8EA238EAE36B', 6, 2),
(506, 'GIROUX', 'Laurent', 'M.', '19 Rue Saint Dsir', NULL, NULL, '33200', 'BORDEAUX', '01-48-40-14-39', '01-75-79-79-71', '1967-06-30 00:00:00.000', 0.71806, 3700, '501FA2B9-F9C1-4F21-B51A-939FA9F24456', 6, 2),
(507, 'FOREST', 'Philippe', 'M.', '65 Rue du Faubourg Saint Honor', NULL, NULL, '21560', 'ARC SUR TILLE', '04-96-33-47-90', '04-38-86-40-33', '1952-06-23 00:00:00.000', 0.0197115, 17000, '3EE0E8C0-4369-4972-8C2A-E39A8E7EE0EA', 6, 2),
(508, 'MAZAUD', 'Nathalie', 'Mme.', '14 Rue d''Alsace', NULL, NULL, '75012', 'PARIS', '03-69-57-50-09', '03-16-75-66-87', '1952-10-25 00:00:00.000', 0.0225274, 8100, '3DF9A4D9-7A69-48AB-80A5-6742B2E23101', 6, 1),
(509, 'TEMIME', 'Jacques', 'M.', '295 Avenue de la Rpublique', NULL, NULL, '71200', 'LE CREUSOT', '03-24-59-43-44', '03-96-96-57-60', '1952-12-25 00:00:00.000', 0.963045, 11200, 'CE0C071A-418F-48DD-9E43-4572628E323A', 2, 2),
(510, 'CLMENT', 'Hugues', 'M.', '16 Rue de Bressey', NULL, NULL, '75007', 'PARIS', '00-43-42-11-76', '00-45-57-77-79', '1961-03-25 00:00:00.000', 0.0281592, 100, '5D38546B-34C1-4C6D-8662-87CE1FECC3E6', 6, 2),
(511, 'REDOLFI', 'Michel', 'M.', '16 Villa du Bel Air', NULL, NULL, '47000', 'AGEN', '02-01-67-83-79', '02-53-39-62-53', '1941-05-17 00:00:00.000', 0.80817, 24100, '128791B8-1BEB-4985-8FB6-B6FDDDA724AE', 6, 2),
(512, 'ANTONINI', 'Michle', 'Mme.', '3 Rue Jean Jaurs', NULL, NULL, '91490', 'MILLY LA FORET', '00-61-22-45-09', '00-34-68-52-71', NULL, 0.633582, 14600, 'B0363774-1706-4A5F-8170-FEFDDA012F62', 6, 1),
(513, 'JANDET', 'Christian', 'M.', '57 Rue Vaneau', NULL, NULL, '13006', 'MARSEILLE', '00-51-94-42-02', '00-97-84-37-99', '1949-11-01 00:00:00.000', 0.929254, 17900, 'AD05D241-54BA-4BD3-AE68-4871AC05C8A7', 6, 2),
(514, 'OHANA', 'Ren', 'M.', '86 Bd de la Rpublique', NULL, NULL, '69220', 'SAINT JEAN D''ARDIERES', '05-79-90-06-04', '05-23-42-77-53', '1939-03-03 00:00:00.000', 0.453363, 2700, '007CCCAD-8112-414E-BD67-3CF29CF5F53C', 6, 2),
(515, 'DE VRIENDT', 'Marcel', 'M.', '21 Avenue de Ganay', NULL, NULL, '75016', 'PARIS', '03-39-48-56-59', '03-27-68-45-78', '1957-01-10 00:00:00.000', 0.408309, 5300, 'F166A2C0-57C6-40D9-AEF2-33E76385106E', 6, 2),
(516, 'FREVILLEZ', 'Herv', 'M.', '65 Avenue Cantini', NULL, NULL, '77200', 'TORCY', '02-23-14-67-61', '02-16-69-86-36', '1956-09-27 00:00:00.000', 0.425204, 16000, '1758276B-A20C-479B-A0E7-2DFF340BB52D', 1, 2),
(517, 'LEAL', 'Patrick', 'M.', '34 Rue Marchal Foch', NULL, NULL, '78560', 'PORT MARLY', '02-34-77-20-67', NULL, '1954-03-14 00:00:00.000', 0.915175, 21300, '661BFF42-E15F-4F21-B038-33AF02D77191', 6, 2),
(518, 'PETRYKOW', 'Joaquim', 'M.', '22 Rue de Boulainvilliers', NULL, NULL, '75008', 'PARIS', '01-62-32-84-99', '01-24-43-46-14', '1931-04-24 00:00:00.000', 0.532209, 13500, '2E976C90-A1A3-46DA-8DA2-BB4448565DF0', 6, 2),
(519, 'MRAND', 'Marc', 'M.', 'Le Khops 1 - 99 Rue de Paris', NULL, NULL, '30240', 'LE GRAU DU ROI', '03-70-33-58-39', '03-90-81-59-17', '1957-03-12 00:00:00.000', 0.42802, 900, 'C0A3A627-1D44-4E0A-97AF-9D038DFE3465', 6, 2),
(520, 'SAUREL', 'Bernard', 'M.', '2 Route de Versailles', NULL, NULL, '26100', 'ROMANS', '04-30-20-80-81', '04-79-13-09-14', '1949-06-30 00:00:00.000', 0.425204, 16700, 'B7566E01-50FD-4EFB-970B-1707024EFAA4', 6, 2),
(521, 'PINCEMAILLE', 'Pascal', 'M.', '66 Rue de Lisbonne', NULL, NULL, '92390', 'VILLENEUVE LA GARENNE', '05-31-14-89-99', '05-46-74-64-70', '1954-06-15 00:00:00.000', 0.0703981, 300, 'B4849439-B29E-4607-BCC5-3C5D184CAED4', 6, 2),
(522, 'KRUMMENACKER', 'Raymond', 'M.', 'Bd du Front de Mer', NULL, NULL, '75001', 'PARIS', '05-83-54-58-16', '05-30-96-82-70', '1933-02-16 00:00:00.000', 0.0506866, 14800, 'FB8D819E-82D1-4DB4-85C9-15D009CDC659', 6, 2),
(523, 'PRETESEILLE', 'Annie', 'Mme.', '3 Bis Bd Marx Dormoy', NULL, NULL, '54000', 'NANCY', '00-84-31-70-17', '00-50-18-27-60', '1943-05-04 00:00:00.000', 0.126716, 1800, '38B1CE4D-323C-49CF-B99A-5A13BADD5867', 1, 1),
(524, 'LELLOUCHE', 'Claude', 'Mme.', '184 Bd Gallini', NULL, NULL, '44000', 'NANTES', '04-46-07-61-39', '04-99-28-62-88', '1957-06-07 00:00:00.000', 0.332279, 19500, 'E7B9C7F4-741F-4AFA-A954-2AEEE4D7D30A', 6, 1),
(525, 'ROBINET DE PLAS', 'Elie', 'M.', '242 Rue de Rivoli', NULL, NULL, '94160', 'SAINT MAND', '00-44-34-70-11', '00-96-44-99-08', '1960-06-12 00:00:00.000', 0.934886, 7100, 'E6A927AA-75F7-4183-AF66-D5838AC95FD9', 6, 2),
(526, 'DAGON', 'Roland', 'M.', '29 Rue de la Salle', NULL, NULL, '45160', 'OLIVET', '00-68-47-45-14', '00-50-13-47-70', '1938-09-02 00:00:00.000', 0.625135, 600, 'A5440039-2FEB-4C1F-B470-1A204DDF83F1', 6, 2),
(527, 'GODARD', 'Frdric', 'M.', '4 Rue Racine', NULL, NULL, '68300', 'SAINT LOUIS', '02-13-29-20-36', '02-90-22-03-65', '1960-06-18 00:00:00.000', 0.582896, 3500, '25A23207-B0DD-4B3D-AB72-6F72381666B8', 6, 2),
(528, 'VITRANT', 'Philippe', 'M.', '14 Bd de la Guyane', NULL, NULL, '30900', 'NIMES', '05-48-24-53-98', '05-59-98-51-98', '1957-10-14 00:00:00.000', 0.658926, 7500, '6A393933-376C-4853-ACD5-2B29F9DBC581', 6, 2),
(529, 'BARBIER', 'Jacqueline', 'Mme.', '211 Rue de Picardie', NULL, NULL, '75017', 'PARIS', '00-18-19-87-57', '00-32-10-19-76', '1927-12-27 00:00:00.000', 0.495602, 14200, '6A87A5C8-5086-4151-978F-67B24A03C3CB', 6, 1),
(530, 'FABRE', 'Christophe', 'M.', '6 Rue des Acacias', NULL, NULL, '93400', 'SAINT OUEN', NULL, '05-24-05-48-34', '1970-11-13 00:00:00.000', 0.937702, 20000, 'A1E45478-087E-419F-B1C8-520E71B7A5C4', 5, 2),
(531, 'JEANNEST DE GYVES', 'Daniel', 'M.', '52 Rue de la Rpublique', NULL, NULL, '06130', 'GRASSE', '02-70-13-41-21', '02-29-00-89-85', '1953-04-17 00:00:00.000', 0.785642, 22000, '2815F942-8C29-4BCE-B12B-80E0028CAB10', 6, 2),
(532, 'GIRARD-CLAUDON', 'Claude', 'Mme.', '110 Rue Pierre Demours', NULL, NULL, '75007', 'PARIS', '04-11-15-88-08', '04-83-44-61-92', '1924-07-21 00:00:00.000', 0.588528, 11400, '3C1E6011-CEEA-41BD-A563-35A74BDA01A6', 6, 1),
(533, 'ROCCON', 'Pierre-Joseph', 'M.', '32 Rue des Rosiers', NULL, NULL, '75008', 'PARIS', '05-12-10-81-58', '05-80-54-19-23', '1928-10-28 00:00:00.000', 0.473075, 18800, '2C2BD260-F53E-475C-8AD3-D7A697A6E029', 6, 2),
(534, 'TURPIN', 'Jean-Loup', 'M.', 'Rsidence Amiral de Grasse', '3 Bis Bd Victor Hugo', NULL, '69008', 'LYON', '02-83-41-71-42', '02-52-39-64-97', '1949-06-15 00:00:00.000', 0.242169, 16200, 'CEEBE755-B522-4ADC-BD0D-063017552523', 6, 2),
(535, 'DUREUX', 'Jean-Claude', 'M.', '286 Bd Saint Germain', NULL, NULL, '45680', 'DORDIVES', '00-54-46-10-18', '00-61-65-81-86', '1939-11-04 00:00:00.000', 0.920807, 12000, 'C8871A05-7571-4988-9B39-81BD32E9904F', 6, 2),
(536, 'DEGEORGES', 'Fernand', 'M.', '5 Rue de Thran', NULL, NULL, '59400', 'CAMBRAI', '00-44-05-64-61', '00-62-92-43-30', '1947-03-23 00:00:00.000', 0.405493, 13200, '0B121662-BDD2-4521-BC28-240879BC42D6', 6, 2),
(537, 'SCHOUBRENNER', 'Roger', 'M.', '36 Rue Villon', NULL, NULL, '63400', 'CHAMALIERES', '02-95-67-24-31', '02-82-72-87-82', '1931-06-13 00:00:00.000', 0.644846, 1800, 'CBD6FCEF-F643-409D-A502-438E47E700DF', 2, 2),
(538, 'GONNU', 'Jean-Denis', 'M.', 'R.N. 7 - 119 Route de Paris', NULL, NULL, '57110', 'YUTZ', '03-20-77-92-71', '03-08-22-02-93', '1954-03-04 00:00:00.000', 0.129532, 10600, '4256EFEC-F697-4F9C-A325-DCC7A609A4B0', 6, 2),
(539, 'GUILLARD', 'Pierre-Jean', 'M.', '105 Rue du Pont aux Moulins', NULL, NULL, '13090', 'AIX EN PROVENCE', '05-19-15-96-98', '05-56-96-80-17', '1949-02-01 00:00:00.000', 0.768747, 9100, '14566574-98BB-4619-9904-497224EE658B', 6, 2),
(540, 'GUILLON', 'Jean', 'M.', '55 Avenue Thermale', NULL, NULL, '75014', 'PARIS', '03-84-80-33-80', '03-43-19-64-61', '1932-10-13 00:00:00.000', 0.0760299, 6500, 'C62BC147-76D3-4A73-A35E-6116DFDF54AD', 6, 2),
(541, 'GEAI', 'Yves', 'M.', '24 Rue Nationale', NULL, NULL, '75001', 'PARIS', '00-32-65-05-63', '00-74-93-92-00', '1946-11-22 00:00:00.000', 0.312567, 0, 'DD6671F1-B287-408D-AA3A-8D530DA4E3CC', 6, 2),
(542, 'MOUTON', 'Georges', 'M.', 'Rsidence Les Facults - Bt. B', '35 Avenue de l'' Europe', NULL, '92800', 'PUTEAUX', '02-13-27-79-69', '02-04-94-86-66', '1949-12-11 00:00:00.000', 0.202746, 18100, '1F060707-A466-401F-BA57-2FDADBD0B19A', 6, 2),
(543, 'PARENT', 'Michel', 'M.', '48 Rue Sarrette', NULL, NULL, '42300', 'ROANNE', '04-65-58-42-04', '04-81-41-33-70', '1947-04-26 00:00:00.000', 0.0985573, 24400, '0FFE064E-01F9-4C31-83B0-238D1650A010', 6, 2),
(544, 'DE VOLONTAT', 'Paul', 'M.', '3 Rue d''Alger', NULL, NULL, '92170', 'VANVES', NULL, '03-44-60-45-92', '1921-05-08 00:00:00.000', 0.991205, 4400, 'FE9204E4-6DB1-489F-B6E6-8DED982695FA', 3, 2),
(545, 'DU ROUX DE CHEVRIER DE VARENNE D', 'Franois', 'M.', '30 Place Ronde', NULL, NULL, '31400', 'TOULOUSE', '01-43-15-51-35', '01-22-40-07-08', '1965-03-02 00:00:00.000', 0.0478707, 6300, '2CAE8350-B2ED-477E-A718-82A4DD2D767B', 6, 2),
(546, 'BERNOLE', 'Michel', 'M.', '33 Rue Jean Jaurs', NULL, NULL, '75007', 'PARIS', NULL, '02-68-84-83-58', '1948-02-04 00:00:00.000', 0.830697, 7600, '7A72499F-5525-409B-B601-9681B0183FEB', 6, 2),
(547, 'BARDON-LEWY', 'Christine', 'Mme.', '53 Rue Sadi Carnot', NULL, NULL, '38250', 'VILLARD DE LANS', '05-57-86-94-90', '05-75-96-75-34', '1955-09-01 00:00:00.000', 0.720876, 1600, '16B56E1D-4D62-4F26-95E4-CE3A5B0B1459', 6, 1),
(548, 'VITU', 'Jrme', 'M.', '1 Rue du Japon', NULL, NULL, '92200', 'NEUILLY', '01-16-72-94-91', '01-09-95-99-98', '1966-11-27 00:00:00.000', 0.461811, 4500, '3612DBE2-BED5-4AC4-B388-B90809EC88BE', 6, 2),
(549, 'SEMETE', 'Benot', 'M.', '78 Rue du Bac', NULL, NULL, '75016', 'PARIS', '01-98-31-70-18', '01-30-98-38-01', '1961-02-01 00:00:00.000', 0.509682, 10800, 'DB719C31-7556-4B34-A3FE-F426B5319A31', 6, 2),
(550, 'RAVIER', 'Francesca', 'Mme.', 'Les Glovettes', NULL, NULL, '91820', 'BOUTIGNY', '02-96-00-17-96', '02-35-17-77-34', '1958-04-21 00:00:00.000', 0.413941, 24100, '0A29A110-066C-48F9-87E0-53E3F64FF8A2', 6, 1),
(551, 'BONNET', 'Jean-Louis', 'M.', '21 Rue de Chartres', NULL, NULL, '75016', 'PARIS', '02-18-96-92-96', '02-60-01-29-92', '1942-11-04 00:00:00.000', 0.422388, 19200, 'A0554895-C95E-4572-8933-1DDB15F9F671', 7, 2),
(552, 'DIARD', 'Patrick', 'M.', '11 Rue Gavarni', NULL, NULL, '63800', 'COURNON D''AUVERGNE', '03-97-82-99-75', '03-68-81-08-15', '1959-04-14 00:00:00.000', 0.166139, 17600, '5CCAD4E8-92DD-41CB-99A4-67F4229962FE', 6, 2),
(553, 'PELLOUX', 'Charles', 'M.', '6 Place Charles De Gaulle', NULL, NULL, '93410', 'VAUJOURS', '01-73-46-74-78', '01-03-88-22-92', '1948-12-18 00:00:00.000', 0.0703981, 24600, 'FBC31863-8007-4B9A-9767-80365029049D', 6, 2),
(554, 'DEL MISTRO', 'Paul-Andr', 'M.', '18 Avenue Mozart', NULL, NULL, '75008', 'PARIS', '02-86-95-12-18', '02-41-24-13-51', NULL, 0.419572, 14700, '0DB58155-2F49-4DC7-83C5-E25EA2C89D50', 6, 2),
(555, 'D''ANDIGN', 'Jol', 'M.', '25 Rue du Commerce', NULL, NULL, '59800', 'LILLE', '02-20-89-14-08', '02-11-87-67-13', '1948-09-21 00:00:00.000', 0.0506866, 11300, 'CD5C876F-1A0B-430B-B464-9A36D7E09FCF', 6, 2),
(556, 'DUCRET', 'Ivan', 'M.', '113 Rue de Meaux', NULL, NULL, '75005', 'PARIS', '01-79-63-75-87', '01-60-37-71-82', '1956-07-18 00:00:00.000', 0, 12500, '0DBF2CBD-7546-4B63-B76E-94CEE99A3AF5', 6, 2),
(557, 'BAYONNE', 'Christine', 'Mme.', '50 Avenue des Champs Elyses', NULL, NULL, '74260', 'LES GETS', '01-28-54-70-66', '01-38-01-66-71', '1962-01-16 00:00:00.000', 0.816617, 2600, '65645E4C-D69E-41B6-AD71-94A03A069783', 6, 1),
(558, 'LABRENNE', 'Pascal', 'M.', '127 Rue Nationale', NULL, NULL, '31130', 'BALMA', '04-59-34-36-02', '04-86-26-89-79', '1968-05-07 00:00:00.000', 0.416756, 11200, 'A9688348-4837-4B11-B02B-3C8BAF3EF3E4', 4, 2),
(559, 'MEA', 'Marcelle', 'Mme.', '81 Bd Saint Michel', NULL, NULL, '95440', 'ECOUEN', '00-62-02-18-77', '00-73-85-01-57', '1939-11-09 00:00:00.000', 0.777195, 7000, 'D4BAC275-16F9-460E-B0E4-067DA7790589', 6, 1),
(560, 'HANIN', 'Martine', 'Mme.', '"Le Ttras "', NULL, NULL, '78290', 'CROISSY SUR SEINE', '04-54-07-27-66', '04-02-84-64-74', '1950-04-22 00:00:00.000', 0.0619503, 18600, '50E84DDA-1941-453C-8341-1F0ED0A9DEEE', 6, 1),
(561, 'BARRAL', 'Philippe', 'M.', '36 Rue Arthur Rimbaud', NULL, NULL, '44000', 'NANTES', '01-47-43-11-05', '01-68-45-18-10', '1957-11-29 00:00:00.000', 0.988389, 200, 'A6D3FECD-3EB8-4508-B17F-0F61DA749AC2', 6, 2),
(562, 'NEYRET', 'Michel', 'M.', '15 Rue Paul Lorillon', NULL, NULL, '34130', 'MAUGUIO', '02-64-31-49-70', '02-36-85-21-98', '1945-07-17 00:00:00.000', 0.554737, 15500, '4DFD7F51-BEA7-4641-B1B1-2DAF128E196F', 6, 2),
(563, 'BORDJEL', 'Andr', 'M.', '40 Bd Fernand Hostachy', NULL, NULL, '01500', 'AMBERIEU EN BUGEY', '04-95-72-25-53', '04-73-71-84-58', '1946-11-26 00:00:00.000', 0.0225274, 6900, 'E188303C-230A-46B1-A62C-846C21AF4895', 6, 2),
(564, 'RIUS', 'Henry-Jo', 'M.', '10 Bis Rue Klber', NULL, NULL, '67000', 'STRASBOURG', '01-48-43-92-95', '01-93-66-31-04', '1957-01-27 00:00:00.000', 0.444916, 16400, 'EDD39EAC-85E3-450E-AC78-B5B566E13F13', 6, 2),
(565, 'CAMMAS', 'Henri', 'M.', '105 Rue des Colverts', NULL, NULL, '31400', 'TOULOUSE', '03-31-75-58-28', '03-71-84-10-75', '1952-10-19 00:00:00.000', 0.0112637, 19200, '9DBA0AFB-0E2B-42BB-8EC1-743C2C06D312', 7, 2),
(566, 'ROGER', 'Christine', 'Mme.', '52 Avenue Paul Painlev', NULL, NULL, '31840', 'SEILH', '02-94-68-78-48', NULL, '1958-11-27 00:00:00.000', 0.613871, 3500, '2548A1A8-293A-402C-9A3A-DC8BED74F31D', 6, 1),
(567, 'GIVERDON', 'Alain', 'M.', '18 Rue de la Msange', NULL, NULL, '95130', 'FRANCONVILLE', '04-90-92-53-09', '04-33-48-82-69', '1949-08-20 00:00:00.000', 0.799722, NULL, '7DF94548-466F-4FD6-8828-3E450A60BB48', 6, 2),
(568, 'CORFA', 'Alain', 'M.', '116 Grande Rue Saint Michel', NULL, NULL, '38750', 'L''ALPE D''HUEZ', '02-68-58-21-68', '02-08-80-83-95', '1953-03-09 00:00:00.000', 0.622319, 11500, 'C4671072-9E6F-46CA-9A96-834016531594', 6, 2),
(569, 'GEBENHOLTZ', 'Jean-Alain', 'M.', 'Village du Golf', 'Rue Rmi Raymond', NULL, '29200', 'BREST', '00-59-15-49-59', '00-81-58-92-20', '1960-04-16 00:00:00.000', 0.692717, 8700, '75AF3CD0-DB98-42CF-A8D9-A546117841C0', 6, 2),
(570, 'RAJKOVIC', 'Georges', 'M.', '117 Rue du Gnral Leclerc', NULL, NULL, '14150', 'OUISTREHAM-RIVA BELLA', '00-13-42-76-43', '00-96-93-21-00', '1959-12-30 00:00:00.000', 0.208378, 15100, 'B8E761E0-11F1-4722-BBB3-F70FB3929E16', 6, 2),
(571, 'CUCHE', 'Eric', 'M.', 'Avenue des Jeux', NULL, NULL, '75013', 'PARIS', '01-76-91-19-85', '01-41-59-91-47', '1953-07-22 00:00:00.000', 0.475891, 22300, '006FD7EC-C589-43ED-AADA-9D666025A66C', 6, 2),
(572, 'DALMAU', 'Didier', 'M.', '45 Rue de Kertatupage', NULL, NULL, '06400', 'CANNES', '05-96-90-10-71', '05-67-45-95-58', '1964-04-28 00:00:00.000', 0.768747, 8400, 'F56AA128-1E9F-4BDD-A429-B227F865FED3', 4, 2),
(573, 'SAILLARD', 'Raymond', 'M.', '1 Rue de la Mer', NULL, NULL, '34410', 'SERIGNAN', '03-70-05-03-07', '03-27-28-77-53', '1935-07-07 00:00:00.000', 0.687085, 6100, 'C755242F-C584-484D-9730-B7FB03C82F33', 6, 2),
(574, 'COESNON', 'Alain', 'M.', '33 Rue du Moulinet', NULL, NULL, '25000', 'BESANCON', '02-32-22-23-02', '02-15-24-13-35', '1943-08-04 00:00:00.000', 0.073214, NULL, '3F6DEC66-8AD4-468C-AA4F-4CDB8071CF90', 6, 2),
(575, 'SOUBIEILLE', 'Jean-Pierre', 'M.', '46 Rue Jean Jaurs', NULL, NULL, '78300', 'POISSY', '03-24-53-19-73', '03-15-84-79-01', '1946-10-16 00:00:00.000', 0.278776, 1100, '48633922-5C04-49A0-B18F-B40FBDCFC321', 6, 2),
(576, 'VILLACRECES', 'Marc', 'M.', '148 Avenue de la Plage', NULL, NULL, '64500', 'CIBOURE', '00-51-66-69-02', '00-01-38-04-49', '1939-09-20 00:00:00.000', 0.394229, 9200, '3B4F55E1-B794-4449-902A-7E05A5BEDEDC', 6, 2),
(577, 'MARVILLE', 'Camille', 'M.', '33 Grande Rue', NULL, NULL, '75008', 'PARIS', '04-68-67-12-71', '04-90-32-72-57', '1937-04-19 00:00:00.000', 0.430836, 20400, '9A4CC841-589C-43C2-B98B-0C313CC18A20', 6, 2),
(578, 'PETIBON DE LA BESNARDIERE', 'Claudine', 'Mme.', '23 RN 13', 'Route de Quarante Sous', NULL, '75016', 'PARIS', '04-13-83-79-70', '04-61-59-47-64', '1939-09-12 00:00:00.000', 0.774379, 11500, '53176353-BB3B-4507-B712-30ECC9539B7F', 6, 1),
(579, 'CHABOCHE', 'Michel', 'M.', 'Rsidence Untxin I', 'SOCOA', NULL, '93220', 'GAGNY', '00-17-54-01-38', '00-32-74-63-06', '1937-06-13 00:00:00.000', 0.0591344, 17300, 'B565249A-F472-4727-927D-C3D72F0720DD', 1, 2),
(580, 'ROYER', 'Jean-Claude', 'M.', '83 Rue du Faubourg Saint Honor', 'Angle 27 Avenue Matignon', NULL, '75016', 'PARIS', '02-49-16-10-70', '02-21-66-80-24', '1946-08-18 00:00:00.000', 0.48997, NULL, 'B2A795BD-174F-4056-81D7-9EDDE967E3B4', 6, 2),
(581, 'ALESSANDRI', 'Patrick', 'M.', '2 Rue du Lieutenant Colonel', 'Deport', NULL, '50000', 'SAINT LO', NULL, '04-63-67-45-63', '1958-05-12 00:00:00.000', 0.537841, 1200, '23CCDB61-4DBD-454B-BB0B-0E607BD9B19E', 6, 2),
(582, 'COSTABEL', 'Louis', 'M.', '9 Avenue Jean Jaurs', NULL, NULL, '83400', 'HYERES', '03-04-15-62-91', '03-91-24-12-14', '1949-03-05 00:00:00.000', 0.948966, 8300, '1D642515-CDE3-47C3-9C57-1A235913B16F', 6, 2),
(583, 'MELOT', 'Andr', 'M.', '46 Rue Chardon Lagache', NULL, NULL, '13001', 'MARSEILLE', '03-77-81-92-94', '03-71-54-86-30', '1935-03-07 00:00:00.000', 0.667374, 1900, '4CC58C23-08DD-4D05-887D-E4EB0B06009C', 6, 2),
(584, 'DELAGE', 'Gilles', 'M.', '26 Place du Gnral De Gaulle', NULL, NULL, '21500', 'MONTBARD', '05-23-25-41-21', '05-50-62-03-38', '1947-02-26 00:00:00.000', 0.571632, 11000, '7E91FCCA-2B67-416B-98B6-8097F9B94DD2', 6, 2),
(585, 'ZAJTELBACH', 'Jean-Claude', 'M.', '"C.A Le Scorpion"', '76 B Avenue Gambetta', NULL, '24300', 'SAINT FRONT LA RIVIERE', '00-37-56-04-85', '00-39-03-90-38', '1952-04-02 00:00:00.000', 0.185851, 16700, 'EFE73D37-2F06-4F07-B488-41AE90A98B69', 6, 2),
(586, 'ALEZRA', 'Vladimir', 'M.', '22 Bd Camille Flammarion', NULL, NULL, '75013', 'PARIS', '05-59-45-40-27', '05-02-94-96-11', '1937-04-22 00:00:00.000', 0.408309, 14000, '9135E15E-D0D0-417C-92CE-52EC593D5A8E', 1, 2),
(587, 'GARROS', 'Claude', 'M.', '4 Bis Place Gambetta', NULL, NULL, '93340', 'LE RAINCY', '04-62-25-66-09', '04-79-48-07-40', '1948-05-25 00:00:00.000', 0.143612, 18700, 'DBF6A124-7F14-48F0-9A4B-C0FF51287E6D', 6, 2),
(588, 'VALERE', 'Hubert', 'M.', 'La Varenne', NULL, NULL, '31000', 'TOULOUSE', '03-42-22-28-55', '03-46-47-82-43', '1953-01-29 00:00:00.000', 0.430836, 20300, '405155C7-A30A-4050-8E41-AF7695C42321', 6, 2),
(589, 'MUNIER', 'Laurent', 'M.', '99 Bd Auguste Blanqui', NULL, NULL, '97232', 'LE LAMENTIN', '04-24-02-26-70', '04-36-44-34-30', '1959-03-08 00:00:00.000', 0.450548, 22500, '0398D5E3-8D08-435C-9D5E-F8867C57433C', 6, 2),
(590, 'PEYTAVI', 'Andr', 'M.', '18 Avenue de la Rsistance', NULL, NULL, '90300', 'VETRIGNE', '01-59-89-08-09', '01-72-27-34-00', '1946-03-13 00:00:00.000', 0.901095, 25000, '298F6560-C7DD-488E-9808-85C3A7167661', 6, 2),
(591, 'BIETRIX', 'Jean', 'M.', '12 Rue d''Astorg', NULL, NULL, '75006', 'PARIS', '02-49-95-54-41', '02-62-83-77-47', '1912-06-27 00:00:00.000', 0.360438, 20200, 'A8F17ED0-ED00-45A6-8C01-DBA147ED5614', 6, 2),
(592, 'VALEANI', 'Andr', 'M.', 'Z.I. de la Lzarde', NULL, NULL, '95290', 'L''ISLE ADAM', '02-74-29-01-10', '02-68-97-79-13', '1937-01-20 00:00:00.000', 0.754667, 18400, '5AEB4B2C-56AE-4340-9C71-56211D3C2373', 6, 2),
(593, 'TOULEMONDE', 'Bernard', 'M.', '77 Grande Rue', NULL, NULL, '75116', 'PARIS', '03-95-58-12-05', '03-89-43-06-99', '1945-12-04 00:00:00.000', 0.79409, 5200, '9B9F270B-34C0-423A-9A15-4300D8E05C44', 5, 2),
(594, 'NICOLAS', 'Michel', 'M.', '12 Rue de l''Ancienne Comdie', NULL, NULL, '27100', 'LE VAUDREUIL', '05-92-63-79-44', '05-42-76-14-81', '1941-12-25 00:00:00.000', 0.0816617, 12300, '99182C8E-2A5E-4971-8C5A-92E99D5DB5B9', 6, 2),
(595, 'OBSZYNSKI', 'Batrice', 'Mme.', '12 Rue Saint Lazare', NULL, NULL, '34300', 'CAP D''AGDE', '05-92-98-35-77', '05-08-39-42-88', '1951-03-05 00:00:00.000', NULL, 1200, '6E38EDB3-684A-4207-974B-DC4F8964132D', 6, 1),
(596, 'RZEPKOWICZ', 'Yannick', 'M.', '19 Rue Lauriston', NULL, NULL, '67100', 'STRASBOURG', '05-56-67-22-14', '05-21-65-58-84', '1953-06-21 00:00:00.000', 0.273144, 16000, 'B24BB6C7-2D39-4521-B967-CE87494C2B7D', 6, 2),
(597, 'AUBRY', 'Charles', 'M.', '14 Rue du Gnral De Gaulle', NULL, NULL, '75002', 'PARIS', '00-19-55-57-35', '00-14-91-92-51', '1951-02-09 00:00:00.000', 0.439284, 20400, '8324D939-675D-4DE1-99FE-94D3431B6872', 6, 2),
(598, 'MULLER', 'Marc', 'M.', 'Port Ambonne', NULL, NULL, '88000', 'EPINAL', '03-80-36-43-16', '03-75-45-15-35', '1951-01-31 00:00:00.000', 0.126716, 18600, '07D69377-DBB7-4C52-8372-7B5F0C0A797D', 6, 2),
(599, 'JOUBERT', 'Carole', 'Mme.', '100 Route du Polygone', NULL, NULL, '31000', 'TOULOUSE', '05-78-28-61-68', '05-78-99-78-05', '1937-07-26 00:00:00.000', 0.974309, 13500, '50A58B5F-6096-4B59-B890-77232980E082', 6, 1),
(600, 'LEBLANC', 'Corinne', 'Mme.', '130 Rue d''Aboukir', NULL, NULL, '85200', 'FONTENAY LE COMTE', '02-15-29-38-18', '02-83-88-18-82', '1959-05-29 00:00:00.000', 0.360438, 13900, '89335084-599B-4BED-AE92-756124E7B85F', 2, 1);
CHECKPOINT;

INSERT INTO T_EMPLOYEE_EMP (EMP_ID, EMP_NOM, EMP_PRENOM, EMP_TITRE, EMP_ADRESSE1, EMP_ADRESSE2, EMP_ADRESSE3, EMP_CP, EMP_VILLE, EMP_TEL, EMP_GSM, EMP_DATE_ENTREE, EMP_INDICE, EMP_SALAIRE, EMP_MATRICULE, SRV_ID, SEX_ID) VALUES
(601, 'POUPON', 'Grard', 'M.', '9 Rue de la Comdie', NULL, NULL, '02540', 'VIEILS MAISONS', '00-67-15-67-10', '00-25-67-99-80', '1964-09-09 00:00:00.000', 0.222458, 1200, 'C0E16A50-9890-4D48-9B58-11D99A43CB13', 6, 2),
(602, 'LAMBERT', 'Dominique', 'M.', '21 Place Dupuy', NULL, NULL, '75017', 'PARIS', '03-18-61-27-86', '03-78-41-06-64', '1945-12-01 00:00:00.000', 0.698349, 9600, '5DB3F843-119F-4F74-9774-857BEA1E8E28', 6, 2),
(603, 'ESPINASSE', 'Daniel', 'M.', '17 Rue Lecomte', NULL, NULL, '69006', 'LYON', '04-26-02-77-63', '04-23-58-68-04', NULL, 0.535025, 15900, '380A4912-EFE8-4996-A22E-73B6FB433C63', 6, 2),
(604, 'MAMOU', 'Robert', 'M.', '26 Grande Rue', NULL, NULL, '66000', 'PERPIGNAN', '05-45-78-30-87', '05-75-97-51-23', '1952-12-16 00:00:00.000', 0.833513, 15400, 'EFD2C321-0A14-49EF-98DA-D98B79B55E46', 6, 2),
(605, 'RIVAULT', 'Christiane', 'Mme.', '19 Bis Rue Jouffroy d''Abbans', NULL, NULL, '06400', 'CANNES', '02-69-54-30-77', NULL, '1941-05-11 00:00:00.000', 0.839145, 19500, '9358B0B0-372A-48B6-BCEF-97579D29C1D2', 6, 1),
(606, 'DELPEYROU', 'Jean-Claude', 'M.', '109 Rue de Sze', NULL, NULL, '95870', 'BEZONS', '00-44-52-72-31', '00-16-54-14-32', '1944-02-28 00:00:00.000', 0.872936, 400, 'C7D8025C-9637-4765-B218-06DA774AB5D2', 6, 2),
(607, 'DUVAL', 'Jean-Pierre', 'M.', '47 Bd Clmenceau', NULL, NULL, '31770', 'COLOMBIERS', '05-84-72-00-43', '05-30-83-05-39', '1953-03-26 00:00:00.000', 0.253433, 22900, '00DB7384-2FCE-4CD2-BD91-1E7FB9932BA3', 1, 2),
(608, 'LEJEAN', 'Jean-Franois', 'M.', '" Palais Lumire "', '1 Rue Henri Ruhl', NULL, '92100', 'BOULOGNE', '02-81-38-82-17', '02-92-89-95-64', '1948-09-24 00:00:00.000', 0.701165, 3700, 'D0A71085-C2F1-45CA-999E-5A6BE64AF847', 6, 2),
(609, 'ZIVY', 'Georges', 'M.', '113 Rue Edouard Vaillant', NULL, NULL, '93340', 'LE RAINCY', '04-62-81-75-75', '04-24-41-12-71', '1922-08-02 00:00:00.000', 0.0901095, NULL, 'CF3BE0F9-001D-4B8A-A168-EFB821FE2CEA', 6, 2),
(610, 'PREAULT', 'Jean-Claude', 'M.', '43 Alle des Corbires', NULL, NULL, '75010', 'PARIS', '05-64-33-95-38', '05-03-68-33-38', '1943-04-27 00:00:00.000', 0.872936, 2600, '91517E4D-7350-4CD2-91B0-6542C82ECC87', 6, 2),
(611, 'VACHON', 'Jean-Pierre', 'M.', '47 Rue Marcel Dassault', NULL, NULL, '26220', 'DIEULEFIT', '03-03-12-97-71', '03-01-47-99-85', '1938-04-15 00:00:00.000', 0.273144, 3300, '56AB1271-EE0B-4618-8EC8-2429ECA59ED9', 6, 2),
(612, 'KROMPHOLTZ', 'Dominique', 'M.', '18 Avenue de la Rsistance', NULL, NULL, '21000', 'DIJON', '04-62-48-33-80', '04-73-88-10-56', '1938-12-03 00:00:00.000', 0.796906, 1200, '9D15C43A-4415-43BE-B04D-AB8C6C4D3826', 6, 2),
(613, 'STAMPF', 'Jean-Claude', 'M.', '53 Bd de Strasbourg', NULL, NULL, '57300', 'HAGONDANGE', '03-23-66-71-95', '03-44-36-19-06', '1953-09-03 00:00:00.000', 0.194299, 6200, '05B0CA72-A001-415E-A96D-186744DADE89', 6, 2),
(614, 'DESCHAMPS', 'Hlne', 'Mme.', '49 Rue du Bourg', NULL, NULL, '68100', 'MULHOUSE', '05-31-26-86-19', '05-92-88-39-61', '1943-01-05 00:00:00.000', 0.270329, 10000, 'C896B302-DAEC-4B74-844D-FD07CF2A5085', 1, 1),
(615, 'RODELLA', 'Daniel', 'M.', '12 Rue Jean Renaud', NULL, NULL, '38000', 'GRENOBLE', '00-81-59-07-09', '00-25-14-13-67', '1948-05-18 00:00:00.000', 0.588528, 5700, 'A9CB60EE-B49E-467F-A067-D9CFBE541AC4', 6, 2),
(616, 'GUIGUES', 'Guy', 'M.', '28 Rue Emile Zola', NULL, NULL, '34500', 'BZIERS', '01-03-34-40-65', '01-78-37-05-26', '1946-11-28 00:00:00.000', 0.546289, 13800, '5C159B6C-A6C6-4388-9054-F16C91394CFF', 6, 2),
(617, 'BISCOT', 'Alain', 'M.', '2 Rue Poincar', NULL, NULL, '84110', 'VAISON LA ROMAINE', '05-21-65-99-14', '05-71-65-50-66', '1962-02-11 00:00:00.000', 0.0619503, 14200, 'A614D3A5-80F8-4E58-AB92-B2A6502200FA', 6, 2),
(618, 'SAUVAGE', 'Catherine', 'Mme.', '74 Rue Thiers', NULL, NULL, '73460', 'FRONTENEX', '05-85-60-42-73', '05-68-89-04-31', '1949-10-26 00:00:00.000', 0.943334, 1400, '83DCF383-9E99-48CE-A552-EE7FC4942918', 6, 1),
(619, 'BRUNON-POIVEY', 'Monique', 'Mme.', '5 Alles Paul Riquet', NULL, NULL, '92200', 'NEUILLY', '00-58-16-43-11', '00-27-64-72-42', '1943-01-07 00:00:00.000', 0.259065, 2400, '952162D6-FC6D-47EE-AA67-96AD252409B2', 6, 1),
(620, 'LACHER', 'Marie-Christine', 'Mme.', '20 Cours Taulignan', NULL, NULL, '31500', 'TOULOUSE', '02-26-31-49-46', '02-32-28-34-01', '1959-01-07 00:00:00.000', 0.79409, 22500, '784089C1-DBE4-4DDD-BAD5-61CD6E4EF587', 6, 1),
(621, 'QURO', 'Ren', 'M.', 'Chemin des Ilettes', NULL, NULL, '62230', 'OUTREAU', '04-06-73-24-15', '04-24-77-65-22', '1930-11-19 00:00:00.000', 0.802538, 16000, 'BD186383-49EE-47CC-9B5F-4BF23B9696FC', 5, 2),
(622, 'EIDEN', 'Simone', 'Mme.', '23 Rue de Villiers', NULL, NULL, '78940', 'LA QUEUE LEZ YVELINES', '02-51-61-79-16', '02-46-28-52-69', '1943-04-24 00:00:00.000', 0.853224, 6100, 'C7B08522-A4E1-48EF-A392-FC5D6C17F38E', 6, 1),
(623, 'CRESTIN', 'Jean-Marie', 'M.', 'Parc d''activits de la Plaine', '11 rue de la marre', NULL, '30129', 'MANDUEL', '04-40-66-94-77', '04-36-19-03-63', '1928-02-03 00:00:00.000', 0.118269, 15500, '43DF3DE2-FC72-4BB0-A703-3EDCAB3E68A4', 6, 2),
(624, 'MARTENS', 'Georges', 'M.', '39 Bd de la Libert', NULL, NULL, '76240', 'BONSECOURS', '00-20-96-08-10', '00-71-49-80-37', '1949-05-21 00:00:00.000', 0.582896, 21000, '0ABBDD85-D092-4081-BEAE-25882395BD24', 6, 2),
(625, 'FERNANDEZ', 'Jean-Luc', 'M.', '16 Route Nationale', NULL, NULL, '77350', 'LE ME SUR SEINE', '00-84-84-40-16', '00-05-14-17-33', '1960-01-23 00:00:00.000', 0.546289, 10700, 'BF841F4F-4965-4FE9-94C5-76779D2A09FE', 6, 2),
(626, 'CAMOU', 'Bernard', 'M.', 'Le Vigni', NULL, NULL, '06400', 'CANNES', '04-79-56-14-51', '04-97-38-56-21', '1948-08-08 00:00:00.000', 0.768747, NULL, '87827A99-E313-417F-B413-EDE4C8754E0D', 6, 2),
(627, 'DAVOLI SCALCON', 'Pierre', 'M.', '1 Square de l''Ile de France', NULL, NULL, '31000', 'TOULOUSE', '03-64-57-81-51', '03-27-22-03-43', '1951-04-25 00:00:00.000', 0.771563, 16300, '31BC20DC-D08D-4633-9294-502DE2C3C276', 6, 2),
(628, 'LACOUR', 'Huguette', 'Mme.', '113 Alle de la Gare', NULL, NULL, '75011', 'PARIS', '04-62-81-69-36', '04-84-02-68-94', '1927-03-26 00:00:00.000', 0.906727, 4600, 'BEC69DDF-8EEE-4BAC-99F0-A221977B7936', 2, 1),
(629, 'DAVERIO', 'Francis', 'M.', '42/44 Rue des Serbes', NULL, NULL, '97150', 'SAINT MARTIN', '01-23-70-34-18', '01-00-12-42-36', '1947-07-28 00:00:00.000', 0.979941, 15700, 'ACDE9534-6B9B-4957-A8AD-CA37B8F51BA4', 6, 2),
(630, 'GRANGE', 'Louis', 'M.', '42 Rue de la Pomme', NULL, NULL, '97400', 'SAINT DENIS', '00-63-26-90-65', '00-49-51-90-06', '1939-05-26 00:00:00.000', 0.791274, 5100, 'FCB20D26-14AC-446A-80DA-A4600B7874DF', 6, 2),
(631, 'HAGGIAG', 'Jean-Louis', 'M.', '127 Rue Amelot', NULL, NULL, '42400', 'SAINT CHAMOND', '04-83-09-20-96', '04-31-99-40-43', '1956-02-04 00:00:00.000', 0.526577, 19400, 'FBEDB846-07D8-4997-93F9-61C90603EEC5', 6, 2),
(632, 'MEURILLON', 'Paul', 'M.', 'Le Doigt de Gant', 'MARIGOT', NULL, '75017', 'PARIS', '04-89-12-70-36', '04-99-44-19-48', '1928-03-28 00:00:00.000', 0.382965, 7400, '0ED6A363-BFCB-426E-8F45-439987AB0ABD', 6, 2),
(633, 'ROSSET', 'Michel', 'M.', '39 Bd Lacaussade', NULL, NULL, '62155', 'MERLIMONT', '03-94-29-37-09', '03-90-19-07-81', '1950-03-03 00:00:00.000', 0.917991, 18100, '560490FE-EDF7-4C9C-9612-62F253418118', 6, 2),
(634, 'LAPORTE', 'Franois', 'M.', '4 Rue Victor Hugo', NULL, NULL, '75007', 'PARIS', '00-51-51-04-35', '00-82-34-90-77', '1923-12-09 00:00:00.000', 0.878568, 11900, '47082DDC-1F93-4369-AE3B-0B7DA5CEBC5D', 6, 2),
(635, 'CLEACH', 'Claude', 'M.', '12 Rue Roger Bacon', NULL, NULL, '85300', 'SOULLANS', '03-65-13-38-97', '03-72-10-47-05', '1948-12-18 00:00:00.000', 0.394229, 18700, '316F1BB8-AE53-4967-8E0D-C021A17F14BC', 3, 2),
(636, 'BRUHAT', 'Marcel-Pierre', 'M.', '8 Rue Camille Delacroix', NULL, NULL, '75008', 'PARIS', '05-00-80-00-92', '05-95-08-61-89', '1934-01-16 00:00:00.000', 0.171771, 14800, 'A80F7B49-E8FB-4B63-B56E-40F0A29067C2', 6, 2),
(637, 'CANDELLIER', 'Emmanuel', 'M.', '1 Bis Avenue de Lowendal', NULL, NULL, '63000', 'CLERMONT FERRAND', '03-92-12-66-40', '03-11-25-87-07', '1964-01-02 00:00:00.000', 0.0168955, 10500, '3908D031-12E1-4BEE-82D8-E6466AC23FAD', 6, 2),
(638, 'SANTI', 'Claudette', 'Mme.', '1 Place des Sports', NULL, NULL, '95250', 'BEAUCHAMP', '03-96-03-68-79', '03-27-21-75-62', '1947-02-11 00:00:00.000', 0.346358, 6700, '145AB77B-C91D-41D0-8405-DE35F6E75D26', 6, 1),
(639, 'METZGER', 'Robert', 'M.', '89 Rue de Monceau', NULL, NULL, '06000', 'NICE', NULL, '04-55-37-13-51', '1941-04-22 00:00:00.000', 0.230906, 5000, '898B6D17-D7AC-4A55-9F6A-B454F11198BA', 6, 2),
(640, 'DEPORT', 'Claude', 'M.', '17 Rue Montlosier', NULL, NULL, '67000', 'STRASBOURG', '02-71-62-35-50', '02-39-56-38-78', '1949-06-29 00:00:00.000', 0.51813, 9600, '9C05B437-A85F-42B4-A91E-E679FAD5FD59', 6, 2),
(641, 'SARFATI', 'Gilles', 'M.', '10/12 Avenue de la Gare', NULL, NULL, '83000', 'TOULON', '03-02-23-16-75', '03-11-15-07-57', '1951-09-20 00:00:00.000', 0.425204, 7100, '8F751AD2-B7CA-450E-A28B-0CDECC3E3A7D', 6, 2),
(642, 'TALMARD', 'Albert', 'M.', '16 Rue Pastorelli', NULL, NULL, '92100', 'BOULOGNE', '04-89-25-80-57', '04-62-60-18-20', '1927-10-23 00:00:00.000', 0.444916, 18800, 'D88585B6-B3D6-413E-AD83-FA64E04AE7C3', 7, 2),
(643, 'IMPINI', 'Elzbieta', 'Mme.', '18 Rue Sainte Madeleine', NULL, NULL, '75116', 'PARIS', '05-63-23-73-08', '05-29-14-47-06', '1949-12-29 00:00:00.000', 0.799722, 13100, 'D157C34A-006A-4D83-8AE5-E06627A072AA', 6, 1),
(644, 'MONTFORT', 'Jean-Philippe', 'M.', '116 Rue Muiron', 'Le Mourillon', NULL, '74400', 'CHAMONIX', '01-47-23-85-76', '01-70-18-96-94', '1955-08-14 00:00:00.000', 0.515314, NULL, '9BD7E433-4A07-49B4-83A7-AAE4F3A899A5', 6, 2),
(645, 'CARRASCO', 'Thierry', 'M.', '24 Bis Rue des Princes', NULL, NULL, '75008', 'PARIS', '04-44-70-02-94', NULL, '1931-04-21 00:00:00.000', 0.951782, 5400, '41054BB2-C183-4CC9-BEB6-708C9DC23081', 6, 2),
(646, 'MORA', 'Sylvie', 'Mme.', '149 Avenue Victor Hugo', NULL, NULL, '44000', 'NANTES', '00-56-50-20-46', '00-59-86-31-85', '1955-02-07 00:00:00.000', 0.839145, 20600, '5F79F289-EC84-4AB5-A76E-0BFAB066D5ED', 6, 1),
(647, 'PORTIER', 'Claudine', 'Mme.', '99 Avenue de l''Aiguille du Midi', NULL, NULL, '97133', 'SAINT BARTHLMY', '01-71-95-12-52', '01-21-84-29-59', '1949-01-04 00:00:00.000', 0.568816, 6400, '98349AA1-F411-4B38-A4BA-1B95266B4662', 6, 1),
(648, 'VACHER', 'Nolle', 'Mme.', '17 Rue Daru', NULL, NULL, '75005', 'PARIS', NULL, '04-13-73-20-39', '1952-09-07 00:00:00.000', 0.171771, 7100, 'B77F303A-A891-4254-9807-0241EC0B69DB', 6, 1),
(649, 'MEUNIER', 'Viviane', 'Mme.', '116 Rue Paul Bellamy', NULL, NULL, '06800', 'CAGNES SUR MER', '03-48-97-57-57', '03-14-61-42-36', '1950-07-01 00:00:00.000', 0.985573, 24700, '2DF58F24-CEE4-4A76-AFCE-3370481C9F4F', 4, 1),
(650, 'LAMOUREUX', 'Jean', 'M.', 'Galeries du Commerce-Saint-Jean', NULL, NULL, '92000', 'NANTERRE', '00-96-57-73-46', '00-17-93-44-84', '1929-02-24 00:00:00.000', 0.50405, 1900, 'F3A32DCC-140F-49BE-AE65-90BAA5086EFD', 6, 2),
(651, 'OBERTO', 'Jean-Claude', 'M.', '17 Rue Pascal', NULL, NULL, '34800', 'CLERMONT L''HRAULT', '04-99-41-49-72', '04-93-33-02-97', '1963-01-30 00:00:00.000', 0.312567, 19600, '93FBE7D2-B8EA-4830-BA04-99743690007F', 6, 2),
(652, 'LELOUP', 'Philippe', 'M.', '3 Rue de la Placette', NULL, NULL, '95220', 'HERBLAY', '05-53-83-04-36', '05-64-31-31-54', '1957-10-19 00:00:00.000', 0.216826, 18500, 'CC8A89F2-5F73-461E-BFB8-BDCC97EF5BF8', 6, 2),
(653, 'CHATEL', 'Maryvonne', 'Mme.', '50 Avenue Franois Arago', NULL, NULL, '44100', 'NANTES', '01-89-69-48-91', '01-43-46-50-04', '1944-11-13 00:00:00.000', 0.360438, 22700, '68DE3A2B-E1CE-449C-B045-8916070F8A07', 6, 1),
(654, 'BOUVET', 'Patrick', 'M.', 'Centre Commercial Grand Axe', NULL, NULL, '13006', 'MARSEILLE', '00-78-76-63-90', '00-75-26-98-78', '1954-11-06 00:00:00.000', 0.582896, 8000, '206EE29A-5BCE-4F23-B113-5C3EB86D8FFC', 6, 2),
(655, 'BAULIER', 'Philippe', 'M.', '17 Bd du 11 Novembre', NULL, NULL, '83200', 'TOULON', '03-64-71-33-42', '03-91-76-12-32', '1929-03-09 00:00:00.000', 0.813801, 14800, 'EB255456-4C02-4ED3-96ED-2449EB606591', 6, 2),
(656, 'CELLIER', 'Yves', 'M.', '48 Bis Bd Jean XXIII', NULL, NULL, '06400', 'CANNES', '00-47-93-50-53', NULL, '1944-10-25 00:00:00.000', 0.948966, 23000, 'C87AD708-9BCF-44C3-8EFA-7BFD7977CBFB', 7, 2),
(657, 'GELEBART', 'Anne', 'Mme.', '68 Rue Saint Jacques', NULL, NULL, '75017', 'PARIS', '02-10-91-58-17', '02-90-82-53-34', '1943-11-23 00:00:00.000', 0.101373, 9700, 'E5590430-10EC-4705-9BFB-36F04BFEF114', 6, 1),
(658, 'HIRIBARREN', 'Alain', 'M.', '99 Bd Amiral Vence', NULL, NULL, '56340', 'CARNAC', '03-36-70-49-80', '03-35-03-40-97', '1946-04-30 00:00:00.000', 0.703981, 17700, 'BF58D78E-B320-4C7B-9247-61F231F44D28', 6, 2),
(659, 'GORDOLON', 'Daniel', 'M.', '93 Promenade de la Croisette', NULL, NULL, '64700', 'HENDAYE', '02-44-13-29-38', '02-21-68-29-30', '1966-03-20 00:00:00.000', 0.557553, 22200, '890A016F-FC25-4854-A66A-CB3341977D40', 6, 2),
(660, 'VIGNAU', 'Jean-Paul', 'M.', '135 Avenue de Wagram', NULL, NULL, '75018', 'PARIS', '02-76-62-92-30', '02-79-19-61-53', '1947-12-28 00:00:00.000', 0.487155, 23400, 'A9FB8998-29B2-41E3-9801-14F17380C6F6', 6, 2),
(661, 'MORTAS', 'Claude-Dora', 'Mme.', '61 Avenue des Druides', NULL, NULL, '81500', 'LAVAUR', '03-52-89-85-51', '03-94-14-94-68', '1963-06-06 00:00:00.000', 0.872936, 13400, 'B4C7EAC4-A75A-4608-9385-A2C225370E57', 6, 1),
(662, 'CHASSIN', 'Dominique-Alexandre', 'M.', '20 Bd du Gnral De Gaulle', NULL, NULL, '34000', 'MONTPELLIER', '01-05-12-95-54', '01-60-30-08-82', '1958-11-15 00:00:00.000', 0.132348, 2800, '3A49A308-79F6-4C3E-9EFC-241180E72801', 6, 2),
(663, 'KRAJCOVIC', 'Jacques', 'M.', '83 Rue Ordener', NULL, NULL, '93240', 'STAINS', '04-20-07-77-64', '04-75-94-56-28', '1940-07-07 00:00:00.000', 0.397045, 16100, '722FCAAA-BC3C-4438-85AB-FC03A9CC1858', 4, 2),
(664, 'SICARD', 'Herv', 'M.', '6 Rue Escoussires du Naridelle', NULL, NULL, '60100', 'CREIL', '05-32-27-57-53', '05-03-65-97-81', '1950-01-22 00:00:00.000', 0.799722, 22800, '4015103C-D70C-49C0-81D8-BEC09B46FBB4', 6, 2),
(665, 'PPIN', 'Pierre', 'M.', '1 Bis Rue de Verdun', NULL, NULL, '83149', 'BRAS', '02-96-31-40-72', '02-36-30-90-35', '1932-11-15 00:00:00.000', 0.4421, 12700, '9867E9DE-A13F-4A8D-AB39-D395C560EFF3', 6, 2),
(666, 'VANDENBERGHE', 'Franois', 'M.', '37 Avenue Marcel Cachin', NULL, NULL, '14470', 'COURSEULLES SUR MER', '04-45-05-65-40', '04-69-80-20-78', '1945-01-04 00:00:00.000', 0.678637, 11800, '23C3811D-1795-4365-AD4F-643C5AFBD02E', 6, 2),
(667, 'OLLET', 'Nol', 'M.', '16 Rue Jules Juillet', NULL, NULL, '75011', 'PARIS', '00-18-56-94-87', '00-47-43-14-53', '1939-12-24 00:00:00.000', 0.140796, 20400, 'C19A56C6-7341-45EE-B56D-EAB3E1CB2869', 6, 2),
(668, 'BALAY', 'Franois', 'M.', 'Place du 14 Juillet', NULL, NULL, '66000', 'PERPIGNAN', '01-65-05-85-46', '01-08-15-56-07', '1968-12-17 00:00:00.000', 0.802538, 12800, '15FEDFC9-D504-4E23-BD5B-C24B191022AF', 6, 2),
(669, 'RANCIEN', 'Lucien', 'M.', '52 Rue de la Mer', NULL, NULL, '75013', 'PARIS', '02-08-24-24-09', '02-53-33-76-21', '1937-03-29 00:00:00.000', 0.160508, 8500, 'F78D67FD-682C-4265-A236-706C8CFAA470', 6, 2),
(670, 'PERRET', 'Jean-Philippe', 'M.', '15 Avenue Philippe Auguste', NULL, NULL, '69150', 'DECINES', '00-94-24-52-92', '00-78-66-58-60', '1967-10-21 00:00:00.000', 0.312567, 5500, '71895A72-B7BB-4AC0-A51B-8CBE2C22C373', 1, 2),
(671, 'DECLOCHEZ', 'Grald', 'M.', '47 Bd Clmenceau', NULL, NULL, '14800', 'DEAUVILLE', '02-06-99-56-42', '02-42-85-02-44', '1942-10-09 00:00:00.000', 0.796906, 5800, 'A6211800-40D8-44D8-813D-C463536690B1', 6, 2),
(672, 'BOUGHATTAS', 'Marie-Claude', 'Mme.', '102 Rue Lon Maurice Nordman', NULL, NULL, '86000', 'POITIERS', '05-71-38-34-33', '05-11-27-95-58', '1949-04-26 00:00:00.000', 0.788458, 18000, '6AC17910-8146-42A8-879A-A196E2EA303E', 6, 1),
(673, 'DUQUENET', 'Salaheddine', 'M.', '214 Avenue Jean Jaurs', NULL, NULL, '75008', 'PARIS', '04-55-15-38-76', '04-82-49-61-05', '1957-09-19 00:00:00.000', 0.825065, 6400, 'B9486A13-DDEE-478D-8B2F-9D4FDF44227F', 6, 2),
(674, 'SEGUIN', 'Claude', 'M.', '1 Quai des Marchands', 'PORT DEAUVILLE', NULL, '83136', 'LA ROQUEBRUSSANNE', '05-28-38-88-82', '05-34-77-64-40', '1932-04-19 00:00:00.000', 0.0647662, 24700, '2A1F612F-177F-40FC-9B8F-5413B02CD55A', 6, 2),
(675, 'BLANKENBERG', 'Andr', 'M.', '17 Rue Magenta', NULL, NULL, '58000', 'NEVERS', '03-82-96-55-33', '03-42-69-74-04', '1943-08-22 00:00:00.000', 0.363254, NULL, 'E632C111-0F4D-4217-85CF-709C897CD977', 6, 2),
(676, 'HOLWECK', 'Maurice', 'M.', '49 Rue de Ponthieu', NULL, NULL, '75009', 'PARIS', '01-52-48-75-39', NULL, '1959-12-17 00:00:00.000', 0.4421, 24700, 'E6A45A06-E213-4230-A1CC-030ECAD428FA', 6, 2),
(677, 'FOURNI', 'Raymond', 'M.', '6 Rue Georges Clmenceau', NULL, NULL, '67000', 'STRASBOURG', '05-59-76-89-41', '05-83-71-65-68', '1951-08-19 00:00:00.000', 0.0140796, NULL, '436B54FA-6FFA-43C6-B67D-EFF4A5F7F62C', 1, 2),
(678, 'GIBOULET', 'Christophe', 'M.', '76 Rue de Trangy', 'SAINT LOI', NULL, '89130', 'TOUCY', '04-10-39-11-19', '04-78-51-44-89', '1972-08-22 00:00:00.000', 0.129532, NULL, '8BDEC806-99AC-4232-A6BC-7003BFAB5F50', 6, 2),
(679, 'RIVIERE', 'Bernadette', 'Mme.', '13 Place Kossuth', NULL, NULL, '30127', 'BELLEGARDE', '04-35-09-78-40', '04-58-11-69-98', '1953-02-11 00:00:00.000', 0.557553, 7600, '363531AF-A90B-477E-9552-A7872AA911A3', 6, 1),
(680, 'ZILLI', 'Jean-Franois', 'M.', '26 Rue du Vieux-March-aux-', 'Grains', NULL, '97434', 'SAINT GILLES LES BAINS', '04-36-49-71-11', '04-69-34-95-94', '1958-07-20 00:00:00.000', 0.0112637, 11200, 'EE0F4D4F-F8DF-4B30-B2EA-F6DB3E1C247D', 6, 2),
(681, 'DUQUENNE', 'Philippe', 'M.', '21 Rue Lucille Cormier', NULL, NULL, '45000', 'ORLANS', '02-99-30-70-07', '02-27-09-34-83', '1958-02-01 00:00:00.000', 0.833513, 8300, 'BE1B1F9A-45BE-4D7E-9FE1-E8B1451EB30F', 6, 2),
(682, 'LAMBERT', 'Jean-Marie', 'M.', '199 Rue de la Tour', NULL, NULL, '75018', 'PARIS', '03-87-60-08-22', '03-80-03-29-31', '1948-07-05 00:00:00.000', 0.816617, 16300, '1E547062-6934-42FD-8298-57FC82E350C0', 6, 2),
(683, 'DIB', 'Michel', 'M.', '3 Rsidence Le Christina', 'Avenue de la Mer', NULL, '91530', 'LE VAL SAINT GERMAIN', '03-84-42-73-15', '03-58-54-44-48', '1936-10-20 00:00:00.000', 0.194299, 3500, '05C5EF72-320D-401D-9FF2-8D41BFDB9039', 6, 2),
(684, 'BELTRA', 'Jean-Pierre', 'M.', '20 Belle Rue Saint Laurent', NULL, NULL, '06000', 'NICE', '05-79-25-16-99', '05-84-78-70-11', '1943-09-11 00:00:00.000', 0.425204, 21500, '43DD2E41-5490-4E48-82D6-97791F32189E', 5, 2),
(685, 'LAFORET', 'Josiane', 'Mme.', '108 Rue Damrmont', NULL, NULL, '34980', 'SAINT CLMENT LA RIVIERE', '02-85-02-84-31', '02-41-51-89-11', '1944-01-14 00:00:00.000', 0.281592, 17200, '3DE8BDAA-31C4-4C22-A562-035E8F5AE4A0', 6, 1),
(686, 'SCHOUWEY', 'Christian', 'M.', '4 Chemin de Malnuit', NULL, NULL, '03200', 'VICHY', '01-27-56-88-91', '01-91-77-10-09', '1946-04-13 00:00:00.000', 0.971493, 23200, '822236F7-90F1-4835-B9E9-102BDB6BF1E1', 6, 2),
(687, 'FAYET', 'Chantal', 'Mme.', '31 Rue de la Buffa', NULL, NULL, '69520', 'GRIGNY', '01-87-35-43-28', '01-11-36-29-47', NULL, 0.887015, 2800, '6A02DEF0-FC9B-43CB-A97A-56BF58E150AA', 6, 1),
(688, 'GROSSE', 'Nicole', 'Mme.', 'Le Mas de Bouzenac n1', 'Avenue de la Clastre', NULL, '33000', 'BORDEAUX', '02-37-91-42-71', '02-33-65-13-40', '1943-02-18 00:00:00.000', 0.29004, 8400, '4B18B487-0CB5-40FA-8689-AD1D4554BA98', 6, 1),
(689, 'ORY', 'Charles', 'M.', '12 Rue de Paris', NULL, NULL, '75006', 'PARIS', '05-36-80-15-73', NULL, '1958-02-06 00:00:00.000', 0.681453, 18500, 'E07E5EC6-A4CE-4B3E-BC25-05560EE23459', 6, 2),
(690, 'TEPER', 'Daniel', 'M.', '43 R.N. 86', NULL, NULL, '74100', 'ANNEMASSE', '04-74-94-64-41', '04-59-70-19-38', '1946-01-31 00:00:00.000', 0.354806, 22900, '90D4EC1D-DE44-4507-A061-794535320393', 6, 2),
(691, 'LACQUIEZE', 'Marc', 'M.', '36 Bis Cours de Verdun', NULL, NULL, '75011', 'PARIS', '00-71-17-27-13', '00-81-18-72-68', '1958-02-03 00:00:00.000', 0.444916, 20200, 'A9DBE823-CE63-422A-A982-5C097A1C0056', 2, 2),
(692, 'PRIEUR', 'Marie-Rose', 'Mme.', '39 Quai des Grands Augustins', NULL, NULL, '75017', 'PARIS', '03-76-66-48-82', '03-45-90-04-17', '1927-06-26 00:00:00.000', 0.979941, 18200, '4886029F-69F1-4FEB-BBDC-BEF484C633D8', 6, 1),
(693, 'PACCAUD', 'Pierre', 'M.', '13 Rue des Tournelles', NULL, NULL, '23600', 'BOUSSAC-BOURG', '00-23-86-19-20', '00-19-65-37-31', '1944-07-18 00:00:00.000', 0.487155, 8000, 'BEF0A066-56ED-43EB-9B07-C762372DE6AD', 6, 2),
(694, 'GENEUIL', 'Robert', 'M.', '20 Bis Bd Voltaire', NULL, NULL, '69002', 'LYON', '02-83-25-70-09', '02-11-40-34-90', '1938-01-05 00:00:00.000', 0.895463, 20000, 'A7A60F3A-13A2-4625-BB88-341055571E8B', 6, 2),
(695, 'MORA', 'Pierre', 'M.', '164 Rue Legendre', NULL, NULL, '06000', 'NICE', '03-19-61-84-13', '03-81-47-15-16', '1956-01-02 00:00:00.000', 0.813801, 3500, 'A64B26B8-8ACC-4CDA-8D52-701C590BEFB0', 6, 2),
(696, 'GRUFFAZ', 'Michel', 'M.', '" Le Touraud "', NULL, NULL, '06800', 'CAGNES SUR MER', '05-34-20-52-38', NULL, '1966-06-19 00:00:00.000', 0.244985, 21000, 'EE11C4BB-3AD7-4DB0-9A4B-598E03EC23A9', 6, 2),
(697, 'FOISEL', 'Lionel', 'M.', '6 Rue Confort', NULL, NULL, '06400', 'CANNES', '05-55-16-72-89', '05-46-64-57-40', '1966-10-10 00:00:00.000', 0.611055, 20100, '5DC2E630-C71E-43B6-B208-05C71F2A0236', 6, 2),
(698, 'CARRON', 'Monique', 'Mme.', '14 Rue Rossini', NULL, NULL, '75008', 'PARIS', '01-72-38-80-44', '01-01-71-56-50', '1939-02-23 00:00:00.000', 0.771563, 13100, 'F89C3AE0-D5E9-4E68-BD0A-3573502D791B', 1, 1),
(699, 'GABORIAU', 'Bruno', 'M.', '11 Rue du Chevalier Martin', NULL, NULL, '01300', 'BELLEY', '00-13-76-85-81', NULL, '1952-05-08 00:00:00.000', 0.0957414, 22400, '69CFBCAF-6080-42A8-BC6C-204D7DB03839', 6, 2),
(700, 'BROCARD', 'Dominique', 'M.', '16 Rue Marchal Joffre', NULL, NULL, '86000', 'POITIERS', '00-54-79-19-48', '00-85-75-41-44', '1938-06-26 00:00:00.000', 0.0985573, 24300, '420315AE-4530-4976-86D7-B00CD6F6B1D4', 6, 2),
(701, 'DIOT', 'Lone', 'Mme.', '13 Rue de Berne', NULL, NULL, '06590', 'THOULE', '02-82-42-28-67', '02-35-78-29-59', '1926-08-03 00:00:00.000', 0.326647, NULL, '19E11811-F15F-4243-81B1-16A9EA56A9B6', 6, 1),
(702, 'GUYONY', 'Danielle', 'Mme.', '11 Rue des Barons', NULL, NULL, '20137', 'PORTO VECCHIO', '04-99-08-03-36', '04-41-45-34-18', '1939-10-10 00:00:00.000', 0.109821, 1400, '3C67B088-5E33-44B1-87B9-C4798BBB5000', 6, 1),
(703, 'URBIETA', 'Liliane', 'Mme.', '17 Rue du Marchal Foch', NULL, NULL, '14130', 'PONT L''VEQUE', '03-10-42-05-30', '03-86-91-85-97', '1950-02-25 00:00:00.000', 0.65611, 5200, 'A4F21DE8-B48A-4880-B69D-78B28CBE29CE', 6, 1),
(704, 'GUILLARD', 'Genevive', 'Mme.', 'Rsidence de la Plage', NULL, NULL, '32260', 'SEISSAN', '02-45-42-59-15', '02-62-00-35-66', '1946-08-06 00:00:00.000', 0.101373, NULL, '30E76476-A623-4BB6-BF58-D9C14EBCFDFB', 6, 1),
(705, 'JAYEZ', 'Jean-Clair', 'M.', 'Villa 77', 'Domaine de San Cypriano', 'LECCI', '35136', 'SAINT JACQUES DE LA LANDE', '00-55-56-60-53', '00-94-88-40-18', '1963-01-05 00:00:00.000', 0.703981, 5500, 'D3CE039B-44C3-4218-823F-F5C15E311242', 1, 2),
(706, 'MORIN', 'Olivier', 'M.', '1 Rue Hamelin', NULL, NULL, '59000', 'LILLE', '03-62-65-99-21', '03-26-29-13-67', '1968-02-12 00:00:00.000', 0.951782, 15300, '0EA7FDF2-AA92-487F-9912-735C3035D70B', 6, 2),
(707, 'MILLET', 'Jean-Pierre', 'M.', '15 Avenue des Pyrnes', NULL, NULL, '92210', 'SAINT CLOUD', '05-86-96-30-81', '05-20-84-00-89', '1950-05-31 00:00:00.000', 0.0647662, 12000, 'EFC2E6C8-89BD-461C-A1DE-F1A43FD24F7C', 6, 2),
(708, 'BENOIT', 'Jean-Pierre', 'M.', '3 Rue des 25 Fusills', NULL, NULL, '75017', 'PARIS', '02-46-15-73-77', '02-60-43-74-87', '1947-02-05 00:00:00.000', 0.0591344, 9000, 'A749092A-FCB7-43C3-B26C-4383CC6193F1', 6, 2),
(709, 'HUDRY', 'Jean', 'M.', '27 Rue Faidherbe', NULL, NULL, '51480', 'POURCY', '05-20-07-69-43', '05-85-57-98-42', '1933-07-19 00:00:00.000', 0.439284, 24500, 'BB53AAAB-EAF1-4B30-910A-B38D569E31F8', 6, 2),
(710, 'CHAGNOLLAUD', 'Jean', 'M.', '19 Rue de l''Yser', NULL, NULL, '39100', 'DOLE', '03-02-70-11-96', '03-47-56-82-53', '1941-07-25 00:00:00.000', 0.132348, 24300, '8571784C-4F48-4E17-9530-F2E6B36577FE', 6, 2),
(711, 'HAMET', 'Monique', 'Mme.', '20 Rue de Phalsbourg', NULL, NULL, '75015', 'PARIS', '04-40-13-35-33', '04-54-61-04-85', '1925-01-15 00:00:00.000', 0.723692, 4600, 'BBA20605-D978-4172-88DE-FF5ACC3F48EE', 6, 1),
(712, 'DEPORT', 'Janine', 'Mme.', '1 Place Machuret', 'Arogare', NULL, '64200', 'BIARRITZ', '00-00-44-36-27', '00-84-19-51-12', '1949-10-23 00:00:00.000', 0.0591344, 17400, 'C5611AF4-6842-4AAF-A1E6-A7597964F3BD', 5, 1),
(713, 'BESSON', 'Francis', 'M.', '78 Bd Wilson', NULL, NULL, '83110', 'SANARY SUR MER', '01-07-44-56-14', '01-62-75-29-11', '1950-06-30 00:00:00.000', 0.813801, 24700, '919E1277-FC2B-4532-80C3-DB62BE4D7498', 6, 2),
(714, 'PASCAL', 'Laurent', 'M.', '3 Rue du Capitaine Scott', NULL, NULL, '79100', 'THOUARS', '05-41-75-00-41', '05-34-43-88-75', '1957-05-22 00:00:00.000', 0.219642, 22800, '96E7C9A8-E7CA-4300-8F5E-3A0A4852C5A2', 6, 2),
(715, 'ARCAS', 'Jean', 'M.', 'Centre International d''Affaires', NULL, NULL, '06000', 'NICE', '03-48-28-90-27', NULL, '1944-06-18 00:00:00.000', 0.399861, 16500, 'B33B218B-BCB2-4B76-B896-35B9D3EEEB96', 6, 2),
(716, 'JESSNER', 'Monique', 'Mme.', '246 Avenue de l''Europe Unie', NULL, NULL, '31000', 'TOULOUSE', '00-31-63-72-88', '00-40-54-39-67', '1936-07-18 00:00:00.000', 0.48997, 1500, '7733FAE6-5998-44F8-A558-75EFAFF69CDA', 6, 1),
(717, 'AUCH-HISIGER', 'Monique', 'Mme.', '4 Avenue Henri Barbusse', NULL, NULL, '75020', 'PARIS', '02-55-27-99-21', '02-24-13-64-23', '1941-02-03 00:00:00.000', 0.478707, 6400, '483B0FF2-7EAE-4530-BA29-E416CC56C6FC', 6, 1),
(718, 'KRUPA', 'Claude', 'M.', '19/21 Avenue Georges Clmenceau', NULL, NULL, '67190', 'MUTZIG', '02-19-98-46-99', '02-18-79-73-90', '1965-04-02 00:00:00.000', 0.236537, 500, '14832BDC-6BCD-41E9-9FD3-E4F1A17C8DAC', 6, 2),
(719, 'TOURRIOL', 'Joseph', 'M.', '9 Rue Saint Rome', NULL, NULL, '97118', 'SAINT FRANCOIS', '02-11-73-37-10', NULL, '1936-03-14 00:00:00.000', 0.636398, 19400, '9B89ED00-FE68-416D-8A57-8E913BC89979', 2, 2),
(720, 'SAVIDAN', 'Xavier', 'M.', '129 Rue des Pyrnes', NULL, NULL, '33000', 'BORDEAUX', '02-59-99-50-78', '02-61-84-81-84', '1947-01-19 00:00:00.000', 0.146428, 18900, 'F998B428-F14E-4D3A-8C85-626326E45D72', 6, 2),
(721, 'VANHOENACKER', 'Jean-Yves', 'M.', '24 Route de Strasbourg', NULL, NULL, '06530', 'PEYMEINADE', '00-87-46-95-22', '00-23-44-25-64', '1967-04-02 00:00:00.000', 0.157692, 800, '69993D13-D586-4AB5-B123-E59B21E25BE3', 6, 2),
(722, 'VERVEL', 'Andr', 'M.', 'Lieu Dit La Marina', NULL, NULL, '59200', 'TOURCOING', '04-82-48-71-52', '04-86-12-01-44', '1947-06-22 00:00:00.000', 0.701165, 15400, '499BC624-3A3F-45A5-83F9-2FA6D088362B', 6, 2),
(723, 'RAMEL', 'Grard', 'M.', '8 Cours de Gourgue', NULL, NULL, '37000', 'TOURS', '00-47-28-68-35', '00-80-07-43-57', '1938-08-15 00:00:00.000', 0.951782, NULL, 'C20A5BD2-1393-491E-B4A5-C1C8722B7A79', 6, 2),
(724, 'BOITEUX', 'Gilles', 'M.', '23 Place Catany', 'Avenue de Boutiny', NULL, '69003', 'LYON', '03-38-39-15-05', '03-79-07-83-16', '1959-02-24 00:00:00.000', 0.568816, 7900, '0D5D77B3-271F-44A1-89A3-37F90ECF2080', 6, 2),
(725, 'DELTOUR', 'Raymond', 'M.', '7 Avenue Gustave Dron', NULL, NULL, '69126', 'BRINDAS', '02-49-29-79-46', '02-28-71-85-72', '1938-02-14 00:00:00.000', 0.774379, 300, 'F8A42D53-8F7E-4789-B3BE-6CF5463CA089', 6, 2),
(726, 'BELLENGER', 'Allain', 'M.', '10 Rue Nationale', NULL, NULL, '14800', 'TOUQUES', '00-54-03-61-00', '00-49-10-29-44', '1940-05-09 00:00:00.000', 0.211194, 7600, '1FA17CFE-114B-4A67-B539-730ED8F40664', 3, 2),
(727, 'FOURNY', 'Grard', 'M.', '62 Rue Molire', NULL, NULL, '75116', 'PARIS', '04-59-66-15-87', '04-26-06-10-04', '1944-10-11 00:00:00.000', 0.537841, 19600, '16719C55-C6F1-404A-BCDD-ADB6ED1574A5', 6, 2),
(728, 'CLOSTRATE', 'Christian', 'M.', '163 Route de Saint Irne', NULL, NULL, '75008', 'PARIS', '01-11-57-43-68', '01-37-22-73-13', '1945-01-09 00:00:00.000', 0.481523, 4100, '0D2B2180-D351-411E-9427-99B9D31FAA89', 6, 2),
(729, 'JACOB', 'Richard', 'M.', '1 Place Foch', NULL, NULL, '94100', 'SAINT MAUR DES FOSSS', '04-69-69-61-39', '04-45-94-51-82', '1949-03-02 00:00:00.000', 0.0703981, 5700, '8FD2C7B2-7216-463F-9553-ACFF52E506C5', 6, 2),
(730, 'DESBOUTIN', 'Jean-Nol', 'M.', '25 Rue de la Tour', NULL, NULL, '21000', 'DIJON', '00-54-31-15-98', '00-83-02-59-58', '1950-08-22 00:00:00.000', 0.154876, NULL, 'C79A0D5A-1D33-4D9D-BC1B-9976533D7F92', 6, 2),
(731, 'DELEU', 'Monique', 'Mme.', '44 Bis Rue Pasquier', NULL, NULL, '60130', 'SAINT JUST EN CHAUSSE', '01-02-97-15-31', '01-45-81-02-36', '1942-09-19 00:00:00.000', 0.895463, 13200, '5FA15EA2-D582-47E7-8EA7-C39C8D485ED7', 6, 1),
(732, 'MAYORKAS', 'Claude', 'Mme.', '17 Rue Baratte Cholet', NULL, NULL, '75015', 'PARIS', NULL, '01-49-53-20-64', '1947-10-31 00:00:00.000', 0.926438, 2900, '44FC5A8C-352D-424A-8FBE-94349F9585EE', 6, 1),
(733, 'CATUGIER', 'Jacques', 'M.', '4 Rue de Metz', NULL, NULL, '75008', 'PARIS', '05-04-14-51-14', '05-64-91-23-39', '1945-10-30 00:00:00.000', 0.833513, 15000, 'B6BB2C9F-9F82-43D8-8E20-EAAA305A4A9C', 7, 2),
(734, 'COATANEA', 'Chantal', 'Mme.', '4 Rue de Paris', NULL, NULL, '31000', 'TOULOUSE', '05-94-04-83-91', '05-40-28-49-02', '1954-12-12 00:00:00.000', 0.501234, 13200, '25C5F5C7-4666-4D04-99B7-252A34E4C346', 6, 1),
(735, 'VIOLARD', 'Marie-Madeleine', 'Mme.', '15 Rue de l''Amiral Roussin', NULL, NULL, '29200', 'BREST', '04-41-14-84-26', '04-59-56-51-32', '1940-08-16 00:00:00.000', 0.577264, NULL, '64D56D1F-8E8C-4D9E-B2D0-0D0C2677BD0B', 6, 1),
(736, 'DELPECH', 'Batrice', 'Mme.', '76/78 Avenue des Champs Elyses', NULL, NULL, '75003', 'PARIS', '05-09-53-78-45', '05-76-81-76-52', '1942-06-06 00:00:00.000', 0.326647, 12100, '0E6F3118-266A-492A-BBF7-43F55847862D', 6, 1),
(737, 'DE CLERCK', 'Cristina', 'Mme.', '38 Rue Pharaon', NULL, NULL, '33148', 'TAUSSAT', '00-66-05-53-43', '00-42-32-61-44', '1947-09-20 00:00:00.000', 0.425204, 19400, 'E392A269-B853-4CD0-8B2E-AAE0ED89E405', 6, 1),
(738, 'BEATRIX', 'Genevive', 'Mme.', '30 Rue Amiral Linois', NULL, NULL, '75016', 'PARIS', '01-29-49-87-81', '01-91-88-80-26', '1948-12-07 00:00:00.000', 0.712428, 11200, '104D69B1-AF17-4A46-8B3E-728E03C3409F', 6, 1),
(739, 'CATS', 'Chantal', 'Mme.', '14 Rue de Normandie', NULL, NULL, '14910', 'BLONVILLE SUR MER', '02-10-80-89-86', '02-60-99-25-98', '1935-12-27 00:00:00.000', 0.30412, 7100, '1F2CD900-0046-4C2D-89C0-9032F3D49FEE', 6, 1),
(740, 'CLEMENT', 'Raymond', 'M.', '61 Avenue Charles De Gaulle', NULL, NULL, '59100', 'ROUBAIX', '05-87-32-55-00', '05-64-59-74-43', '1946-03-09 00:00:00.000', 0.253433, 14900, 'E80480CE-F19B-49E8-A90F-2AC68FBE37EE', 4, 2),
(741, 'MUSY', 'Pascal', 'M.', '71 Avenue Marceau', NULL, NULL, '76210', 'BOLBEC', '03-00-60-81-72', '03-97-45-66-19', '1963-04-27 00:00:00.000', 0.309751, 18900, '4D850D59-DBEC-4531-84FB-3F6598754D90', 6, 2),
(742, 'DUFFER', 'Patrice', 'M.', '53 Avenue Michel d''Ornano', NULL, NULL, '92100', 'BOULOGNE', '00-13-94-76-10', '00-68-14-98-62', '1946-04-01 00:00:00.000', 0.143612, 5100, '93A98D23-54D9-4002-9CF5-24256564D9E8', 6, 2),
(743, 'BERTHOUD', 'Pierre', 'M.', '35 Avenue Jean Lebas', NULL, NULL, '18000', 'BOURGES', '02-03-41-71-41', '02-08-71-66-25', '1938-11-02 00:00:00.000', 0.681453, 16900, '7214038F-8D45-4435-B6F4-C6CD67D2ED03', 6, 2),
(744, 'MISSET', 'Franois-Xavier', 'M.', '56 Rue des Martyrs', NULL, NULL, '75008', 'PARIS', '00-93-01-40-29', '00-78-66-55-38', '1948-10-21 00:00:00.000', 0.833513, 12900, 'CC976E5C-746A-4FF5-82E1-7FD894494796', 6, 2),
(745, 'CHAUSSINANT', 'Jean-Jacques', 'M.', '100 Avenue Jean-Baptiste Clment', NULL, NULL, '83170', 'BRIGNOLES', '02-79-05-82-37', '02-04-53-65-89', '1949-04-01 00:00:00.000', 0.481523, 6600, 'B4141C7D-6FDD-4036-BB67-7FD5FFDB1210', 6, 2),
(746, 'LEMOINE', 'Bruno', 'M.', '6 Rue du Four au Roi', NULL, NULL, '05100', 'PUY SAINT ANDR', '01-13-56-67-79', '01-61-12-27-02', NULL, 0.332279, 2300, '4C618159-35D5-4244-8643-19B0A4623479', 6, 2),
(747, 'PEREZ', 'Jean-Michel', 'M.', '1 Bis Avenue Hoche', NULL, NULL, '35800', 'DINARD', '02-07-97-23-68', '02-19-81-07-87', '1936-07-21 00:00:00.000', 0.948966, 18000, '1E899D0E-8A77-499C-B82F-CCBE2E85C019', 7, 2),
(748, 'FOURNIER', 'Pierre', 'M.', '39 Rue du Docteur Barbaroux', NULL, NULL, '75003', 'PARIS', '00-59-79-86-54', '00-20-29-59-50', '1958-11-05 00:00:00.000', 0.163323, 14300, '36F52264-1C10-449E-9859-AA21E0164887', 6, 2),
(749, 'DELZEUX', 'Alain', 'M.', 'Route de Pierrefeu', NULL, NULL, '02200', 'SOISSONS', '04-84-62-90-84', '04-88-76-84-20', '1951-05-03 00:00:00.000', 0.185851, 12800, '47AD24C9-A8AD-421E-B378-B18D7A8FBB1C', 6, 2),
(750, 'KAHAN', 'Jean-Pierre', 'M.', '46 Rue Levavasseur', NULL, NULL, '69002', 'LYON', '00-47-54-21-07', '00-34-17-76-16', '1945-04-13 00:00:00.000', 0.839145, 17100, '7FF0483C-3A2D-47C1-B4A0-7827BAE74630', 6, 2),
(751, 'KASSAM', 'Alain', 'M.', '197 Rue du Temple', NULL, NULL, '75116', 'PARIS', '00-67-12-14-78', '00-94-42-30-45', '1949-09-02 00:00:00.000', 0.323831, 15900, 'ED15BEA5-12DC-4107-A643-527BAFE109EB', 6, 2),
(752, 'LETOVSKY', 'Fatehali', 'M.', '35 Ter Avenue Charles De Gaulle', NULL, NULL, '06300', 'NICE', '01-76-17-71-34', '01-38-83-42-63', '1956-08-14 00:00:00.000', 0.183035, NULL, '225E0E9D-F5C9-48D7-81A9-09F1CEF4CF92', 6, 2),
(753, 'BOUCH', 'Pierre', 'M.', '48 Rue de la Rpublique', NULL, NULL, '75008', 'PARIS', '04-13-66-73-68', '04-30-88-89-26', '1940-03-28 00:00:00.000', 0.0197115, 14700, '22BDD672-31C7-48C0-A2BB-01EF3C09C5BA', 6, 2),
(754, 'MIGEOTTE', 'Jacky', 'M.', '41 Avenue Klber', NULL, NULL, '89000', 'AUXERRE', '03-59-02-81-65', '03-48-87-08-33', '1944-05-29 00:00:00.000', 0.464627, 19800, '32AE1A98-6CFE-411E-800F-B012582878EC', 4, 2),
(755, 'CLERC', 'Chantal', 'Mme.', '2 Chemin des Crtes', NULL, NULL, '51100', 'REIMS', '01-66-44-43-48', '01-37-20-31-05', '1955-07-12 00:00:00.000', 0.920807, 4900, 'C1E63D57-8FE5-47C6-8612-3AD2B779EDC5', 6, 1),
(756, 'DUMAZET', 'Jean-Paul', 'M.', '120 Avenue des Champs lyses', NULL, NULL, '97133', 'SAINT BARTHLMY', '05-38-05-39-26', '05-64-37-72-09', '1959-06-24 00:00:00.000', 0.582896, 21000, '232050EF-5A8B-4C1E-B0B0-D4161B63C3F7', 6, 2),
(757, 'PARISOT', 'Joselyne', 'Mme.', '13 Bis Rue d''Egleny', NULL, NULL, '11000', 'CARCASSONNE', '00-81-49-34-66', '00-96-24-17-64', '1943-02-16 00:00:00.000', 0.554737, 1100, 'EAF8DAAC-5EB1-4ECF-B10B-16FCB4BACFEF', 6, 1),
(758, 'CHESNARD', 'Serge', 'M.', '144 Rue de Cernay', NULL, NULL, '78280', 'GUYANCOURT', '02-71-85-17-20', '02-63-71-43-94', '1942-03-28 00:00:00.000', 0.878568, 22400, '1A81BBC0-FFBC-419C-AD58-BB2C94058793', 6, 2),
(759, 'FTIZONS', 'Pierre', 'M.', 'Rsidence " Les Jardins de Saint', 'Jean "', NULL, '69600', 'OULLINS', '00-25-52-84-11', '00-45-46-99-75', '1946-03-31 00:00:00.000', 0.458995, 14200, 'B41B46D9-5C1B-4259-ADD7-FCC87D0FF7F4', 6, 2),
(760, 'VAPAILLE', 'Jean', 'M.', '35 Bd de Varsovie', NULL, NULL, '94230', 'CACHAN', '05-13-48-92-66', '05-58-51-22-68', '1947-02-17 00:00:00.000', 0.850408, 14900, '0D5E531E-FC6A-4752-9D88-06717D165F52', 6, 2),
(761, 'SANCHEZ', 'Daniel', 'M.', 'Centre Commercial Louis Blriot', 'Alle du Commerce', NULL, '77100', 'MEAUX', '02-22-65-36-73', '02-81-09-88-78', '1949-05-01 00:00:00.000', 0.0337911, 10900, 'A444C318-F677-4D62-8396-0FA18F175DF8', 1, 2),
(762, 'COHEN', 'Eric', 'M.', '68 Grande Rue', NULL, NULL, '83390', 'CUERS', '04-10-50-27-36', '04-03-92-36-57', '1969-08-20 00:00:00.000', 0.73214, NULL, '70C52922-3550-4161-8980-340FB539006E', 6, 2),
(763, 'DRENO', 'Lucien', 'M.', '75 Avenue Aristide Briand', NULL, NULL, '75017', 'PARIS', '00-64-73-97-60', '00-92-83-12-26', '1933-04-26 00:00:00.000', 0.571632, 3400, '100D5016-D07F-46CD-B262-82F05FFD7104', 6, 2),
(764, 'ABBOU', 'Jean-Claude', 'M.', '11 Rue Paul Belmondo', NULL, NULL, '66000', 'PERPIGNAN', '02-11-72-68-18', '02-66-21-28-81', '1954-03-11 00:00:00.000', 0.0253433, 3000, '124E526B-A0E1-42B9-B0AD-CB2816B183A0', 6, 2),
(765, 'DE MHRENC DE SAINT-PIERRE', 'Josette', 'Mme.', '2 Place Pasteur', NULL, NULL, '75012', 'PARIS', '02-61-36-95-98', '02-95-45-67-25', '1945-05-18 00:00:00.000', 0.636398, 24600, '9A8A532C-1B35-4201-B43A-03CA8AE47CE6', 6, 1),
(766, 'COVO', 'Hubert', 'M.', '116 Rue Cardinet', NULL, NULL, '44000', 'NANTES', '04-90-05-43-77', '04-52-23-86-28', '1950-05-20 00:00:00.000', 0.487155, 23800, '7A0CCA70-960B-4119-B39E-A7F52D8E8F2F', 6, 2),
(767, 'MOULIN', 'Franck', 'M.', '2 Rue Cit Bartissol', NULL, NULL, '75008', 'PARIS', NULL, '05-19-77-40-77', '1943-08-05 00:00:00.000', 0.0394229, NULL, 'A7D63190-5D7A-4449-A42A-4FCA5E418288', 6, 2),
(768, 'DEPIEDS', 'Pierre', 'M.', '37 Rue de Cotte', NULL, NULL, '30100', 'ALES', '03-87-69-79-66', '03-52-60-93-23', '1938-05-28 00:00:00.000', 0.960229, 21100, '889C4D99-6431-42BA-9AE5-A70A33CDF6ED', 1, 2),
(769, 'BONNEFOND', 'Michel', 'M.', '1 Rue Tournefort', NULL, NULL, '13007', 'MARSEILLE', NULL, '03-57-79-77-47', '1957-10-25 00:00:00.000', 0.667374, 14100, '7560A0BE-EC94-4E2E-B46A-4D7F749D7B93', 6, 2),
(770, 'KLING', 'Armand', 'M.', '11 Rue d''Artois', NULL, NULL, '69170', 'TARARE', '03-56-24-79-08', '03-53-26-60-27', '1937-07-30 00:00:00.000', 0.979941, 4300, '403FEA1F-490F-4E5A-9CDC-36CBF6B5C2D5', 6, 2),
(771, 'TISSIER', 'Grard', 'M.', '3 Rue Albert 1 er', NULL, NULL, '57400', 'SARREBOURG', '03-06-94-32-15', '03-51-53-69-76', '1953-06-16 00:00:00.000', 0.126716, 9100, 'BF1012FE-FD68-4D88-BE20-92F4A94DBE85', 6, 2),
(772, 'DE VANSSAY', 'Daniel', 'M.', '1 Rue Sauveur Tobelem', NULL, NULL, '58200', 'COSNE SUR LOIRE', NULL, '00-92-78-75-58', NULL, 0.253433, 12500, '63F093CB-41A5-40F5-8AE1-8089E8409725', 6, 2),
(773, 'GONCALVES', 'Batrice', 'Mme.', '8 Rue Mezelle', NULL, NULL, '75008', 'PARIS', '04-88-80-14-34', '04-72-61-81-60', '1952-07-03 00:00:00.000', 0.512498, 11700, '881178DD-9509-435D-988D-035E387015ED', 6, 1),
(774, 'LEMOINE', 'Jean-Manuel', 'M.', 'Rsidence Pasteur', '23 rue jean Jaurs', NULL, '94220', 'CHARENTON LE PONT', '04-12-08-98-16', '04-43-55-67-03', '1971-03-13 00:00:00.000', 0.357622, 4400, '57C3DFF3-6B6B-4BFA-8B36-7F402F5526F1', 6, 2),
(775, 'LAFONT', 'Jean-Michel', 'M.', '20 Rue du Commerce', NULL, NULL, '35800', 'DINARD', '05-67-52-08-76', '05-67-56-92-01', '1936-07-21 00:00:00.000', 0.782826, 1400, 'DA32B56D-6DDA-45A2-873E-93080689D0DE', 5, 2),
(776, 'DUHAND', 'Jean-Claude', 'M.', '78 Avenue des Champs lyses', NULL, NULL, '13260', 'CASSIS', '01-76-81-40-81', '01-47-76-68-52', '1939-11-10 00:00:00.000', 0.109821, 13500, '62651F95-34F5-455C-80E4-0E33D15E3BAE', 6, 2),
(777, 'AMAR', 'Jean-Charles', 'M.', '4 Quai de Bercy', NULL, NULL, '54000', 'NANCY', '03-67-62-14-50', '03-21-97-47-51', '1960-01-13 00:00:00.000', 0.568816, 23800, '319BA82E-FD14-4F64-9482-6EB744133976', 6, 2),
(778, 'COPELAND', 'Tania', 'Mme.', '46 Rue Levavasseur', NULL, NULL, '75016', 'PARIS', '02-29-99-78-83', '02-87-25-35-11', '1966-04-03 00:00:00.000', 0.419572, 1900, '0E7BC369-5520-4637-92AB-A0757AE2A216', 6, 1),
(779, 'HURON', 'Marc', 'M.', '49 Avenue Victor Hugo', NULL, NULL, '77400', 'SAINT THIBAUT DES VIGNES', '05-62-97-05-79', '05-64-18-07-53', '1950-02-15 00:00:00.000', 0.0281592, 14100, 'C8FA32A8-635B-409C-A6A3-ECEB0FFCA568', 6, 2),
(780, 'LEDOUX', 'Patrick', 'M.', '44 Rue de Mulhouse', NULL, NULL, '78100', 'SAINT GERMAIN EN LAYE', '00-11-49-66-23', '00-63-66-96-01', '1949-03-21 00:00:00.000', 0.273144, 3200, 'D3422A52-1454-4054-BE9B-C82177406AF9', 6, 2),
(781, 'PIRON', 'Gilbert', 'M.', '29 Rue de Miromesnil', NULL, NULL, '77540', 'ROZAY EN BRIE', '05-46-57-21-10', '05-92-73-22-50', '1926-09-01 00:00:00.000', 0.512498, 9800, '7081E24E-B341-41DC-94CA-C8735FC97327', 6, 2),
(782, 'HUARD', 'Annick', 'Mme.', '6 Rue Lamartine', NULL, NULL, '13770', 'VENELLES', '02-27-64-61-37', '02-17-21-56-14', '1950-06-02 00:00:00.000', 0.0619503, 15300, '6C452920-2FB9-40DE-BDE1-4346AC5CF689', 2, 1),
(783, 'RICHOU', 'Francis', 'M.', '35 Rue Franklin', NULL, NULL, '97150', 'SAINT MARTIN', '01-23-63-18-82', '01-66-39-24-00', '1959-01-06 00:00:00.000', 0.703981, 15600, '553730E8-1D90-4FDF-A55B-75DAE432261C', 6, 2),
(784, 'RICARD', 'Hlne', 'Mme.', '4 Place du March au Bl', NULL, NULL, '62290', 'NOEUX LES MINES', '02-41-48-09-15', '02-32-06-72-98', '1930-09-26 00:00:00.000', 0.771563, 800, '4E2A020C-61A8-4847-A1D8-276E393FE758', 6, 1),
(785, 'JOUBERT', 'Jean-Pierre', 'M.', 'Les Isnards - Bt. B', NULL, NULL, '97150', 'SAINT MARTIN', '01-41-85-58-93', '01-50-95-43-53', '1946-08-12 00:00:00.000', 0.478707, NULL, '823E4845-DD30-4D74-8614-3FC562AEE1BA', 6, 2),
(786, 'ARJEAU', 'Jean-Pierre', 'M.', '18 Rue Flix Ebou', 'MARIGOT', NULL, '75017', 'PARIS', '02-44-67-57-75', '02-63-51-39-93', '1943-02-16 00:00:00.000', 0.991205, 8800, '2407F643-AA3D-49A3-AC20-3396B46DD45A', 6, 2),
(787, 'KOTETZKI', 'Jean', 'M.', '79 Bis Route Nationale', NULL, NULL, '33100', 'BORDEAUX', '03-23-56-49-40', '03-71-92-10-51', '1960-09-13 00:00:00.000', 0.625135, 14200, '4CC1113A-0162-4DF7-BD72-9E15D45DB65D', 6, 2),
(788, 'OBERTO', 'Andr', 'M.', 'Les Portes de Saint Martin', NULL, NULL, '75007', 'PARIS', '01-94-69-79-64', NULL, '1944-03-14 00:00:00.000', 0.329463, 16100, 'B1A8FE27-E799-4F8A-895B-B64637EB2BB6', 6, 2),
(789, 'GOUGUENHEIM', 'Philippe', 'M.', '41 Rue Saint Ferdinand', NULL, NULL, '95150', 'TAVERNY', '00-78-21-29-66', '00-90-01-79-96', '1957-10-19 00:00:00.000', 0.177403, 8300, '816F4EBD-8AC1-4DF8-8A9B-3C884FFDD530', 1, 2),
(790, 'DU FRESNAY', 'Gilles', 'M.', '354 Avenue Thiers', NULL, NULL, '44000', 'NANTES', '05-84-89-82-36', '05-60-16-63-28', '1952-02-13 00:00:00.000', 0.160508, 14300, '3166B2F7-48CE-467A-8D9E-E5B2DD480FCB', 6, 2),
(791, 'SCIACCA', 'Charles', 'M.', '41 Avenue Rapp', NULL, NULL, '33000', 'BORDEAUX', '01-27-94-18-06', '01-44-16-91-81', '1949-03-11 00:00:00.000', 0.968677, 23800, 'D1D1606A-7020-4D2B-B04A-EB7B5A6F613C', 6, 2),
(792, 'HUGON', 'Sauveur', 'M.', '4 Place de la Gare', NULL, NULL, '13410', 'LAMBESC', '04-07-65-66-74', '04-21-12-44-79', '1940-09-16 00:00:00.000', 0.163323, 10000, 'D50F70FC-2182-428F-9F51-8BD2236DB7F9', 6, 2),
(793, 'DELHAYE', 'Richard', 'M.', '12 Rue du Calvaire', NULL, NULL, '30900', 'NIMES', '01-13-28-98-16', '01-90-32-16-48', '1951-11-04 00:00:00.000', 0.543473, 6200, '23FDAE5B-46E7-4E43-B181-DBA568DD1A9B', 6, 2),
(794, 'BEAULAND', 'Bruno', 'M.', '3 Rue Pauline Kergomard', NULL, NULL, '69004', 'LYON', '01-92-60-20-96', '01-65-77-68-45', '1957-11-14 00:00:00.000', 0.354806, 24000, '9F84A01B-581A-41B1-A258-141AFA0AF47F', 6, 2),
(795, 'CHIKLI', 'Alain', 'M.', '28 Rue Grande', NULL, NULL, '77300', 'FONTAINEBLEAU', '05-45-65-63-87', NULL, '1955-02-27 00:00:00.000', 0.177403, 9400, '81E2C2A7-7E90-4E9E-B02D-FEBF42C33124', 6, 2),
(796, 'KROENER', 'Yves', 'M.', '4 Quai de la Fontaine', NULL, NULL, '75011', 'PARIS', '05-74-12-52-09', '05-71-21-16-08', '1961-05-17 00:00:00.000', 0.323831, 7300, '359D29CB-3DD7-49BC-9D36-691A3E20B608', 1, 2),
(797, 'ROSSET', 'Alain', 'M.', '101 Grande Rue de la Croix', 'Rousse', NULL, '75016', 'PARIS', '00-30-13-33-32', '00-93-81-11-92', '1940-07-21 00:00:00.000', 0.419572, 9300, 'AE447B87-5F5C-4B10-8903-BCD12FBDDA52', 6, 2),
(798, 'SOLOVIEFF', 'Franois', 'M.', '72 Rue Aristide Briand', NULL, NULL, '75007', 'PARIS', '05-02-64-37-93', '05-83-98-64-33', '1923-12-09 00:00:00.000', 0.537841, 15100, '1A6577ED-580A-4B0D-B126-A10B81E84A3E', 6, 2),
(799, 'DELAHAYE', 'Martine', 'Mme.', '27 Bis Rue Godefroy Cavaignac', NULL, NULL, '92100', 'BOULOGNE', '02-45-64-59-00', '02-13-06-58-41', '1952-02-15 00:00:00.000', 0.0563184, 19300, '21960B8F-88C4-4F18-989A-80D0CDAF26C3', 6, 1),
(800, 'AUJOLET', 'Jrme', 'M.', '37 Rue des Vignes', NULL, NULL, '75015', 'PARIS', '00-32-38-77-86', '00-96-26-05-30', '1964-02-21 00:00:00.000', 0.78001, 16800, '30F8FE14-97EC-4009-BCB1-8CC5B06DD3A8', 6, 2),
(801, 'DIERS', 'Nadine', 'Mme.', '2 Avenue de Sgur', NULL, NULL, '78100', 'SAINT GERMAIN EN LAYE', '04-07-08-20-66', '04-38-47-11-74', '1947-11-09 00:00:00.000', 0.65611, 4800, '94023B8D-D16C-4D90-8EEE-550913D567AE', 6, 1),
(802, 'LABUCHELLE', 'Laurent', 'M.', '5 Avenue du Marchal Juin', NULL, NULL, '62120', 'AIRE SUR LA LYS', '02-68-97-78-11', '02-11-67-35-71', '1964-05-17 00:00:00.000', 0.36607, 20100, 'B25E1CA5-59DE-41CE-B392-73786D19968F', 6, 2),
(803, 'GREMMEL', 'Michel', 'M.', '1 Rue Frmicourt', NULL, NULL, '33000', 'BORDEAUX', '05-08-84-00-55', '05-54-18-95-36', '1937-05-03 00:00:00.000', 0.425204, 8100, 'CF0CFE1C-58D1-49CD-9DD2-200A85CB31A2', 5, 2),
(804, 'REEB', 'Dominique', 'M.', '69 Avenue du Marchal Foch', NULL, NULL, '21110', 'GENLIS', '02-86-77-85-22', '02-07-13-74-79', '1962-09-13 00:00:00.000', 0.281592, 5600, '88565E6E-DB7D-497B-A8EB-C4A193F51241', 6, 2),
(805, 'OUSTRIC-PATABES', 'Jean-Pierre', 'M.', '26 Place Notre Dame', NULL, NULL, '67000', 'STRASBOURG', '05-68-57-71-39', '05-49-86-25-21', '1942-01-11 00:00:00.000', 0.64203, 14000, '3DD2F01D-DCAE-4468-B265-55F8D6DA9DB4', 6, 2),
(806, 'DEVIER', 'Jacqueline', 'Mme.', '36 Bis Cours de Verdun', NULL, NULL, '66200', 'ELNE', '01-35-96-36-62', '01-14-19-86-24', '1952-07-17 00:00:00.000', 0.765931, 21300, '269E1BFC-849F-43E3-BE6F-8493F4730A18', 6, 1),
(807, 'LE GAL', 'Philippe', 'M.', '14 Rue Bernard Laureau', NULL, NULL, '34000', 'MONTPELLIER', '00-05-43-23-92', '00-32-05-80-58', '1961-03-14 00:00:00.000', 0.985573, 9900, 'B6217B68-D2E2-4CEB-8BAA-63F410B70D97', 6, 2),
(808, 'BONNET-EYMARD', 'Alain', 'M.', '16 Rue du Faubourg de Pierre', NULL, NULL, '95140', 'GARGES LES GONESSE', '05-62-53-99-69', '05-39-02-38-52', '1951-06-28 00:00:00.000', 0.816617, 13200, '73BEACB7-5937-4B7B-83DE-9B59AD4C8B1A', 6, 2),
(809, 'CAVALIER', 'Bernadette', 'Mme.', '58 Bis Route Nationale', NULL, NULL, '38170', 'SEYSSINET PARISET', '00-68-66-55-36', NULL, '1948-09-30 00:00:00.000', 0.0422388, 22800, 'F8446CAE-FC47-41F0-8F09-00806689B6CB', 6, 1),
(810, 'BOYER', 'Michel', 'M.', '4 Rue Henri Ren', NULL, NULL, '26500', 'BOURG LES VALENCE', '04-38-27-78-94', '04-67-97-34-16', '1955-01-16 00:00:00.000', 0.0140796, 20400, '246C0162-E679-4843-AC48-740597E42349', 2, 2),
(811, 'RAULT', 'Jean-Marie', 'M.', '160 Avenue de Stalingrad', NULL, NULL, '83630', 'AUPS', '00-10-10-89-20', '00-14-10-06-96', '1952-10-31 00:00:00.000', 0.923622, 22500, 'BA526D98-23FC-4125-8C45-7A41CA3AD76B', 6, 2),
(812, 'DEROUET', 'Emmanuel', 'M.', '4 Rue Paul Valrien Perrin', NULL, NULL, '92150', 'SURESNES', '01-21-81-17-06', '01-93-76-04-34', '1945-10-08 00:00:00.000', 0.729324, 13600, '1FEED053-9278-44D6-AF41-F42DFB2017C2', 6, 2),
(813, 'LE FOLL', 'Guy', 'M.', '20 Alle des Frgates', NULL, NULL, '27000', 'EVREUX', '05-01-46-18-91', '05-34-11-23-75', '1954-03-01 00:00:00.000', 0.456179, 19000, '225B838A-1C60-4DAF-9D5C-2B77C6F175AE', 6, 2),
(814, 'OHAYON', 'Yves', 'M.', 'Rue Gabriel Pri', NULL, NULL, '75015', 'PARIS', NULL, '02-29-75-47-64', '1945-11-28 00:00:00.000', 0.813801, 19800, 'CD8ADF7A-529A-49F5-A9E8-1095A838A0C4', 6, 2),
(815, 'NICOLAI', 'Charles', 'M.', '37 Rue Rouget de l''Isle', NULL, NULL, '75017', 'PARIS', '05-90-86-77-74', '05-90-59-29-09', '1937-08-24 00:00:00.000', 0.520946, NULL, 'C46B7CE8-2A60-4226-A07E-F11E925DFC04', 6, 2),
(816, 'RIFFIOD', 'Eric', 'M.', '6 Avenue Aristide Briand', NULL, NULL, '83990', 'SAINT TROPEZ', '04-31-91-86-08', '04-38-48-34-24', '1952-04-11 00:00:00.000', 0.585712, 20900, '86A346CD-75A3-4990-ADED-F385533360B9', 6, 2),
(817, 'NOYELLE', 'Alain', 'M.', '263 Rue Lecourbe', NULL, NULL, '39000', 'LONS LE SAUNIER', '00-86-20-39-64', '00-63-99-44-53', '1949-06-06 00:00:00.000', 0.244985, 19000, '2A85C7B3-5386-46D3-91AF-2F109930F065', 3, 2),
(818, 'CHIFFARD', 'Grard', 'M.', '48 Rue Laugier', NULL, NULL, '78100', 'SAINT GERMAIN EN LAYE', '04-93-05-83-79', '04-29-69-92-76', '1946-08-30 00:00:00.000', 0.202746, NULL, 'E79F294C-F8C8-4583-BF3E-025D1B52C2A1', 6, 2),
(819, 'GRANDJEAN', 'Elisabeth', 'Mme.', '2 Rue de la Rsistance', NULL, NULL, '28250', 'SENONCHES', '00-93-08-70-37', '00-16-58-06-41', '1953-12-13 00:00:00.000', 0.453363, 800, '2D182C01-CDE0-4C6A-9758-DE5497943BB2', 6, 1),
(820, 'DUTAS', 'Michel', 'M.', '18 Rue Lafayette', NULL, NULL, '57050', 'LE BAN SAINT MARTIN', '05-86-83-80-83', '05-79-27-95-10', '1953-10-11 00:00:00.000', 0.408309, 23100, 'D2F58354-6037-4A23-A739-B0ED645EA913', 6, 2),
(821, 'THOMASSET', 'Jacques', 'M.', '78 Rue de Poissy', NULL, NULL, '57160', 'CHATEL SAINT GERMAIN', '00-57-42-07-80', '00-76-78-62-11', '1947-08-10 00:00:00.000', 0, NULL, 'AE0A0657-F771-4EA9-81AB-FD4ED97A71CC', 6, 2),
(822, 'GALLET-ROHART', 'Jean-Lon', 'M.', 'Rue Louis Peuret', NULL, NULL, '01600', 'TRVOUX', '02-87-46-55-28', '02-61-71-55-05', '1960-04-10 00:00:00.000', 0.653294, 3900, '76504FDF-DA18-442D-8BB8-DBC84478FA26', 6, 2),
(823, 'DUPONT', 'Corinne', 'Mme.', '33 Avenue de la Libert', NULL, NULL, '76470', 'LE TRPORT', '05-46-11-56-47', '05-52-72-97-25', '1962-12-08 00:00:00.000', 0.670189, 7700, 'F611819B-4C3D-4B02-BD89-5EE8D9D76E6D', 6, 1),
(824, 'RECULON-DUPONT', 'Jean-Pierre', 'M.', '14 Avenue de la Libration', NULL, NULL, '75008', 'PARIS', '05-90-99-93-01', '05-81-36-67-48', '1946-11-08 00:00:00.000', 0.473075, 22200, 'BBA0BE5B-2D87-4793-871B-4E8063040668', 7, 2),
(825, 'ARNAUD', 'Guy', 'M.', '38 Monte de Pronde', NULL, NULL, '75003', 'PARIS', '03-60-25-47-58', '03-20-80-49-19', '1941-12-11 00:00:00.000', 0.771563, 16100, 'BFDDCD4F-3667-45FA-8833-2836BDA7AEA5', 6, 2),
(826, 'ZILLI', 'Louis', 'M.', '2 Rue de la Rade', NULL, NULL, '13200', 'ARLES', '01-50-11-18-91', '01-17-22-95-88', '1935-09-03 00:00:00.000', 0.898279, 23400, 'A81ED5FD-4537-43EB-97F4-A5C058F468F0', 6, 2),
(827, 'DOURU', 'Philippe', 'M.', '20 Avenue de Wagram', NULL, NULL, '34000', 'MONTPELLIER', '01-90-00-20-66', '01-26-18-99-91', '1958-02-01 00:00:00.000', 0.371702, 22300, '4EC1738D-12C2-4DE1-BA0C-AB29C0BCCE12', 6, 2),
(828, 'SANTUS', 'Marlne', 'Mme.', '4 Bd St Martin', 'Angle Rue Ren Boulanger', NULL, '89100', 'SENS', '04-03-61-39-39', '04-97-39-45-59', '1957-09-10 00:00:00.000', 0.487155, 9900, 'A11A4662-6FB9-4B2A-A371-88AEFFB372EF', 6, 1),
(829, 'POTIER', 'Edith', 'Mme.', '27 Bd Georges Clmenceau', NULL, NULL, '75005', 'PARIS', '05-18-94-89-15', '05-43-40-80-38', '1935-11-10 00:00:00.000', 0.901095, 14800, '8F718CC9-464A-4D25-8687-828D8CC9FE4C', 6, 1),
(830, 'QUARTERON', 'Bernard', 'M.', '27 Rue de la Loge', NULL, NULL, '92100', 'BOULOGNE', '01-67-92-94-82', '01-50-23-24-03', '1948-09-13 00:00:00.000', 0.782826, 1300, '31D10BBC-DB90-4532-867D-96E8A87FDE01', 6, 2),
(831, 'GUILLEUX', 'Daniel', 'M.', '2 Rue de la Rpublique', NULL, NULL, '51000', 'CHALONS SUR MARNE', '01-55-74-39-56', '01-59-76-07-01', '1935-06-22 00:00:00.000', 0.687085, 11900, 'B0C22D0C-FC2A-4C0E-B51E-98F7906D7F81', 4, 2),
(832, 'BLANCHET', 'Daniel', 'M.', '42 Rue Monge', NULL, NULL, '35000', 'RENNES', '01-62-80-24-53', '01-36-63-45-27', '1950-05-26 00:00:00.000', 0.259065, 20000, '14D97BE3-4E5D-4959-B780-4D2710FC005B', 6, 2),
(833, 'COLIN', 'Denis', 'M.', '112 Rue de Paris', NULL, NULL, '75008', 'PARIS', '04-26-73-39-01', '04-66-52-02-57', '1946-10-09 00:00:00.000', 0.858856, 20400, '7C2ECBBD-D5A5-4F85-AB4F-79A443516529', 6, 2),
(834, 'DU PELOUX', 'Michel', 'M.', '16 Place de la Rpublique', NULL, NULL, '04100', 'MANOSQUE', '03-26-28-76-81', '03-32-77-06-70', '1947-10-23 00:00:00.000', 0.335095, 6200, '80EA15B4-39D6-4FEC-9CE3-B99E287B4D51', 6, 2),
(835, 'POLIMENI', 'Alain', 'M.', '16 Quai Duguay-Trouin', NULL, NULL, '75006', 'PARIS', '00-41-89-59-86', '00-94-84-45-45', '1924-06-26 00:00:00.000', 0.523762, 9600, '81D6E76E-BE7D-43BB-AD30-CD0E71929CFE', 6, 2),
(836, 'ASSOULINE', 'Domenico', 'M.', '1 Rue Saint Philippe du Roule', NULL, NULL, '75018', 'PARIS', '01-73-98-50-55', '01-21-85-87-66', '1932-09-11 00:00:00.000', 0.391413, 21100, '4E05FC57-ABEF-4008-9AF5-2C11AB81DA77', 6, 2),
(837, 'RAMBAUD', 'Thierry', 'M.', '1 Avenue Jean Giono', NULL, NULL, '75016', 'PARIS', '00-69-54-97-23', '00-69-04-99-06', '1968-08-20 00:00:00.000', 0.453363, NULL, 'E95F8B76-AD69-4C18-A9F4-6B53474F40C7', 6, 2),
(838, 'QUINQUENNEAU', 'Philippe', 'M.', '9 Rue Jean Ferrandi', NULL, NULL, '73300', 'SAINT JEAN DE MAURIENNE', '02-87-64-05-49', '02-08-31-53-60', '1962-06-26 00:00:00.000', 0.85604, 5400, '095CA603-926B-4A42-B486-08955AF120C9', 7, 2),
(839, 'VERNETTE', 'Jean', 'M.', '8 Avenue de Saint Ouen', NULL, NULL, '37500', 'CHINON', '01-42-21-42-69', '01-84-16-70-62', '1934-07-31 00:00:00.000', 0.777195, 1400, '60B40B2D-2DA0-414B-A2C9-FD653AFE15C9', 6, 2),
(840, 'BRACCO', 'Henri', 'M.', '45 Bd Suchet', NULL, NULL, '30000', 'NIMES', NULL, '03-58-68-81-46', '1951-07-14 00:00:00.000', 0.540657, 16800, '1A179D5A-9C95-4244-A64B-A0E2888CD71B', 6, 2),
(841, 'DESCHANCIAUX', 'Philippe', 'M.', '227 Avenue de la Libration', NULL, NULL, '06200', 'NICE', '04-87-10-01-46', '04-52-29-01-04', '1955-07-17 00:00:00.000', 0.0197115, 7800, '894EDCD7-DCAE-4A32-8276-971B462FCCFD', 6, 2),
(842, 'PIEKOLEK', 'Josette', 'Mme.', '68 Quai Jeanne d''Arc', NULL, NULL, '75012', 'PARIS', '04-89-06-96-27', '04-67-14-75-32', '1936-04-06 00:00:00.000', 0.273144, 7700, 'DA8AFEAF-EBA7-4924-9FB5-D8656CE6EE46', 6, 1),
(843, 'CHERVILLE', 'Jean-Michel', 'M.', '12 Rue Roussy', NULL, NULL, '75005', 'PARIS', '04-34-77-67-88', '04-55-01-40-22', '1947-10-04 00:00:00.000', 0.661742, 17100, '9E7C1BC4-CC1B-43AF-A9D4-4791FB490AD4', 6, 2),
(844, 'TERRIER', 'Armelle', 'Mme.', '455 Promenade des Anglais', 'Porte de l''Arnas  Hall C', NULL, '44510', 'LE POULIGUEN', '05-37-33-55-75', '05-39-49-57-16', '1954-03-17 00:00:00.000', 0.582896, 3700, 'E5C67389-C37A-4697-87EB-8CF1F207438C', 6, 1),
(845, 'CHAVANON', 'Jean-Pierre', 'M.', '16 Villa du Bel Air', NULL, NULL, '74140', 'SCIEZ', '00-85-38-59-77', '00-56-38-07-40', '1965-05-25 00:00:00.000', 0.889831, 8400, 'D7F172FD-FA30-405B-AA45-F95C3F9F0889', 4, 2),
(846, 'VALENTIN-ANTOINE', 'Marcel', 'M.', '6 Avenue des Gobelins', NULL, NULL, '69630', 'CHAPONOST', '00-36-43-45-80', '00-87-39-97-57', '1948-10-31 00:00:00.000', 0.0281592, 20600, '0A60492E-6A1A-4A19-AFDB-FBF47D1D5A4F', 6, 2),
(847, 'FEDIRKO', 'Corinne', 'Mme.', '3 Grande Rue', NULL, NULL, '83120', 'SAINTE MAXIME', '03-45-10-55-59', '03-80-15-76-45', '1963-11-17 00:00:00.000', 0.430836, 5200, '5850F4DD-BDB9-427C-99BB-E2F6DE9606DC', 6, 1),
(848, 'DUAULT EPOUSE GIANOTTI', 'Frdric', 'M.', 'Sur les Crts', NULL, NULL, '75009', 'PARIS', '03-69-09-53-11', '03-57-42-37-54', '1960-12-20 00:00:00.000', 0.701165, 13700, 'FFC2C90C-DAA1-4FB2-92A1-8F65C026D4C4', 6, 2),
(849, 'DUBOIS', 'Michle', 'Mme.', '37 Rue Lucien Cozon', NULL, NULL, '75017', 'PARIS', '04-65-59-09-77', '04-05-47-51-53', '1944-01-10 00:00:00.000', 0.458995, 9900, '3F754AD8-17FE-40FF-9AEA-092A390F996C', 6, 1),
(850, 'LAMY-RINCHEVAL', 'Catherine', 'Mme.', '"Le Splendid Azur B"', 'Bd De Lattre de Tassigny', NULL, '69290', 'SAINT GENIS LES OLLIERES', '00-54-27-19-10', NULL, '1944-10-30 00:00:00.000', 0.208378, 19100, '009037C1-7547-4601-A224-3F3DDE2711D5', 6, 1),
(851, 'CARLIN', 'Anne-Marie', 'Mme.', '85 Rue du Faubourg Poissonnire', NULL, NULL, '01200', 'BELLEGARDE SUR VALSERINE', '05-91-00-09-59', '05-47-59-49-10', '1945-10-22 00:00:00.000', 0.757483, 7000, '15F61851-9431-42B3-9F89-8AFC0F70DD37', 6, 1),
(852, 'SIOZAC', 'Daniel', 'M.', '82 Rue de Saussure', NULL, NULL, '83990', 'SAINT TROPEZ', '03-18-46-43-45', '03-25-47-28-15', '1947-07-30 00:00:00.000', 0.977125, 16500, '8D2852F4-73F5-409B-BCA8-58EDDBB80C4F', 1, 2),
(853, 'TEYSSAIRE', 'Murielle', 'Mme.', '8 Place Georges Pompidou', NULL, NULL, '51100', 'REIMS', '04-54-19-74-22', '04-95-90-47-66', '1962-07-07 00:00:00.000', 0.250617, 7900, 'C80D168C-DA19-430D-A498-F0E7035031B3', 6, 1),
(854, 'BONNEFOND', 'Stphane', 'M.', '4 Rue Zphirin Jeantet', NULL, NULL, '75008', 'PARIS', '02-54-09-78-01', '02-73-97-65-30', '1952-06-30 00:00:00.000', 0.675821, 9700, '9424C0D2-0AB4-4E67-9264-1860C16D7F88', 6, 2),
(855, 'ADJENNIAN', 'Jean-Pierre', 'M.', '2 Rue Victor Laugier', NULL, NULL, '73550', 'MERIBEL LES ALLUES', '01-44-02-90-50', '01-36-06-87-86', '1945-09-23 00:00:00.000', 0.906727, 9500, 'BC632F25-8CE1-44C3-8787-B63F39157E8F', 6, 2),
(856, 'YVROUD', 'Robert', 'M.', '2 Bis Rue du Gnral Sarrail', NULL, NULL, '92320', 'CHATILLON', '04-73-95-92-04', '04-38-90-52-42', '1956-08-17 00:00:00.000', 0.216826, NULL, '315CB7FE-6BEA-469B-AE83-62FD9409BD6E', 6, 2),
(857, 'KUNDURIAN', 'Gilbert', 'M.', '37 Rue d''Amsterdam', NULL, NULL, '73100', 'AIX LES BAINS', '04-50-20-27-51', '04-45-26-88-48', '1949-02-10 00:00:00.000', 0.847593, 1100, 'FA6EEFE4-1859-44EE-93B3-3E1735474359', 6, 2),
(858, 'VOIDIES', 'Patrick', 'M.', 'Le Mottaret', NULL, NULL, '94220', 'CHARENTON LE PONT', '05-93-28-06-30', '05-63-95-89-76', '1947-10-23 00:00:00.000', 0.765931, 10200, '74D7A72F-3C1B-405A-9657-FC8486DF231D', 6, 2),
(859, 'IMBERT', 'Claude', 'M.', '3 Rue Gabriel Pri', NULL, NULL, '75010', 'PARIS', '01-11-61-73-78', '01-54-59-85-76', '1938-05-15 00:00:00.000', 0.515314, 400, '95578767-114B-4375-86D1-03D6F07C9758', 1, 2),
(860, 'ANIBALI', 'Roger', 'M.', '12 Rue du Casino', NULL, NULL, '69006', 'LYON', '04-35-73-86-82', '04-65-37-29-53', '1925-02-07 00:00:00.000', 0.371702, 16900, '6FE44B35-362E-4366-8236-F440CD756887', 6, 2),
(861, 'NORVAL', 'Bertrand', 'M.', '68 Bis Rue de Paris', NULL, NULL, '33320', 'EYSINES', '03-33-06-76-42', '03-96-42-90-01', '1951-09-14 00:00:00.000', 0.887015, 19000, '864F0438-BF7E-450C-A422-34F7DD1B5D7F', 6, 2),
(862, 'SCHWARTZ', 'Alain', 'M.', '93 Rue de Maubeuge', NULL, NULL, '75006', 'PARIS', '05-28-79-94-05', '05-28-13-61-92', '1951-09-26 00:00:00.000', 0.58008, 21600, 'FAD6F965-8AE9-4404-B921-55C8BBBD5A41', 6, 2),
(863, 'ARGENTI', 'Guy', 'M.', '3 Rue Pierre Corneille', NULL, NULL, '67310', 'WASSELONNE', '03-61-03-68-79', '03-30-17-67-96', '1958-03-27 00:00:00.000', 0.754667, 19800, 'E972E8EE-B6EA-4E3C-9A54-EA635A4B0876', 6, 2),
(864, 'FAURE', 'Martine', 'Mme.', '115 Avenue de Saint Mdard', NULL, NULL, '33700', 'MERIGNAC', '01-61-10-04-01', '01-63-66-75-58', '1955-06-24 00:00:00.000', 0.250617, 9000, 'D32D7EE2-65C4-4C11-8ACF-A1B477732F6C', 6, 1),
(865, 'MARTINETTI', 'Philippe', 'M.', '167 Bd du Montparnasse', NULL, NULL, '06530', 'PEYMEINADE', '03-97-43-98-27', '03-57-60-84-19', '1973-01-05 00:00:00.000', 0.537841, 23900, '42B90AFE-FCE2-4E87-A82A-07B02A5C32DF', 6, 2),
(866, 'BULIT', 'Toussaint', 'M.', '23 Rue du Gnral De Gaulle', NULL, NULL, '75009', 'PARIS', '03-32-66-33-85', '03-98-75-11-39', '1930-07-04 00:00:00.000', 0.374518, 12000, '68F40C23-798C-4B23-BFD3-927B9824ACF6', 5, 2),
(867, 'TIRARD', 'Patrice', 'M.', '1 Avenue de la Libration', NULL, NULL, '47000', 'AGEN', '00-92-31-08-09', '00-46-29-55-78', '1962-11-18 00:00:00.000', 0.64203, 20500, '3D2242EB-F641-4BBC-8E81-6C61C4EC396D', 6, 2),
(868, 'PATAS', 'Alain', 'M.', '23 Avenue de Boutigny', NULL, NULL, '76600', 'LE HAVRE', '01-63-75-48-90', '01-26-13-40-82', '1939-08-13 00:00:00.000', 0.0281592, NULL, '18AD5613-97DC-4C04-8E00-897061E3684B', 6, 2),
(869, 'DEMARS', 'Pierre', 'M.', '42 Rue du Faubourg Montmartre', NULL, NULL, '64200', 'BIARRITZ', '03-87-54-22-80', '03-54-79-77-09', '1964-02-06 00:00:00.000', 0.464627, 16000, '377A4887-5BCC-4469-A4A9-59C69A63CA06', 6, 2),
(870, 'JOURNE', 'Claude', 'M.', 'Place Pelletan', NULL, NULL, '75012', 'PARIS', '04-04-76-36-21', '04-19-90-74-07', '1938-04-20 00:00:00.000', 0.608239, 11600, 'D06F3C11-DF56-4340-B787-CD6FE661B4CB', 6, 2),
(871, 'BALEZ', 'Jol', 'M.', '35 Quai Southampton', NULL, NULL, '75017', 'PARIS', '02-96-87-78-84', '02-38-25-28-85', '1945-06-21 00:00:00.000', 0.661742, 24100, '3567F685-1836-4A3C-AC83-65B420B2786E', 6, 2),
(872, 'CHEMLA', 'Franoise', 'Mme.', '31 Rue Mazagran', NULL, NULL, '75019', 'PARIS', '01-20-70-32-98', '01-53-41-90-99', '1941-06-08 00:00:00.000', 0.225274, 15600, '9F174D32-F136-4342-965C-42A197C77B04', 6, 1),
(873, 'BOUTON', 'Albert', 'M.', '14 Rue Ernest Lacoste', NULL, NULL, '75008', 'PARIS', '01-10-99-99-38', '01-20-14-79-46', '1945-10-20 00:00:00.000', 0.912359, 22100, '2264EE95-CBEC-45CB-B620-C9A2CB33B1ED', 2, 2),
(874, 'ROUX', 'Alain', 'M.', '9 Bis Rue Pierre Demours', NULL, NULL, '44120', 'VERTOU', '05-54-47-99-53', '05-79-52-83-50', '1956-03-10 00:00:00.000', 0.566, 13000, 'FAFD8EF9-146C-46A5-BDCB-512583719F45', 6, 2),
(875, 'HUGONET', 'Guillaume', 'M.', '60 Rue Petit', NULL, NULL, '34000', 'MONTPELLIER', '00-88-32-46-69', '00-34-59-47-75', '1963-06-12 00:00:00.000', 0.951782, 15000, 'ABDF38C0-71A8-45F1-817F-08A5A9ADD243', 6, 2),
(876, 'BOURNET', 'Patrick', 'M.', '122 Rue La Botie', NULL, NULL, '91650', 'BREUILLET', '00-40-78-61-62', '00-75-34-94-41', '1945-01-12 00:00:00.000', 0.684269, 18400, 'B2AC2398-544C-42D9-B8AA-8F46D441F895', 6, 2),
(877, 'BAUDRY', 'Jean-Louis', 'M.', '58 Rue Delahaye', NULL, NULL, '66210', 'LES ANGLES', '04-18-01-14-47', '04-42-10-34-20', '1951-10-07 00:00:00.000', 0.0197115, 3800, '191E8866-95AC-4622-B5E9-755CF0AFD76F', 6, 2),
(878, 'ROUCH', 'Benot', 'M.', '103 Avenue Don Bosco', NULL, NULL, '17300', 'ROCHEFORT', '04-03-99-39-52', '04-69-36-88-28', '1958-08-13 00:00:00.000', 0.321015, NULL, 'D7F35928-173B-4258-A1A4-571C5F8995EF', 6, 2),
(879, 'BURGNIARD', 'Henri', 'M.', '2 Rue Ancienne Poste', NULL, NULL, '31000', 'TOULOUSE', '01-48-52-86-32', '01-29-73-39-34', '1936-07-29 00:00:00.000', 0.878568, 4000, '70696E27-4E0A-4CA4-BCD7-BF421BA1B169', 6, 2),
(880, 'MEUNIER', 'Christian', 'M.', 'Rsidence "Le Grand Ttras"', NULL, NULL, '74130', 'BONNEVILLE', '03-88-79-41-70', '03-56-60-14-18', '1956-12-01 00:00:00.000', 0.740588, 13100, '662EFD37-FDF9-464E-B189-1D13B87D3FF7', 1, 2),
(881, 'SCHMITT-JAEGERT', 'Grard', 'M.', '52 Rue Cochon Duvivier', NULL, NULL, '75008', 'PARIS', '04-67-86-03-82', NULL, '1956-04-13 00:00:00.000', 0.301304, 21100, '14365543-E04B-42C8-8D9C-2130952A1040', 6, 2),
(882, 'DIETSCH', 'Kathy', 'Mme.', '17 Place Occitane', NULL, NULL, '68100', 'MULHOUSE', '05-96-89-78-19', '05-40-21-17-16', '1956-11-16 00:00:00.000', 0.985573, 6700, 'F174470E-42BF-4864-B731-E20194B0BD1D', 6, 1),
(883, 'RENSCH', 'Jean-Eric', 'M.', '115 Rue du Pont', NULL, NULL, '75116', 'PARIS', '03-98-69-12-96', '03-52-86-82-14', '1950-10-10 00:00:00.000', 0.315383, 1700, '3F667BCC-0132-4AFF-AD3C-09B421BE8350', 6, 2),
(884, 'REY', 'Rodolphe', 'M.', '22 Rue de la Ppinire', NULL, NULL, '76200', 'DIEPPE', '01-53-62-18-34', '01-26-38-40-31', '1950-02-27 00:00:00.000', 0.464627, 9700, 'FCD23396-C63E-4222-8BA7-E30C8BFBF674', 6, 2),
(885, 'ROUTIER', 'Alain', 'M.', '4 Porte du Miroir', NULL, NULL, '34400', 'LUNEL', '00-63-43-56-05', '00-73-16-24-44', '1953-03-28 00:00:00.000', 0.687085, 7600, '9556A089-26E7-41F6-A227-BE9425023845', 6, 2),
(886, 'CHEMLA', 'Dominique', 'M.', '8 Rue Massenet', NULL, NULL, '80500', 'MONTDIDIER', '01-24-09-84-92', '01-86-09-14-57', '1951-03-22 00:00:00.000', 0.760299, 13900, '37DADBF2-C766-4018-9FB6-700D5ACA08C4', 6, 2),
(887, 'GOYER', 'Raphal', 'M.', 'Rue Saint Rmy', NULL, NULL, '75015', 'PARIS', '02-92-62-24-16', '02-54-63-31-39', '1970-08-12 00:00:00.000', 0.585712, NULL, 'DDC55C86-B7CF-4A2D-B818-E6FACEBC51E5', 1, 2),
(888, 'MECHIN', 'Michel', 'M.', '228 Bd Gnral Sarrail', NULL, NULL, '91100', 'CORBEIL ESSONNES', '01-03-37-49-43', '01-54-52-07-81', '1936-10-10 00:00:00.000', 0.292856, 15700, '85674C14-CEF2-4ADC-AAA0-2D4E7081564E', 6, 2),
(889, 'SAILLARD', 'Henry', 'M.', '12 Bd du Gnral Debeney', NULL, NULL, '71570', 'LA CHAPELLE DE GUINCHAY', '00-87-48-15-94', '00-29-28-30-95', '1954-07-25 00:00:00.000', 0.740588, 11700, 'D6C37C3B-52B5-4267-8A5E-D9BFA5DE1110', 6, 2),
(890, 'CIPIERRE', 'Alain', 'M.', '84 Rue Saint Charles', NULL, NULL, '25500', 'MORTEAU', '00-77-57-82-98', '00-83-55-75-73', '1943-08-04 00:00:00.000', 0.4421, NULL, '28C58646-EE61-4B3C-A51C-F360934F2268', 6, 2),
(891, 'BOINVILLE', 'Eric', 'M.', '64 Rue Feray', NULL, NULL, '24000', 'PRIGUEUX', '00-44-52-75-26', '00-56-33-17-05', '1962-04-08 00:00:00.000', 0.79409, 22300, 'EBC398F0-D832-47A7-A7E0-0A4D03A3F730', 6, 2),
(892, 'DUPEY', 'Roland', 'M.', '" La Cascade "', NULL, NULL, '77780', 'BOURRON MARLOTTE', '00-67-75-44-89', '00-69-13-90-78', '1936-02-03 00:00:00.000', 0.768747, 800, '7A50C460-763A-4581-9469-CB13B893AD9A', 6, 2),
(893, 'DE SALEON TERRAS', 'Michel', 'M.', '19 Grande Rue', NULL, NULL, '33160', 'SAINT MDARD EN JALLES', '04-81-77-82-93', '04-61-50-99-15', '1955-04-01 00:00:00.000', 0.515314, 20400, '4162759F-898F-4254-8DEF-60B6720D6C53', 6, 2),
(894, 'RIVIERE', 'Bruno', 'M.', '58 Rue Wilson', NULL, NULL, '83110', 'SANARY SUR MER', '02-63-00-13-51', '02-04-92-37-00', '1955-05-10 00:00:00.000', 0.0563184, 5500, '4E1ECC43-F4F7-4878-A479-C43CED23C467', 5, 2),
(895, 'AMAR', 'Jean-Franois', 'M.', '26 Rue Murger', NULL, NULL, '97430', 'LE TAMPON', '03-13-88-41-97', '03-08-44-72-15', '1958-07-20 00:00:00.000', 0.247801, 4300, '7051349C-6E2C-4A5F-B3DA-1D93CA8EC7BD', 6, 2),
(896, 'LOUVIER', 'Chamuel', 'M.', '16 Rue Charles Chaumel', NULL, NULL, '75116', 'PARIS', '03-87-64-27-20', '03-89-52-15-08', '1953-10-03 00:00:00.000', 0.430836, 10400, '4B969E94-EEEE-423A-A9F2-E547E9DC2ADE', 6, 2),
(897, 'HUCHET DE QUNETAIN', 'Georges', 'M.', '19 Chemin du Rosaire', NULL, NULL, '74300', 'LES CARROZ D''ARACHES', '04-42-98-08-21', '04-99-90-77-12', '1933-01-10 00:00:00.000', 0.751851, 300, '2B335EF7-46F4-4079-97CA-F26A9ED3BC3E', 6, 2),
(898, 'MONCHARMONT', 'Georges', 'M.', '217 Rue Jules Bertaut', NULL, NULL, '92130', 'ISSY LES MOULINEAUX', '00-60-66-43-68', '00-66-83-72-05', '1950-03-02 00:00:00.000', 0.0929254, 19300, '650EB683-943E-4E56-B590-CE1664876D09', 6, 2),
(899, 'JADAS', 'Jean-Claude', 'M.', '59 Rue Boissire', NULL, NULL, '38170', 'SEYSSINET PARISET', '02-11-94-56-70', '02-49-65-91-14', '1951-07-30 00:00:00.000', 0.751851, 18800, '3EF1AC9A-D3B7-4D05-924E-48F17C5481BB', 6, 2),
(900, 'LUCAS', 'Franois', 'M.', '97 Route du Serveray', NULL, NULL, '60200', 'COMPIEGNE', '04-28-54-62-03', '04-30-80-52-83', '1950-05-07 00:00:00.000', 0.79409, 7900, 'CADF027B-DCB8-4A53-AFB2-F2CE15E81B22', 6, 2),
(901, 'BOURDIN', 'Georges', 'M.', '30/32 Rue Diderot', NULL, NULL, '57000', 'METZ', '05-72-44-64-42', '05-86-14-41-94', '1952-06-17 00:00:00.000', 0.112637, 12400, '4A5AB8F5-37D1-49BB-9B2D-B1D60D3C7D3B', 2, 2),
(902, 'BIECHELE', 'Alain', 'M.', '18 Rue de la Tuilerie', NULL, NULL, '95560', 'MAFFLIERS', '03-41-75-07-35', '03-02-29-39-91', '1950-04-15 00:00:00.000', 0.29004, 11200, '835D615D-36A2-4F78-B633-2BE7351FCEFD', 6, 2),
(903, 'LAIK', 'Eugne', 'M.', '31 Rue Pierre Sauvage', NULL, NULL, '13006', 'MARSEILLE', '00-26-79-51-17', '00-20-85-65-49', '1923-06-23 00:00:00.000', 0.726508, 1700, '08A290C8-BF95-4D7F-B6F1-69C1794F28C6', 6, 2),
(904, 'SARFATI', 'Jean-Jacques', 'M.', '10 Rue des Augustins', NULL, NULL, '31300', 'TOULOUSE', '01-19-97-05-57', '01-52-37-36-92', '1950-11-27 00:00:00.000', 0.464627, 19500, 'ACE1394F-4C43-4AC5-ACAF-1F267EC2ACA2', 6, 2),
(905, 'DODANTHUN', 'Daisy', 'Mme.', '15 Rue de la Mairie', NULL, NULL, '92200', 'NEUILLY', '01-58-15-16-83', '01-38-80-50-09', '1952-03-21 00:00:00.000', 0.371702, 19800, 'BFD12954-789B-4799-A1F2-691870058369', 6, 1),
(906, 'LUQUE', 'Jacqueline', 'Mme.', '16 Rue Lafon', NULL, NULL, '75017', 'PARIS', '01-78-40-30-20', '01-35-76-38-81', '1936-05-19 00:00:00.000', 0.810986, 18700, '5C5258FF-605B-4F3B-ADEA-B1F2C2CC93C1', 6, 1),
(907, 'QUARTA', 'Robert', 'M.', '66 Bis Avenue Etienne Billires', NULL, NULL, '06140', 'TOURRETTES SUR LOUP', '03-58-96-20-80', '03-85-36-21-68', '1944-02-05 00:00:00.000', 0.839145, 17300, 'A9EC161E-92E8-4281-BDD7-3AF1FDC421B2', 6, 2),
(908, 'GASTARD', 'Isabelle', 'Mme.', '14 Rue Paul Chatrousse', NULL, NULL, '93140', 'BONDY', '02-18-26-40-36', '02-34-01-61-10', '1965-08-01 00:00:00.000', 0.425204, NULL, '4E0D7279-6A6A-4DAD-B81C-07669A923260', 3, 1),
(909, 'PUECH', 'Ren', 'M.', '206 Bd Pereire', NULL, NULL, '61130', 'BELLEME', '01-21-84-95-06', '01-63-55-75-83', '1947-11-12 00:00:00.000', 0.833513, 200, '69252296-F1FB-4880-B2BB-910F71085023', 6, 2),
(910, 'PEREZ', 'Bernard', 'M.', '1492 Route de La-Colle', NULL, NULL, '06000', 'NICE', '01-32-25-61-21', '01-06-46-38-09', '1955-04-03 00:00:00.000', 0.264697, 14600, '86EC8C77-333A-4F97-9045-B1AB9DB6EDFC', 6, 2),
(911, 'DU PELOUX MENAG', 'Pierre', 'M.', '6 Rue de la Libert', NULL, NULL, '78250', 'MEULAN', '03-83-79-25-39', NULL, '1959-05-20 00:00:00.000', 0.399861, 13200, 'B5EFCB93-9BEF-4846-9211-0625EBAFC2F1', 6, 2),
(912, 'GUILLEMINOT', 'Franois', 'M.', '8 Bd Bansard des Bois', NULL, NULL, '75008', 'PARIS', NULL, '03-37-62-71-68', '1965-12-25 00:00:00.000', 0.498418, 12300, '8562CE40-4AD9-49D7-81CE-57DEC31D9DDB', 6, 2),
(913, 'COULON', 'Jean-Paul', 'M.', '15 Rue Alberti', NULL, NULL, '13011', 'MARSEILLE', '04-23-91-12-48', '04-32-75-17-31', '1947-09-13 00:00:00.000', 0.720876, 7000, '5E60738E-D166-44B5-AFF2-7F8D70E8496F', 6, 2),
(914, 'VIENNET', 'Michel', 'M.', '8 Rue du Marchal Foch', NULL, NULL, '71100', 'CHALON SUR SAONE', '05-32-82-81-34', '05-26-46-18-58', '1947-12-12 00:00:00.000', 0.689901, 9300, '141C2C39-A612-45E8-BE0B-ED4A96CE71C0', 6, 2),
(915, 'MADAR', 'Jean-Paul', 'M.', '72 Rue du Faubourg Saint Honor', NULL, NULL, '05290', 'PUY SAINT VINCENT', '03-79-29-24-61', '03-26-75-58-60', '1951-04-21 00:00:00.000', 0.943334, 24500, '75DF7AA4-3F0B-410C-BED2-34FF63F719B4', 7, 2),
(916, 'FERRET', 'Laurent', 'M.', '125 Bd de Saint Marcel', NULL, NULL, '75015', 'PARIS', '04-85-15-93-73', '04-12-14-58-67', '1955-05-20 00:00:00.000', 0.264697, 7000, 'F9B55FDC-F966-4459-8EF3-2FDD78249852', 6, 2),
(917, 'CUER', 'Christophe', 'M.', '12 Rue Lamartine', NULL, NULL, '60400', 'NOYON', '02-99-88-89-78', '02-09-15-64-86', '1967-03-04 00:00:00.000', 0.664558, 12900, '27EE91EC-2C0E-4B7F-A5A5-1CAC4CDBB59A', 6, 2),
(918, 'SANCY', 'Pascal', 'M.', 'Immeuble " La Voile "', NULL, NULL, '13300', 'SALON DE PROVENCE', '05-76-06-71-37', '05-36-29-56-48', '1962-08-20 00:00:00.000', 0.636398, NULL, '7947D819-1C99-436F-87FE-B37EEDBFF95A', 6, 2),
(919, 'PAILLET', 'Jolle', 'Mme.', '51 Rue Dombasle', NULL, NULL, '77550', 'MOISSY CRAMAYEL', NULL, '03-71-59-36-25', '1947-10-08 00:00:00.000', 0.858856, 1200, '400E1D4E-4B3A-4D43-ABDA-D4D5003C9940', 6, 1),
(920, 'MEGLIO', 'Dominique', 'Mme.', '17 Rue de Paris', NULL, NULL, '86180', 'BUXEROLLES', '02-52-15-56-63', '02-69-80-60-04', '1953-11-23 00:00:00.000', 0.495602, 22700, 'C993274C-3075-4570-BF8D-8E6B16AA9E65', 6, 1),
(921, 'MORET', 'Alain', 'M.', '420 Bd Ledru Rollin', NULL, NULL, '75017', 'PARIS', '00-69-71-21-32', '00-86-38-82-98', '1947-07-11 00:00:00.000', 0.644846, 24500, 'F76F0268-02E2-4634-A3DF-1B0168B7F422', 6, 2),
(922, 'JOURDE', 'Hlne', 'Mme.', '28 Avenue Pasteur', NULL, NULL, '90000', 'BELFORT', '05-89-30-69-65', '05-20-15-51-82', '1947-01-17 00:00:00.000', 0.498418, 9700, '125520AC-57B4-4B21-8B61-1BFBE66FF06A', 4, 1),
(923, 'VULCANO', 'Jack-Claude', 'M.', '13 Rue de l''Htel de Ville', NULL, NULL, '75002', 'PARIS', '00-41-02-70-03', '00-12-11-80-11', '1927-07-12 00:00:00.000', 0.833513, 12400, 'F508E19C-D9D4-4E1B-8558-8A3FC2CA9E0F', 6, 2),
(924, 'MAILLARD', 'Caroline', 'Mme.', '46 Avenue des Ternes', NULL, NULL, '67000', 'STRASBOURG', '02-42-45-53-08', '02-12-05-61-53', '1964-09-04 00:00:00.000', 0, 23900, 'F4481702-B17A-44B9-9761-87A24AD95D40', 6, 1),
(925, 'CREMOUX', 'Josette', 'Mme.', '17 Rue Thiers', NULL, NULL, '94120', 'FONTENAY SOUS BOIS', '00-16-42-11-40', '00-29-94-32-74', '1937-03-01 00:00:00.000', 0.250617, 20100, '74DB4685-39B0-4FE1-A97F-292472EA60D5', 6, 1),
(926, 'COTREAU', 'Pierre', 'M.', '15 Rue de la Banque', NULL, NULL, '87000', 'LIMOGES', '04-80-47-66-36', '04-95-45-40-48', '1967-05-01 00:00:00.000', 0.0450548, 25000, 'EFB9A7C8-86DB-4D7F-8A3E-0EE0BEF70BF3', 6, 2),
(927, 'GRAVIER', 'Bernard', 'M.', '12 Place des Halles', NULL, NULL, '33000', 'BORDEAUX', '01-70-72-43-49', '01-51-33-53-27', '1953-11-01 00:00:00.000', 0.915175, 9000, '25F44CE9-2B57-4F04-BCDD-DD57DB845343', 6, 2),
(928, 'CHAPELLE', 'Jean-Michel', 'M.', '49 Rue Roublot', NULL, NULL, '92240', 'MALAKOFF', '01-58-30-03-72', '01-17-00-08-86', '1955-05-10 00:00:00.000', 0.0253433, 22500, 'B27C1D28-793D-4981-AF5B-BFFB6461CA2D', 6, 2),
(929, 'FORGEOT', 'Andr', 'M.', '15 Avenue Gnral De Gaulle', NULL, NULL, '69003', 'LYON', '04-11-02-80-38', '04-19-99-26-52', '1947-06-08 00:00:00.000', 0.247801, 100, '18E40B58-EF1F-4588-A580-2999EFB49A38', 7, 2),
(930, 'BEINISCH', 'Gilbert', 'M.', '3 Rue de l''Htel de Ville', NULL, NULL, '21000', 'DIJON', '01-61-70-62-17', '01-86-89-29-89', '1938-05-09 00:00:00.000', 0.644846, 14200, '0CE9940F-EFEA-407D-B24E-EBE4135BA691', 6, 2),
(931, 'THIVOLLE', 'Grard', 'M.', '6 Place du 11 Novembre', NULL, NULL, '92200', 'NEUILLY', NULL, NULL, '1938-09-28 00:00:00.000', 0.281592, 18000, 'FB98DED2-A003-46EA-BDD7-6F8FCE51CCC0', 6, 2),
(932, 'BENTZ', 'Olivier', 'M.', '24 Rue Mazenod', NULL, NULL, '31000', 'TOULOUSE', '02-28-59-20-32', '02-22-71-60-37', '1950-12-15 00:00:00.000', 0.906727, 8500, '120A775D-71CD-4EAC-B596-AD759FA46B89', 6, 2),
(933, 'MENDES', 'Alain', 'M.', '29 Rue Monge', NULL, NULL, '63500', 'ISSOIRE', NULL, '00-38-55-30-57', '1939-07-12 00:00:00.000', 0.0478707, 15600, '1BDF4080-2EA4-4078-B320-19477D9A8C57', 6, 2),
(934, 'SABARD', 'Rosa', 'Mme.', '47 Rue Perronet', NULL, NULL, '94300', 'VINCENNES', '01-19-89-51-65', '01-11-11-38-52', '1961-09-28 00:00:00.000', 0.560369, 23700, '353ED6DA-A80C-4A85-A215-69C944654A2E', 6, 1),
(935, 'SAVEROT', 'Jean', 'M.', '15 Rue de l''Industrie', NULL, NULL, '95160', 'MONTMORENCY', '03-28-33-44-57', '03-74-20-43-06', '1945-04-04 00:00:00.000', 0.763115, 15700, '804AB269-E617-4293-B838-B845B0F26A58', 6, 2),
(936, 'JOUIN', 'Andr', 'M.', '31 Bd de la Manlire', NULL, NULL, '06300', 'NICE', '03-50-56-13-98', '03-59-90-07-45', '1941-10-05 00:00:00.000', 0.971493, 7900, '9DF3924B-C9A5-4187-BB02-5BB762467C4D', 4, 2),
(937, 'DIEUMEGARD', 'Michel', 'M.', '140 Avenue de Paris', NULL, NULL, '35000', 'RENNES', '00-31-38-06-54', '00-86-39-21-16', '1951-01-19 00:00:00.000', 0.546289, 14900, '8676C292-BF23-4C04-84EE-0D628EA7DC98', 6, 2),
(938, 'VIGNE', 'Andr', 'M.', '4 Alle de Longchamp', NULL, NULL, '79260', 'LA CRECHE', '04-74-80-92-92', '04-66-92-22-96', '1945-10-11 00:00:00.000', 0.0450548, 500, '22C9FE25-FAD8-4F20-8733-A789D7624D16', 6, 2),
(939, 'BEAUVINEAU', 'Claude', 'M.', '4 Rue Paul Reboux', NULL, NULL, '30500', 'SAINT AMBROIX', '02-29-69-98-30', '02-67-38-70-90', '1941-05-08 00:00:00.000', 0.647662, 17500, '4DD39B9C-55CA-43C4-8716-9C23D6357ACC', 6, 2),
(940, 'SPIESS', 'Sandrine', 'Mme.', '2 Quai Richemont', NULL, NULL, '44400', 'REZ', '04-29-04-23-93', '04-64-38-79-16', '1970-11-06 00:00:00.000', 0.0506866, 22600, '9EA774E1-79E5-479D-8AF1-FC00C22F2295', 6, 1),
(941, 'VAN LOON', 'Dominique', 'M.', '75 Avenue de Paris', NULL, NULL, '68330', 'HUNINGUE', '01-41-23-41-85', '01-05-30-40-31', '1954-11-20 00:00:00.000', 0.988389, 11700, '2ED2B5B7-546A-4688-8F92-0492B0F35F24', 6, 2),
(942, 'COHEN', 'Charles', 'M.', '23 Bd du Portalet', NULL, NULL, '75008', 'PARIS', NULL, '01-15-53-07-63', '1936-04-13 00:00:00.000', 0.861672, 20500, 'BCCCAFDA-C087-45D1-A25B-2944758937EE', 6, 2),
(943, 'CHAPEAU', 'Albert', 'M.', '74 Rue Jean Jaurs', NULL, NULL, '75008', 'PARIS', '01-81-72-71-19', '01-96-05-08-07', '1934-01-25 00:00:00.000', 0.875752, 12000, '13F6BA9F-F050-495C-8986-51E6F24A4459', 1, 2),
(944, 'RENNIE', 'Philippe', 'M.', '6 Rue de l''Htel de Ville', NULL, NULL, '75012', 'PARIS', '01-05-98-05-46', '01-87-57-60-70', '1964-06-05 00:00:00.000', 0.64203, 19300, 'BA1F5217-F158-4F43-B70A-ACC3BF06A8D6', 6, 2),
(945, 'THEVENIAUD', 'Eric', 'M.', '38 Rue de Berri', NULL, NULL, '97400', 'SAINT DENIS', '03-31-16-06-16', '03-54-12-00-31', '1958-06-27 00:00:00.000', 0.881384, 3800, '307518D0-A31B-4C08-A3A5-95ED0891EE24', 6, 2),
(946, 'BARBIER', 'Sylvain', 'M.', '6 Rue Berryer', NULL, NULL, '58110', 'CHATILLON EN BAZOIS', '03-91-30-38-68', '03-57-60-55-92', '1955-06-26 00:00:00.000', 0.104189, 12300, '3628F563-C3C2-410E-860D-5D3C6C709BC0', 6, 2),
(947, 'CAYLA', 'Claude', 'M.', '14 Rue Lacue', NULL, NULL, '92120', 'MONTROUGE', '02-56-99-48-58', '02-08-64-94-94', '1940-03-22 00:00:00.000', 0.689901, 16600, '99422AD2-90F7-45B2-B667-6B087D96F130', 6, 2),
(948, 'BELAICH', 'Claude', 'M.', '20 Rue Juliette Dodu', NULL, NULL, '75016', 'PARIS', '00-99-23-13-17', NULL, '1957-05-08 00:00:00.000', 0.861672, 1100, '685FC6F6-2CA6-4843-A370-5CA504EF41D1', 6, 2),
(949, 'BORDIER', 'Jacques', 'M.', 'Rue du Lion d''Or', NULL, NULL, '75008', 'PARIS', '01-25-86-98-53', '01-92-62-87-78', '1954-03-13 00:00:00.000', 0.994021, 12500, '52F2EAF8-A58A-4978-AB00-CD841FB087AA', 6, 2),
(950, 'GUERET', 'Jean-Paul', 'M.', '28 Bis Rue Barbs', NULL, NULL, '75017', 'PARIS', '00-38-76-50-54', '00-08-37-23-48', '1951-12-16 00:00:00.000', 0.30412, 6300, 'F2565F3C-E173-40BE-89DF-E0F9BF83ED07', 1, 2),
(951, 'JOSEPH', 'Eric', 'M.', '23 Rue Scheffer', NULL, NULL, '91700', 'SAINTE GENEVIEVE DES BOIS', NULL, '03-11-81-63-16', '1957-10-01 00:00:00.000', 0.0563184, 20400, '0D826650-9B83-4646-9659-733715956947', 6, 2),
(952, 'SCETBON', 'Michel', 'M.', '95 Bd Haussmann', NULL, NULL, '34830', 'CLAPIERS', '04-31-30-88-66', '04-89-14-43-84', '1952-11-19 00:00:00.000', 0.867304, 9400, '5F10FDAE-36EC-4295-BD4B-C4C2DF6064D2', 6, 2),
(953, 'DEVRIENDT', 'Daniel', 'M.', '13 Rue d''Hliopolis', NULL, NULL, '75014', 'PARIS', '04-67-39-48-38', '04-87-83-24-15', '1948-12-30 00:00:00.000', 0.436468, 300, 'C32EAE9B-A0AD-41D6-9461-AB163947DC59', 6, 2),
(954, 'MIGUET', 'Danile', 'Mme.', '212 Route de Corbeil', NULL, NULL, '78490', 'MONTFORT L''AMAURY', '05-58-83-52-79', '05-99-13-49-02', '1951-09-05 00:00:00.000', 0.588528, 1400, 'FA2013FD-031D-4C0A-A831-AB0DB469BE97', 6, 1),
(955, 'GUILLI', 'Michel', 'M.', '" Le Chalet " - Route de Prads', NULL, NULL, '93230', 'ROMAINVILLE', '03-50-41-47-54', '03-48-60-00-32', '1948-09-02 00:00:00.000', 0.295672, 3400, 'CD1BE987-A76D-4F90-AF98-3D5EC65CB24F', 6, 2),
(956, 'CUSSAC', 'Arlette', 'Mme.', '203 Rue d''Alsia', NULL, NULL, '83120', 'SAINTE MAXIME', '05-86-02-47-94', '05-48-24-01-44', '1941-11-06 00:00:00.000', 0.847593, 14400, 'FB6F1CEF-A899-4D53-B72C-7C69DDA26093', 6, 1),
(957, 'MARIANI NE MAZETIER', 'Thierry', 'M.', '12 Place de la Libration', NULL, NULL, '91150', 'ETAMPES', '01-03-43-62-24', '01-56-74-52-38', '1955-11-24 00:00:00.000', 0.0872936, 10600, '2E3CC4EA-7B40-4B84-B4CF-8FF3BF20BDF2', 5, 2),
(958, 'BOUSSOGNE', 'Suzette', 'Mme.', '5 Rue de Paris', NULL, NULL, '91160', 'LONGJUMEAU', '03-53-32-08-64', '03-75-13-32-00', '1938-01-29 00:00:00.000', 0.963045, 17200, 'F5A05C02-B527-4A2B-A795-D91ABFEAE340', 6, 1),
(959, 'GRANDAZZI', 'Bernard', 'M.', '9 Rue Pierre Curie', NULL, NULL, '92100', 'BOULOGNE', '03-64-08-14-51', '03-13-68-74-74', '1949-11-29 00:00:00.000', 0.546289, 10600, 'DAE7786A-5904-4BD0-A432-C790DF29EB15', 6, 2),
(960, 'PAILLONCY', 'Jean-Pierre', 'M.', '1 Place Notre Dame', NULL, NULL, '93210', 'LA PLAINE SAINT DENIS', '04-41-62-38-45', '04-60-68-90-68', '1939-12-23 00:00:00.000', 0.30412, 11100, '00A63CA7-92D4-4BF4-A9B0-9815608F4417', 6, 2),
(961, 'ESTEVE', 'Hubert', 'M.', '8 Bis Rue de l''Yvette et', '10 Rue de l''Abreuvoir', NULL, '31590', 'VERFEIL', '05-85-06-57-83', '05-47-10-43-99', '1956-08-21 00:00:00.000', 0.774379, NULL, 'BB842DB9-0A48-4E55-981F-15C4FAAA4D95', 6, 2),
(962, 'SANTOT', 'Nicole', 'Mme.', '86 Rue de Bellevue', NULL, NULL, '56400', 'AURAY', '03-92-72-36-43', '03-08-58-09-00', '1936-04-10 00:00:00.000', 0.00844777, 11000, 'CE42BB69-BE65-4972-9B76-AB2ECB86F4B8', 6, 1),
(963, 'REVOLLET', 'Reinold', 'M.', '162 Rue du Landy', NULL, NULL, '76600', 'LE HAVRE', '04-80-72-07-69', '04-73-75-93-39', '1961-03-07 00:00:00.000', 0.230906, 13600, '4DC2DAED-02BF-4CFE-B16C-B5092B43FC75', 6, 2),
(964, 'ROUSSELIN', 'Michel', 'M.', 'Le Breil', NULL, NULL, '38100', 'GRENOBLE', '02-43-80-73-41', '02-29-88-32-44', '1987-10-01 00:00:00.000', 0.889831, 19400, 'F0186E74-DF23-4EA4-9D5B-70D2A8B1428A', 2, 2),
(965, 'AMRAM', 'Jacques', 'M.', '15 Place Notre Dame', NULL, NULL, '35500', 'VITR', '01-04-07-67-22', '01-12-59-56-28', NULL, 0.979941, 23300, '6CBF4CD6-6570-4DFE-B4B5-2F4E65D68E1C', 6, 2),
(966, 'COLIN', 'Raoul', 'M.', '94 Rue Bernardin de Saint Pierre', NULL, NULL, '75016', 'PARIS', '05-00-40-23-84', '05-32-78-41-45', '1941-01-14 00:00:00.000', 0.363254, 5400, '96124F6B-A8E6-4812-A89E-BE65F566E065', 6, 2),
(967, 'CASSAN', 'Michel', 'M.', '191 Cours de la Libration', NULL, NULL, '92600', 'ASNIERES', '05-14-99-36-30', '05-80-47-34-75', '1934-10-24 00:00:00.000', 0.461811, 15300, '26C8C5F6-C950-4CD7-9954-03DFF04409F0', 6, 2),
(968, 'AUMAITRE', 'Jacques', 'M.', '" Les Ntumires "', '11 rue Cambacrs', NULL, '06300', 'NICE', '02-41-78-32-75', '02-99-35-26-40', '1945-02-10 00:00:00.000', 0.687085, 12400, '83F4B881-CBF4-4B7C-9B42-C40EB3670921', 6, 2),
(969, 'TEXIER', 'Robert', 'M.', '17 Rue Duret', NULL, NULL, '03100', 'MONTLUON', '01-50-56-97-77', '01-17-33-74-61', '1941-02-07 00:00:00.000', 0.0703981, 19200, '2CF3E598-5C17-4685-BACE-9FB870A32EAB', 6, 2),
(970, 'MOURGE', 'Philippe', 'M.', '70 Avenue d''Argenteuil', NULL, NULL, '60460', 'PRECY SUR OISE', '03-42-16-13-22', '03-47-79-82-29', '1958-02-27 00:00:00.000', 0.734956, 22600, 'A190F33A-BDAE-40F3-9D4D-12C0157FCE0F', 6, 2),
(971, 'VILLEMINOZ', 'Jacqueline', 'Mme.', '4 Bd Carnot', NULL, NULL, '06560', 'VALBONNE', '04-19-82-38-81', '04-71-09-38-19', '1947-09-01 00:00:00.000', 0.650478, 13300, '2019B9D8-6ADB-4A04-AA33-55E6857CB180', 1, 1),
(972, 'BILLOT', 'Marc', 'M.', '27 Rue des Forges', NULL, NULL, '38300', 'BOURGOIN JALLIEU', '00-09-98-76-24', '00-38-43-81-34', '1948-10-25 00:00:00.000', 0.0619503, 20000, '8BB552CF-1FAE-4FDB-9023-CC900762A983', 6, 2),
(973, 'LE GLOU', 'Michel', 'M.', '27 Rue du Havre', NULL, NULL, '78000', 'VERSAILLES', '00-82-01-18-73', '00-44-76-11-70', '1946-04-09 00:00:00.000', 0.703981, 21100, 'E74646D4-9A85-4828-9024-568E9294606F', 6, 2),
(974, 'LEVEAU', 'Pierre', 'M.', 'L''Altha - Avenue de Pierrefeu', 'La Moulire', NULL, '93190', 'LIVRY GARGAN', '01-53-12-22-42', '01-08-12-69-36', '1941-06-18 00:00:00.000', 0.698349, 5400, 'C2137B51-7A5B-4648-B36D-6DC1D7907792', 6, 2),
(975, 'JACQUETY', 'Gil', 'M.', '10 Place Hector Berlioz', NULL, NULL, '75116', 'PARIS', '01-83-41-11-67', '01-81-00-46-91', '1967-04-08 00:00:00.000', 0.225274, 20500, '7C6ACDF8-BB63-4105-801B-5F82A9C8D4A6', 6, 2),
(976, 'MUSSLIN', 'Claire', 'Mme.', '8 Impasse de Toulouse', NULL, NULL, '75008', 'PARIS', '04-40-87-94-71', '04-39-22-35-48', '1958-05-19 00:00:00.000', 0.864488, 2500, 'F9C7B29E-562B-41E5-89D8-E6DDC047604D', 6, 1),
(977, 'BLANC', 'Alphonse', 'M.', '23 Place de la Libration', NULL, NULL, '68100', 'MULHOUSE', '04-83-81-39-85', '04-32-55-55-19', '1944-06-04 00:00:00.000', 0.703981, 19600, 'DB26FFC9-6087-4861-A1C6-9CFA851A7738', 6, 2),
(978, 'CRES-DELLINGER', 'Patrice', 'M.', '18 Rue Cortambert', NULL, NULL, '73100', 'AIX LES BAINS', '00-91-71-14-09', '00-07-59-16-37', '1954-01-29 00:00:00.000', 0.667374, 16200, '0799BCA8-74BC-431F-BB4B-D2CC461CF660', 1, 2),
(979, 'CROS', 'Marie-Jeanne', 'Mme.', '28 Rue de Naples', NULL, NULL, '06300', 'NICE', '05-74-65-34-23', '05-32-73-14-84', '1944-01-11 00:00:00.000', 0.225274, 5400, '5B77D220-F706-4596-9C78-33EFCD230334', 6, 1),
(980, 'FISCHER', 'Georges', 'M.', '9 Avenue du Marchal De Lattre', 'de Tassigny', NULL, '81230', 'LACAUNE', '05-56-04-95-47', '05-59-42-72-13', '1920-06-07 00:00:00.000', 0.920807, 3300, '51382300-9FB5-4B1F-AFC5-36CE3463DB18', 6, 2),
(981, 'LOIODICE', 'Pierre', 'M.', '11 Rue de Genve', NULL, NULL, '68140', 'MUNSTER', '02-15-28-12-59', '02-87-52-64-50', '1938-04-21 00:00:00.000', 0.197115, 11300, '766F09C8-2282-45B5-881D-A4562E09EF73', 6, 2),
(982, 'COUILLEAUD', 'Dominique', 'M.', '19 Rue Lascaris', NULL, NULL, '94800', 'VILLEJUIF', '01-03-90-08-63', '01-95-74-41-21', '1934-02-20 00:00:00.000', 0.653294, 9800, '48AC806B-9037-4B3A-8FF5-C102F45CD69B', 6, 2),
(983, 'CHEVALIER', 'Maurice', 'M.', '33 Avenue de Naurois', NULL, NULL, '50400', 'GRANVILLE', '04-00-72-18-87', '04-79-89-57-18', '1910-11-26 00:00:00.000', 0.523762, 11000, '424A76E9-F747-409C-81E6-EF0E07A4F565', 6, 2),
(984, 'BREVILLE', 'Elisabeth', 'Mme.', '23 Grande Rue', NULL, NULL, '69006', 'LYON', '01-95-86-60-92', '01-67-87-43-03', '1961-01-09 00:00:00.000', 0.439284, 3000, '4370E17F-72FA-4230-87C5-B97783106739', 6, 1),
(985, 'ARTAZ', 'Laurent', 'M.', '53 Rue Jean Jaurs', NULL, NULL, '14800', 'DEAUVILLE', '01-36-40-53-06', '01-66-28-11-57', '1961-08-03 00:00:00.000', 0.644846, NULL, '86E846A9-BC20-4551-90D7-1F3ED943E721', 5, 2),
(986, 'PARMEGGIANI', 'Michel', 'M.', '79 Rue Couraye', NULL, NULL, '75008', 'PARIS', '03-56-86-71-68', '03-88-46-93-20', '1944-12-04 00:00:00.000', 0.943334, 14900, '81E35A00-02CC-428B-8DDA-18584FFB6B2C', 6, 2),
(987, 'PERROT', 'Georges', 'M.', '5 Rue Vendme', NULL, NULL, '04160', 'CHATEAU ARNOUX', '00-40-10-83-02', '00-88-81-63-19', '1954-10-03 00:00:00.000', 0.0253433, 20600, '31CBA901-215C-4746-A801-35EFFBAECD94', 6, 2),
(988, 'GRUSQ', 'Jean-Yves', 'M.', '17 Place Morny', NULL, NULL, '75015', 'PARIS', '03-73-54-41-65', '03-74-35-62-86', '1947-01-17 00:00:00.000', 0.287224, 11600, '17AC798A-58CA-4D8F-B5B9-9480E8649A52', 6, 2),
(989, 'RAYMOND', 'Christian', 'M.', '40 Rue des Mathurins', NULL, NULL, '75007', 'PARIS', '02-40-23-76-41', '02-58-31-96-47', '1955-07-23 00:00:00.000', 0.473075, 9500, '3AD16170-A543-4D3C-86FA-BD9903F2730D', 6, 2),
(990, 'CERQUANT', 'Nicole', 'Mme.', '" La Bastide Neuve "', '45 route de Paris', NULL, '75008', 'PARIS', '00-35-33-53-59', '00-66-65-30-94', '1944-08-02 00:00:00.000', 0.0844777, NULL, '1C0F2DE7-8DBB-444A-AB91-AA1117DC96E3', 6, 1),
(991, 'BARDIN', 'Ludovic', 'M.', 'Centre MBE n 302', 'Base arienne', NULL, '14000', 'CAEN', '05-83-78-15-51', '05-91-80-28-16', '1960-04-02 00:00:00.000', 0.453363, 18800, '3972C2C7-252A-479A-BD75-AF656CF7C8F3', 6, 2),
(992, 'BACHEVALIER', 'Patrick', 'M.', '25 Rue du Champ de Mars', NULL, NULL, '74000', 'ANNECY', '01-10-19-76-58', '01-35-40-03-75', '1951-04-08 00:00:00.000', 0.337911, 15600, '68CB512C-64A9-46F5-936A-1CC1F11C4FAC', 2, 2),
(993, 'HALAJKO', 'Anne-Marie', 'Mme.', '10 Rue Royale', NULL, NULL, '30000', 'NIMES', '04-67-91-14-97', '04-94-29-91-22', '1960-09-30 00:00:00.000', 0.29004, 16000, 'C21D99B2-164F-454E-A6FC-7232CDD8F0F7', 6, 1),
(994, 'REGNAULT', 'Michel', 'M.', '17 Rue Sadi Carnot', NULL, NULL, '89480', 'ETAIS LA SAUVIN', '05-20-41-78-17', '05-63-53-77-08', '1946-06-20 00:00:00.000', 0.678637, 15700, '5004A8DA-1AE3-4360-823F-C53E1A4C50DD', 6, 2),
(995, 'SAVY', 'Herv', 'M.', '14 Rue de la Poste', NULL, NULL, '50000', 'SAINT LO', '04-23-99-40-20', '04-47-39-51-67', '1957-03-24 00:00:00.000', 0.146428, 0, 'FA4B21DE-DE40-4EA2-A497-2FA877B56F50', 6, 2),
(996, 'CANARD', 'Louis', 'M.', '25 Rue Vincent Fata', NULL, NULL, '75016', 'PARIS', '02-10-56-17-81', '02-17-43-37-93', '1960-01-09 00:00:00.000', 0.960229, 5300, '2AE31198-0F85-44BE-BF3F-F8E52B54299E', 6, 2),
(997, 'GUEGAN', 'Franois', 'M.', 'CHEVIGNY', NULL, NULL, '75017', 'PARIS', '03-96-50-14-50', '03-29-14-40-64', '1940-08-27 00:00:00.000', 0.65611, NULL, 'A2058BE3-EF34-4424-A37E-A8CFF7AAC9C3', 6, 2),
(998, 'LE BRAS', 'Philippe', 'M.', '26 Place du Gnral De Gaulle', NULL, NULL, '22000', 'SAINT BRIEUC', '01-17-32-52-83', '01-67-35-14-55', '1959-03-14 00:00:00.000', 0.132348, 7100, '38CBA5A5-0B96-4985-899B-44B9FF37F084', 6, 2),
(999, 'DEGRANGE', 'Yves', 'M.', '17 Avenue Thophile Gautier', NULL, NULL, '75006', 'PARIS', '01-42-67-84-40', '01-24-64-56-01', '1946-02-09 00:00:00.000', 0.174587, 24000, '6B9CB9B9-9CAA-47AE-8E65-FC2ABD527B79', 3, 2),
(1000, 'ZACHARY', 'Pascal', 'M.', '105 Rue des Moines', NULL, NULL, '26000', 'VALENCE', '05-87-20-86-92', '05-44-73-15-15', '1953-10-26 00:00:00.000', 0.0281592, 17500, '6C0D5165-1BE4-4450-B201-8A4E99FF6054', 6, 2),
(1001, 'BLANC', 'Jean-Paul', 'M.', '2 Rue Saint Gilles', NULL, NULL, '54150', 'BRIEY', '00-87-15-65-71', '00-77-30-66-37', '1949-02-20 00:00:00.000', 0.399861, 7500, '06EA9D2C-ECBE-44A1-B653-68BC4D55B24A', 6, 2),
(1002, 'LE BRAS', 'Herv', 'M.', '9 Rue Saint Sulpice', NULL, NULL, '75010', 'PARIS', '00-48-03-61-37', '00-87-73-70-92', '1963-12-09 00:00:00.000', 0.312567, 8200, '3DCC4E4A-2A2A-47D8-9FEF-F22434E4418D', 6, 2),
(1003, 'CARROT', 'Patrick', 'M.', '23 Rue Bouffier', NULL, NULL, '95240', 'CORMEILLES EN PARISIS', '01-19-53-32-28', '01-48-18-36-05', '1948-08-20 00:00:00.000', 0.00844777, NULL, '69371536-9058-4547-8445-24B7294F7DAF', 6, 2),
(1004, 'GUARINOS', 'Yves', 'M.', '17 Rue de Metz', NULL, NULL, '64600', 'ANGLET', '02-83-34-48-09', '02-12-53-96-04', '1915-11-10 00:00:00.000', 0.202746, 6000, 'A4ADB8DB-91DC-4778-A116-3563BF29CF51', 6, 2),
(1005, 'DEPEYRE', 'Philippe', 'M.', '101 Rue du Faubourg Saint Denis', NULL, NULL, '83000', 'TOULON', '05-58-80-62-54', '05-10-67-34-41', '1955-01-19 00:00:00.000', 0.109821, 18400, 'F6F2F9BC-8AEF-4591-A99D-F3B9D5C9761A', 6, 2),
(1006, 'STUDNIA', 'Christian', 'M.', '14 Bd Georges Clmenceau', NULL, NULL, '42000', 'SAINT TIENNE', '01-02-86-05-04', '01-51-71-92-97', '1938-04-22 00:00:00.000', 0.264697, 13000, 'F1717850-CCA3-41E7-A761-CF6981786A8B', 7, 2),
(1007, 'VIARD', 'Gilles', 'M.', '18 Promenade du Parc Belay', NULL, NULL, '92370', 'CHAVILLE', '01-68-38-48-75', '01-81-13-90-87', '1946-09-13 00:00:00.000', 0.0450548, 3600, 'E7A88746-2FBF-420C-9E17-184F1239286A', 6, 2),
(1008, 'CESCHIA', 'Philippe', 'M.', '217 Avenue de la Victoire', NULL, NULL, '75010', 'PARIS', '04-30-25-27-18', '04-16-22-18-22', '1954-11-29 00:00:00.000', 0.121085, 15900, 'CB2F839D-663D-4C94-9F2B-F7D106FFB009', 6, 2),
(1009, 'ORIGAS', 'Myriam', 'Mme.', '14 Rue Brossard', NULL, NULL, '06530', 'LE VAL DU TIGNET', '05-47-42-61-80', '05-12-39-93-16', '1955-03-31 00:00:00.000', 0.132348, 22100, '8935901D-63BE-491D-BD82-D72CAF5D7586', 6, 1),
(1010, 'COSIO', 'Grard', 'M.', '1336 Avenue Roger Salengro', NULL, NULL, '77300', 'FONTAINEBLEAU', '05-60-50-06-50', '05-75-14-58-67', '1943-08-11 00:00:00.000', 0.611055, NULL, 'D0DE669A-8345-4F08-89BE-1E7F7B187E08', 6, 2),
(1011, 'DIRRINGER', 'Jean', 'M.', '97 Bd de la Villette', NULL, NULL, '31300', 'TOULOUSE', '01-26-50-71-86', '01-32-64-49-67', '1948-09-30 00:00:00.000', 0.796906, 1300, 'C406A17B-2E05-40E8-BA34-CE2262CF49C5', 6, 2),
(1012, 'GRANATA', 'Robert', 'M.', 'Centre Commercial Saint Georges', NULL, NULL, '94300', 'VINCENNES', '04-68-15-66-25', '04-85-07-83-42', '1916-11-17 00:00:00.000', 0.847593, 19300, '03DD041D-439D-4A18-ADC9-16627F84E63A', 6, 2),
(1013, 'MONTARON', 'Jean-Claude', 'M.', '3 Rue Grande', NULL, NULL, '83220', 'LE PRADET', '01-74-51-77-72', '01-69-13-32-42', '1940-11-22 00:00:00.000', 0.566, 13400, 'DD96F89A-DFEB-47F5-97F5-BDD8569BB170', 4, 2),
(1014, 'ADDA', 'Anne-Franoise', 'Mme.', '10/12 Place du Ravelin', NULL, NULL, '53000', 'LAVAL', '04-81-36-47-31', '04-87-40-27-99', '1952-09-03 00:00:00.000', 0.112637, 18000, '4716F5A9-7C5F-42B2-AE01-2B940E7B4CF4', 6, 1),
(1015, 'DAUJEAN', 'Richard', 'M.', '4 Avenue Fayolle', NULL, NULL, '75015', 'PARIS', '02-29-32-03-84', '02-05-01-38-81', '1952-08-20 00:00:00.000', 0.673005, NULL, '0AC99CB3-D1A3-4A7A-A766-22B3BF70DF88', 6, 2),
(1016, 'DUPR', 'Nicole', 'Mme.', '70 Rue du Pensionnat', NULL, NULL, '83150', 'BANDOL', '00-56-20-18-00', '00-55-69-59-94', '1944-05-11 00:00:00.000', 0.87012, 15800, '23D51CE6-1016-489C-8E2F-19DF34440560', 6, 1),
(1017, 'POGNEAUX', 'Elisabeth', 'Mme.', '20 Place Saint Tugal', NULL, NULL, '38500', 'VOIRON', '02-25-49-69-37', '02-74-15-14-83', '1945-09-24 00:00:00.000', 0.453363, 19700, '398EF9EF-7A61-4853-AECE-C2C6217B99EF', 6, 1),
(1018, 'LEPRINCE', 'Chantal', 'Mme.', '21 Rue de Cronstadt', NULL, NULL, '05330', 'CHANTEMERLE', '02-41-31-31-36', '02-01-31-01-67', '1948-03-02 00:00:00.000', 0.844777, 18100, '4860DC2E-6D51-4FD3-AAB6-4840473F5146', 6, 1),
(1019, 'BOURDUT', 'Francine', 'Mme.', '50 Avenue du 11 Novembre', NULL, NULL, '45390', 'BOESSE', '03-02-51-09-85', '03-95-18-96-82', '1944-05-17 00:00:00.000', 0.157692, 2400, '5A3A4999-7EFE-4F82-BA56-F2215DD2A5E4', 6, 1),
(1020, 'CNUDDE', 'Alain', 'M.', '7 Rue Vaucanson', NULL, NULL, '91360', 'EPINAY SUR ORGE', '03-65-48-40-64', '03-23-69-54-55', '1947-04-08 00:00:00.000', 0.596975, 14600, '4C7D8CFF-D1A3-4566-A474-65622E6BD7DF', 7, 2),
(1021, 'MATHIEU', 'Danielle', 'Mme.', 'Alle des Boutiques', NULL, NULL, '91410', 'DOURDAN', '01-87-98-13-00', '01-84-91-51-71', '1945-02-15 00:00:00.000', 0.458995, 23600, '203C9785-F5B3-4023-9FD6-9AFC31ABF65C', 6, 1),
(1022, 'FRANCO', 'Daniel', 'M.', '13 Rue de Bourgogne', NULL, NULL, '30420', 'CALVISSON', '04-95-08-38-66', NULL, '1951-02-21 00:00:00.000', 0.80817, 0, 'FCEE07DE-8599-4ACE-8AC4-990AE31B6C7B', 6, 2),
(1023, 'HEYLLIARD', 'Marie-Yvette', 'Mme.', '146 Grande Rue', NULL, NULL, '06830', 'GILETTE', '03-06-74-34-45', '03-21-46-34-51', '1942-06-25 00:00:00.000', 0.636398, 7800, '5272D3FB-9B85-4CD0-B660-2D1DFC378E66', 6, 1),
(1024, 'LECUYER', 'Franoise', 'Mme.', '4 Bis Rue de Sarcey', NULL, NULL, '78170', 'LA CELLE SAINT CLOUD', '02-17-82-87-91', '02-31-66-18-14', '1954-01-24 00:00:00.000', 0.526577, 1000, '34A796F4-E870-4AA8-9370-07E42FACDC86', 6, 1),
(1025, 'STOFLIQUE', 'Anne', 'Mme.', '10 Route de Sommires', NULL, NULL, '75017', 'PARIS', '01-93-25-35-03', '01-39-99-77-19', '1953-09-16 00:00:00.000', 0.605423, 18700, '012107A5-6BBC-4CA7-9DA2-F893CA0C9375', 6, 1),
(1026, 'GARDEUR', 'Daniel', 'M.', 'Rue de la Poste', NULL, NULL, '16100', 'COGNAC', '03-47-33-50-27', '03-31-97-08-26', '1944-12-23 00:00:00.000', 0.157692, 17000, '6271E6E2-E558-483A-9ABA-820E89E79469', 6, 2),
(1027, 'STOIKOVITCH', 'Alain', 'M.', '11 Avenue Auguste Dutreux', NULL, NULL, '95170', 'DEUIL LA BARRE', '00-08-78-36-46', '00-28-69-40-43', '1944-01-31 00:00:00.000', 0.48997, 20300, 'F0DD954F-3058-4D30-AB86-B7A04007F980', 4, 2),
(1028, 'DAMBREVILLE', 'Mathilde', 'Mme.', '206 Bd Pereire', NULL, NULL, '97200', 'FORT DE FRANCE', '04-19-07-51-82', '04-76-19-88-08', '1958-02-18 00:00:00.000', 0.59416, 17500, '209AB041-306D-4AAF-AFC4-7324025EC2B7', 6, 1),
(1029, 'GATTEGNO', 'Raymond', 'M.', '44 Rue Millardet', NULL, NULL, '97400', 'SAINT DENIS', '00-27-69-99-59', '00-18-31-24-61', '1943-01-08 00:00:00.000', 0.444916, 24700, '1BB91A2A-1F73-446A-A481-D5AE62793358', 6, 2),
(1030, 'BARIOU', 'Lucien', 'M.', '49 Avenue de la Division Leclerc', NULL, NULL, '75002', 'PARIS', '04-31-44-48-64', '04-23-04-08-09', '1938-09-23 00:00:00.000', 0.799722, 14600, 'D2A561A0-8198-4D0E-A840-945ECE5922EF', 6, 2),
(1031, 'GUESTIN', 'Claude', 'M.', 'c/o COULEURS D''ILES', '1,6 Km Route de Didier', NULL, '37400', 'AMBOISE', '03-41-67-75-27', '03-65-00-64-01', '1953-02-05 00:00:00.000', 0.73214, 25000, 'D86443D5-2222-47D6-B735-2DD6E3605160', 6, 2),
(1032, 'JOSSEC', 'Bernard', 'M.', '63 Rue de la Bourdonnais', NULL, NULL, '74400', 'CHAMONIX', '01-12-81-22-64', '01-66-41-35-61', '1950-12-07 00:00:00.000', 0.78001, 18600, '537709B3-19C2-4D75-8BA2-67B7A3B883EC', 6, 2),
(1033, 'BOUQUET', 'Marc', 'M.', '56 Bis Rue du Louvre', NULL, NULL, '92600', 'ASNIERES', '02-81-84-41-42', '02-26-61-70-90', '1957-02-18 00:00:00.000', 0.881384, 22900, '8647CA71-8EFC-4BEF-91C2-27E19A2490D7', 6, 2),
(1034, 'BENACCHIO', 'Daniel', 'M.', '58 Place Michel Debr', NULL, NULL, '75016', 'PARIS', '04-01-64-37-67', '04-16-33-00-25', '1958-06-07 00:00:00.000', 0.481523, 21600, 'B677F73C-69C1-4D48-8FE6-ACBD20455008', 1, 2),
(1035, 'VASNER', 'Alain', 'M.', '223 Rue Joseph Vallot', 'Le Mummery', NULL, '38160', 'SAINT MARCELLIN', '00-06-97-96-72', '00-06-72-32-66', '1946-03-11 00:00:00.000', 0.467443, 10500, 'F152965D-05DB-4EED-A8E4-67FA9E13E0BD', 6, 2),
(1036, 'ARDUIN', 'Sylvie', 'Mme.', '1/3 Rue Bapst', NULL, NULL, '06400', 'CANNES', '03-10-44-26-71', '03-50-53-97-38', '1952-09-18 00:00:00.000', 0.51813, 13400, '3432F3A6-6B03-4117-B8EE-9508700EDEE0', 6, 1),
(1037, 'BOSCO', 'Georges', 'M.', '110 Avenue Mozart', NULL, NULL, '05200', 'EMBRUN', '03-38-83-17-80', '03-93-55-15-91', '1942-09-22 00:00:00.000', 0.571632, 14500, '67B6BCD3-E80E-42F4-96E4-ACC334958287', 6, 2),
(1038, 'TABOURDEAU', 'Werther', 'M.', '28 Bd du Champ de Mars', NULL, NULL, '57000', 'METZ', '03-00-27-33-02', NULL, '1932-01-10 00:00:00.000', 0.954598, 23500, '0505C6D1-ADF2-4FBA-B34E-D53BB71B02F6', 6, 2),
(1039, 'GUILLET DE LA BROSSE', 'Jean', 'M.', '5 Rue Flix Faure', NULL, NULL, '86000', 'POITIERS', '05-34-15-28-07', '05-25-30-69-55', '1945-08-18 00:00:00.000', 0.681453, NULL, '76927DBE-4A97-47DD-A0ED-D111152C60FD', 6, 2),
(1040, 'ROGER', 'Bruno', 'M.', 'Immeuble "Les Cordeliers"', 'Place du Gnral Dosse', NULL, '56000', 'VANNES', '01-86-22-88-25', '01-83-92-47-95', '1949-02-19 00:00:00.000', 0.343542, 13100, 'BB5EEEF2-9626-4CCD-B80D-CE7ABFA847F4', 6, 2),
(1041, 'KNYSZEWSKI', 'Hlne', 'Mme.', '8 Rue des Frres Lacretelle', NULL, NULL, '06250', 'MOUGINS', '02-57-39-05-70', '02-49-41-72-89', '1948-08-27 00:00:00.000', 0.512498, NULL, '65398AAE-8853-4074-8EF8-CA9F23A92FD5', 1, 1),
(1042, 'BENARROCH', 'Zygmund', 'M.', '2 Rue Gaston Hulin', NULL, NULL, '66210', 'LES ANGLES', '03-57-91-12-01', '03-82-27-27-09', '1938-05-01 00:00:00.000', 0.757483, 11500, '5AC4BD0D-8EBF-412E-951A-B3D05111E76E', 6, 2),
(1043, 'LORIOT', 'Albert', 'M.', '32 Rue du Lieutenant Colonel', 'Maury', NULL, '75008', 'PARIS', '02-78-09-02-01', '02-54-21-18-84', '1951-05-28 00:00:00.000', 0.349174, 20500, '46EA3579-974A-4738-89EE-65AC52E28C48', 6, 2),
(1044, 'LAPORTE', 'Bernard', 'M.', '55 Alle de la Bergerie', NULL, NULL, '21000', 'DIJON', '02-02-02-96-62', '02-90-32-21-60', '1950-02-05 00:00:00.000', 0.29004, 7700, '84BA0E30-9490-48E4-A3D8-0E8A7B07F648', 6, 2),
(1045, 'LALYS', 'Francis', 'M.', 'Rsidence La Matte', 'Avenue de Balcre', NULL, '91430', 'IGNY', '00-90-33-88-87', '00-16-73-29-72', '1938-08-30 00:00:00.000', 0.608239, NULL, 'E9C7B28F-6D5E-4EDD-952B-2D8587A6FB65', 6, 2),
(1046, 'BAROUSSE', 'Franois', 'M.', '20 Rue Royale', NULL, NULL, '56100', 'LORIENT', '01-35-30-33-66', '01-46-39-58-94', '1944-03-01 00:00:00.000', 0.875752, 15700, '4FEF7D2D-6781-4431-ABE7-66D7A4C99693', 6, 2),
(1047, 'DODISCO', 'Michel', 'M.', '5 Rue Franois Jouffroy', NULL, NULL, '66000', 'PERPIGNAN', '03-41-13-68-82', '03-76-89-14-45', '1935-07-09 00:00:00.000', 0.948966, 12900, '783A7C22-464D-49DB-920C-4AA412F65F67', 6, 2),
(1048, 'JUVENEL', 'Claude', 'M.', '20 Place de Stalingrad', NULL, NULL, '13006', 'MARSEILLE', '02-93-29-99-64', '02-58-12-18-34', '1965-03-17 00:00:00.000', 0.458995, 19600, 'B3BF429C-A51E-4707-A240-FD9F6ECA810D', 5, 2),
(1049, 'SOBRA', 'Thibault', 'M.', '5 rue Gambetta', NULL, NULL, '31190', 'AUTERIVE', '04-20-70-31-25', '04-27-81-86-98', '1957-04-06 00:00:00.000', 0.250617, 13500, 'D22C2103-C80D-4040-BB91-1F6DE42C0F8F', 6, 2),
(1050, 'BONNEAU', 'Thrse', 'Mme.', '17 Avenue du Gnral De Gaulle', NULL, NULL, '75008', 'PARIS', '03-77-34-79-70', '03-59-28-93-26', '1947-03-29 00:00:00.000', 0.602607, 8500, 'E517E661-1479-4942-98FA-C83F6B6CEC10', 6, 1),
(1051, 'GEHAN', 'Thierry', 'M.', '200 Rue de Breteuil', NULL, NULL, '75004', 'PARIS', '00-01-22-67-40', '00-59-77-97-21', '1955-05-13 00:00:00.000', 0.746219, 19800, '2A0E0F1B-F0D6-4AEB-A63C-F1718B5081B4', 6, 2),
(1052, 'LEVY', 'Jean', 'M.', '2 Rue Jules Vals', NULL, NULL, '27300', 'BERNAY', '02-63-84-19-61', '02-16-78-81-47', '1941-09-22 00:00:00.000', 0.261881, 24100, '39D602EF-34AC-488D-8C34-07EFDDDF98D1', 6, 2),
(1053, 'EL NASHASHIBI', 'Albert', 'M.', '16 Rue de Marignan', NULL, NULL, '75002', 'PARIS', '01-57-28-06-03', '01-90-65-16-70', '1953-09-03 00:00:00.000', 0.588528, 8700, '044F8551-7B0D-4B1F-81C5-D49DB6F4846A', 6, 2),
(1054, 'CARLE', 'Mark', 'M.', '13 Rue de Turenne', NULL, NULL, '06230', 'VILLEFRANCHE SUR MER', '00-43-39-11-19', NULL, '1946-07-05 00:00:00.000', 0.256249, 1400, 'BF9B1565-647F-4726-BCE0-BAF994AF0EAB', 6, 2),
(1055, 'CAPELLA', 'Olivier', 'M.', '7 Rue de l''Abbatiale', NULL, NULL, '83400', 'HYERES', '04-43-27-01-89', '04-04-01-87-66', '1963-03-23 00:00:00.000', 0.135164, 21600, '5D2893A3-E2CA-418D-B3B1-4CAD0A3360BA', 2, 2),
(1056, 'CORBET', 'Grard', 'M.', '24 Rue du 4 Septembre', NULL, NULL, '34000', 'MONTPELLIER', '05-29-89-96-73', '05-48-23-93-49', '1946-11-23 00:00:00.000', 0.394229, 20200, '72DFD091-D92C-4DBC-9AA3-7F1FB20274E1', 6, 2),
(1057, 'FAGUER', 'Gilles', 'M.', '5 Avenue Albert 1 er', NULL, NULL, '01210', 'FERNEY VOLTAIRE', '00-29-88-40-72', '00-33-47-92-15', NULL, 0.903911, 15100, '898206AF-C5BE-4FF5-A8EC-3A8B31281812', 6, 2),
(1058, 'HERRRO', 'Arlette', 'Mme.', 'Le Lamartine 1 A', '6 Avenue Jean-Jacques Perron', NULL, '92100', 'BOULOGNE', '05-10-56-97-96', '05-85-55-69-68', '1940-02-16 00:00:00.000', 0.864488, 18100, 'B922EA12-A995-4AE1-B5B7-358C9036060F', 6, 1),
(1059, 'LESUEUR', 'Grard', 'M.', '3 Place Jean Jaurs', NULL, NULL, '34000', 'MONTPELLIER', '03-19-70-38-46', '03-78-50-62-23', '1946-12-19 00:00:00.000', 0.861672, 9700, '6D502552-5BB0-409E-B0B8-1C0E74C5E21D', 6, 2),
(1060, 'FAI', 'Jean-Luc', 'M.', '45 Rue de Genve', NULL, NULL, '75008', 'PARIS', '02-12-54-69-32', '02-46-21-40-42', '1956-03-15 00:00:00.000', 0.858856, 7200, '49843CA9-4521-477D-91D7-5D937FD855EE', 6, 2),
(1061, 'GARNEAU', 'Antonio', 'M.', '10 Rue Mollien', NULL, NULL, '75004', 'PARIS', '01-69-83-31-87', '01-69-71-94-75', '1948-01-04 00:00:00.000', 0.971493, 12000, '5519422B-6526-4B9E-8C7A-02A142A9F3BC', 6, 2),
(1062, 'ROLLAND', 'Franois-Xavier', 'M.', '59 Avenue de Toulouse Porte B', NULL, NULL, '75015', 'PARIS', '00-55-96-99-74', '00-42-00-77-35', '1956-12-07 00:00:00.000', 0.0788458, 8500, '75620AA9-9736-48DF-A119-E90279FFBD86', 1, 2),
(1063, 'IOUALALEN', 'Alain', 'M.', '38 Rue de Berri', NULL, NULL, '30600', 'VAUVERT', '00-75-58-23-29', '00-46-50-16-05', '1949-03-11 00:00:00.000', 0.836329, 16200, '9A7550B0-9B7A-4F8B-A70A-9BAA8D7668AC', 6, 2),
(1064, 'COTTE', 'Olivier', 'M.', '19 Rue Saint Antoine', NULL, NULL, '92100', 'BOULOGNE', '05-92-64-62-92', '05-79-62-72-76', '1970-10-09 00:00:00.000', 0.126716, 23200, '8227076A-1EF5-44AC-A0DA-47A070261713', 6, 2),
(1065, 'PESSIN', 'Michle', 'Mme.', '45 Rue Falguire', NULL, NULL, '94800', 'VILLEJUIF', '03-56-37-98-78', '03-51-27-00-45', '1953-04-20 00:00:00.000', 0.123901, 8100, '04588882-5FF9-4C0A-9340-A71CB28F81F9', 6, 1),
(1066, 'JOUZEL', 'Suzana', 'Mme.', '8 Rue du Bosquet', NULL, NULL, '28270', 'BREZOLLES', '03-15-61-15-75', '03-06-55-81-85', '1952-12-05 00:00:00.000', 0.71806, 24300, '585EE4DD-DF54-4F85-AA18-A6838B688010', 6, 1),
(1067, 'FOULON', 'Nicole', 'Mme.', '10 Rue Georges Sorel', NULL, NULL, '78400', 'CHATOU', '05-62-38-10-18', '05-26-19-49-41', '1935-08-17 00:00:00.000', 0.27596, NULL, '33E80D04-CB7D-4908-B227-878526C1683A', 6, 1),
(1068, 'MUNOZ', 'Jean', 'M.', '39/41 Bd Maxime Gorki', NULL, NULL, '60180', 'NOGENT SUR OISE', '02-40-57-34-66', '02-74-30-94-03', '1949-01-15 00:00:00.000', 0, 5900, 'AD5EE0B8-64AA-42BA-92DC-7329C5FFFCB0', 6, 2),
(1069, 'HATTERER', 'Pascal', 'M.', '4 Bis Place de la Halle', NULL, NULL, '81100', 'CASTRES', '02-25-64-43-32', '02-34-15-76-00', '1965-12-01 00:00:00.000', 0.487155, 17500, 'C2B667E0-86CC-4A03-9ADE-35F0F2535AFC', 1, 2),
(1070, 'MOUSSET', 'Marie-Josphe', 'Mme.', '14 Avenue Gambetta', NULL, NULL, '67201', 'ECKBOLSHEIM', '02-88-04-79-97', '02-59-86-35-53', '1960-07-18 00:00:00.000', 0.225274, 1900, 'A520D96D-9E55-4DB2-B3AD-230B45FBC600', 6, 1),
(1071, 'LOBATO', 'Lucie', 'Mme.', '15 Rue du Pont Royal', NULL, NULL, '75013', 'PARIS', '01-41-84-65-44', '01-74-13-33-96', '1950-04-17 00:00:00.000', 0.239353, 16400, '569B27F9-54CC-47C0-AEE3-749FCF57774F', 6, 1),
(1072, 'ASTULFONI', 'Jorge', 'M.', '20 Place Soult', NULL, NULL, '95600', 'EAUBONNE', '05-32-47-33-47', '05-75-20-49-38', '1961-06-25 00:00:00.000', 0.185851, 16200, '09AA5AFE-35FD-48C1-8D88-837DDBDB481D', 6, 2),
(1073, 'DESMETTE', 'Paul', 'M.', '47 Rue d''Oberhausbergen', NULL, NULL, '69004', 'LYON', '00-44-69-95-62', '00-28-99-22-28', '1933-10-24 00:00:00.000', 0.650478, 12900, '8CBC4A29-EEC8-4E7F-8CF9-7D153A7C73BC', 6, 2),
(1074, 'SABLAIROLES', 'Huguette', 'Mme.', '9 Place d''Italie', NULL, NULL, '59211', 'SANTES', '04-37-90-18-52', '04-23-61-53-93', '1929-03-27 00:00:00.000', 0.371702, 15300, 'ACDC56E5-3316-4FFC-927D-9748B631A8A4', 6, 1),
(1075, 'EDERY', 'Christian', 'M.', '40 Avenue de Paris', NULL, NULL, '11430', 'GRUISSAN', '03-32-34-57-04', '03-23-03-77-71', '1941-11-07 00:00:00.000', 0.278776, 23100, '2BEBC87F-8850-4466-812A-23D0731E3BC9', 6, 2),
(1076, 'GAL', 'Jacques', 'M.', '14 Rue Roussy', NULL, NULL, '93190', 'LIVRY GARGAN', '05-72-35-68-39', '05-91-49-54-79', NULL, 0.104189, 9700, 'E8CE5446-A26A-46F2-BA78-FBA3D5A7AAED', 5, 2),
(1077, 'PETIT', 'Rgis', 'M.', '75 Rue Marx Dormoy', NULL, NULL, '06000', 'NICE', '04-56-86-28-49', '04-43-29-46-76', '1945-06-10 00:00:00.000', 0.30412, 7900, '0419F5CD-246D-4FB2-BDD1-04D440785436', 6, 2),
(1078, 'PRETESEILLE', 'Pascal', 'M.', 'Rsidence Les Marines', NULL, NULL, '30000', 'NIMES', '05-79-68-34-16', '05-83-23-25-24', '1958-01-23 00:00:00.000', 0.154876, 3200, '63BB48C5-2FE8-44F2-BDEA-F8B5D49930C7', 6, 2),
(1079, 'METZMEYER', 'Claude', 'Mme.', '20 Avenue de la Rpublique', NULL, NULL, '29000', 'QUIMPER', '00-85-85-79-86', '00-73-30-58-92', '1957-06-07 00:00:00.000', 0.0309751, 11700, '0DCF3CBF-DB70-46BA-9311-C6BE02109DF3', 6, 1),
(1080, 'MEIGNAN', 'Jean-Louis', 'M.', 'Le Grand Palais', 'Entre n9', '2 Bd de Cimiez', '67200', 'STRASBOURG', '04-72-17-28-44', '04-44-37-11-03', '1955-01-24 00:00:00.000', 0.0929254, 8800, '7A9F3F9E-DD88-40A6-B10C-953816EFBD31', 6, 2),
(1081, 'ABELLO', 'Philippe', 'M.', '3 Bd Amiral Courbet', NULL, NULL, '06700', 'SAINT LAURENT DU VAR', '02-87-80-63-37', '02-02-40-89-12', '1953-08-03 00:00:00.000', 0.211194, NULL, '5429A15F-91EC-414F-98B2-560AD6194B3D', 6, 2),
(1082, 'BOG', 'Grard', 'M.', '16 Alle Docteur Pilven', NULL, NULL, '06550', 'LA ROQUETTE SUR SIAGNE', '03-91-91-89-28', '03-63-69-27-14', '1948-07-24 00:00:00.000', 0.50405, 20600, '1D6DDC33-5C15-4C68-AD8E-37B41C1450B2', 6, 2),
(1083, 'CLARIOND', 'Guy', 'M.', '11 Rue des Comtes', NULL, NULL, '10300', 'SAINTE SAVINE', '05-02-04-69-16', '05-81-92-47-03', '1939-09-25 00:00:00.000', 0.399861, 4200, '4640E561-1173-45D9-B321-A4390FD2F46B', 2, 2),
(1084, 'GUNTHER', 'Christian', 'M.', '650 R.N. 98', NULL, NULL, '05000', 'GAP', '05-33-23-34-51', '05-00-18-68-10', '1951-07-24 00:00:00.000', 0.225274, 13400, 'C4CC3F4E-E0C8-4FF9-9ECA-28B007953DD4', 6, 2),
(1085, 'GOSSELIN', 'Michelle', 'Mme.', '195 Bd de la Rpublique', NULL, NULL, '67160', 'WISSEMBOURG', '00-20-76-30-86', '00-95-50-85-95', '1945-09-27 00:00:00.000', 0.974309, 10400, 'DB58AF80-5AA2-4513-A506-D270FF526BF6', 6, 1),
(1086, 'MARMONIER', 'Jean-Franois', 'M.', '120 Bis Avenue Gallini', NULL, NULL, '62800', 'LIEVIN', '05-86-58-60-82', '05-72-96-20-99', '1953-04-30 00:00:00.000', 0.895463, 4200, 'BA4FFA52-EFDB-4FB4-9CBA-D2D712D6D5CF', 6, 2),
(1087, 'RUDY', 'Louis', 'M.', '6 Rue de l''Odon', NULL, NULL, '75011', 'PARIS', '03-37-92-37-66', '03-75-91-08-75', '1931-01-02 00:00:00.000', 0.0985573, 11700, '0F43A405-0817-4572-8034-F14B81E78168', 6, 2),
(1088, 'GOFFAUX', 'Jean', 'M.', '18 Rue de la Rpublique', NULL, NULL, '77440', 'LIZY SUR OURCQ', '02-81-53-52-95', '02-96-59-37-31', '1966-08-24 00:00:00.000', 0.174587, NULL, 'E27740F5-E3CA-4DC0-9080-FF7CF29DA9B2', 6, 2),
(1089, 'VENARD', 'Paul', 'M.', '20 Rue Jean Jaurs', NULL, NULL, '78000', 'VERSAILLES', '05-90-86-09-33', '05-93-72-50-15', '1933-01-18 00:00:00.000', 0.698349, 8800, '13F00765-8E7C-485B-9C0A-23152DC7E2C0', 6, 2),
(1090, 'HUART', 'Jean', 'M.', '33 Avenue Philippe Auguste', NULL, NULL, '22680', 'ETABLES SUR MER', '04-08-26-78-08', '04-17-56-04-21', '1934-05-17 00:00:00.000', 0.861672, 19700, '5F52BAAA-463D-4203-9450-A17B7C8B79F3', 3, 2),
(1091, 'THOMAS', 'Jacky', 'M.', '46 Rue Jean Jaurs', NULL, NULL, '66700', 'ARGELES SUR MER', '00-48-23-21-95', '00-67-93-21-66', '1946-07-11 00:00:00.000', 0.625135, 23500, '0E96BAEE-782E-47CC-86B6-D9ACB225B463', 6, 2),
(1092, 'CROGIEZ', 'Raphal', 'M.', '19 Rue de l''Orangerie', NULL, NULL, '78250', 'MEULAN', '03-52-83-85-85', '03-31-78-83-50', '1949-02-02 00:00:00.000', 0.8842, 4300, '23FFC94E-0C41-4295-B2D8-75F9BF84E6CB', 6, 2),
(1093, 'CONNUEL', 'Serge', 'M.', '" La Garonnire "', 'Chemin de Gacon', NULL, '74270', 'FRANGY', '02-17-61-56-82', '02-77-57-73-64', '1946-07-02 00:00:00.000', 0.391413, 18700, '604D3B27-7CD9-46BC-82EC-A4E3CAB5B345', 6, 2),
(1094, 'MONIER', 'Roger', 'M.', '7 Route Nationale', NULL, NULL, '75007', 'PARIS', '02-89-24-09-12', '02-29-76-66-89', '1944-05-30 00:00:00.000', 0.591344, 6200, '4F65E183-32EB-4774-BC07-5DAD69726233', 6, 2),
(1095, 'LE BESCHU DE CHAMPSAVIN', 'Ren', 'M.', '3 Rue Albert Jozon', NULL, NULL, '06600', 'ANTIBES', '01-03-04-50-79', '01-21-50-01-91', '1948-02-19 00:00:00.000', 0.520946, 20400, '2BFB0406-3595-4C46-94BA-87EACD7C9094', 6, 2),
(1096, 'EHRHARDT', 'Patrick', 'M.', 'Rue du Grand Pont', NULL, NULL, '44000', 'NANTES', '00-72-59-28-83', NULL, '1933-12-09 00:00:00.000', 0.357622, 8700, '391756DE-DFBC-4361-ADC1-26621A4F0C18', 6, 2),
(1097, 'ROUVIERE', 'Paul', 'M.', '16 Avenue Bosquet', NULL, NULL, '74400', 'CHAMONIX MONT BLANC', '04-16-61-65-82', '04-86-40-76-78', '1935-09-07 00:00:00.000', 0.188667, 2200, '00EAE933-DB23-4DA2-99A7-C83EB6ED6203', 7, 2),
(1098, 'JACQUEL', 'Jacques', 'M.', '21 Bis Bd Chancel', NULL, NULL, '75008', 'PARIS', '00-56-85-73-39', '00-96-65-59-60', '1947-06-10 00:00:00.000', 0.540657, 18500, '16107DD7-E951-4218-A64B-7310B1B57C12', 6, 2),
(1099, 'MONDOR', 'Peggy', 'Mme.', '42 Rue du Marchal Joffre', NULL, NULL, '76600', 'LE HAVRE', '03-54-88-71-69', '03-44-92-28-75', '1971-11-18 00:00:00.000', 0.917991, 3000, '8AFED68C-FF80-49E4-8CAB-0A8F5D499E98', 6, 1),
(1100, 'CHARVIN', 'Stphane', 'M.', '31 Rue du Lyret', NULL, NULL, '75020', 'PARIS', '02-99-75-34-34', '02-99-17-95-41', '1959-12-28 00:00:00.000', 0.326647, 4000, '902D1204-15B4-47DB-91B5-27506453D2A7', 6, 2),
(1101, 'MOUSSET', 'Christian-Jacques', 'M.', '49 Rue de Lisbonne', NULL, NULL, '69002', 'LYON', '02-12-15-96-35', '02-70-75-11-51', '1951-03-21 00:00:00.000', 0.0535025, 9800, '7FFE2733-CD62-483D-A924-739CF97E9A27', 6, 2),
(1102, 'TABET', 'Lucie', 'Mme.', '174 Rue Victor Hugo', NULL, NULL, '75012', 'PARIS', '05-84-54-58-61', '05-81-32-81-18', '1950-04-17 00:00:00.000', 0.478707, 14200, 'CD0FDFD2-915E-4B63-B837-90863516DD2C', 6, 1),
(1103, 'BRECHENMACHER', 'David', 'M.', '63 Rue des Pyrnes', NULL, NULL, '75116', 'PARIS', '03-99-25-71-55', '03-83-27-12-58', '1952-01-15 00:00:00.000', 0.0591344, 9600, 'CA468852-C6EA-4EEE-A56D-634B4B968CF6', 6, 2),
(1104, 'TALBOT', 'Patrick', 'M.', '16 Rue des Archers', NULL, NULL, '67300', 'SCHILTIGHEIM', '04-52-90-51-82', '04-48-97-81-21', '1955-03-06 00:00:00.000', 0.292856, 24300, '3D6BBCEE-D7DA-4EA9-9020-80B123BDBEDF', 4, 2),
(1105, 'MOREAU', 'Danielle', 'Mme.', '86 Bd Soult', NULL, NULL, '78320', 'LE MESNIL SAINT DENIS', '01-86-45-18-26', '01-73-49-41-55', '1950-09-07 00:00:00.000', 0.0225274, 23900, '3D4D3ABB-BEA4-4728-9496-CB5201EA8BE5', 6, 1),
(1106, 'THIRIOT', 'Guy', 'M.', '37 Avenue Paul Doumer', NULL, NULL, '78470', 'MILLON LA CHAPELLE', '02-23-79-69-06', '02-86-99-46-90', '1946-01-29 00:00:00.000', 0.673005, 21200, '93FAB594-4F2F-43E8-8ADD-79B30E083874', 6, 2),
(1107, 'CHUCHANA', 'Claude', 'M.', '40 Rue Principale', NULL, NULL, '81000', 'ALBI', '03-08-85-93-31', '03-23-22-43-62', '1935-08-03 00:00:00.000', 0.27596, NULL, 'C5BB796A-84EE-4CB7-BE85-DBFD4AB43B00', 6, 2),
(1108, 'PRVOST', 'Ren', 'M.', '6 Rue Raymond Berrurier', NULL, NULL, '06150', 'CANNES', '00-53-45-30-47', '00-11-58-92-10', '1945-10-19 00:00:00.000', 0.273144, 10200, 'ECB824BA-9BB7-4B37-B830-F7D3EC60C5CD', 6, 2),
(1109, 'LAURENT', 'Jacques', 'M.', '17 Route du Buisson', NULL, NULL, '11500', 'QUILLAN', '01-16-61-34-43', '01-08-93-03-47', '1944-09-14 00:00:00.000', 0.743403, 16200, '07CD107E-DDAE-49F4-8427-B0DBA1447BDF', 6, 2),
(1110, 'CHANEL', 'Hlne', 'Mme.', '33 Lices Georges Pompidou', NULL, NULL, '93340', 'LE RAINCY', '01-47-70-60-29', '01-25-80-50-02', '1947-05-15 00:00:00.000', 0.0197115, 6400, '1DAC3238-C087-4392-9F66-4C94C9272F09', 6, 1),
(1111, 'VERGELY', 'Roger', 'M.', 'Les Pleades', '23 Bd Leader', NULL, '63000', 'CLERMONT FERRAND', '04-72-76-02-14', '04-08-06-98-31', '1942-06-21 00:00:00.000', 0.920807, 25000, '57B1A579-D02F-4DAA-B1CD-F8E9B2BE744D', 7, 2),
(1112, 'RAMAUG', 'Marc', 'M.', '7 Bis Rue Voltaire', NULL, NULL, '82300', 'CAUSSADE', '03-51-46-02-02', '03-69-08-83-03', '1962-01-09 00:00:00.000', 0.540657, 12600, '867242EA-9A18-46B4-BB55-429A286D515B', 6, 2),
(1113, 'PLAGNARD', 'Christophe', 'M.', '5 Rond Point de Montfermeil', NULL, NULL, '41700', 'CONTRES', '05-47-57-63-08', '05-35-69-34-95', '1963-10-14 00:00:00.000', 0.413941, 20300, 'AA7A1374-4B02-48BC-BF95-42E3C30373DE', 6, 2),
(1114, 'ANDRIEUX', 'Pierre-Sylvain', 'M.', '9 Place de Jaude', NULL, NULL, '97300', 'CAYENNE', '01-28-48-18-54', '01-44-69-48-90', '1940-04-29 00:00:00.000', 0.253433, 13800, '8D5DC573-45EB-439E-8011-C3BB877F11CF', 6, 2),
(1115, 'RACAUT', 'Annick', 'Mme.', '21 Bd Didier Rey', NULL, NULL, '17390', 'LA TREMBLADE', '04-49-24-67-20', '04-96-27-55-20', '1951-04-19 00:00:00.000', 0.425204, 1500, '9BA22F1E-DA1F-4A1F-AD27-6E72CEBF72DF', 6, 1),
(1116, 'MIGNOT', 'Anny', 'Mme.', '5 Rue Henri-Pierre Mauger', NULL, NULL, '78640', 'SAINT GERMAIN DE LA GRANGE', '04-60-71-96-08', '04-58-91-49-77', '1937-03-31 00:00:00.000', 0.977125, 17400, 'F415CBC0-34DD-4A9E-9FD1-6AE58E971C73', 6, 1),
(1117, 'NUGUES', 'Ren', 'M.', '" Les Jardins de la Madeleine "', 'Immeuble Europa', NULL, '54130', 'SAINT MAX', '02-63-52-60-79', '02-36-66-19-97', '1932-01-25 00:00:00.000', 0.121085, 24000, '66653633-9224-4933-A926-2D84FB80E223', 6, 2),
(1118, 'RAFFIT', 'Jean-Pierre', 'M.', '11 Bis Rue du Gnral Leclerc', NULL, NULL, '58140', 'LORMES', '02-49-96-62-56', '02-89-98-96-61', '1943-06-11 00:00:00.000', 0.501234, 2500, '2C891825-8FFB-4D0E-A1CF-F1285AB92A2C', 4, 2),
(1119, 'PALAND', 'Olivier', 'M.', '4 Rue Pasteur', NULL, NULL, '75017', 'PARIS', '00-65-59-11-59', '00-98-37-61-91', '1950-02-19 00:00:00.000', 0.00563184, 22300, '4291BABE-7838-4E5B-A08E-C7AF9D75ADF7', 6, 2),
(1120, 'KERVOELEN', 'Christine', 'Mme.', '23 Rue Louis Barthou', NULL, NULL, '44000', 'NANTES', '02-85-03-48-82', '02-84-75-29-71', '1953-08-23 00:00:00.000', 0.639214, NULL, 'CC0F69CC-E442-4E86-A1A5-54843786BB18', 6, 1),
(1121, 'MESSELOT', 'Tristan', 'M.', 'Grande Rue', NULL, NULL, '75009', 'PARIS', '04-40-38-46-13', '04-33-11-81-38', '1953-11-06 00:00:00.000', 0.703981, 10900, '4B0758CB-87D4-443E-BCDA-5ADE631AA711', 6, 2),
(1122, 'PLANCHAIS', 'Liliane', 'Mme.', '14 Rue de Prony', NULL, NULL, '25000', 'BESANCON', '05-99-80-58-08', '05-39-26-27-99', '1954-03-05 00:00:00.000', 0.991205, 18600, '962FEDC6-4489-4F90-9CCC-00FB2B98E050', 6, 1),
(1123, 'HUSTIN', 'Michel', 'M.', '2 Rue Scribe', NULL, NULL, '53000', 'LAVAL', '03-69-15-24-27', '03-08-04-17-02', '1949-07-16 00:00:00.000', 0.411125, 8000, '04766C00-179F-45D9-82A1-8F2097D1F7D5', 6, 2),
(1124, 'BONDI', 'Michel', 'M.', '40 Rue Rochechouart', NULL, NULL, '33200', 'BORDEAUX CAUDERAN', '04-83-07-10-57', '04-62-52-66-20', '1939-08-16 00:00:00.000', 0.104189, NULL, '7BBC0FB7-8286-43C1-894B-CC241096F98C', 6, 2),
(1125, 'OQUET', 'Jean-Claude', 'M.', '58 Rue Bersot', NULL, NULL, '75007', 'PARIS', '01-05-73-90-67', '01-50-20-37-19', '1941-07-20 00:00:00.000', 0.760299, 23600, 'CE4B2C64-F2EF-425C-BD62-C7F14FF92A12', 1, 2),
(1126, 'SAENZ DE PIPAON Y MENGS', 'Philippe', 'M.', '32 Rue Bernard Le Pecq', NULL, NULL, '75003', 'PARIS', '04-29-33-53-78', '04-37-91-40-34', '1950-02-01 00:00:00.000', 0.247801, 23500, '5A4139BA-18AB-4AA1-8F7E-EA8E93EE387A', 6, 2),
(1127, 'MOREAUX', 'Jos', 'M.', '39 Rue des Bleuets', NULL, NULL, '64700', 'HENDAYE', '02-95-42-91-87', '02-17-50-33-24', '1945-11-18 00:00:00.000', 0.180219, 14500, 'E09F384A-D24B-4C6B-A96B-C7AD16AE64AC', 6, 2),
(1128, 'VICENS', 'Jol', 'M.', '25 Rue Vaneau', NULL, NULL, '76170', 'LILLEBONNE', '03-44-93-58-78', '03-71-31-91-31', '1944-04-05 00:00:00.000', 0.673005, 24000, '75960A21-2F50-4631-9C9F-4F4E04963C65', 6, 2),
(1129, 'BOURREE', 'Marc', 'M.', '48 Rue Volta', NULL, NULL, '34500', 'BZIERS', '01-48-89-31-16', '01-14-36-72-52', '1960-04-14 00:00:00.000', 0.999652, 14400, 'BC1C73B9-9419-4567-AF61-7AB95DE08B84', 6, 2),
(1130, 'GAUTHIER', 'Patrick', 'M.', 'Les Rsidences Sokoburu - A', '115 Bd de la Mer', NULL, '30240', 'LE GRAU DU ROI', '02-73-34-53-39', '02-43-73-45-12', '1957-07-25 00:00:00.000', 0.0168955, 14500, '2BA049AF-CCFF-4FC6-A0FA-36E170D0C8C1', 6, 2),
(1131, 'COYNEL', 'Francis', 'M.', '5 Rue Pasteur', NULL, NULL, '75001', 'PARIS', '04-34-11-82-33', '04-56-26-96-47', '1940-11-25 00:00:00.000', 0.0253433, 20700, '0672AA0A-8172-4BC9-8DFE-4D6696B6D0D7', 6, 2),
(1132, 'PELORGEAS', 'Nolle', 'Mme.', '22 Bd de Strasbourg', NULL, NULL, '38520', 'BOURG D''OISANS', '02-80-83-71-86', '02-85-68-00-52', '1955-03-07 00:00:00.000', 0.157692, 20400, '9C650658-0AAF-48CB-B785-6D111A57B092', 1, 1),
(1133, 'TISSOT', 'Cyril', 'M.', 'Centre Commercial " La Curieuse"', 'PORT CAMARGUE', NULL, '30100', 'ALES', '04-84-64-85-55', '04-55-55-10-54', '1966-09-08 00:00:00.000', 0.520946, 13300, 'A9C14758-2E45-40E9-AB7C-C4CF3B2F3E9C', 6, 2),
(1134, 'FROMENTY', 'Victor', 'M.', '13 Rue Montmartre', NULL, NULL, '74700', 'SALLANCHES', '03-87-15-63-06', '03-24-24-13-02', '1926-01-09 00:00:00.000', 0.0535025, 20700, '8F1591A5-39DA-4BB0-8DEC-9E50DC40C833', 6, 2),
(1135, 'OUAZANA', 'Jean-Louis', 'M.', '20 La Condamine', NULL, NULL, '75007', 'PARIS', '03-27-99-61-49', '03-61-28-07-57', '1947-01-29 00:00:00.000', 0.104189, 21300, 'D60128F6-5504-445C-9580-060A496CF867', 6, 2),
(1136, 'PENCHARD', 'Lon', 'M.', '6 Bis Rue d''Avjan', NULL, NULL, '92400', 'COURBEVOIE', '04-63-18-47-31', '04-01-56-98-40', '1956-03-13 00:00:00.000', 0.591344, 900, 'FEBEEA6C-5681-4367-AD6F-7C2ACEB9D9F3', 6, 2),
(1137, 'BEGHIN', 'Tania', 'Mme.', '22 Avenue de la Gare', NULL, NULL, '97100', 'BASSE TERRE', '02-98-94-19-26', '02-35-27-10-83', '1959-11-25 00:00:00.000', 0.673005, 12300, '8D6F1925-7169-4FD3-88F1-890A96DC6425', 6, 1),
(1138, 'SAVY', 'Alain', 'M.', '41 Avenue Rapp', NULL, NULL, '75020', 'PARIS', '03-17-12-58-69', NULL, '1952-05-07 00:00:00.000', 0.430836, 20500, '95D3303B-9190-4A62-90F9-BF1707D3B807', 6, 2),
(1139, 'HALTER', 'Marie-Christine', 'Mme.', '8 Rue de Colombes', NULL, NULL, '75016', 'PARIS', '03-62-27-56-64', '03-25-97-91-29', '1958-08-12 00:00:00.000', 0.847593, NULL, '00420C5C-A791-4D4F-8866-D3BCC8D8D6CF', 5, 1),
(1140, 'COURTADE', 'Yves', 'M.', '1 Bis Rue de la Rpublique', NULL, NULL, '68000', 'COLMAR', '05-95-39-85-79', '05-83-93-74-21', '1943-09-20 00:00:00.000', 0.284408, 20900, '82DA91CD-1DF1-48AB-A375-9A95F6D49E1B', 6, 2),
(1141, 'SABOURAUD', 'Claude', 'M.', '8 Rue du Docteur Paquelin', NULL, NULL, '31000', 'TOULOUSE', '05-78-38-53-33', '05-50-22-39-52', '1937-09-28 00:00:00.000', 0.585712, 19800, 'BAB76255-71FC-4F76-9862-8D994ABB0123', 6, 2),
(1142, 'BOULET', 'Patrick', 'M.', '17 Avenue Thophile Gautier', NULL, NULL, '95160', 'MONTMORENCY', '03-25-66-86-16', NULL, '1954-05-06 00:00:00.000', 0.22809, 24300, '8DFF4543-3815-4C7D-BE3B-F98765C8FCC9', 6, 2),
(1143, 'BITON', 'Philippe', 'M.', 'Rsidence Le Patio', '48 Rue du Nord', NULL, '60600', 'BREUIL LE SEC', '03-54-95-38-66', '03-66-38-78-90', '1956-04-09 00:00:00.000', 0.273144, 20500, '2990B278-B196-45D9-949A-7191DFE6A6B9', 6, 2),
(1144, 'FESSLER', 'Lionel', 'M.', '11 Rue Paul Vidal', NULL, NULL, '92100', 'BOULOGNE', '04-13-18-90-84', '04-55-68-35-24', '1954-06-16 00:00:00.000', 0.687085, 19600, 'B8CE6955-CB02-4EFA-89EF-28442EA807F8', 6, 2),
(1145, 'RIBAK', 'Gabriel', 'M.', '25 Avenue Emile', NULL, NULL, '67000', 'STRASBOURG', '04-47-22-52-09', '04-56-34-82-93', '1941-03-08 00:00:00.000', 0.985573, 17200, 'A0A9A5F3-7647-4524-83B6-33E60CD45DBB', 6, 2),
(1146, 'MOREL', 'Charles', 'M.', '1081 Route de Nointel', NULL, NULL, '75010', 'PARIS', '03-30-31-74-64', '03-23-41-69-50', '1949-05-10 00:00:00.000', 0.408309, 4300, 'D10E4139-5085-408B-8DD0-AB2A222B4496', 2, 2),
(1147, 'BENYOUNES', 'Jean-Pierre', 'M.', '112 Rue de Paris', NULL, NULL, '75016', 'PARIS', '01-15-68-28-92', '01-91-18-88-94', '1955-12-13 00:00:00.000', 0.957414, 9100, 'DC8D9F65-3D10-490A-A4FF-8F86BBF3D696', 6, 2),
(1148, 'DOILLON-DREYFUS', 'Herv', 'M.', '6 Rue des Francs Bourgeois', NULL, NULL, '75011', 'PARIS', '01-58-47-79-28', '01-03-90-59-55', '1960-07-20 00:00:00.000', 0.965861, 600, '4D4DA893-4E22-4017-AB51-15A1E25CC4C1', 6, 2),
(1149, 'WALTZER', 'Delphine', 'Mme.', '45 Bd Magenta', NULL, NULL, '03200', 'VICHY', '02-53-50-47-40', '02-06-90-52-71', '1969-02-03 00:00:00.000', 0.985573, 11200, 'C89FA28A-D68D-4E74-BBC7-5A2C2A9709C0', 6, 1),
(1150, 'REVERBEL', 'Chantal', 'Mme.', '81 Bd Suchet', NULL, NULL, '67000', 'STRASBOURG', '05-50-19-86-53', '05-95-23-98-39', '1955-02-09 00:00:00.000', 0.0985573, 1700, 'B192A964-9904-4CE4-8F0A-1D59ADDC5B50', 6, 1),
(1151, 'HABERT', 'Albert', 'M.', '52 Avenue de la Rpublique', NULL, NULL, '34000', 'MONTPELLIER', '02-00-50-40-65', '02-22-59-55-79', '1924-11-30 00:00:00.000', 0.616687, 9000, '15347613-5C94-4A58-885D-A69E9FA72DFE', 6, 2),
(1152, 'LADEGAILLERIE', 'Michel', 'M.', '86 Rue de Paris', NULL, NULL, '75001', 'PARIS', '01-69-99-68-81', '01-57-79-22-64', '1926-02-11 00:00:00.000', 0.695533, 11300, '8873AD42-D2B4-41D3-9513-DE9540D79B0C', 6, 2),
(1153, 'DELOBRE', 'Marie-Louise', 'Mme.', '80 Alle de la Robertsau', NULL, NULL, '91330', 'YERRES', '03-27-71-36-29', '03-81-64-20-07', '1953-01-22 00:00:00.000', 0.073214, 18900, '32E6DD03-904A-4716-89D0-E8D523DD9AEA', 1, 1),
(1154, 'GALLIGO', 'Jean-Paul', 'M.', '5 Rue du Clos Ren', NULL, NULL, '71800', 'VARENNES SOUS DUN', '02-16-71-92-99', '02-78-71-31-89', '1949-03-28 00:00:00.000', 0.827881, 9100, '79A7E16C-55B7-4BF7-92BD-4600482B0AB7', 6, 2),
(1155, 'LECLERC-CHALVET', 'Henri', 'M.', '23 Rue Jean-Jacques Rousseau', NULL, NULL, '66000', 'PERPIGNAN', '02-46-63-50-28', '02-26-15-56-45', '1938-05-07 00:00:00.000', 0.985573, 6100, '254955C7-4A6D-41A3-9C9F-6DE6C68D5E14', 6, 2),
(1156, 'SAHUQUET', 'Dominique', 'M.', '42 Bis Avenue du Gnral Leclerc', NULL, NULL, '25000', 'BESANCON', '03-68-75-40-60', '03-29-88-24-77', '1934-01-31 00:00:00.000', 0.661742, 2200, 'F2161E9A-FA11-4A4C-B8AA-26FE66E68260', 6, 2),
(1157, 'BUDE', 'Daniel', 'M.', 'CROIX BOUTHIER', NULL, NULL, '30320', 'MARGUERITTES', '03-67-00-31-66', '03-15-25-00-39', '1955-07-05 00:00:00.000', 0.971493, 3200, 'DC1ED7A6-332B-4C61-89C3-8349D016767C', 6, 2),
(1158, 'CANIT', 'Thierry', 'M.', '10 Rue Rempart Villeneuve', NULL, NULL, '24750', 'TRELISSAC', '04-96-51-43-85', '04-44-58-76-11', '1957-08-14 00:00:00.000', 0.470259, NULL, '19C0BA46-304D-4783-9C06-813706047EB9', 6, 2),
(1159, 'RAYNAUD', 'Ghislaine', 'Mme.', '20 Rue des Villas', NULL, NULL, '75011', 'PARIS', '01-11-17-99-69', '01-05-27-08-77', '1961-05-20 00:00:00.000', 0.65611, 14400, '95757BEE-3CA4-4F7E-9670-732A68548E19', 6, 1),
(1160, 'ALLONGUE', 'Roger', 'M.', 'Centre Commercial Le Ventoux', NULL, NULL, '67000', 'STRASBOURG', '03-22-84-93-30', '03-15-24-00-83', '1951-05-05 00:00:00.000', 0.658926, 22400, '30F192CD-DEC9-4F49-8E49-D7D743C05122', 1, 2),
(1161, 'RIEUSSET', 'Colin', 'M.', '9 Rue des Dahlias', NULL, NULL, '75004', 'PARIS', '04-92-32-76-93', '04-95-13-09-95', '1967-09-03 00:00:00.000', 0.588528, 11400, 'E018D1FC-DEDC-449B-932F-B3DDEBB3FAEB', 6, 2),
(1162, 'ROUSSEILLE', 'Anne-Marie', 'Mme.', '262 Bd Voltaire', NULL, NULL, '34500', 'BZIERS', '04-22-36-24-81', '04-85-98-54-68', '1947-07-09 00:00:00.000', 0, 9800, '0DFC941C-BA1B-48A9-9564-3F9412E5D277', 6, 1),
(1163, 'COVILLE', 'Robert', 'M.', '24 Bd d''Anvers', NULL, NULL, '69003', 'LYON', NULL, '04-96-31-93-33', '1937-07-25 00:00:00.000', 0.118269, 11200, 'AAD97B75-BDB8-48EF-B1BB-938E580645AB', 6, 2),
(1164, 'BINDREIFF', 'Jean-Louis', 'M.', '5 Rue d''Ormesson', NULL, NULL, '92600', 'ASNIERES', '04-81-31-24-41', '04-79-22-88-24', '1957-05-07 00:00:00.000', 0.546289, 20100, 'D6B7F07E-F816-4D1C-A475-28C5B3097E62', 6, 2),
(1165, 'COMMUN', 'Emmanuel', 'M.', '31 Bis Bd d''Angleterre', NULL, NULL, '68100', 'MULHOUSE', '01-96-14-12-44', '01-32-89-79-12', '1958-08-02 00:00:00.000', 0.394229, NULL, '41092259-6A8B-42BF-8BE1-1AC030A4473B', 6, 2),
(1166, 'BARNY', 'Jean-Pierre', 'M.', '3 Cours du Docteur Long', NULL, NULL, '75116', 'PARIS', NULL, '03-56-92-12-84', '1937-10-24 00:00:00.000', 0.948966, 12400, '2BE8D944-EA4D-437D-A17E-ACB81333A02A', 6, 2),
(1167, 'FLATRES', 'Bernard', 'M.', '119 Bis Rue de Colombes', NULL, NULL, '31300', 'TOULOUSE', '04-57-93-93-55', NULL, '1949-07-24 00:00:00.000', 0.805354, 100, '4925639B-FB0A-4F8F-82FE-0FCF4BDE0B98', 5, 2),
(1168, 'HARANG', 'Philippe', 'M.', '115 Rue de Ble', NULL, NULL, '56100', 'LORIENT', '01-86-91-29-58', '01-11-89-97-96', '1955-08-11 00:00:00.000', 0.0816617, NULL, 'A4586B4A-CB4C-47F6-8BC5-20EC1DE5903B', 6, 2),
(1169, 'VIGNERON', 'Claude', 'M.', '31 Avenue Raymond Poincar', NULL, NULL, '75011', 'PARIS', '03-34-25-64-63', '03-69-82-01-05', '1944-05-08 00:00:00.000', 0.219642, 18400, 'E9838A82-C139-4F7D-945B-3B1F25B525C4', 6, 2),
(1170, 'AFONSO', 'Sylvie', 'Mme.', '139/141 Rue de Cugnaux', NULL, NULL, '67118', 'GEISPOLSHEIM', '02-21-29-01-09', '02-67-83-09-19', '1960-03-18 00:00:00.000', 0.185851, 24300, 'A3B2B2EB-5A68-423E-9EB7-973172B58444', 6, 1),
(1171, 'DURAND', 'Gabrielle', 'Mme.', '9 Bd du Gnral Leclerc', NULL, NULL, '66470', 'SAINTE MARIE LA MER', '02-09-05-68-47', '02-29-25-20-33', '1963-05-11 00:00:00.000', 0.93207, 23600, '7ED143D6-BC32-4499-A16F-176152AF8B16', 6, 1),
(1172, 'EILERTSEN', 'Yannick', 'M.', '10 Rue Roubo', NULL, NULL, '44000', 'NANTES', '02-55-37-66-36', NULL, '1956-11-01 00:00:00.000', 0.467443, 20300, '0C7CC4F6-530C-4465-AD8B-9DC52AB77882', 6, 2),
(1173, 'DUSSERRE', 'Eric', 'M.', '5 Rue Charles de Wendel', NULL, NULL, '75011', 'PARIS', '00-52-40-39-55', '00-01-29-27-38', '1958-03-05 00:00:00.000', 0.892647, 11400, '23A2DF0E-EDA6-48B0-9BD0-B80F8982AA23', 6, 2),
(1174, 'JEHL', 'Fabien', 'M.', 'Avenue des Marendes', NULL, NULL, '78310', 'MAUREPAS', '02-56-69-91-74', '02-09-15-56-93', '1966-04-28 00:00:00.000', 0.681453, 3000, '5C51E9EF-7EB0-483B-A1B2-3E35954C9908', 2, 2),
(1175, 'DELAGNEAU', 'Marc', 'M.', '24 Rue du Calvaire', NULL, NULL, '28410', 'ABONDANT', '05-83-71-16-92', '05-30-53-33-46', '1948-02-13 00:00:00.000', 0.625135, 21000, '7EB77EAC-CE40-4EB9-AF83-579043A6DDFD', 6, 2),
(1176, 'DE BEVILACQUA', 'Jacques', 'M.', '4 Avenue Parmentier', NULL, NULL, '94550', 'CHEVILLY LARUE', '00-72-44-18-28', '00-78-47-94-98', '1932-11-30 00:00:00.000', 0.115453, 3700, '876C6927-5F18-4469-B896-9AD3C07DC2EE', 6, 2),
(1177, 'BELLOTTO', 'Doris', 'Mme.', '5 Alle du Bourbonnais', NULL, NULL, '75017', 'PARIS', '01-75-53-30-42', '01-34-34-58-44', '1941-08-15 00:00:00.000', 0.782826, NULL, '1DC965AE-33F3-4AF4-A1A1-08B38D6D7A16', 6, 1),
(1178, 'DELAHAYE', 'Alain', 'M.', '2 Rue des Glands', NULL, NULL, '75009', 'PARIS', '03-04-81-48-61', '03-48-84-56-57', '1952-01-04 00:00:00.000', 0.292856, 1300, '85EE2405-80C3-466B-99E2-6501256EBB7D', 6, 2),
(1179, 'LOUIS', 'Yvon', 'M.', '20 Alle d''Alsace', NULL, NULL, '92370', 'CHAVILLE', '03-08-16-98-23', '03-75-38-37-67', '1938-08-01 00:00:00.000', 0.596975, NULL, '628FF13C-9FA9-42EE-956C-55C2D2152B13', 6, 2),
(1180, 'TCHACAROFF', 'Pascal', 'M.', '17 Rue des Acacias', NULL, NULL, '27940', 'LA CROIX SAINT LEUFROY', '04-14-28-97-22', '04-38-24-83-14', '1963-01-03 00:00:00.000', 0.836329, 18100, 'FB532BAD-65D9-47AB-AB3F-08F42ECEBADA', 6, 2),
(1181, 'KOSKAS', 'Michel', 'M.', '56 Rue de Maubeuge', NULL, NULL, '24100', 'BERGERAC', '02-79-75-69-95', '02-96-46-66-16', '1946-11-19 00:00:00.000', 0.712428, 11900, '87628F66-2052-4F0A-934B-93BCD990C211', 3, 2),
(1182, 'AMMENDOLA', 'Guy', 'M.', '3 Rue des Blanchisseurs', NULL, NULL, '75016', 'PARIS', '04-36-84-08-51', '04-28-91-01-56', '1958-10-21 00:00:00.000', 0.323831, 1800, '602257FD-3971-4B3E-B16E-2A4B7AFC386A', 6, 2),
(1183, 'BARTHELMAY', 'Danielle', 'Mme.', '28 Rue de Louviers', NULL, NULL, '75010', 'PARIS', '03-87-20-83-18', '03-47-01-14-42', '1936-09-11 00:00:00.000', 0.0760299, 5100, 'F314EEFE-A72B-4D64-9A3C-C15167AC6319', 6, 1),
(1184, 'AZOULAY', 'Alain', 'M.', '6 Rue des Carmes', NULL, NULL, '77500', 'CHELLES', '00-61-69-96-21', '00-29-82-05-47', '1944-07-31 00:00:00.000', 0.284408, 17500, '5F528096-CA6C-47B1-8023-DF9EFD27F3A2', 6, 2),
(1185, 'BONNET', 'Alain', 'M.', '61 Bis Avenue Mozart', NULL, NULL, '75011', 'PARIS', '03-81-60-57-88', '03-23-86-52-22', '1962-12-15 00:00:00.000', 0.613871, 1800, '3C7C15BD-1B57-470D-9032-B92CFFF074C2', 6, 2),
(1186, 'THVENON', 'Laurent', 'M.', '26 Rue de Saint Quentin', NULL, NULL, '85100', 'LES SABLES D''OLONNE', '05-74-32-69-16', '05-23-66-90-02', '1965-07-17 00:00:00.000', 0.0337911, 23500, '4934C7C7-6368-4BF9-AD31-61C5D16BE28F', 6, 2),
(1187, 'AMANS', 'Andr', 'M.', '2 Avenue des Abbesses', NULL, NULL, '42100', 'SAINT TIENNE', '01-15-48-87-61', '01-03-91-33-70', '1951-01-21 00:00:00.000', 0.999652, 5400, '17E2EFD3-5C81-4C00-9112-9D820569F5E9', 6, 2),
(1188, 'HUMBERTJEAN', 'Georges', 'M.', '193 Bd Voltaire', NULL, NULL, '34000', 'MONTPELLIER', '05-18-60-08-16', '05-78-75-42-39', '1945-05-16 00:00:00.000', 0.529393, 8900, '2662E7D3-0D8D-4299-BB02-28E5943B71BE', 7, 2),
(1189, 'PINOT', 'Gabriel', 'M.', '3 Bis Cours Carnot', NULL, NULL, '25000', 'BESANCON', '03-87-43-82-37', '03-80-33-12-77', '1944-02-28 00:00:00.000', 0.816617, 21200, 'C5EC339D-49D8-42A1-B445-6EA212592DA6', 6, 2),
(1190, 'RANSBOTYN', 'Franoise', 'Mme.', '36 Cours Fauriel', NULL, NULL, '58000', 'NEVERS', '03-15-60-24-26', '03-83-05-88-30', '1937-02-16 00:00:00.000', 0.687085, 4400, '4A300E20-5F81-421E-94F3-D9807A194643', 6, 1),
(1191, 'SCHOLTES', 'Grard', 'M.', '18 Avenue Georges Clmenceau', NULL, NULL, '58000', 'NEVERS', '00-69-34-74-62', '00-18-93-39-67', '1949-11-02 00:00:00.000', 0.881384, 3300, 'DDB40AB1-BE26-401A-A15A-C4B107DB9177', 6, 2),
(1192, 'GASTEL', 'Edith', 'Mme.', '52 C Rue des Fltes Agasses', NULL, NULL, '06560', 'VALBONNE', '01-67-60-47-94', '01-47-36-00-62', '1947-04-24 00:00:00.000', 0.923622, 13200, '71655979-550F-4ED9-A9BD-2F8508947B91', 6, 1),
(1193, 'VERNEREY', 'Jean', 'M.', '21 Rue Gambetta', NULL, NULL, '21000', 'DIJON', '02-34-68-82-53', '02-44-51-37-48', '1946-05-26 00:00:00.000', 0.619503, 8000, 'F8370586-1540-4EE8-87FF-A1DFD79A4881', 6, 2),
(1194, 'LE GOFF', 'Olivier', 'M.', '21 Rue Gambetta', NULL, NULL, '92300', 'LEVALLOIS PERRET', '02-71-39-75-33', '02-34-45-14-12', '1950-07-07 00:00:00.000', 0.591344, 18100, '415E0AF0-7265-422C-9778-85EB574C3F01', 6, 2),
(1195, 'ESPITALLIER', 'Jean', 'M.', 'Villantipolis 11', 'Route des Dolines', NULL, '92120', 'MONTROUGE', '05-60-36-19-46', '05-18-31-14-15', '1944-02-22 00:00:00.000', 0.537841, 19300, '870E6239-804F-4E1C-A62F-DBAE91714ED9', 4, 2),
(1196, 'QUATREBOEUFS', 'Renaud', 'M.', '27 Rue de Jouvence', NULL, NULL, '06400', 'CANNES', NULL, '02-66-11-05-28', '1960-11-20 00:00:00.000', 0.892647, 16700, '95C3FD2F-6926-45F1-9AC6-1CB557299147', 6, 2),
(1197, 'FORCE-LAMBERT', 'Franois', 'M.', '40 Rue Edouard Vaillant', NULL, NULL, '75007', 'PARIS', '05-90-66-73-76', '05-96-58-17-51', '1935-06-22 00:00:00.000', 0.123901, 19800, '8059CFB9-D2D6-4637-940E-4D479AA7F6FF', 6, 2),
(1198, 'GUILLEMET', 'Vivette', 'Mme.', '3 Rue Charles Floquet', NULL, NULL, '75013', 'PARIS', '04-20-71-45-79', '04-65-47-78-36', '1939-11-13 00:00:00.000', 0.689901, 500, '3DF80905-94F5-4986-AEB2-249BEF1BA4D1', 6, 1),
(1199, 'ALLAN', 'Vincent', 'M.', '104 La Croisette', NULL, NULL, '75019', 'PARIS', '00-08-85-57-75', '00-63-58-39-38', '1965-06-20 00:00:00.000', 0.841961, 15400, '79B9FEFC-74B2-495A-AFCB-7E377F9D90FC', 6, 2),
(1200, 'VALENZA', 'Franois', 'M.', '18 Rue Valadon', NULL, NULL, '62140', 'HESDIN', '02-50-61-35-80', '02-48-55-81-64', '1963-03-14 00:00:00.000', 0.687085, 7000, 'EEF926BA-1DC6-43F8-8A65-31833DAF5385', 6, 2);
CHECKPOINT;

INSERT INTO T_EMPLOYEE_EMP (EMP_ID, EMP_NOM, EMP_PRENOM, EMP_TITRE, EMP_ADRESSE1, EMP_ADRESSE2, EMP_ADRESSE3, EMP_CP, EMP_VILLE, EMP_TEL, EMP_GSM, EMP_DATE_ENTREE, EMP_INDICE, EMP_SALAIRE, EMP_MATRICULE, SRV_ID, SEX_ID) VALUES
(1201, 'BILLARD', 'Jean-Claude', 'M.', '81 Rue Barrault', NULL, NULL, '13004', 'MARSEILLE', '01-43-50-21-22', '01-94-52-95-49', '1961-05-16 00:00:00.000', 0.577264, 3100, 'C3A55EDA-C9E4-4BDE-A64C-B27E12E0C0F3', 6, 2),
(1202, 'RAOUX', 'Jean-Philippe', 'M.', '60 Rue Petit', NULL, NULL, '11370', 'PORT LEUCATE', '01-96-31-35-71', '01-29-42-85-92', '1966-02-11 00:00:00.000', 0.596975, 13500, '413427F7-F14C-417A-8986-395D32C0E83F', 7, 2),
(1203, 'KARM', 'Jacques', 'M.', '46 Rue d''Arras', NULL, NULL, '13100', 'AIX EN PROVENCE', '05-02-07-05-20', '05-55-40-93-25', '1944-10-17 00:00:00.000', 0.154876, 1000, 'FA1EC553-96F4-46B7-B756-02E1D22CFB27', 6, 2),
(1204, 'FONTANEZ', 'Jean-Marie', 'M.', '127 Avenue de Montolivet', NULL, NULL, '34980', 'SAINT GELY DU FESC', '03-25-68-53-90', NULL, '1945-10-05 00:00:00.000', 0.788458, 14200, 'F7B14F75-0AE2-484B-BFBC-757E7C504940', 6, 2),
(1205, 'SITBON', 'Nicole', 'Mme.', '1 Centre Cial du Port', NULL, NULL, '91550', 'PARAY VIEILLE POSTE', '04-66-23-31-80', '04-38-87-99-22', '1937-04-18 00:00:00.000', 0.771563, 14100, '6E712235-14EE-49E2-A7ED-98C14C46E4CB', 6, 1),
(1206, 'BOUVERET', 'Guy', 'M.', '31 Rue Emeric David', NULL, NULL, '67000', 'STRASBOURG', '01-01-95-67-10', '01-78-25-80-72', '1937-12-26 00:00:00.000', 0.861672, 23500, 'BF638413-F85A-423E-A85B-3EEA7BD1CE35', 6, 2),
(1207, 'GARCIA', 'Andr', 'M.', 'Centre Commercial du Forum', NULL, NULL, '70000', 'VESOUL', '05-77-93-03-40', '05-37-26-30-58', '1951-11-12 00:00:00.000', 0.85604, 12000, '1C524E35-B933-4501-88A0-279C8CC13DBC', 6, 2),
(1208, 'SERVAN', 'Roberto', 'M.', '102 Rue de Verdun', NULL, NULL, '12000', 'RODEZ', '04-05-54-95-64', '04-11-33-81-71', '1956-08-02 00:00:00.000', 0.639214, NULL, '9A12EF8D-EB9E-47EE-AA85-8A9761222D0F', 6, 2),
(1209, 'BOURGIN', 'Patrick', 'M.', '4 Rue Charles Appel', NULL, NULL, '75008', 'PARIS', '05-57-17-86-07', '05-61-82-32-62', '1940-02-06 00:00:00.000', 0.126716, 4400, '5B68AE09-71D0-473E-8FE5-41165738433A', 4, 2),
(1210, 'MENGUY', 'Franois-Philippe', 'M.', '27  Bis Place Pierre Renet', NULL, NULL, '75013', 'PARIS', '04-30-54-61-25', '04-35-81-59-46', '1956-05-08 00:00:00.000', 0.923622, 11900, '9FC10A3E-FF37-47D1-8519-81B9A7FA0494', 6, 2),
(1211, 'RENARD', 'Olivier', 'M.', '6 Rue Victoire Massol', NULL, NULL, '75008', 'PARIS', '02-50-70-88-98', '02-29-17-68-34', '1957-06-22 00:00:00.000', 0.0788458, 6900, '868AE900-25D9-4282-9212-E67C4BD241C8', 6, 2),
(1212, 'ESTABLET', 'Marie-Hlne', 'Mme.', '6 Rue Arsne Houssaye', NULL, NULL, '75017', 'PARIS', '04-97-87-03-04', '04-08-45-02-39', '1949-10-27 00:00:00.000', 0.0197115, 5200, 'B272ABA2-90C4-41ED-912E-70C5BCAE3553', 6, 1),
(1213, 'GUY-MOYAT', 'Roger', 'M.', '103 Rue Bobillot', NULL, NULL, '66750', 'SAINT CYPRIEN PLAGE', '02-80-55-08-55', '02-02-76-13-29', '1940-02-08 00:00:00.000', 0.644846, 11300, 'F32CD13A-286E-4085-832A-83A8B4BC6E87', 6, 2),
(1214, 'LARRE', 'Claude', 'M.', '73 Bd Malesherbes', NULL, NULL, '34110', 'FRONTIGNAN', '04-53-76-78-98', NULL, '1946-12-04 00:00:00.000', 0.684269, 2700, '54F346F6-C902-4DB8-A3C4-281FAF2E6F02', 6, 2),
(1215, 'GRAILLE', 'Bernard', 'M.', '58 Avenue de Wagram', NULL, NULL, '31000', 'TOULOUSE', '05-56-51-88-69', '05-56-07-43-92', '1957-04-16 00:00:00.000', 0.760299, 20400, 'A0F6B0FD-2EFF-4886-AD79-73A17E847DCC', 6, 2),
(1216, 'CHAPEL', 'Yvette', 'Mme.', 'Rsidence Maillol', NULL, NULL, '06600', 'ANTIBES', '05-06-31-47-87', '05-62-68-62-33', '1947-01-11 00:00:00.000', 0.0140796, 15800, 'D74282CC-4D5A-4609-9444-3FE3A8847356', 1, 1),
(1217, 'D''ABADIE', 'Paul', 'M.', '8 Avenue Clestin Arnaud', 'LA PEYRADE', NULL, '56340', 'CARNAC', '05-56-96-66-54', '05-39-38-51-74', '1963-06-24 00:00:00.000', 0.346358, 2100, '3145A266-075C-4F14-A195-3B4CFC6CF897', 6, 2),
(1218, 'CHOPIER EPOUSE FERRANDIN', 'Caroline', 'Mme.', '1 Rue Bouquires', NULL, NULL, '36000', 'CHATEAUROUX', '01-80-16-52-08', '01-94-93-88-12', '1961-07-28 00:00:00.000', 0.560369, 200, '4AF4258B-CD58-4D27-BE0B-59D3ABDA2CF8', 6, 1),
(1219, 'TRONC', 'Ghislaine', 'Mme.', 'ANTIBES BUREAU SERVICES', '24 Avenue Gambetta', NULL, '27220', 'GROSSOEUVRE', '05-84-11-86-97', NULL, '1945-01-28 00:00:00.000', 0.129532, 21300, '00F69E58-8B48-4743-B315-F67D01FE3ECA', 6, 1),
(1220, 'LE PENNEC', 'Jean-Louis', 'M.', '32 Avenue des Druides', NULL, NULL, '95870', 'BEZONS', '03-92-13-47-09', '03-76-47-13-66', '1940-07-02 00:00:00.000', 0.853224, 15500, '067C8067-8013-4F72-8254-550237D890AA', 6, 2),
(1221, 'BLASQUEZ', 'Jean-Claude', 'M.', '2 Place Sainte Hlne', NULL, NULL, '06000', 'NICE', '03-06-83-25-57', '03-93-45-35-40', '1950-07-27 00:00:00.000', 0.647662, 20000, '2BFC456D-755E-40F7-B248-7061677BC98B', 6, 2),
(1222, 'MARCHAND', 'Pedro', 'M.', '68 Rue Saint Martin', 'CISSEY', NULL, '27400', 'LOUVIERS', '02-43-39-96-09', '02-64-12-28-67', '1945-12-05 00:00:00.000', 0.64203, 21300, '419F3B40-3B23-4F91-9F21-ABF1B399274C', 6, 2),
(1223, 'NOUE', 'Claude', 'M.', '134 Rue Edouard Vaillant', NULL, NULL, '80440', 'DOMMARTIN', '04-60-62-83-78', '04-74-37-37-62', '1942-04-12 00:00:00.000', 0.630767, 16600, 'E4634C6E-A31B-4C76-93D2-D2FB42D0A8EC', 1, 2),
(1224, 'BOJUC', 'Alain', 'M.', '40 Rue Pastorelli', NULL, NULL, '89000', 'AUXERRE', '02-15-00-64-56', '02-05-16-83-83', '1943-07-06 00:00:00.000', 0.326647, 20600, 'A6C6C9F6-94E0-46E7-BFF8-311D00639396', 6, 2),
(1225, 'CLAMARON', 'Maurice', 'M.', '7 Rue du March aux Oeufs', NULL, NULL, '69740', 'GENAS', '05-58-09-80-10', '05-63-59-41-54', '1940-03-05 00:00:00.000', 0.673005, 21600, '87D84BE6-6CE1-4AB2-836A-6ADFD8990EF8', 6, 2),
(1226, 'ROLLAIN', 'Gabriel', 'M.', '6 Rue Emile Bourgeois', NULL, NULL, '38200', 'VIENNE', NULL, '03-63-73-01-48', '1933-03-28 00:00:00.000', 0.374518, 9300, '68B0262C-A097-498B-91A0-EAB725096D53', 6, 2),
(1227, 'BUDNIOK', 'Grard', 'M.', '7 Place des Cordeliers', NULL, NULL, '75015', 'PARIS', '02-78-18-67-05', '02-69-53-08-17', '1940-02-20 00:00:00.000', 0.163323, 1100, 'C303F0EF-61E6-49D1-B08D-8E893BB40D04', 6, 2),
(1228, 'RUFFI', 'Denys', 'M.', '39 Rue de la Rpublique', NULL, NULL, '59163', 'CONDE SUR ESCAUT', '05-71-23-26-50', '05-17-52-68-49', '1965-07-22 00:00:00.000', 0.0140796, 16300, 'FB53A809-BFD4-452B-A2C3-DBBD57E907CB', 6, 2),
(1229, 'GASTALDY', 'Jean-Franois', 'M.', '52 Rue Victor Hugo', NULL, NULL, '94270', 'LE KREMLIN BICETRE', '04-99-90-50-27', '04-87-99-12-69', '1943-01-08 00:00:00.000', 0.78001, 5900, '7C425292-E263-498D-9EF5-7383CA1D775C', 6, 2),
(1230, 'BONI', 'Stphane', 'M.', '12 Rue Lacordaire', NULL, NULL, '06320', 'CAP D''AIL', '02-55-82-16-86', '02-75-26-22-88', '1966-06-06 00:00:00.000', 0.889831, 22800, '1C89AEFC-1302-4CE9-9516-7CB37D971068', 5, 2),
(1231, 'ROBELIN', 'Jean-Claude', 'M.', '5 Rue Jean Jaurs', NULL, NULL, '83000', 'TOULON', '01-96-43-10-62', '01-84-94-47-68', '1941-08-12 00:00:00.000', 0.371702, NULL, '369160E4-95A9-41C1-8629-CC1059BC8631', 6, 2),
(1232, 'BENICHOU', 'Michel', 'M.', '52 Rue du Gnral Leclerc', NULL, NULL, '86000', 'POITIERS', '02-95-43-53-57', '02-05-48-00-17', '1940-09-19 00:00:00.000', 0.566, 14900, '975BD18E-2049-486E-B758-8012C2CE62D4', 6, 2),
(1233, 'COURTINE', 'Marc', 'M.', '71 Avenue du 3 Septembre', NULL, NULL, '91120', 'PALAISEAU', '00-17-63-11-53', '00-34-65-79-45', '1959-01-24 00:00:00.000', 0.791274, 4700, '0AD30FC0-3578-42EF-A949-04241572DEF4', 6, 2),
(1234, 'CARRION', 'Jacques-Edm', 'M.', '3 Place Camille Ledeau', NULL, NULL, '75008', 'PARIS', '00-24-36-89-64', '00-03-51-91-95', '1941-07-14 00:00:00.000', 0.357622, 9600, '928F9F02-2511-4C60-A124-6230EB022D20', 6, 2),
(1235, 'ARNAUD', 'Olivier', 'M.', '18 Rue Carnot', NULL, NULL, '06000', 'NICE', '02-99-76-24-31', '02-50-75-49-51', '1956-06-06 00:00:00.000', 0.22809, 4300, '105ECA82-D843-4829-9665-32AA55B3CD00', 6, 2),
(1236, 'MEGLIO', 'Marie-Christine', 'Mme.', '11 Rue du Docteur Morre', NULL, NULL, '92300', 'LEVALLOIS PERRET', '04-79-95-69-59', '04-22-05-16-90', '1953-07-17 00:00:00.000', 0.588528, 4800, '7310B2EB-0321-48A7-A71C-4C9D5B878956', 6, 1),
(1237, 'DEVAUX', 'Alain', 'M.', '201 Rue du Faubourg Saint Honor', NULL, NULL, '75017', 'PARIS', '04-93-96-81-05', '04-95-95-01-80', '1947-07-11 00:00:00.000', 0.411125, 8400, 'D7CE04D9-220D-4E72-A0BE-15B2C1DEADB8', 2, 2),
(1238, 'SCHRANTZ', 'Jacques', 'M.', '12 Rue de Russie', NULL, NULL, '31170', 'TOURNEFEUILLE', '00-95-68-50-32', '00-46-80-37-52', '1950-06-20 00:00:00.000', 0.872936, 13800, '8E09F1B9-C527-49D1-BB71-08924A79DD7A', 6, 2),
(1239, 'AUGUY', 'Sophie', 'Mme.', '105 Rue Jules Guesde', NULL, NULL, '75015', 'PARIS', '01-63-74-69-09', '01-98-20-20-37', '1966-03-09 00:00:00.000', 0.543473, 24600, '67FB3B79-15BC-418A-BBFC-6C3856F41509', 6, 1),
(1240, 'TUBIANA', 'Daniel', 'M.', '46 Avenue des Ternes', NULL, NULL, '75009', 'PARIS', '03-71-95-00-25', '03-86-26-58-85', '1959-12-06 00:00:00.000', 0.168955, 600, 'C58F0313-3F78-4673-829F-172E96FBA728', 6, 2),
(1241, 'LEBEL', 'Hubert', 'M.', '12 Rue Clment Ader', NULL, NULL, '75017', 'PARIS', '04-04-82-07-95', '04-32-97-08-04', '1945-12-08 00:00:00.000', 0.0563184, 19000, '5F515950-A8E5-4F26-90BD-CCEE9E9E6C93', 6, 2),
(1242, 'CLAUDEL', 'Dominique', 'M.', '9 Rue Alasseur', NULL, NULL, '75017', 'PARIS', '05-51-28-75-27', '05-92-70-34-63', '1950-01-01 00:00:00.000', 0.380149, 1700, '4AB67DF3-7765-4C89-9551-E233081486CE', 6, 2),
(1243, 'JOLY', 'Jean', 'M.', '35 Rue Saint Georges', NULL, NULL, '66740', 'SAINT GENIS DES FONTAINES', '03-01-95-48-74', '03-15-78-05-63', '1963-10-07 00:00:00.000', 0.408309, 18000, 'C3A1585D-7744-4AEA-98C0-921A4D1533CF', 6, 2),
(1244, 'LOPEZ', 'Alain', 'M.', '4 Rue du Gnral Lanrezac', NULL, NULL, '06000', 'NICE', '03-86-91-73-35', '03-12-38-12-68', '1949-06-14 00:00:00.000', 0.146428, 11200, '9137BBA1-DC1C-4E10-BDFA-DAC0B53A7AD5', 1, 2),
(1245, 'DAGON', 'Gilbert', 'M.', '251 Bd Pereire', NULL, NULL, '92600', 'ASNIERES', '04-54-52-07-49', '04-65-67-10-02', '1954-07-28 00:00:00.000', 0.0168955, 2400, '74B715C7-9FE6-49D7-9273-0C4CBC7AF016', 6, 2),
(1246, 'LIGER', 'Gilbert', 'M.', '1 Rue Georges Clmenceau', NULL, NULL, '68100', 'MULHOUSE', '05-04-76-95-05', '05-70-53-28-46', '1934-12-09 00:00:00.000', 0.267513, 21200, '2909D572-52A5-48AC-AE32-7A4201C8352B', 6, 2),
(1247, 'OHANA', 'Claude', 'M.', '32 Rue Gounod', NULL, NULL, '60160', 'MONTATAIRE', '01-63-55-33-56', '01-54-10-50-48', '1945-01-01 00:00:00.000', 0.253433, 13100, '16942BFE-EDB2-4FE7-B1C3-F102820A0597', 6, 2),
(1248, 'MERGUI', 'Mose', 'M.', '31 Rue d''Anjou', NULL, NULL, '78760', 'PONTCHARTRAIN', '00-33-35-65-50', '00-30-98-80-51', '1951-02-13 00:00:00.000', 0.0816617, 15800, '285C3155-6D92-449B-B94D-98166C6667C1', 6, 2),
(1249, 'CASTAN', 'Maurice', 'M.', '29 Rue de la Wanne', NULL, NULL, '92220', 'BAGNEUX', '01-45-91-51-32', '01-73-16-74-60', '1927-01-22 00:00:00.000', 0.0197115, 17900, '9090CC53-AA5D-491D-8618-D95E6BBBC589', 6, 2),
(1250, 'FRANCOIS', 'Jean-Louis', 'M.', '10 Place Auguste Gnie', NULL, NULL, '75015', 'PARIS', '02-29-93-77-80', '02-43-92-38-83', '1946-02-21 00:00:00.000', 0.194299, 17900, '875C7D66-2EF6-410A-89C2-5B4064D20A7D', 6, 2),
(1251, 'LE BAIL', 'Christiane', 'Mme.', '47 Route de Paris', NULL, NULL, '01750', 'SAINT LAURENT SUR SAONE', '05-15-67-64-86', '05-20-87-65-88', '1944-12-29 00:00:00.000', 0.0929254, 23300, '96025DA3-66CF-4FC5-8971-9E2A0DE433EF', 1, 1),
(1252, 'PALACIO', 'Maurice', 'M.', '78 Avenue Aristide Briand', NULL, NULL, '95520', 'OSNY', '02-90-94-09-15', '02-26-93-42-37', '1942-09-17 00:00:00.000', 0.988389, 15400, '0607BC51-9C90-4871-9F58-009B73954927', 6, 2),
(1253, 'FRENEHARD', 'Philippe', 'M.', '30 Rue de Lourmel', NULL, NULL, '83400', 'HYERES', '05-25-41-24-07', '05-67-79-28-66', '1962-01-24 00:00:00.000', 0.115453, 5600, '5FFF0033-F06D-4BAB-825B-FDF62AF0ABAE', 6, 2),
(1254, 'GAILLARD', 'Jacques', 'M.', '73 Rue de la Leve', NULL, NULL, '75014', 'PARIS', '01-28-74-33-21', '01-55-68-20-86', '1937-07-23 00:00:00.000', 0.00563184, 24600, '1D2AEA84-0ECC-4749-89CD-1BB8D7682BC6', 6, 2),
(1255, 'RIBES', 'Jean-Paul', 'M.', '1 Rue du Muguet', NULL, NULL, '75011', 'PARIS', '03-47-58-09-45', '03-39-76-83-10', '1954-03-20 00:00:00.000', 0.788458, 18800, '57F52838-D6C0-4AB8-A79C-D575458BAE57', 6, 2),
(1256, 'BENSADOUN', 'Yan', 'M.', '135 Chemin de la Tarente', NULL, NULL, '75116', 'PARIS', '00-67-25-38-79', '00-62-23-18-77', '1957-05-25 00:00:00.000', 0.422388, 9400, '46E68717-9ADC-4D80-898E-A03BA6548A2D', 6, 2),
(1257, 'PINET', 'Pascal', 'M.', '22 Rue de la Gait', NULL, NULL, '92150', 'SURESNES', '00-13-33-74-82', '00-19-92-53-19', '1960-09-26 00:00:00.000', 0.844777, 3900, '45DEFEB6-2C45-4292-8C26-75613F400C12', 6, 2),
(1258, 'CADIC', 'Jean-Marc', 'M.', '18 Rue Saint Ambroise', NULL, NULL, '51100', 'REIMS', '01-39-53-21-66', '01-39-98-44-55', '1951-06-27 00:00:00.000', 0.85604, 24800, 'CAEB97FD-DED8-4943-83BC-D09A92184BD1', 5, 2),
(1259, 'LE TALLEC', 'Jean-Franois', 'M.', '69 Rue Nicolo', NULL, NULL, '49100', 'ANGERS', '00-12-24-83-71', '00-59-97-85-03', '1943-07-10 00:00:00.000', 0.394229, 13900, '00472D1D-423E-447C-9B3E-88A4D5518AAE', 6, 2),
(1260, 'SANANES', 'Dominique', 'Mme.', '30 Rue du Docteur Bombiger', NULL, NULL, '56100', 'LORIENT', '03-20-65-01-96', '03-48-71-68-89', '1953-10-15 00:00:00.000', 0.788458, 23000, '98B4A21A-58A9-4A05-AA34-FCE8ABD8EC62', 6, 1),
(1261, 'MEGLIO', 'Maurice', 'M.', '7 Rue Marie Stuart', NULL, NULL, '95320', 'SAINT LEU LA FORET', '00-77-76-62-47', '00-91-27-80-74', '1946-10-29 00:00:00.000', 0.168955, 15700, 'F049B67A-9F4A-467C-B2C2-0A74ADF59191', 6, 2),
(1262, 'KIRSTETTER', 'Gilbert', 'M.', '3 Bis Rue Saint Blaise', NULL, NULL, '75018', 'PARIS', '02-97-09-43-62', '02-80-82-70-57', '1955-11-29 00:00:00.000', 0.974309, 3800, 'A638E4CB-21AB-44CA-B336-E1EA569A83B9', 6, 2),
(1263, 'GRAIN', 'Raymond', 'M.', '29 Bis Rue de Lige', NULL, NULL, '68000', 'COLMAR', '03-20-30-70-84', '03-92-86-90-25', '1948-01-03 00:00:00.000', 0.194299, 21100, 'D59E099A-9FFA-461B-9083-7293D515CF0D', 6, 2),
(1264, 'COUILLARD', 'Bernard', 'M.', '17 Rue de Paris', NULL, NULL, '69002', 'LYON', '01-00-73-78-19', '01-00-78-14-43', NULL, 0.501234, 20700, 'FE52ACFB-7FE3-4AAD-8D20-2E839C4DCD56', 6, 2),
(1265, 'DE PIOGER', 'Annick', 'Mme.', '77 Rue Championnet', NULL, NULL, '06570', 'SAINT PAUL DE VENCE', '02-13-78-82-27', '02-57-93-76-65', '1943-08-15 00:00:00.000', 0.58008, NULL, '6DD217A1-78B9-4CBE-A0C2-FE56D954D45F', 2, 1),
(1266, 'DEVAUX', 'Jean-Jacques', 'M.', '29 Rue de la Semm', NULL, NULL, '75006', 'PARIS', NULL, '00-55-99-77-16', '1946-02-19 00:00:00.000', 0.287224, 4700, '1137E4A6-D506-47A3-A0A1-B43299C8138F', 6, 2),
(1267, 'GRENON', 'Jocelyne', 'Mme.', '81 Rue de la Rpublique', NULL, NULL, '78330', 'FONTENAY LE FLEURI', '05-91-08-73-52', '05-44-16-88-02', '1953-02-22 00:00:00.000', 0.94615, 6300, '76DA2C71-4F80-459D-9458-0BDE44F54581', 6, 1),
(1268, 'FOURNIER', 'Loc', 'M.', '266 Chemin de Peyre-Long', 'Les Espinets', NULL, '85300', 'CHALLANS', '01-15-03-14-42', '01-63-15-98-57', '1947-08-27 00:00:00.000', 0.810986, NULL, '8AF1E2AD-2BD6-494C-914F-197875D3F2A9', 6, 2),
(1269, 'NGUYEN-XUAN', 'Nicole', 'Mme.', '13 Rue Vavin', NULL, NULL, '86100', 'CHATELLERAULT', '01-60-13-52-31', '01-18-53-59-93', '1939-05-17 00:00:00.000', 0.929254, 19200, 'B6DEC065-17A9-4077-9512-E2FE7B6C800C', 6, 1),
(1270, 'ANNET', 'Kim-Dominique', 'M.', '16 Avenue de la Rpublique', NULL, NULL, '92310', 'SEVRES', '02-23-70-24-32', '02-38-52-19-38', '1952-11-03 00:00:00.000', 0.492786, 1300, '360D9F04-7B58-41C0-AF9E-2C0F1D7745E9', 6, 2),
(1271, 'KOLLER', 'Serge', 'M.', '15 Rue de Nantes', NULL, NULL, '33290', 'BLANQUEFORT', '02-40-14-61-71', '02-52-16-70-18', '1937-11-26 00:00:00.000', 0.577264, 4800, 'A3175D25-4AA3-45AD-BD16-B1420159649F', 6, 2),
(1272, 'JEAN', 'Antoine', 'M.', '8 Bd Victor Hugo', NULL, NULL, '67210', 'OBERNAI', '04-41-60-18-56', '04-95-38-70-70', '1950-09-15 00:00:00.000', 0.532209, 13800, '6179EF5E-7233-486B-A9A4-761F3DE3C005', 3, 2),
(1273, 'CHAUCHEPRAT', 'Denis', 'M.', '158 Grande Rue', NULL, NULL, '75019', 'PARIS', '01-44-35-66-51', '01-83-46-77-16', '1954-10-25 00:00:00.000', 0.608239, 200, 'B65F7B61-FBFD-4F22-8B52-63435F381489', 6, 2),
(1274, 'DURAND', 'Jacques', 'M.', '2 Place de l''glise', NULL, NULL, '63000', 'CLERMONT FERRAND', '03-03-75-16-19', '03-45-24-10-85', '1939-09-11 00:00:00.000', 0.211194, 23400, 'D0190F8E-4EA0-4E35-A718-4D4F77294298', 6, 2),
(1275, 'RAT', 'Yannick', 'M.', '5 Rue Chanoine Gyss', NULL, NULL, '44000', 'NANTES', '02-71-52-60-91', '02-69-31-02-52', '1956-11-01 00:00:00.000', 0.0197115, 6800, '8C5786DB-310F-4510-8D17-2CD4937C80E0', 6, 2),
(1276, 'MERLI', 'Georges', 'M.', '81 Avenue Jean Jaurs', NULL, NULL, '73330', 'PONT DE BEAUVOISIN', '02-73-12-92-50', '02-07-26-24-03', '1944-10-07 00:00:00.000', 0.771563, 11300, 'B6992EF3-EE88-487D-9DBD-69401B21579E', 6, 2),
(1277, 'ROCOFFORT', 'Eric', 'M.', '4 Rue des Gras', NULL, NULL, '95600', 'EAUBONNE', '00-63-48-45-19', '00-52-69-67-78', NULL, 0.903911, 4800, '7BAB3F89-CE40-41E5-A0A2-3A46EF566712', 6, 2),
(1278, 'CONAN', 'Georges', 'M.', '24 Rue du Calvaire', NULL, NULL, '75007', 'PARIS', '00-29-08-53-99', '00-58-01-08-43', '1949-02-01 00:00:00.000', 0.385781, 3500, '204714BA-7BA9-4C85-BE95-5929D1693D7A', 6, 2),
(1279, 'CASSE', 'Batrice', 'Mme.', 'Place Carouge', NULL, NULL, '69160', 'TASSIN LA DEMI LUNE', '05-75-61-20-35', '05-78-71-72-34', '1948-03-04 00:00:00.000', 0.0675821, 20000, '49830436-6675-4746-9ADD-F57FFFB10E20', 7, 1),
(1280, 'RADIGOIS', 'Jean', 'M.', '26 avenue de Paris', NULL, NULL, '69008', 'LYON', '00-47-76-34-31', '00-53-95-56-77', '1940-07-27 00:00:00.000', 0.960229, 13200, 'C1A1912A-3247-4B05-A03F-46EE8E0F5A0B', 6, 2),
(1281, 'BLIDON', 'Jean-Philippe', 'M.', '17 Rue Duvivier', NULL, NULL, '06160', 'JUAN LES PINS', '02-19-06-62-96', '02-83-24-52-35', '1953-05-29 00:00:00.000', 0.0168955, 2900, '3B78CEAC-3C3C-47A6-9EED-C8B3FB194FF5', 6, 2),
(1282, 'GOURGUES', 'Grard', 'M.', '72 Avenue de la Rpublique', NULL, NULL, '78170', 'LA CELLE SAINT CLOUD', '02-24-46-42-47', '02-84-51-31-01', '1944-03-23 00:00:00.000', 0.0140796, 5300, 'DECB4BAC-0315-4F35-AC74-135EF7C901B4', 6, 2),
(1283, 'PINNERT', 'Eliane', 'Mme.', '10 Rue Antoine Lumire', NULL, NULL, '40100', 'DAX', '02-33-79-67-28', '02-97-82-47-43', '1947-04-30 00:00:00.000', 0.0281592, 19700, 'D495CB7C-116F-487A-9AE3-1DF680FCAB39', 6, 1),
(1284, 'CARLI', 'Daniel', 'M.', '113 Bd Wilson', NULL, NULL, '21000', 'DIJON', '01-27-51-07-83', '01-75-09-33-36', '1949-02-06 00:00:00.000', 0.751851, 23000, '18B1C93B-4845-4BED-A73C-985999A1E3F8', 6, 2),
(1285, 'COPIT', 'Norbert', 'M.', '8 Avenue Lyautey', NULL, NULL, '30000', 'NIMES', '03-45-00-82-27', '03-98-29-14-32', '1924-07-24 00:00:00.000', 0.523762, 9000, 'BC787041-1D1B-4808-9FC9-8A8A5993755E', 6, 2),
(1286, 'LECLERC', 'Andr', 'M.', '25 Rue Cazade', NULL, NULL, '85000', 'LA ROCHE SUR YON', '03-17-82-58-85', '03-54-03-58-59', '1946-08-07 00:00:00.000', 0.78001, NULL, '938EA90B-76EE-4AE7-85E7-0C34819FFADC', 4, 2),
(1287, 'BOUDET', 'Michel', 'M.', '9 Rue Jean Renaud', NULL, NULL, '69003', 'LYON', '05-31-46-92-97', '05-04-27-36-39', '1947-05-30 00:00:00.000', 0.712428, 13200, 'A3EE4A1F-AE8B-4E50-B92D-D91B84B02977', 6, 2),
(1288, 'BUZAGLO', 'Marie-Christine', 'Mme.', 'Les Jardins d''Aquitaine', '24 B Rue d''Aquitaine', NULL, '92150', 'SURESNES', '00-61-07-37-96', '00-42-58-89-63', '1951-05-17 00:00:00.000', 0.475891, 19600, 'C4A4A3DF-C7C2-4D5F-BCEC-C542AA91ACEC', 6, 1),
(1289, 'CLIMAQUE', 'Samy', 'M.', '84 Rue du Prsident De Gaulle', NULL, NULL, '75017', 'PARIS', '03-54-93-02-70', '03-60-00-89-04', '1951-08-16 00:00:00.000', 0.112637, NULL, 'F9CD6109-FDB5-490E-B1F6-48AD0C6A1D90', 6, 2),
(1290, 'DELBREIL', 'Ren', 'M.', '20 Rue de Bonnel', NULL, NULL, '16100', 'COGNAC', '03-18-62-09-01', '03-46-92-42-08', '1927-04-12 00:00:00.000', 0.65611, 3200, '7B2938D7-1377-4A76-AA74-1C0459D22001', 6, 2),
(1291, 'JOUBEAUX', 'Jean-Gabriel', 'M.', '24 Avenue Edouard Vaillant', NULL, NULL, '66750', 'SAINT CYPRIEN PLAGE', '04-32-26-05-52', '04-18-43-83-86', '1946-11-19 00:00:00.000', 0.841961, 9700, 'E1450A63-228D-46C1-B416-4C6BB6184931', 6, 2),
(1292, 'RUSPINI', 'Christophe', 'M.', '23 Rue Pierre Demours', NULL, NULL, '27200', 'VERNON', '03-99-97-28-38', '03-63-27-76-02', '1951-02-18 00:00:00.000', 0.858856, 17800, 'EFFDD751-3348-432A-98B5-57589098DF73', 6, 2),
(1293, 'BELZANE', 'Christophe', 'M.', '8 Rue du 14 Juillet', NULL, NULL, '78370', 'PLAISIR', '04-26-31-08-71', '04-67-46-10-32', '1962-06-07 00:00:00.000', 0.951782, 23600, 'D6BF34A5-1719-479A-BAE4-D28281B5D682', 7, 2),
(1294, 'MEDY', 'Grard', 'M.', 'Rsidence les Ondines', 'Place Maillol', NULL, '78400', 'CHATOU', '05-27-43-62-73', '05-77-02-28-12', '1952-03-01 00:00:00.000', 0.582896, 6900, 'A9CF2EB4-F150-468F-88B5-94CCB829BDED', 6, 2),
(1295, 'COTTE-BOUTEILLAT', 'Sylvie', 'Mme.', '91 Rue d''Albufra', NULL, NULL, '75013', 'PARIS', NULL, '05-45-56-79-26', '1955-03-23 00:00:00.000', 0.354806, 24800, '90E60138-78A5-48CC-880C-0C3EAE31F67A', 6, 1),
(1296, 'COLOMBARI', 'Nicolle', 'Mme.', '78 Rue du 19 Mars 1962', NULL, NULL, '38270', 'BEAUREPAIRE', '05-20-15-73-87', '05-03-98-27-06', '1997-10-23 00:00:00.000', 0.777195, 4800, 'CE243C08-FA46-46CC-9DB1-EA05FCCD4266', 6, 1),
(1297, 'NAKACHE', 'Charles', 'M.', '47 Avenue du Marchal Foch', NULL, NULL, '74000', 'ANNECY', '00-53-30-42-44', '00-76-22-36-78', '1947-02-02 00:00:00.000', 0.985573, 15800, '9E83D471-27C6-4020-B2C4-D7EBAAD15BED', 6, 2),
(1298, 'DAUPTAIN', 'Claude', 'M.', '68 Avenue des Gobelins', NULL, NULL, '83130', 'LA GARDE', '02-69-50-31-05', '02-52-55-30-10', '1962-06-09 00:00:00.000', 0.985573, 12600, '94D37BF0-7901-4927-8210-BDEC87313F48', 6, 2),
(1299, 'POTIER DE LA MORANDIERE', 'Annie', 'Mme.', '7 Place du Jeu de Paume', NULL, NULL, '78590', 'NOISY LE ROI', '00-27-05-44-88', '00-14-74-28-76', NULL, 0.329463, 19500, '5A8AAE0A-53F9-4EBF-9951-6D1D3CC6462E', 6, 1),
(1300, 'ORY', 'Hugues', 'M.', '8 Place aux Bois', NULL, NULL, '75007', 'PARIS', '01-28-14-93-60', '01-07-75-62-93', '1959-10-28 00:00:00.000', 0.135164, 8200, '9CB9E9BA-5587-495A-B314-FCB3585506A6', 4, 2),
(1301, 'ROUDAUT', 'Pascal', 'M.', 'Espace Mercure', '11 rue Marcel Daillant', NULL, '06700', 'SAINT LAURENT DU VAR', '02-75-00-73-66', NULL, '1963-01-08 00:00:00.000', 0.58008, 200, 'BF1045F5-879A-4744-AD0B-AF5D81EEB01F', 6, 2),
(1302, 'CARILLO', 'Joseph', 'M.', '9 Rue Lebourblanc', NULL, NULL, '92270', 'BOIS COLOMBES', '04-24-81-41-41', '04-12-87-20-79', '1936-04-06 00:00:00.000', 0.813801, 15000, 'B9633499-3215-4C53-847E-E75966C57FBC', 6, 2),
(1303, 'BRUDO', 'Christian', 'M.', '42 Rue Barbet de Jouy', NULL, NULL, '83600', 'FRJUS', '05-02-94-42-98', '05-95-38-90-79', '1957-09-12 00:00:00.000', 0.613871, 9100, 'F362F6A7-9B42-4399-BC97-061B5091163F', 6, 2),
(1304, 'FLEURY-MAHIEUX', 'Christine', 'Mme.', '104 Quai Nord', 'Port de Plaisance', NULL, '92200', 'NEUILLY', '03-19-17-40-34', '03-21-90-58-37', '1954-06-03 00:00:00.000', 0.625135, 6400, '02852FE9-C771-4940-8FFE-CB9F1E3818F8', 6, 1),
(1305, 'HUIGNARD', 'Olivier', 'M.', '2 Rue des Peupliers', NULL, NULL, '95100', 'ARGENTEUIL', '03-99-91-87-64', '03-07-89-85-65', '1959-10-17 00:00:00.000', 0.647662, 15900, '969E6002-8382-4334-B71A-DD7A8C20A5A9', 6, 2),
(1306, 'SAVEROT', 'Jean-Pierre', 'M.', 'Rsidence Le Nadir', 'Rue des Forces Libres', NULL, '75015', 'PARIS', '04-32-27-74-48', '04-47-02-62-77', '1952-05-01 00:00:00.000', 0.295672, 200, '9B94D0E2-7771-4494-8375-A4AC7FEFAA7F', 6, 2),
(1307, 'MADAR', 'Andr', 'M.', '14 Rue Charles Laffitte', NULL, NULL, '06000', 'NICE', '03-66-63-13-22', '03-41-85-46-84', '1941-10-05 00:00:00.000', 0.4421, 23900, '18E188E5-864B-4F42-ABF5-77613393DD13', 1, 2),
(1308, 'HUGON', 'Raoul', 'M.', '1 Bd Lon Feix', NULL, NULL, '75015', 'PARIS', '02-82-86-35-47', '02-76-39-40-15', '1925-01-30 00:00:00.000', 0.963045, 11300, '5ABF9A6A-A42C-4CD2-9DC6-346E5944FFBB', 6, 2),
(1309, 'MAURIER', 'Didier', 'M.', '44 Bd Pasteur', NULL, NULL, '30900', 'NIMES', '05-00-37-91-41', '05-74-62-96-86', '1954-06-02 00:00:00.000', 0.853224, 2400, 'D2F0E2C6-32CB-4874-914D-53BF70E4CFE8', 6, 2),
(1310, 'ROSSET', 'Michel', 'M.', '1 Rue du Docteur Barty', NULL, NULL, '60500', 'CHANTILLY', '03-68-08-77-39', '03-76-59-23-87', '1947-08-07 00:00:00.000', 0.602607, NULL, '852D7075-3C12-4507-A52A-3601D8370C8D', 6, 2),
(1311, 'DHAINE', 'Fabrice', 'M.', '51 Rue Dombasle', NULL, NULL, '75008', 'PARIS', '04-64-23-53-11', '04-16-21-53-86', '1965-03-30 00:00:00.000', 0.523762, 8100, 'D391E19F-B48E-45A5-87E7-6F6C0C7A7A46', 6, 2),
(1312, 'GIRARD', 'Frank-Andr', 'M.', '4 Quai de la Fontaine', NULL, NULL, '93700', 'DRANCY', '02-78-39-61-16', '02-98-65-51-76', '1960-07-24 00:00:00.000', 0.340727, 2800, 'A0D0E38D-0D15-47EF-8D14-9E14B2171853', 6, 2),
(1313, 'ALONZO', 'Ren', 'M.', '2 Place de la Gare', NULL, NULL, '93600', 'AULNAY SOUS BOIS', '05-54-40-93-45', '05-32-31-39-60', '1930-03-11 00:00:00.000', 0.168955, 22400, '88CB95D5-5CE9-4E9F-8B19-08AFA513C648', 6, 2),
(1314, 'RAT', 'Jean-Paul', 'M.', '87 Bd Haussmann', NULL, NULL, '75014', 'PARIS', '01-66-11-65-64', '01-53-16-61-96', '1948-01-08 00:00:00.000', 0.166139, 17600, '457535B4-E115-428C-87DF-60F779AA80DA', 1, 2),
(1315, 'DELAHAYE', 'Micheline', 'Mme.', '50 Avenue Henri Barbusse', NULL, NULL, '97434', 'SAINT GILLES LES BAINS', '00-05-60-52-87', '00-70-17-99-03', '1943-06-16 00:00:00.000', 0.771563, 12400, '340C3B04-EAA5-441F-9BBE-7B7A8A225E60', 6, 1),
(1316, 'GUILLOT', 'Frdric', 'M.', '15 Rue du 11 Novembre', NULL, NULL, '59800', 'LILLE', '00-93-02-05-74', '00-45-61-33-60', '1959-03-09 00:00:00.000', 0.36607, 1000, '2D3E040B-BA94-4C13-9431-8A3EDA77FEAF', 6, 2),
(1317, 'BRYJA', 'Marcel', 'M.', '3 Rue Roger', NULL, NULL, '74300', 'CLUSES', '05-20-17-08-60', '05-36-65-53-62', '1934-03-26 00:00:00.000', 0.259065, 15000, '3B2364E1-81AB-41D6-B22D-5CBD511D1151', 6, 2),
(1318, 'LEFORT', 'Zdzislaw', 'M.', '18 Rue du Gnral De Gaulle', NULL, NULL, '91240', 'SAINT MICHEL SUR ORGE', '04-12-03-02-37', '04-10-46-39-17', '1939-04-26 00:00:00.000', 0.994021, 23300, 'BBA8229F-C433-4176-BE70-F1AE8345B728', 6, 2),
(1319, 'FANET', 'Annie', 'Mme.', '77 Rue de la Barre', NULL, NULL, '78100', 'SAINT GERMAIN EN LAYE', '02-75-10-94-37', '02-02-96-44-77', '1946-08-18 00:00:00.000', 0.15206, NULL, '0FC05EC9-5EC3-475F-BF26-7C8641C2F9F0', 6, 1),
(1320, 'MJEAN', 'Anne', 'Mme.', '2 Rue Pierre Trappier', NULL, NULL, '75009', 'PARIS', '03-13-45-81-09', '03-29-59-57-92', '1961-05-17 00:00:00.000', 0.684269, 18000, 'BF74EC7D-94D2-4373-AD76-65854FF7CBF4', 6, 1),
(1321, 'VALENTIN', 'Manuel', 'M.', '2 Route Sainte Genevive', NULL, NULL, '75020', 'PARIS', '04-91-85-76-47', '04-94-63-79-01', '1963-09-04 00:00:00.000', 0.991205, 7700, '01FACDAB-F09B-4D40-85EA-16795E3D6BC7', 5, 2),
(1322, 'MANTERO', 'Jean-Marie', 'M.', '3 Rue Franois Bonvin', NULL, NULL, '08100', 'CHARLEVILLE MZIERES', '04-29-61-31-24', '04-52-21-69-03', '1928-06-16 00:00:00.000', 0.954598, 7500, 'AC1726A6-1528-4520-8570-EFC42AB43D6F', 6, 2),
(1323, 'LORENTZ', 'Jean-Pierre', 'M.', '17 Rue Henri Monnier', NULL, NULL, '66000', 'PERPIGNAN', '04-39-20-08-80', '04-62-47-50-99', '1936-06-03 00:00:00.000', 0.332279, 21100, '0A223B19-1B3B-46B9-858C-410FA60014D4', 6, 2),
(1324, 'LARZUL', 'Denis', 'M.', '61 Rue de la Chine', NULL, NULL, '57000', 'METZ', '03-35-12-12-72', '03-25-67-61-17', '1957-09-03 00:00:00.000', 0.951782, 24000, 'ACC96CDB-6B37-4A8C-B2A5-4597C8BEDD20', 6, 2),
(1325, 'LE MARREC', 'Vincent', 'M.', '11 Rue de l''Arquebuse', NULL, NULL, '18000', 'BOURGES', '00-46-66-74-28', '00-74-55-84-96', '1969-11-17 00:00:00.000', 0.208378, 6300, '1CBBCE40-5BCE-4354-8BA7-A5C56DC8D666', 6, 2),
(1326, 'BADIN', 'Edith', 'Mme.', '14 Bis Avenue du Gnral De', 'Gaulle', NULL, '78630', 'ORGEVAL', '00-86-84-14-13', '00-30-75-64-10', '1943-02-07 00:00:00.000', 0.157692, 14400, 'C53F19F1-3D66-4B78-B7BF-60F05A7137D0', 6, 1),
(1327, 'DEPAGNEUX', 'Rgis', 'M.', '11 Rue du Neufbourg', NULL, NULL, '69600', 'OULLINS', '03-61-06-52-59', '03-29-94-39-31', '1937-09-02 00:00:00.000', 0.698349, 16800, '492EFDA4-F698-40D3-AA54-64EB6E9C4E7B', 6, 2),
(1328, 'BOTELLA', 'Marc', 'M.', '8 Avenue Henri Laudier', NULL, NULL, '69220', 'BELLEVILLE SUR SAONE', '04-42-78-61-24', '04-24-49-51-16', '1948-12-15 00:00:00.000', 0.0703981, 3300, '5663C088-9468-4695-8D94-E9280A29632A', 2, 2),
(1329, 'GRAINVILLE', 'Gilbert', 'M.', '213 Avenue Pasteur', NULL, NULL, '30200', 'SAINT LAURENT DE CARNOLS', '02-01-20-22-11', '02-63-96-71-74', '1952-08-06 00:00:00.000', 0.726508, NULL, '64D6AF1E-F475-4A0E-ACC5-5F735EA7AF5C', 6, 2),
(1330, 'COG', 'Georges', 'M.', '84 Bd Emile Zola', NULL, NULL, '76600', 'LE HAVRE', '05-18-82-02-90', '05-44-31-23-95', '1932-03-08 00:00:00.000', 0.622319, 3000, '230FBEF5-2A8A-4794-B419-2FD241C06E6B', 6, 2),
(1331, 'MORELLE', 'Grard', 'M.', '22 Rue de la Poste', NULL, NULL, '92600', 'ASNIERES', '00-93-04-22-88', '00-09-25-33-81', '1941-08-10 00:00:00.000', 0.419572, NULL, '95FD8B57-8E27-4DAA-AFAA-0B1AABCE4AA7', 6, 2),
(1332, 'GIRARDOT', 'Jean-Paul', 'M.', '23 rue des champs', NULL, NULL, '57100', 'THIONVILLE', '04-61-55-64-62', '04-92-99-41-77', '1954-05-28 00:00:00.000', 0.630767, 9300, 'B02AFDAB-1478-4860-8523-772F2F48674A', 6, 2),
(1333, 'OLEYNIK', 'Didier', 'M.', '94 Rue Bernardin de Saint Pierre', NULL, NULL, '75008', 'PARIS', '03-24-52-69-08', '03-26-57-05-11', '1950-08-01 00:00:00.000', 0.825065, NULL, '409F3102-7672-4F2D-B116-AD3DFCF76CF9', 6, 2),
(1334, 'VIEIRA', 'Edmond', 'M.', '24 Rue des Bourguignons', NULL, NULL, '06140', 'TOURRETTES SUR LOUP', '03-04-58-14-80', '03-50-16-10-96', '1942-01-28 00:00:00.000', 0.892647, 1000, '65419510-32A0-47BF-8D6A-C31208ACCB4B', 6, 2),
(1335, 'PASCAUD', 'Ezequiel', 'M.', '52 Route d''Elange', NULL, NULL, '78100', 'SAINT GERMAIN EN LAYE', '00-96-48-35-70', '00-24-65-48-45', '1944-01-03 00:00:00.000', 0.853224, 10300, 'A8834A67-C2DC-440A-84D4-D258F91CCA48', 1, 2),
(1336, 'BARBERA', 'Joseph', 'M.', '18 Avenue des Champs lyses', NULL, NULL, '92150', 'SURESNES', '03-84-67-03-76', '03-12-53-81-00', '1947-03-22 00:00:00.000', 0.526577, 8300, '738C90B2-57D0-48CC-98C0-2A7DFD6EDB60', 6, 2),
(1337, 'BONDI', 'Orlando', 'M.', '146 Route des Cabanes', NULL, NULL, '78400', 'CHATOU', '05-49-94-94-31', '05-45-67-61-35', '1935-10-16 00:00:00.000', 0.737772, 5200, '0CDA256A-83C4-44A8-9FF6-3DC8F19CF21D', 6, 2),
(1338, 'RADFORD-WEISS', 'Jean-Claude', 'M.', '4 Rue Arthur Honegger', NULL, NULL, '75116', 'PARIS', '03-38-27-93-48', '03-93-16-13-20', '1941-07-20 00:00:00.000', 0.715244, 4100, '5CA38736-C7E0-48E5-80B3-6332E3C66A39', 6, 2),
(1339, 'RIBEYRE', 'Adrian', 'M.', '34 Avenue Jean Jaurs', NULL, NULL, '75008', 'PARIS', '00-26-41-12-45', '00-31-04-43-08', '1954-12-17 00:00:00.000', 0.94615, 23800, 'DB210D79-A0F8-476A-8D40-4AFDDEA614BB', 6, 2),
(1340, 'CASSART-RUHLMANN', 'Christine', 'Mme.', '3 Avenue d''Aligre', NULL, NULL, '59800', 'LILLE', '03-64-81-67-61', '03-87-95-20-99', '1966-11-21 00:00:00.000', 0.19993, 7400, '838A31FE-9CB8-46D8-B55B-195541A6F488', 6, 1),
(1341, 'MARQUIS', 'Yvette', 'Mme.', '64 Avenue Raymond Poincar', NULL, NULL, '92400', 'COURBEVOIE', '00-73-89-88-06', '00-58-15-55-44', '1937-07-03 00:00:00.000', 0.788458, 13700, '3BF2AE63-29F6-4DC5-9FF9-1C1E155A7FC7', 6, 1),
(1342, 'TREVES', 'Monique', 'Mme.', '64 Rue de Rome', NULL, NULL, '30490', 'MONTFRIN', '03-52-80-30-16', '03-01-33-20-54', '1949-10-26 00:00:00.000', 0.740588, 15200, '608F59CB-E958-4CA2-AA09-7F5B25B4ABCF', 1, 1),
(1343, 'VAUDE', 'Grard', 'M.', '34/36 Place du Gnral De Gaulle', NULL, NULL, '73190', 'CHALLES LES EAUX', '03-63-98-76-17', '03-88-68-25-61', '1942-06-04 00:00:00.000', 0.335095, 11200, '93A5B34B-0211-4321-85F2-10C1180F435B', 6, 2),
(1344, 'LECUYER', 'Jean-Pierre', 'M.', '1 Rue des Boudoux', NULL, NULL, '73000', 'BASSENS', '05-46-19-79-94', '05-48-94-43-15', '1950-04-07 00:00:00.000', 0.889831, 13300, '906363A0-313C-416E-A9CE-411619DE9053', 6, 2),
(1345, 'LEMARI', 'Pierre', 'M.', '6 Rue Pierre Brossolette', NULL, NULL, '60260', 'LAMORLAYE', '00-72-06-54-13', '00-60-77-47-84', '1945-02-01 00:00:00.000', 0.996836, 25000, 'F91764F8-97E0-41D1-9C72-B4573A9127CD', 6, 2),
(1346, 'NEVEU', 'Sylviane', 'Mme.', 'Maison Forte du Chaffard', '285 Rue Amlie Gex', NULL, '75006', 'PARIS', '00-62-15-26-48', '00-97-40-98-57', '1951-02-21 00:00:00.000', 0.512498, 13900, '06B871A5-56E4-4DBD-A915-5D2B0DE0544E', 6, 1),
(1347, 'JACQUES-SERMET', 'Pierre', 'M.', '8 Rue Centrale', NULL, NULL, '75007', 'PARIS', '01-47-37-31-97', '01-00-89-80-60', '1960-03-17 00:00:00.000', 0.498418, 8600, 'C60EA9A5-9B31-48D3-8F12-C65DBC72C67B', 6, 2),
(1348, 'LINTIGNAC', 'Louis', 'M.', '21 Avenue de la Libration', NULL, NULL, '06600', 'ANTIBES', '02-79-50-30-68', '02-77-85-54-34', '1922-12-21 00:00:00.000', 0.630767, 2400, '7CD9374A-CF21-4D6F-83FE-9F4E2DEB0015', 6, 2),
(1349, 'PONS', 'Jean-Yves', 'M.', '41 Rue Madame', NULL, NULL, '69009', 'LYON', '05-45-92-58-58', NULL, '1967-09-23 00:00:00.000', 0.861672, 19300, 'A800582A-E093-4FDA-97BF-A26BE609AEEC', 5, 2),
(1350, 'MEULEY', 'Didier', 'M.', '8 Rue Dupont des Loges', NULL, NULL, '34500', 'BZIERS', '03-51-10-16-95', '03-52-44-80-91', '1952-03-11 00:00:00.000', 0.236537, 22400, 'AC2BFC3F-EB3B-41AA-B66F-E10A41C5BCB3', 6, 2),
(1351, 'LAMOUREUX', 'Francis', 'M.', '27/29 Bd Albert 1 er', NULL, NULL, '66700', 'ARGELES SUR MER', '01-16-50-61-62', '01-31-84-78-41', '1954-10-15 00:00:00.000', 0.256249, 3000, '9E1BF265-F33E-4A3D-A119-F5E1246DEB4B', 6, 2),
(1352, 'OHNLEITER', 'Jean-Claude', 'M.', '21 Quai Pierre Scize', NULL, NULL, '34800', 'CLERMONT L''HRAULT', '01-56-48-23-40', '01-05-21-30-82', '1963-01-30 00:00:00.000', 0.994021, 6400, '6B335416-9486-43A2-B384-AABABFFA6982', 6, 2),
(1353, 'VERNEAU', 'Antoine', 'M.', '3 Avenue Georges Clmenceau', NULL, NULL, '49480', 'SAINT SYLVAIN D''ANJOU', '01-05-07-49-89', '01-94-29-36-36', '1955-10-26 00:00:00.000', 0.974309, 18100, '9E8C1834-850F-40D1-A5A9-93DA63F2F74B', 6, 2),
(1354, 'ARLA', 'Christian', 'M.', '52 Avenue Jean Moulin', NULL, NULL, '89220', 'BLNEAU', '01-19-76-96-25', '01-70-77-79-37', '1950-07-04 00:00:00.000', 0.630767, 11700, '7CD8253A-81A0-45FB-A16F-022F2D198521', 6, 2),
(1355, 'LORIOT', 'Dominique', 'M.', '55 Bd Gambetta', NULL, NULL, '06160', 'JUAN LES PINS', '04-54-29-73-58', '04-30-68-79-94', '1949-01-10 00:00:00.000', 0.616687, 1300, '67B1284D-E53D-401F-856B-02A30AF61438', 6, 2),
(1356, 'MARY', 'Jean', 'M.', 'Place de La Mairie', NULL, NULL, '83310', 'COGOLIN', '00-32-23-47-22', '00-00-62-03-67', '1942-07-25 00:00:00.000', 0.244985, 20000, '722CA2EA-ED42-46B1-8605-B7E68C8E8165', 2, 2),
(1357, 'EDEL', 'Michle', 'Mme.', '11 Rue du Chteau', NULL, NULL, '77280', 'OTHIS', '00-77-17-18-93', '00-35-43-76-55', '1947-10-29 00:00:00.000', 0.00563184, 24600, '31D26183-0077-4090-B65B-5460DFE61D02', 6, 1),
(1358, 'MAUBERT', 'Michel', 'M.', '113 Bd Wilson', NULL, NULL, '75016', 'PARIS', '05-60-87-64-16', '05-22-68-54-52', '1941-03-09 00:00:00.000', 0.197115, 800, '2FC98B7F-8463-438B-B54D-63DB37D7F67B', 6, 2),
(1359, 'CHAMBOLLE', 'Franoise', 'Mme.', 'La Galiote - C 44', 'Les Marines de Cogolin', NULL, '75016', 'PARIS', '01-87-93-90-13', '01-18-17-01-29', '1944-08-10 00:00:00.000', 0.850408, NULL, '27B1BFCA-A1C2-4950-B642-1DEA0168C0D4', 6, 1),
(1360, 'PEREZ', 'Danielle', 'Mme.', '19 Rue Grard de Nerval', NULL, NULL, '66420', 'LE BARCARES', '01-43-75-17-98', '01-33-54-40-30', '1947-01-21 00:00:00.000', 0.901095, 16600, '1B280688-62F7-472D-96B5-3F98251F0CD0', 6, 1),
(1361, 'POULINGUE', 'Sammy', 'M.', '35 Avenue Paul Doumer', NULL, NULL, '75016', 'PARIS', '00-32-41-05-76', '00-18-62-44-05', '1932-06-05 00:00:00.000', 0.692717, 12400, '78B55840-DFAF-483D-8EFB-CBEB0C8C322D', 6, 2),
(1362, 'MONTIRONI', 'Didier', 'M.', '48 Rue de Passy', NULL, NULL, '27700', 'LES ANDELYS', '05-07-75-46-79', '05-24-68-82-41', NULL, 0.340727, 8400, '8FFDADFF-9C15-49B8-90D8-C49752A5CD97', 6, 2),
(1363, 'LE PROVOT', 'Frdric', 'M.', 'Bt. 1 A Bis', 'Rsidence Le Grand Large', 'Avenue Annibal', '75011', 'PARIS', '02-78-59-70-39', '02-79-85-15-50', '1963-07-30 00:00:00.000', 0.149244, 10900, '7FA3E4A6-CF2C-44AB-97CE-7259696A9B84', 3, 2),
(1364, 'TENENBAUM', 'Yan', 'M.', '70 Avenue Mozart', NULL, NULL, '75017', 'PARIS', '05-92-64-94-37', '05-10-71-67-20', '1961-12-01 00:00:00.000', 0.301304, 2000, 'E22CB9F6-FF73-4F39-A3AE-8494CF9A9CD3', 6, 2),
(1365, 'EVENO DIT VILLERS', 'Guy', 'M.', '23 Place Nicolas Poussin', NULL, NULL, '06220', 'LE GOLFE JUAN', NULL, '00-26-11-41-65', '1952-01-15 00:00:00.000', 0.71806, 22000, '19BE8879-1A46-4A88-87D9-D6F92FA92C72', 6, 2),
(1366, 'LE GALLE', 'Ren', 'M.', '297 Rue du Faubourg Saint', 'Antoine', NULL, '75018', 'PARIS', '05-66-09-33-69', '05-97-30-69-71', '1920-01-14 00:00:00.000', 0.988389, 14400, '80BEC466-A9E9-4230-987B-A1CF28DDA6EA', 6, 2),
(1367, 'CUPILLARD', 'Jean-Michel', 'M.', '32 Rue des Renaudes', NULL, NULL, '92380', 'GARCHES', '03-25-85-24-85', '03-76-47-87-55', '1947-04-20 00:00:00.000', 0.613871, 4200, '7B0523F0-1428-43AD-861E-17DE3BC8D58C', 6, 2),
(1368, 'BERETTA', 'Thierry', 'M.', '76 Chemin de la Californie', NULL, NULL, '73000', 'CHAMBRY', '02-05-87-10-74', '02-67-79-98-83', '1967-01-27 00:00:00.000', 0.943334, 12400, '403BB783-33A9-4EA8-A7F6-4F0A4F3A15F3', 6, 2),
(1369, 'DELORY', 'Ren', 'M.', '4 Rue Damrmont', NULL, NULL, '06220', 'VALLAURIS', '03-43-22-44-41', '03-43-11-63-33', '1934-02-11 00:00:00.000', 0.526577, 19600, '24274EBF-8E5E-4459-AD70-0181FA42DD45', 6, 2),
(1370, 'DELLAC', 'Marie-Christine', 'Mme.', '44 Bd Raymond Poincar', NULL, NULL, '62520', 'LE TOUQUET', '00-22-67-52-57', '00-04-58-48-85', NULL, 0.0816617, 12100, '094B2990-6348-4B90-B786-19C707A79743', 7, 1),
(1371, 'TSERETOPOULOS', 'Olivier', 'M.', '78/82 Avenue du Marchal Leclerc', NULL, NULL, '77590', 'BOIS LE ROI', '04-00-70-55-63', '04-66-02-51-28', '1973-08-28 00:00:00.000', 0.726508, NULL, '57B056E9-515A-4267-97E1-AEE6B976AAC8', 6, 2),
(1372, 'BEDRANE', 'Denis', 'M.', '27 Avenue Georges Clmenceau', NULL, NULL, '75020', 'PARIS', '03-11-28-04-95', '03-09-42-14-35', '1968-08-01 00:00:00.000', 0.126716, NULL, '65D88A3B-5B2B-42F2-9A9F-A55A5D3870B7', 6, 2),
(1373, 'VULCANO', 'Nouria', 'Mme.', '80 Rue de Metz', NULL, NULL, '93100', 'MONTREUIL', '03-40-20-01-22', '03-42-96-69-52', '1952-02-02 00:00:00.000', 0.588528, 5400, '2DA7A821-FFC1-4B9F-A31F-74945B3BCFB2', 6, 1),
(1374, 'DAHAN', 'Caroline', 'Mme.', '6 Place de la Rpublique', NULL, NULL, '67201', 'ECKBOLSHEIM', '01-78-73-24-12', '01-27-54-06-31', '1964-09-04 00:00:00.000', 0.270329, 6800, 'FB24B8FF-F514-4271-97A9-16A8A34DD1D5', 6, 1),
(1375, 'GOLDSCHMID', 'Alexandre', 'M.', '89 Avenue Gambetta', NULL, NULL, '22000', 'SAINT BRIEUC', '03-18-49-03-02', '03-37-97-49-73', '1933-07-05 00:00:00.000', 0.382965, 12000, 'D5FA8E71-0023-41A6-870E-2CE61798678F', 6, 2),
(1376, 'MARIDAT', 'Franois', 'M.', '80 Rue de Paris', NULL, NULL, '75010', 'PARIS', '02-99-63-07-58', '02-56-77-35-11', '1959-05-24 00:00:00.000', 0.208378, 1000, '02654806-12F3-445B-87BC-97B41582D707', 6, 2),
(1377, 'BAUDOUIN', 'Paulette', 'Mme.', '3 Rue des Frres Lumire', NULL, NULL, '92200', 'NEUILLY', '02-81-90-95-92', '02-90-61-47-31', NULL, 0.836329, 21600, 'DFD530FB-43C9-43F1-9F78-02C761136E5B', 4, 1),
(1378, 'ARNARDI', 'Jean-Franois', 'M.', '2 Rue Saint Gilles', NULL, NULL, '79200', 'PARTHENAY', '04-26-60-75-84', NULL, '1962-01-11 00:00:00.000', 0.670189, 900, '51ACE2FF-0EBE-46F0-8B47-AEE46A9D2770', 6, 2),
(1379, 'GERVAIS', 'Claude', 'M.', '180 Rue Lafayette', NULL, NULL, '83400', 'HYERES', '01-05-31-39-23', '01-06-20-67-66', '1946-01-17 00:00:00.000', 0.270329, 3000, '2DE27CC5-7B55-4D56-B8F4-4B8367C4F42F', 6, 2),
(1380, 'SIEURIN', 'Jean-Louis', 'M.', '14 Rue Paul Chatrousse', NULL, NULL, '92140', 'CLAMART', '04-20-96-36-26', '04-91-02-46-60', '1959-12-11 00:00:00.000', 0.788458, 13400, '193FE3CC-CE82-4134-B07B-9D56A72A5984', 6, 2),
(1381, 'DREYFUSS', 'Daniel', 'M.', '15 Bd de la Meilleraye', NULL, NULL, '06220', 'LE GOLFE JUAN', '04-45-39-75-97', '04-64-09-34-37', '1949-01-20 00:00:00.000', 0.132348, 1200, '7CF286D5-169E-4568-BD6A-EDFBC58EA104', 6, 2),
(1382, 'PERROTIN', 'Daniel', 'M.', '101 Avenue Alphonse Denis', NULL, NULL, '67230', 'BENFELD', '00-56-80-76-48', '00-49-11-42-90', '1958-07-26 00:00:00.000', 0.456179, 8000, '9F61B923-C8F8-45F8-9A47-0A34AC3EBC24', 6, 2),
(1383, 'D''ASTA', 'Maurice', 'M.', '44 Avenue Jean Jaurs', NULL, NULL, '69004', 'LYON', '03-28-43-16-53', '03-23-06-74-52', '1925-04-23 00:00:00.000', 0.0985573, 9300, 'C86BDC45-5BF4-45DF-A8CA-F978012B6173', 6, 2),
(1384, 'WOLKOWICZ', 'Jean-Charles', 'M.', '202 R.N. 7', NULL, NULL, '78640', 'NEAUPHLE LE CHATEAU', '02-26-86-95-83', '02-76-84-49-36', '1960-11-28 00:00:00.000', 0.104189, 24900, '8B3A5A15-FC8D-4E61-86BA-432344406A25', 7, 2),
(1385, 'FLINT', 'Claude', 'M.', '6 Rue du Grand Rempart', NULL, NULL, '75008', 'PARIS', '00-91-67-72-96', '00-78-54-09-51', '1939-01-10 00:00:00.000', 0.261881, 2500, 'AE075D30-4C56-4A3A-8B61-54278C969A36', 6, 2),
(1386, 'OROZ', 'Didier', 'M.', '17 Rue Richan', NULL, NULL, '95270', 'CHAUMONTEL', '01-90-32-33-60', NULL, '1963-07-30 00:00:00.000', 0.701165, 13100, '2975E346-A88F-4EBE-ACF5-7D797E5839D4', 6, 2),
(1387, 'MOURIES', 'Jean', 'M.', '21 Grande Rue', NULL, NULL, '64700', 'HENDAYE PLAGE', '00-14-25-19-46', '00-42-85-55-90', '1945-08-09 00:00:00.000', 0.354806, NULL, '5B13E9D0-6235-43E6-9B76-38B698D16697', 6, 2),
(1388, 'MOURADIAN', 'Jean-Pierre', 'M.', '3 Rue du Cirque', NULL, NULL, '94500', 'CHAMPIGNY SUR MARNE', '05-15-20-56-14', '05-33-99-25-15', '1956-01-01 00:00:00.000', 0.363254, 14600, '257974D3-F015-480F-8C25-0ABF61ABA654', 6, 2),
(1389, 'REVOLLET', 'Anade', 'Mme.', '22 Rue de Paris ( R.N. 16 )', NULL, NULL, '06560', 'VALBONNE', '05-72-58-32-20', '05-96-04-35-61', '1941-10-20 00:00:00.000', 0.413941, 16000, 'E0827504-3395-4848-AE09-E2DC19F2DE69', 6, 1),
(1390, 'RIGOLAGE', 'Sylvie', 'Mme.', '4 Rue des Aubpines', NULL, NULL, '38100', 'GRENOBLE', '00-27-14-88-29', '00-43-71-40-27', '1958-04-24 00:00:00.000', 0.678637, 8300, '542DAAB2-3A82-4E82-B4DF-B1C1BA15FD9F', 6, 1),
(1391, 'DUFFOUX', 'Jean-Louis', 'M.', '71 Bd de Stalingrad', NULL, NULL, '94250', 'GENTILLY', '01-30-98-59-63', '01-41-13-16-14', NULL, 0.163323, 23300, '304B0707-5D60-41E6-AEF3-ACE3ECB5E3C6', 4, 2),
(1392, 'TEMPERE', 'Pierre', 'M.', '26 Bd Carnot', NULL, NULL, '75008', 'PARIS', NULL, '04-39-20-49-64', '1930-02-26 00:00:00.000', 0.036607, 23000, 'D4E7A4AB-4C02-47B1-8FD1-67138B399F73', 6, 2),
(1393, 'OLIVI', 'Philippe', 'M.', '191 Cours de la Libration', NULL, NULL, '92330', 'SCEAUX', '02-50-36-69-27', '02-53-90-02-95', '1962-10-24 00:00:00.000', 0.101373, 8000, 'C4B78FC8-DBBA-4370-A0A1-1FDCD4AAE180', 6, 2),
(1394, 'BALEZ', 'Jean-Jacques', 'M.', '57 Avenue Charles Frrot', NULL, NULL, '31200', 'TOULOUSE', '03-37-74-81-09', '03-24-00-05-21', '1962-03-31 00:00:00.000', 0.765931, 12600, '764D8973-8505-421D-AD54-F09F97DEF89D', 6, 2),
(1395, 'RAYSSAC', 'Yonnel', 'M.', '73 Bd Malesherbes', NULL, NULL, '75019', 'PARIS', '02-09-15-02-73', '02-55-44-05-03', '1944-06-28 00:00:00.000', 0.898279, 5800, 'B170BDD0-35EE-4D5B-8948-A822C860A163', 6, 2),
(1396, 'COQUEBLIN', 'Valrie', 'Mme.', '79 Rue Houdan', NULL, NULL, '31000', 'TOULOUSE', '03-07-55-30-90', '03-41-11-95-52', '1968-08-07 00:00:00.000', 0.149244, NULL, 'FF32B2D3-A53B-4535-B2A0-B7E0641C5A4E', 6, 1),
(1397, 'BOYER', 'Laurence', 'Mme.', '55 Bd de l''Embouchure', NULL, NULL, '78220', 'VIROFLAY', '05-89-96-87-37', '05-23-45-99-02', '1956-09-04 00:00:00.000', 0.166139, 12800, '1B6651FD-095F-49F4-A17F-958353141DB0', 6, 1),
(1398, 'CLERC', 'Pascal', 'M.', '60 Rue Petit', NULL, NULL, '74170', 'SAINT GERVAIS', '03-63-05-49-51', '03-50-42-13-54', '1952-11-26 00:00:00.000', 0.830697, 24100, '1D8F41C7-0463-4D36-B3A1-98FB1B94D587', 1, 2),
(1399, 'GILLET', 'Jean-Claude', 'M.', '40 Rue du Rempart Saint Etienne', NULL, NULL, '74000', 'ANNECY', '01-02-92-75-32', NULL, '1954-03-16 00:00:00.000', 0.242169, 3900, 'F9CD450C-8437-4ECD-A997-D1FF561D28FE', 6, 2),
(1400, 'MURATET', 'Bernard', 'M.', '8 Rue Madeleine', NULL, NULL, '75012', 'PARIS', '05-95-24-71-08', '05-82-81-60-56', '1912-04-16 00:00:00.000', 0.596975, 800, '2B1FBB0C-0B78-4A9D-9619-DAAF6B4EA1CC', 6, 2),
(1401, 'BRAYDA', 'Catherine', 'Mme.', '132 Avenue du Mont d''Arbois', NULL, NULL, '31000', 'TOULOUSE', '03-95-86-39-40', '03-80-81-78-38', '1952-03-18 00:00:00.000', 0.180219, 8900, 'D966426A-BED7-4326-B9E4-C9B95BF3A8C4', 6, 1),
(1402, 'CHEILLAN', 'Patrick', 'M.', '49 Avenue de Genve', NULL, NULL, '94160', 'SAINT MAND', '01-50-96-44-06', '01-39-51-65-71', '1949-01-18 00:00:00.000', 0.909543, 8100, '1DD2A241-6781-4342-B279-7D6F0CBF9297', 6, 2),
(1403, 'DELUS', 'Jacqueline', 'Mme.', '105 Avenue du Gnral Michel', 'Bizot', NULL, '83704', 'SAINT RAPHAEL CEDEX', '03-06-48-43-34', '03-77-73-79-10', '1954-07-22 00:00:00.000', 0.0788458, 21300, '76EB9BA8-1254-41F3-A314-20B808AA335D', 6, 1),
(1404, 'VAISSE', 'Martine', 'Mme.', '7 Rue des Moutons', NULL, NULL, '57200', 'SARREGUEMINES', '02-36-49-17-38', '02-35-16-94-15', '1948-01-30 00:00:00.000', 0.602607, 15500, '6A3BA444-EA05-4797-9877-3ABC71CB3A01', 6, 1),
(1405, 'ROCOFFORT', 'Philippe', 'M.', '2 Rue de l''Alouette', NULL, NULL, '75017', 'PARIS', '03-58-40-06-87', '03-30-66-87-33', '1942-06-30 00:00:00.000', 0.920807, 13500, '085403DF-67EE-4EA6-8913-FD628804855A', 1, 2),
(1406, 'MOTTIER', 'Georges', 'M.', 'Centre d''Affaires Europe', 'Bd du Cerceron', 'B.P.498', '14470', 'COURSEULLES SUR MER', '03-11-42-87-24', '03-91-99-04-97', '1949-02-01 00:00:00.000', 0.658926, 24200, 'AFF0C56C-9BF3-4BBF-BE8D-C5CE4CFE166A', 6, 2),
(1407, 'ALBRECHTS', 'Frdric', 'M.', '12 Rue Utzschneider', NULL, NULL, '77260', 'LA FERT SOUS JOUARRE', '04-09-31-00-64', '04-94-31-45-10', '1962-07-05 00:00:00.000', 0.180219, 8800, 'DFEB0A3B-72C8-4369-864C-E0046AA26093', 6, 2),
(1408, 'BON', 'Stphane', 'M.', '21 Rue Lebon', NULL, NULL, '91260', 'JUVISY SUR ORGE', '00-47-86-43-27', '00-44-31-49-36', '1962-07-06 00:00:00.000', 0.613871, 16400, '6A943711-C456-49C0-A5BE-A7056955A1E6', 6, 2),
(1409, 'FAVEL-FENATEU', 'Ren-Jean', 'M.', '25 Quai Est', NULL, NULL, '92210', 'SAINT CLOUD', '03-22-02-12-11', '03-21-68-61-23', '1943-11-28 00:00:00.000', 0.399861, 5500, '2E918614-29C1-4770-86F1-A56B601B4E79', 6, 2),
(1410, 'LE PROUX DE LA RIVIERE', 'Sylvie', 'Mme.', '36 Avenue Franklin Roosevelt', NULL, NULL, '06400', 'CANNES', '00-81-05-32-23', '00-25-35-48-66', '1956-03-16 00:00:00.000', 0.875752, 3100, 'FF16905D-0477-4598-A6A3-1C195A0BC9E4', 6, 1),
(1411, 'JARLOT', 'Bertrand', 'M.', '1 Avenue Klber', NULL, NULL, '33120', 'ARCACHON', '03-67-09-58-11', '03-93-73-48-62', '1949-11-25 00:00:00.000', 0.917991, 17300, 'F1498097-0375-46E1-8AF0-570B6D6407CD', 6, 2),
(1412, 'GUINET', 'Philippe', 'M.', '54 Bd de la Rpublique', NULL, NULL, '77580', 'CRY LA CHAPELLE', '02-84-95-91-03', '02-53-73-63-54', '1960-06-30 00:00:00.000', 0.588528, 10900, 'F8FB7D0B-476C-453D-8730-03E684EE4CC0', 5, 2),
(1413, 'MERLI', 'Jean-Claude', 'M.', 'Prado Parc', '21 Avenue du Grand Pin', NULL, '75001', 'PARIS', '04-15-12-05-39', '04-70-20-70-64', '1935-06-24 00:00:00.000', 0.901095, 1000, '4F5D6C2B-5A62-4706-8B76-41A674CEAD14', 6, 2),
(1414, 'DORMOY', 'Eric', 'M.', '332 Bd de la Plage', NULL, NULL, '95270', 'VIARMES', NULL, '03-92-54-57-70', '1959-08-05 00:00:00.000', 0.563184, NULL, '792A020F-41C0-4F41-95BF-8F6C7F6081F6', 6, 2),
(1415, 'CARLES', 'Daniel', 'M.', '23 Rue de Libernon', NULL, NULL, '76420', 'BIHOREL', '02-68-73-27-21', '02-17-48-09-12', '1943-12-11 00:00:00.000', 0.323831, 14100, 'D9724EC5-F372-45BA-A71E-8296900B19AC', 6, 2),
(1416, 'BEUNES', 'Bernard', 'M.', '62 Rue du Louvre', NULL, NULL, '83100', 'TOULON', '01-51-45-41-15', '01-18-37-74-48', '1943-02-26 00:00:00.000', 0.0872936, 9600, '918711A9-DE00-4F07-BD08-7BAC0F584516', 6, 2),
(1417, 'COLLEAU', 'Bruno', 'M.', '73 Rue de Paris', NULL, NULL, '59200', 'TOURCOING', '02-45-76-78-83', '02-08-55-79-19', '1957-06-17 00:00:00.000', 0.273144, 6700, 'E82206D6-E7DE-4E2D-B3B8-791679129767', 6, 2),
(1418, 'SIMOND', 'Danielle', 'Mme.', 'Horizon 2000 - Mach 5', 'Avenue des Hauts Grigneux', NULL, '29110', 'CONCARNEAU', '02-21-48-74-88', '02-98-70-36-02', '1938-10-11 00:00:00.000', 0.439284, 6300, '9595764D-B0FB-459C-A34D-323F8886B830', 6, 1),
(1419, 'NAHOUM', 'Michel', 'M.', '2500 Avenue Joseph Gasquet', NULL, NULL, '73000', 'CHAMBRY', '02-43-99-36-29', '02-25-49-67-41', '1958-05-31 00:00:00.000', 0.861672, 5800, '2787A6DD-AC99-4203-A50B-85BEEDD9D1BC', 2, 2),
(1420, 'ICARD', 'David', 'M.', '26/36 Rue Charles Wattines', NULL, NULL, '75008', 'PARIS', '03-37-15-29-91', '03-91-41-11-09', '1932-08-29 00:00:00.000', 0.391413, NULL, '1A1A54C3-0AAA-49E7-9A38-760ADA0C97E7', 6, 2),
(1421, 'ALRIQ', 'Francis', 'M.', '2 Bis Rue A. Leray', NULL, NULL, '13001', 'MARSEILLE', '04-61-55-83-38', '04-16-13-57-75', '1941-06-02 00:00:00.000', 0.498418, 15600, 'BCB63722-25B9-48FA-82F8-AAE239490491', 6, 2),
(1422, 'BROUARD', 'Jean', 'M.', '1 Place de la Libration', NULL, NULL, '83120', 'SAINTE MAXIME', '00-05-41-10-13', '00-61-43-56-70', '1934-03-27 00:00:00.000', 0.174587, 14900, 'C6C029AC-E584-4D10-A963-706840C275E1', 6, 2),
(1423, 'MEREDITH', 'Jean-Claude', 'M.', '58 Rue Pierre Charron', NULL, NULL, '75001', 'PARIS', '00-61-45-54-09', '00-68-05-55-32', '1930-03-28 00:00:00.000', 0.0788458, 14800, 'D1531327-D99B-4966-986F-7EB0EAB053B2', 6, 2),
(1424, 'BIENCOURT', 'Keith', 'M.', '1 Rue Molire', NULL, NULL, '06250', 'MOUGINS', '01-99-75-75-50', '01-04-98-67-44', '1948-12-12 00:00:00.000', 0.484339, 7100, '9A9E41E9-82F2-4A9A-95AF-AF51287E516B', 6, 2),
(1425, 'PALARIC', 'Olivier', 'M.', '6 Bis Avenue Montfleuri', NULL, NULL, '75012', 'PARIS', '04-24-40-02-43', NULL, '1964-12-04 00:00:00.000', 0.813801, 15800, 'A001F33B-C03E-4B5D-A1C1-711AA81CFA30', 6, 2),
(1426, 'BALLADA', 'Danielle', 'Mme.', '7 Rue du Louvre', NULL, NULL, '56100', 'LORIENT', '02-83-80-82-96', '02-83-56-94-33', '1950-10-20 00:00:00.000', 0.126716, 12300, '4EBBAEC0-610F-44BD-B11C-BD7A927DCDA2', 1, 1),
(1427, 'GUERIN', 'Martine', 'Mme.', 'La Palombire', '71 Avenue de Tournamy', NULL, '75006', 'PARIS', '03-77-23-11-47', '03-46-41-07-11', '1948-09-21 00:00:00.000', 0.121085, 21300, 'CFD016AD-F263-43BB-9956-8CF92032FFFC', 6, 1),
(1428, 'CHEMIN', 'Christian', 'M.', '24/26 Rue Baudelaire', NULL, NULL, '06000', 'NICE', '02-06-03-74-16', '02-27-58-97-52', '1953-04-08 00:00:00.000', 0.13798, 17800, '9FDA80D8-1967-4ED3-A364-71C7BE793846', 6, 2),
(1429, 'LE NY', 'Jean-Louis', 'M.', '19 Bd Leclerc', NULL, NULL, '78300', 'POISSY', '03-91-88-78-62', '03-89-88-14-89', '1940-07-10 00:00:00.000', 0.535025, 24800, '97A4C264-1FA1-4C98-BD74-5FE7271C95D5', 6, 2),
(1430, 'SALAETS', 'Alexandre', 'M.', '2 Rue Crbillon', NULL, NULL, '22000', 'SAINT BRIEUC', '04-61-85-75-58', NULL, '1933-05-30 00:00:00.000', 0.439284, 19100, 'DA070DE6-42C6-4DA8-9A17-89DD3E7435F6', 6, 2),
(1431, 'COLLIN', 'Filiep', 'M.', '35 Rue Pastorelli', NULL, NULL, '59250', 'HALLUIN', '04-43-67-06-92', '04-48-03-83-60', '1958-08-23 00:00:00.000', 0.830697, NULL, '38AE195A-0076-402E-A1B9-A9C87DC8002C', 6, 2),
(1432, 'MARCHADIER', 'Gilles', 'M.', '39 Rue du Gnral De Gaulle', NULL, NULL, '60290', 'RANTIGNY', '04-26-64-38-87', '04-05-05-73-72', '1943-07-09 00:00:00.000', 0.988389, 20400, '2F7A4993-F27C-4CC2-8469-C9B070120F10', 6, 2),
(1433, 'DUH', 'Alain', 'M.', '8 Rue de Rohan', NULL, NULL, '16000', 'ANGOULEME', '02-22-12-19-08', '02-84-20-45-62', '1936-03-19 00:00:00.000', 0.360438, 16000, '69BB386A-6CD3-45A1-851D-8361B646D3B6', 1, 2),
(1434, 'CHOQUET', 'Lise-Marie', 'Mme.', '86 Rue de Lille', NULL, NULL, '06700', 'SAINT LAURENT DU VAR', '03-20-38-24-40', '03-57-62-18-92', '1958-09-15 00:00:00.000', 0.402677, 13900, 'E25F2DEA-6CE3-4549-9714-CE0986B6F3EC', 6, 1),
(1435, 'BITTMANN', 'Christine', 'Mme.', '9 Avenue Jean Jaurs', NULL, NULL, '77100', 'MEAUX', '00-34-70-76-70', '00-09-43-36-95', '1964-05-09 00:00:00.000', 0.0591344, 1700, '662EBF39-7A73-4D6B-811B-2EB2763E91B6', 6, 1),
(1436, 'GUILLON', 'Cdric', 'M.', '31 Avenue Wilson', NULL, NULL, '67380', 'LINGOLSHEIM', '02-79-48-96-46', '02-46-62-39-50', '1972-01-25 00:00:00.000', 0.616687, 24800, 'B4F26ADF-26CC-4B35-A5D1-F89D5CCB5E7C', 6, 2),
(1437, 'DUVAL', 'Jacques', 'M.', 'CAP VAR C1', '148 Avenue Georges Guynemer', NULL, '11370', 'LEUCATE', '04-93-99-34-70', '04-68-39-16-75', '1932-03-08 00:00:00.000', 0.785642, 7900, 'D0027D90-239A-4E1D-875E-D35410474299', 6, 2),
(1438, 'LECHAT', 'Christiane', 'Mme.', '40 Quai Sadi Carnot', NULL, NULL, '92290', 'CHATENAY MALABRY', '01-70-37-44-77', '01-77-02-34-99', '1940-01-22 00:00:00.000', 0.109821, 18900, '971D63EF-8A32-46FE-A28E-335D8A76023A', 6, 1),
(1439, 'GARNIER', 'Jean-Pierre', 'M.', '42 Rue du Marchal Foch', NULL, NULL, '33800', 'BORDEAUX', '03-66-86-56-87', NULL, '1943-07-23 00:00:00.000', 0.526577, 4200, '128E7616-92F8-4860-AEA6-AC262D170AA7', 6, 2),
(1440, 'ZAMITH', 'Camille', 'M.', '63 Avenue du Languedoc', 'LA FRANQUI', NULL, '95320', 'SAINT LEU LA FORET', '03-84-18-08-25', '03-05-44-85-50', '1939-05-28 00:00:00.000', 0.177403, 4300, 'EBD27E21-CC2B-4109-A0AF-6A5F26EDFABD', 5, 2),
(1441, 'HOENNER', 'Alain', 'M.', '10 Place de l''Eglise', NULL, NULL, '81200', 'MAZAMET', '02-12-97-08-40', '02-60-93-07-93', '1947-08-30 00:00:00.000', 0.230906, NULL, '672F6D5E-EEF2-4DA9-825D-DBD49377E141', 6, 2),
(1442, 'LEROY', 'Christian', 'M.', '49 Cours de l''Yser', NULL, NULL, '68400', 'RIEDISHEIM', '05-49-00-48-65', '05-08-07-10-40', '1957-10-31 00:00:00.000', 0.236537, 23100, 'A60A9D66-D7CC-432F-B79A-8F0CD8218780', 6, 2),
(1443, 'JOUFFRIAULT', 'Bruno', 'M.', '16 Rue du Gnral Leclerc', NULL, NULL, '60250', 'MOUY', '04-38-51-66-83', '04-45-53-85-65', '1955-01-05 00:00:00.000', 0.839145, 9900, '569E44D7-E91D-47D1-B1B3-905C12D29BF8', 6, 2),
(1444, 'PRUD''HOMME', 'Alain', 'M.', '1 Alle Pierre Bruyre', NULL, NULL, '16200', 'JARNAC', '02-71-15-08-44', '02-72-55-68-29', '1952-11-03 00:00:00.000', 0.0929254, 21700, '36CDA124-FC42-4A2D-8FCE-D60D03026BCD', 6, 2),
(1445, 'POZZO', 'Richard', 'M.', '59 Rue de Mulhouse', NULL, NULL, '93600', 'AULNAY SOUS BOIS', '03-52-24-18-05', '03-42-36-37-24', '1947-06-29 00:00:00.000', 0.839145, 12400, '09396D3A-57B3-4AD4-AD37-DA3B22311A73', 6, 2),
(1446, 'SMADJA', 'Thierry', 'M.', '1 Place Cantrel', NULL, NULL, '75014', 'PARIS', '00-32-33-55-80', '00-01-07-55-36', '1961-06-18 00:00:00.000', 0.346358, 12000, '608D189B-ACF1-403B-8E29-C6AE8377B930', 6, 2),
(1447, 'TOSELLO', 'Lucien', 'M.', '19 Place du Chteau', NULL, NULL, '75008', 'PARIS', '00-78-69-25-40', '00-85-03-64-14', '1950-12-22 00:00:00.000', 0.323831, 3000, 'E6D6AC99-1682-4C04-9AA9-E1A53A867D4C', 2, 2),
(1448, 'COURTY-CUVILLIER', 'Marie-Thrse', 'Mme.', '8 Rue Jules Princet', NULL, NULL, '06130', 'GRASSE', '01-01-62-25-11', NULL, '1944-10-10 00:00:00.000', 0.160508, 21000, '8805E4CC-47FF-4B93-A576-7ECEAE5AAA3E', 6, 1),
(1449, 'CHARNAY', 'Brigitte', 'Mme.', '2 Rue Rmy Dumoncel', NULL, NULL, '92100', 'BOULOGNE', '01-92-01-45-49', '01-60-45-33-41', '1952-04-17 00:00:00.000', 0.4421, 18500, '26E5A8EE-0D79-4731-A8E5-64749D4F0E28', 6, 1),
(1450, 'HERMAN', 'Claire', 'Mme.', '22 Rue de Madrid', NULL, NULL, '75116', 'PARIS', '03-60-14-53-07', '03-74-49-47-61', '1932-09-08 00:00:00.000', 0.768747, 6600, 'A532F55F-69B6-4014-9162-0B9BF750B783', 6, 1),
(1451, 'CORDET', 'Alain-Didier', 'M.', '25 Avenue Thiers', NULL, NULL, '06400', 'CANNES', '01-14-35-65-17', '01-60-28-17-76', '1946-06-03 00:00:00.000', 0.0760299, 12300, 'F127EB8D-8245-42FF-AA03-973A47615A3F', 6, 2),
(1452, 'GIRARD', 'Ginette', 'Mme.', '51 Bis Rue Fessart', NULL, NULL, '26110', 'NYONS', '05-70-11-09-72', '05-48-41-55-02', '1935-11-22 00:00:00.000', 0.537841, 9100, 'D0908DCF-EB68-4AEA-A67C-FB67AE568008', 6, 1),
(1453, 'LOUIS', 'Monique', 'Mme.', '95 Rue de la Pompe', NULL, NULL, '87000', 'LIMOGES', '05-42-09-13-20', '05-66-28-13-90', '1947-02-03 00:00:00.000', 0.796906, 12300, '9207C798-D84D-4550-A25C-340113668BBB', 6, 1),
(1454, 'AGNIEL', 'Andr', 'M.', '125 Rue d''Antibes', NULL, NULL, '92100', 'BOULOGNE', '00-58-60-17-03', NULL, '1957-01-09 00:00:00.000', 0.149244, 6200, '326844FB-45D3-4F3B-8BCA-1F9AD84AECE7', 3, 2),
(1455, 'CHALOPIN', 'Bernard', 'M.', '35 Place de la Libration', NULL, NULL, '84000', 'AVIGNON', '05-00-45-30-34', '05-00-03-33-30', '1950-03-08 00:00:00.000', 0.444916, 22000, '075580F3-E9B4-45F9-9FE1-EDFFEA9466DE', 6, 2),
(1456, 'ASSOULINE', 'Michel', 'M.', '3 Bd de la Cit', NULL, NULL, '95400', 'ARNOUVILLE LES GONESSE', '02-05-92-84-85', '02-15-49-70-60', '1942-11-12 00:00:00.000', 0.458995, 16900, '6B51059B-CB60-415B-B190-1CAD0F23F2BE', 6, 2),
(1457, 'BOURDU', 'Jacques', 'M.', '55 Avenue Edouard Vaillant', NULL, NULL, '75008', 'PARIS', '01-62-54-46-26', '01-12-60-08-02', '1947-11-11 00:00:00.000', 0.309751, 1600, '6A36E6D2-881C-4DCC-9E62-BAFE62B4A238', 6, 2),
(1458, 'GHANTOUS', 'Liliane', 'Mme.', '17 Place de la Pignotte', NULL, NULL, '64600', 'ANGLET', '03-49-10-01-37', '03-48-26-36-80', '1931-03-19 00:00:00.000', 0.512498, 11000, '2B34548A-2706-438E-ACED-85E3619BD454', 6, 1),
(1459, 'LARROQUE', 'Joseph', 'M.', '36 Avenue de la Rpublique', NULL, NULL, '92100', 'BOULOGNE', '00-06-44-67-48', NULL, '1952-08-16 00:00:00.000', 0.678637, NULL, 'EE092DA6-C318-4B6E-8C5D-DCF0677641DE', 6, 2),
(1460, 'MACHER', 'Jean-Pierre', 'M.', '25 Rue de Ponthieu', NULL, NULL, '33120', 'ARCACHON', '02-85-00-79-55', '02-80-38-69-15', '1947-07-27 00:00:00.000', 0.670189, 15500, 'EC0F1539-2DDB-4B86-AB12-746FCCCC4F83', 6, 2),
(1461, 'DURAND', 'Denis', 'M.', '35 Avenue de Bayonne', NULL, NULL, '68100', 'MULHOUSE', '05-10-77-65-98', '05-09-99-18-03', '1957-05-16 00:00:00.000', 0.0816617, 5400, '4D20AEE4-2DFA-442B-8A46-4C1A87B13B24', 7, 2),
(1462, 'FOURNIER', 'Alain', 'M.', '53 Bis Route de la Reine', NULL, NULL, '06400', 'CANNES', '05-31-95-68-00', '05-16-99-16-02', '1945-08-24 00:00:00.000', 0.00281592, NULL, '320AFB30-291D-4205-8B02-5B3438B30E05', 6, 2),
(1463, 'MARTY', 'Franoise', 'Mme.', '2 Alle Daniel Rastel', NULL, NULL, '75018', 'PARIS', '02-97-51-76-86', '02-09-86-10-31', '1949-03-12 00:00:00.000', 0.236537, 4200, '2FCB6651-A306-4968-AE98-3AFF4707340E', 6, 1),
(1464, 'LETOURNEUR', 'Bernard', 'M.', '4 Rue Stoeber', NULL, NULL, '34300', 'CAP D''AGDE', '02-86-44-56-66', '02-47-44-56-23', '1958-10-06 00:00:00.000', 0.036607, 21500, '6B8192F9-3A1C-48E1-9332-8B6A36111C64', 6, 2),
(1465, 'MENTION', 'Jean-Paul', 'M.', '2 Rond Point Duboys d''Angers', NULL, NULL, '60800', 'CRPY EN VALOIS', '02-77-44-38-26', '02-93-64-34-65', '1944-07-10 00:00:00.000', 0.21401, 16900, '3A046254-F91E-4490-B275-2DB5B4BA5EBB', 6, 2),
(1466, 'APIED', 'Philippe', 'M.', '21 Bis Rue Simplon', NULL, NULL, '59500', 'DOUAI', '01-57-67-73-06', '01-14-28-23-33', '1967-01-29 00:00:00.000', 0.30412, 13100, 'CB47C28B-ECBB-43D3-9D3C-F2A852C669E0', 6, 2),
(1467, 'CHEVALLIER', 'Delpha', 'Mme.', 'Rsidence Port La Roquille', 'Avenue des Lavandires', NULL, '77300', 'FONTAINEBLEAU', '03-29-90-66-25', '03-39-90-58-43', '1951-08-03 00:00:00.000', 0.163323, NULL, 'E0C655A9-F968-4771-AFCD-9C679790312F', 6, 1),
(1468, 'LACOSTE', 'Dominique', 'M.', '8 Rue Lamartine', NULL, NULL, '75015', 'PARIS', '04-81-03-38-99', '04-83-60-31-51', '1954-08-02 00:00:00.000', 0.520946, NULL, 'AB7EDCC5-0C36-4FBC-9E7C-8A99FE71E34E', 4, 2),
(1469, 'PERSONN', 'Genevive', 'Mme.', '23 Rue Gambetta', NULL, NULL, '31500', 'TOULOUSE', '01-34-05-64-71', '01-81-14-95-20', '1947-10-15 00:00:00.000', 0.278776, 14700, '1928C93E-8376-45C8-8414-F02DAFA89D2E', 6, 1),
(1470, 'DAHAN', 'Vincent', 'M.', '42 Rue de France', NULL, NULL, '97400', 'SAINT DENIS', '04-32-64-50-73', '04-27-00-97-92', '1960-04-05 00:00:00.000', 0.259065, 8500, '2A131A56-9F48-4E00-AB2F-276C2B0103F1', 6, 2),
(1471, 'GLORIA', 'Grard', 'M.', '8 Rue Fallempin', NULL, NULL, '06000', 'NICE', '01-51-19-04-35', '01-55-58-31-90', '1962-01-18 00:00:00.000', 0.858856, 2000, 'CB5A65B6-DE2C-43FD-98D7-B9B48FF8E456', 6, 2),
(1472, 'POTIER', 'Marc-Armand', 'M.', '239 Avenue de Castres', NULL, NULL, '60000', 'BEAUVAIS', '02-02-26-23-90', '02-44-93-62-11', '1959-08-25 00:00:00.000', 0.520946, NULL, 'A85CA961-3CD7-49D0-9526-B51C757518FD', 6, 2),
(1473, 'GAUTIER', 'Bernard', 'M.', '13 Rue Flix Guyon', NULL, NULL, '92100', 'BOULOGNE', '00-03-89-44-36', '00-23-94-44-43', '1948-09-13 00:00:00.000', 0.577264, 21200, '82B95310-03B7-45BC-928D-6036BC0E511A', 6, 2),
(1474, 'DIAZ', 'Sabine', 'Mme.', '6 Avenue de Sude', NULL, NULL, '83600', 'FRJUS', '03-65-09-61-35', '03-53-27-35-22', '1961-06-02 00:00:00.000', 0.847593, 4600, '83FFE335-908E-4D91-92D9-FBDD252E251B', 6, 1),
(1475, 'GRAVIER', 'Marie-Hlne', 'Mme.', '66 Rue Gambetta', NULL, NULL, '34280', 'CARNON', '02-58-83-46-32', '02-69-75-97-00', '1958-10-30 00:00:00.000', 0.157692, 18200, '52921664-2FA2-4CE3-97EB-7A976A402D41', 7, 1),
(1476, 'LOYSEL', 'Dominique', 'M.', '123 Rue du Chteau', NULL, NULL, '71100', 'CHALON SUR SAONE', '05-77-27-12-08', '05-93-13-30-73', '1940-04-08 00:00:00.000', 0.647662, 20900, '62615BF6-B377-4A91-9189-66B86AC3EAD9', 6, 2),
(1477, 'AMOROS', 'Philippe', 'M.', '11 Bd d''Alger', NULL, NULL, '75008', 'PARIS', '00-35-27-92-02', '00-18-51-46-94', '1951-05-14 00:00:00.000', 0.906727, 3800, '2007DA3A-2D43-4FE1-89B5-23EA2E94CB2C', 6, 2),
(1478, 'BELONCLE', 'Jos', 'M.', 'Avenue des Comtes du Melgueil', NULL, NULL, '30700', 'UZES', '01-41-78-38-20', '01-53-54-91-40', '1951-06-07 00:00:00.000', 0.19993, 17300, '7E0EABE0-5056-44F1-85D1-24161D4D35D6', 6, 2),
(1479, 'HEURARD DE FONTGALLAND', 'Patrick', 'M.', '7 Place de l''Oblisque', NULL, NULL, '14800', 'DEAUVILLE', '03-74-04-96-14', '03-44-70-36-07', '1950-11-08 00:00:00.000', 0.495602, 2800, 'BD04B83F-0B35-400E-9A08-0F4C114025A7', 6, 2),
(1480, 'BRUNIER', 'Grard', 'M.', '11 Rue Marbeuf', NULL, NULL, '69009', 'LYON', '04-26-50-31-02', '04-86-96-61-61', '1945-05-07 00:00:00.000', 0.104189, 2200, '60DF89D0-DE99-4922-AF53-6A2266AB9993', 6, 2),
(1481, 'CUER', 'Sylvain', 'M.', '10 Bd Gambetta', NULL, NULL, '78570', 'ANDRESY', '05-61-05-02-06', '05-17-91-95-65', '1954-02-13 00:00:00.000', 0.802538, 14400, 'A99CED26-E9E5-47C5-91D8-823993180568', 6, 2),
(1482, 'CHARBONNIER', 'Jean-Luc', 'M.', '67 Rue Dsir Le Hoc', NULL, NULL, '13800', 'ISTRES', '00-09-02-13-42', '00-55-39-46-71', '1960-01-06 00:00:00.000', 0.385781, 9300, '1E5A8A5F-9C6F-48AB-8F6A-7B4745F93413', 4, 2),
(1483, 'AUBERT', 'Pierre', 'M.', '120 Rue de Saint Cyr', NULL, NULL, '91100', 'CORBEIL ESSONNES', '04-00-47-91-28', '04-92-72-07-37', '1956-09-11 00:00:00.000', 0.335095, 12700, '69C96B4F-15BF-40C8-A8A8-5B575CAC21A4', 6, 2),
(1484, 'CRUMIERE', 'Gilles', 'M.', 'Centre Commercial des Charvaux', NULL, NULL, '75012', 'PARIS', '01-51-65-79-73', '01-35-33-84-09', '1948-11-17 00:00:00.000', 0.825065, 2200, '18AA5AF3-91B8-4362-9B88-6329BC9579BC', 6, 2),
(1485, 'ALMAYRAC', 'Pilar', 'Mme.', '4 Bd Jean Jacques Prat', NULL, NULL, '30000', 'NIMES', '01-58-40-46-04', '01-47-66-00-80', '1948-10-30 00:00:00.000', 0.757483, 7500, '506A3F2D-DEA1-45EB-8775-A03A3E2452F5', 6, 1),
(1486, 'CHETRIT', 'Marie-Claude', 'Mme.', 'Rue Jean Cocteau', 'Centre Commercial Art De Vivre', NULL, '84360', 'LAURIS', '02-00-45-97-97', '02-20-42-80-84', '1951-05-09 00:00:00.000', 0.887015, 13900, 'D8970F5C-EA32-4C9F-BA8D-3D4A0FE21113', 6, 1),
(1487, 'SEIDLITZ', 'Stphan', 'M.', '142 Rue de Picpus', NULL, NULL, '75006', 'PARIS', '03-84-87-00-94', '03-94-81-18-63', '1963-03-27 00:00:00.000', 0.264697, 4800, 'E0E095FB-07C3-457C-BA8B-5ABDE57DEC70', 6, 2),
(1488, 'GARDEZ', 'Gilbert', 'M.', '41 Avenue Gnral Leclerc', NULL, NULL, '76800', 'SAINT TIENNE DU ROUVRAY', '00-32-49-02-05', '00-79-68-54-63', '1941-07-02 00:00:00.000', 0.887015, 11100, '059BB94E-197C-45AA-84DF-4DB3449CCBA2', 6, 2),
(1489, 'ROCA', 'Georges', 'M.', '36 Avenue Philippe de Girard', NULL, NULL, '80350', 'MERS LES BAINS', NULL, '02-80-97-45-37', '1928-12-11 00:00:00.000', 0.833513, 20700, 'AFB53D47-91C9-43F2-BBF7-E3C9A664A3D2', 1, 2),
(1490, 'SEPHONS', 'Pierre', 'M.', '13 Rue de Tournon', NULL, NULL, '66000', 'PERPIGNAN', '01-25-34-53-20', '01-64-71-04-38', '1955-05-08 00:00:00.000', 0.701165, 10100, 'B967AAF2-BB3B-4BD6-8938-E46643CD92B5', 6, 2),
(1491, 'BACHELIER', 'Michle', 'Mme.', '4 Rue Ernest Renan', NULL, NULL, '92400', 'COURBEVOIE', '05-39-03-74-62', '05-90-95-52-23', '1953-02-01 00:00:00.000', 0.205562, 10600, 'E8B910FF-6C92-4D7B-A446-B8B937877767', 6, 1),
(1492, 'ARAMA', 'Suzanne', 'Mme.', '43 Place du March', NULL, NULL, '75008', 'PARIS', '01-58-28-44-34', '01-43-57-09-74', '1932-07-16 00:00:00.000', NULL, 9700, '6A9083B5-0E54-46A3-99C6-34C49080423C', 6, 1),
(1493, 'CAPRON', 'Jean-Pierre', 'M.', '58 Rue Marchal Foch', NULL, NULL, '75020', 'PARIS', '05-65-80-43-73', '05-37-92-46-16', '1939-01-03 00:00:00.000', 0.760299, 7300, '8117861D-01A6-4D05-88AA-71114D4B7A31', 6, 2),
(1494, 'JAILLET', 'Jean-Marc', 'M.', '20 Place de L''Iris', NULL, NULL, '06400', 'CANNES', '05-46-32-21-97', '05-77-32-06-20', '1951-08-31 00:00:00.000', 0.306936, NULL, 'F114C065-5FE4-4DB3-976B-93F4A1690542', 6, 2),
(1495, 'DAILCROIX', 'Roger', 'M.', '201 Rue du Faubourg Saint Honor', NULL, NULL, '69002', 'LYON', '01-37-84-21-52', '01-59-04-10-30', '1937-04-20 00:00:00.000', 0.954598, 4100, '6CD3884D-CD8E-4BEF-BFF7-3880DDAD7007', 6, 2),
(1496, 'LEFEBVRE', 'Lucie', 'Mme.', '19 Rue d''Avron', NULL, NULL, '71200', 'LE CREUSOT', '03-01-54-06-00', NULL, '1936-07-28 00:00:00.000', 0.157692, 21800, '231639F0-97F1-40FC-B88C-EC87A4EA7A48', 1, 1),
(1497, 'MANZANO', 'Jean-Pierre', 'M.', 'Le Gray d''Albion', '17 La Croisette', NULL, '74700', 'SALLANCHES', '02-20-11-25-54', '02-19-34-38-80', '1949-01-18 00:00:00.000', 0.909543, 19400, '513E7A0B-5705-4D04-9D0B-502BCD997DD2', 6, 2),
(1498, 'LAFOUGE', 'Nicole', 'Mme.', '106 Rue du Prsident Edouard', 'Herriot', NULL, '71400', 'AUTUN', '04-93-93-21-74', '04-18-57-35-48', '1958-08-08 00:00:00.000', 0.174587, NULL, '83B35B55-03B8-4345-BBD3-D8D4E6A2916F', 6, 1),
(1499, 'BEAUDONNET', 'Henri', 'M.', '3 Rue Anatole France', NULL, NULL, '71100', 'CHALON SUR SAONE', '04-23-07-34-61', '04-28-62-72-74', '1933-10-15 00:00:00.000', 0.523762, 8400, 'AEBEF755-33CE-4548-9D4D-D8A447345158', 6, 2),
(1500, 'GUILLERET', 'Rgine', 'Mme.', '71 Rue du Faucigny', NULL, NULL, '75008', 'PARIS', '02-85-27-24-22', '02-73-26-00-04', '1951-01-21 00:00:00.000', 0.0929254, 6800, '9A0111EF-E883-42B3-B917-E72003A2C9EE', 6, 1),
(1501, 'SCHERHAG', 'Richard', 'M.', '19 Avenue Charles De Gaulle', NULL, NULL, '75017', 'PARIS', '02-77-66-69-92', '02-33-74-34-57', '1958-10-11 00:00:00.000', 0.0957414, 6700, '77EC412D-EB25-466A-B19B-C2D72235261B', 6, 2),
(1502, 'FASSEL', 'Christophe', 'M.', '31 Place de Beaune', NULL, NULL, '83990', 'SAINT TROPEZ', '01-38-87-36-52', '01-12-64-84-63', '1969-05-31 00:00:00.000', 0.287224, 200, 'DDAE0381-B7BB-4BF0-AB18-A15E332AD41B', 6, 2),
(1503, 'COHEN', 'Raymond', 'M.', '234 Rue du Faubourg Saint Honor', NULL, NULL, '67110', 'NIEDERBRONN LES BAINS', '05-43-06-49-42', '05-39-10-90-21', '1960-04-29 00:00:00.000', 0.777195, 1300, '7DEF8C17-E0A1-45F6-8A2F-95FBF979AF94', 5, 2),
(1504, 'LETOURNEUR', 'Alain', 'M.', '9 Rue Jouffroy d''Abbans', 'Angle 85 Rue de Saussure', NULL, '75019', 'PARIS', '03-88-56-39-27', '03-15-06-23-04', '1956-01-30 00:00:00.000', 0.8842, 21200, '221D66CC-E80F-493E-8373-D12DDD799E42', 6, 2),
(1505, 'DEWISME', 'Jean-Paul', 'M.', '42 Rue Henri Seillon', NULL, NULL, '60800', 'CRPY EN VALOIS', '01-28-37-31-18', '01-95-41-69-00', '1944-07-10 00:00:00.000', 0.160508, 12200, '656FE674-D5C4-4CC1-B542-C9574C4BA40C', 6, 2),
(1506, 'BEGUIN', 'Eric', 'M.', '5 Rue des Juifs', NULL, NULL, '75011', 'PARIS', '05-53-84-02-34', '05-88-97-90-16', '1957-07-05 00:00:00.000', 0.242169, 10600, 'E520FABF-7D70-4978-8A65-39C68676C7B0', 6, 2),
(1507, 'MONCERET', 'Christian', 'M.', '13 Alle des Eiders', NULL, NULL, '75008', 'PARIS', '05-77-33-12-61', '05-00-14-19-95', '1948-04-17 00:00:00.000', 0.78001, 20200, '6A3BDA8B-DECB-4AF4-941E-F6F32329D893', 6, 2),
(1508, 'RIOS', 'Michel', 'M.', '31 Rue Nationale', NULL, NULL, '31500', 'TOULOUSE', '01-64-96-42-87', '01-17-32-67-52', '1943-01-24 00:00:00.000', 0.574448, 6500, '6ED05F54-357D-4345-A516-484C3E89B47F', 6, 2),
(1509, 'AMIOT', 'Grald', 'M.', '96 Bd Beaumarchais', NULL, NULL, '69002', 'LYON', '03-05-93-10-51', '03-66-91-20-10', '1951-02-08 00:00:00.000', 0.872936, 6500, '73FC9209-981D-42C2-B384-853B8A3EF9C2', 6, 2),
(1510, 'MORERE', 'Patrice', 'M.', '9 Rue Richepanse', NULL, NULL, '75020', 'PARIS', '01-60-15-72-92', '01-41-59-83-04', '1955-04-10 00:00:00.000', 0.109821, 8100, '699F9D72-4482-4A21-A097-CB640D22DEEF', 2, 2),
(1511, 'BEAUNEE', 'Jacques', 'M.', '31 Avenue Jean Rieux', NULL, NULL, '75009', 'PARIS', '05-78-03-10-35', '05-43-29-34-98', '1948-10-19 00:00:00.000', 0.0619503, 7300, '357C2EA2-3F47-4232-B5D0-44D5FE6F8A58', 6, 2),
(1512, 'BOURGEADE', 'Daniel', 'M.', 'Espace Cordeliers', '2 Rue Prsident Carnot', NULL, '94190', 'VILLENEUVE SAINT GEORGES', '04-58-04-22-51', '04-16-55-70-02', '1947-08-07 00:00:00.000', 0.825065, NULL, 'C02F0FE4-34BE-4E2A-ADFE-A777C21ED7C0', 6, 2),
(1513, 'DUP', 'Gisle', 'Mme.', '63 Bd Mortier', NULL, NULL, '75006', 'PARIS', '01-86-34-99-05', '01-40-51-16-91', '1928-08-27 00:00:00.000', 0.847593, NULL, '0C6C5E51-683F-4FF4-B38D-FFBA7A3F0A4E', 6, 1),
(1514, 'BRUNEL', 'Ren', 'M.', '27 Rue La Bruyre', NULL, NULL, '78800', 'HOUILLES', '03-93-64-50-28', '03-95-80-68-39', '1940-10-10 00:00:00.000', 0.112637, 24700, '21003D3B-6583-4BA4-91F3-9497253BB96D', 6, 2),
(1515, 'GUIRAUD', 'Gisle', 'Mme.', '8 Place Pierre Smard', NULL, NULL, '43000', 'LE PUY EN VELAY', '02-16-09-83-06', NULL, NULL, 0.337911, 18900, '5C291F7F-D0A6-453D-A8A7-A51001114BC3', 6, 1),
(1516, 'BROUSTAUT', 'Patricia', 'Mme.', '10 Rue Hautefeuille', NULL, NULL, '30100', 'ALES', '00-18-66-91-50', '00-19-65-15-48', '1950-07-27 00:00:00.000', 0.394229, 6500, '59DF5E69-9B79-4EA8-B19A-84CB59E229B4', 6, 1),
(1517, 'BARRE', 'Marie-Thrse', 'Mme.', '25 Avenue Charles De Gaulle', NULL, NULL, '33470', 'GUJAN MESTRAS', '04-16-51-28-07', '04-17-95-33-13', '1951-07-21 00:00:00.000', 0.653294, 11000, 'FA8BD6B2-3ABF-4326-84C3-E6A0D9035560', 1, 1),
(1518, 'VOULET', 'Guy', 'M.', '29 Bis Bd Carnot', NULL, NULL, '30120', 'LE VIGAN', '00-69-19-71-02', '00-79-14-39-77', '1944-07-06 00:00:00.000', 0.65611, 7700, '549CAAFD-71B7-47AE-822E-68ED32473F68', 6, 2),
(1519, 'MAGNO', 'Sylvie', 'Mme.', '8 Rue Allende', NULL, NULL, '26400', 'MIRABEL ET BLACONS', '04-02-28-14-97', '04-56-39-60-10', '1950-09-08 00:00:00.000', 0.408309, 3900, 'D97FB0D4-41A9-4303-88DA-CEC2CA0E16EF', 6, 1),
(1520, 'GALLAND', 'Thierry', 'M.', '13 Cours de Verdun', NULL, NULL, '39300', 'CHAMPAGNOLE', '04-60-80-45-18', '04-96-12-92-60', '1964-04-16 00:00:00.000', 0.920807, 10400, '657EADD4-7EEE-4F24-9FD8-F9FA7E229781', 6, 2),
(1521, 'GRANDJEAN', 'Eric', 'M.', '14 Avenue Emmanuel d''Alzon', NULL, NULL, '34170', 'CASTELNAU LE LEZ', '05-36-33-98-00', '05-41-63-76-49', '1965-02-16 00:00:00.000', 0.183035, 13600, 'BBE9D98A-7E26-4D00-AF39-21A57CE48C25', 6, 2),
(1522, 'NAVARRE', 'Paul', 'M.', 'La Salire', NULL, NULL, '75020', 'PARIS', '00-83-24-33-49', '00-76-99-11-74', '1946-02-24 00:00:00.000', 0.143612, 7900, '3AE52D97-96B9-4720-B586-E278EB5C22E1', 6, 2),
(1523, 'QUENTIN', 'Bernard', 'M.', '6 Avenue de la Rpublique', NULL, NULL, '65000', 'TARBES', '03-63-30-10-67', '03-62-86-53-30', '1953-10-15 00:00:00.000', 0.191483, 19500, '650B7263-215D-4F15-A364-507407C65297', 6, 2),
(1524, 'MORAND', 'Marie', 'Mme.', '3 Rue Pasteur', NULL, NULL, '31130', 'FLOURENS', '00-62-01-38-87', '00-74-61-10-38', '1957-05-21 00:00:00.000', 0.948966, 23900, '960C8A30-0F52-42B7-B95E-29A8EE1F80ED', 1, 1),
(1525, 'PARFAIT', 'Gaston', 'M.', '36 Rue de Pixrcourt', NULL, NULL, '74350', 'CRUSEILLES', '00-69-93-53-94', '00-71-84-47-40', '1907-05-18 00:00:00.000', 0.858856, 3900, '7F1C93D0-8A92-4874-8AA0-114DD9194AB0', 6, 2),
(1526, 'CAVOIT', 'Roger', 'M.', '27 Place Marcadieu', NULL, NULL, '97300', 'CAYENNE', '03-06-19-35-23', '03-60-55-20-55', '1949-01-21 00:00:00.000', 0.19993, 1000, 'E5097143-C269-408E-B457-E12951B9341C', 6, 2),
(1527, 'VIGNES DE CHAMPSEINPEYRE', 'Patrick', 'M.', '11 Rue du Nouvielle', NULL, NULL, '45510', 'VIENNE EN VAL', '01-82-52-18-79', '01-53-13-72-00', '1946-02-19 00:00:00.000', 0.261881, 6500, 'E84C5A27-8DEC-481B-803E-C4D48E660D77', 6, 2),
(1528, 'VERDI', 'Fabienne', 'Mme.', '1 place de la Rpublique', NULL, NULL, '33000', 'BORDEAUX', '01-95-71-70-70', '01-15-94-74-02', '1964-01-08 00:00:00.000', 0.185851, 7100, '7CFBCD6D-5E89-48E8-B520-FC4645E38A20', 6, 1),
(1529, 'LOISEL', 'Marie-Jacqueline', 'Mme.', '40 Rue Christophe Colomb', NULL, NULL, '31000', 'TOULOUSE', '01-79-24-15-82', '01-59-07-34-80', '1929-01-03 00:00:00.000', 0.216826, 8000, '84658BEE-886E-4C73-B104-10DA09836F39', 6, 1),
(1530, 'DESBIOLLES', 'Chantal', 'Mme.', 'La Bathe', NULL, NULL, '83600', 'SAINT AYGULF', '03-88-08-94-26', '03-01-35-90-25', '1947-09-17 00:00:00.000', 0.698349, 11400, '61A39289-B542-400E-8DCA-E027CD07D8C1', 6, 1),
(1531, 'VERDIER', 'Jol', 'M.', '115 Rue du Palais Gallien', NULL, NULL, '73490', 'LA RAVOIRE', '05-42-40-37-07', '05-69-71-40-38', '1953-06-28 00:00:00.000', 0.0816617, 1200, '36196982-BB3B-4772-A982-1884A6F5FAED', 5, 2),
(1532, 'QURO', 'Viviane', 'Mme.', '15 Rue Ninau', NULL, NULL, '80000', 'AMIENS', '04-95-19-99-04', '04-53-20-84-00', '1958-10-05 00:00:00.000', 0.943334, 20600, '763AF216-9CB5-45C2-AAEC-601D213A85E2', 6, 1),
(1533, 'PLASSAIS', 'Daniel', 'M.', '901 Avenue de la Corniche d''Azur', NULL, NULL, '78940', 'LA QUEUE LEZ YVELINES', '03-04-78-06-72', '03-47-64-09-57', '1957-05-21 00:00:00.000', 0.22809, 1500, 'CA9DD45D-4B40-4BE6-9E90-C276CB646DED', 6, 2),
(1534, 'COHEN-SALMON', 'Claude', 'Mme.', '254 Route d''Apremont', NULL, NULL, '77140', 'NEMOURS', '01-04-92-09-75', '01-13-56-93-21', '1941-05-11 00:00:00.000', 0.940518, 10800, 'C0D6C2B5-D8FE-403A-81C0-8C9C604093FA', 6, 1),
(1535, 'NOUCHY', 'Georges', 'M.', '1 Bis Rue Allart', NULL, NULL, '75009', 'PARIS', '05-78-60-26-54', '05-43-96-66-82', '1953-06-11 00:00:00.000', 0.298488, 24300, '09393BCD-0441-4160-91CF-A54BD364F476', 6, 2),
(1536, 'RONDOT', 'Hlne', 'Mme.', '16 Route Nationale', NULL, NULL, '13006', 'MARSEILLE', '05-18-52-00-06', '05-11-02-31-38', '1947-11-10 00:00:00.000', 0.977125, 1000, '596DE6FA-69D7-43FD-98B0-3900B0B44820', 6, 1),
(1537, 'GARCIA', 'Jean-Michel', 'M.', '22 Rue de Paris', NULL, NULL, '56640', 'ARZON', '01-69-39-23-95', '01-49-10-08-08', '1955-08-25 00:00:00.000', 0.391413, NULL, '5971B685-5ADF-45CC-B7DD-19B00C5FCE7F', 6, 2),
(1538, 'BAUER', 'Jean-Pierre', 'M.', '51 Bis Rue Condorcet', NULL, NULL, '84110', 'VAISON LA ROMAINE', '03-40-38-18-00', '03-19-86-98-65', '1942-09-15 00:00:00.000', 0.749035, 2800, '279F51CA-E0B4-4704-BB0A-9266B719D93F', 2, 2),
(1539, 'CASSAGNE', 'Alain', 'M.', '112 Cours Lieutaud', NULL, NULL, '75008', 'PARIS', '01-70-48-05-15', '01-55-13-84-09', '1966-04-30 00:00:00.000', 0.796906, 4700, '018E9EB5-669E-4459-82D1-A092746AB196', 6, 2),
(1540, 'D''ALES', 'Nol', 'M.', '1 Rue Centrale', NULL, NULL, '69006', 'LYON', '01-81-12-82-49', '01-30-69-82-23', NULL, 0.0985573, 13800, '5B9E3C3E-E413-4D50-A698-40C593B27ADA', 6, 2),
(1541, 'FOUCAUD', 'Alain', 'M.', '57/59 Cours Taulignan', NULL, NULL, '78220', 'VIROFLAY', '05-94-37-31-75', '05-32-37-09-75', '1946-11-29 00:00:00.000', 0.456179, 5600, '2F40165E-0040-4383-87F0-19EEF9B38CD2', 6, 2),
(1542, 'OZENNE', 'Philippe', 'M.', '16 Rue Christophe Colomb', NULL, NULL, '24120', 'TERRASSON', '01-07-59-86-03', '01-39-79-34-44', '1957-05-08 00:00:00.000', 0.492786, 18600, 'D674044A-F396-4688-BE82-CD2E62B85919', 6, 2),
(1543, 'BOURREAU', 'Catherine', 'Mme.', '60 Rue Waldeck Rousseau', NULL, NULL, '14910', 'BENERVILLE SUR MER', '04-53-21-43-87', '04-25-70-21-09', '1960-07-18 00:00:00.000', 0.971493, 8100, 'AF8DFCE9-23B2-4B57-B06A-39D31058CC64', 6, 1),
(1544, 'BANNIER', 'Vincent', 'M.', '53 Avenue Gaston Boissier', 'Cournarie', NULL, '90000', 'BELFORT', '04-04-14-04-70', '04-72-59-46-83', '1965-11-30 00:00:00.000', 0.563184, 10700, '184212DC-C49E-4C88-A882-D0992115C0EF', 6, 2),
(1545, 'MAHE', 'Laurent', 'M.', '13 Rue du Gnral Gouverneur', NULL, NULL, '75009', 'PARIS', '02-69-03-21-08', '02-51-45-36-08', '1955-04-14 00:00:00.000', 0.188667, 10600, '1C4BE6D0-04D0-47C2-B2A1-A819DE2AA95E', 3, 2),
(1546, 'VITRANT', 'Christophe', 'M.', '42 Avenue du Littoral', NULL, NULL, '44500', 'LA BAULE', '00-17-62-33-49', '00-84-27-59-53', '1958-09-01 00:00:00.000', 0, 23500, '17F6ECD3-A197-4D75-8032-D386453A956C', 6, 2),
(1547, 'PIMONT', 'Michle', 'Mme.', '5 Bis Rue de Turenne', NULL, NULL, '06000', 'NICE', '02-40-54-38-23', '02-37-05-54-94', '1949-03-29 00:00:00.000', 0.920807, 21000, 'CB727E91-F9D3-4D78-9443-F31675C640C2', 6, 1),
(1548, 'SUYS', 'Frdric', 'M.', '46 Rue Lafayette', NULL, NULL, '91470', 'LIMOURS', '00-92-11-04-23', '00-65-20-98-95', '1971-11-06 00:00:00.000', 0.881384, 10700, 'F4B60AA7-2A0B-4898-B22D-8F6C7AC2B249', 6, 2),
(1549, 'BLANCHARD', 'Christophe', 'M.', '27 Avenue Lajarrige', NULL, NULL, '66000', 'PERPIGNAN', '03-84-45-86-78', '03-53-96-43-04', '1953-09-26 00:00:00.000', 0.470259, 11800, '5B045B7A-B2DB-4B0A-A57E-D3A9CDE9C15C', 6, 2),
(1550, 'HONOR', 'Franois', 'M.', '14 Avenue Borriglione', NULL, NULL, '75008', 'PARIS', '00-84-66-60-21', '00-22-12-37-81', '1949-12-21 00:00:00.000', 0.501234, 4200, '8017754C-0EDF-493F-AE83-7F87C3934EF3', 6, 2),
(1551, 'RUEFF', 'Alain', 'M.', '2 Villa de L'' Albatros', NULL, NULL, '71200', 'LE CREUSOT', '05-83-44-53-02', '05-05-95-00-56', '1942-05-25 00:00:00.000', 0.740588, 18800, 'BD1BEACB-C2D0-4156-A08C-33537BE35458', 6, 2),
(1552, 'BONNAUD', 'Serge', 'M.', '1 Bis Rue de la Cloche d''Or', NULL, NULL, '75009', 'PARIS', '00-71-51-57-42', '00-45-88-51-60', '1912-04-28 00:00:00.000', 0.991205, 13600, '09C76949-9296-4BEE-BE7B-C32F50D44276', 7, 2),
(1553, 'BENATTAR', 'Philippe', 'M.', '14 Rue de Marignan', NULL, NULL, '06700', 'SAINT LAURENT DU VAR', '02-81-75-05-99', '02-20-31-30-03', '1958-02-02 00:00:00.000', 0.681453, 15200, '35E19887-330D-4672-A1B7-D46F2791F90D', 6, 2),
(1554, 'BOUZIAT', 'Maurice', 'M.', '88 Rue Marchal Foch', NULL, NULL, '83140', 'SIX FOURS LES PLAGES', '04-82-81-11-72', '04-27-72-70-53', '1953-07-05 00:00:00.000', 0.537841, 20400, '2CB3EEB7-5CC5-4C90-84AE-FD3F829C7B0C', 6, 2),
(1555, 'DEN HOED', 'Jacques', 'M.', '17 Rue de Calais', NULL, NULL, '78120', 'RAMBOUILLET', '03-34-45-10-97', '03-20-85-79-37', '1944-04-28 00:00:00.000', 0.143612, 4900, '5097BED3-A5BF-4C68-A642-851EB300843E', 6, 2),
(1556, 'PAUL LE SACH DE LA NEUVILLE', 'Hlne', 'Mme.', '105 Avenue Decaroli', NULL, NULL, '06560', 'VALBONNE', '03-95-33-14-67', '03-87-33-21-01', '1946-12-26 00:00:00.000', 0.0394229, 24100, 'B004AF1D-9175-42DD-8097-ECF943ABB135', 6, 1),
(1557, 'FENZY', 'Hubert', 'M.', '241 Avenue de la Mer', NULL, NULL, '75006', 'PARIS', '03-39-25-29-94', '03-10-91-41-73', '1949-09-06 00:00:00.000', 0.991205, 3100, 'FDB61E35-1A53-4AFD-AE93-8645E685B160', 6, 2),
(1558, 'SAGASPE', 'Etienne', 'M.', '51 Rue Raymond Patentre', NULL, NULL, '91000', 'EVRY', '03-71-67-02-14', '03-78-78-98-05', '1950-09-19 00:00:00.000', 0.630767, 4200, '9932B389-E6BC-4C35-9061-965596214E59', 6, 2),
(1559, 'CHARON', 'Jean-Nicolas', 'M.', 'Domaine de Val d''Azur', 'Four Seasons Park', 'Route de Biot - D 4', '33130', 'BEGLES', '04-67-78-92-53', '04-27-37-21-96', '1971-10-13 00:00:00.000', 0.225274, 16300, '430AC8A1-5455-4086-9DC9-7A35F94B724D', 4, 2),
(1560, 'SOZZI', 'Luc', 'M.', '9 Ter Bd du Montparnasse', NULL, NULL, '75008', 'PARIS', '03-14-89-77-32', '03-92-97-94-51', '1942-06-01 00:00:00.000', 0.740588, 8400, 'C95E801F-AEF8-4677-AB94-FF728CEBBC6F', 6, 2),
(1561, 'EISSEN', 'Catherine', 'Mme.', '61 Rue Henri Rochefort', NULL, NULL, '69004', 'LYON', '00-54-34-83-18', '00-95-67-49-65', '1952-09-10 00:00:00.000', 0.619503, 21100, '911EFE22-0BD1-4273-826A-C2BCE01D826F', 6, 1),
(1562, 'GAGUECHE', 'Jacques', 'M.', '86 Cours Victor Hugo', NULL, NULL, '75012', 'PARIS', '01-34-44-14-79', '01-62-05-35-02', '1941-03-17 00:00:00.000', 0.4421, 11400, 'CD9E3068-BD3D-4595-ACA5-821A0CA9CBAF', 6, 2),
(1563, 'OUDOTTE', 'Flix', 'M.', '102 Avenue des Champs lyses', NULL, NULL, '75018', 'PARIS', '01-66-27-70-88', '01-84-79-47-82', '1938-02-15 00:00:00.000', 0.295672, 19700, 'FBA6E170-352C-4085-B6E7-97CFA9E86B15', 6, 2),
(1564, 'MAURICE', 'Roland', 'M.', '101 Grande Rue de la Croix', 'Rousse', NULL, '71600', 'PARAY LE MONIAL', '03-69-82-37-45', '03-49-12-24-68', '1956-07-14 00:00:00.000', 0.73214, 16900, '48C96E27-D9C9-4974-94B9-CD7D7F7ABF6F', 6, 2),
(1565, 'OSSUDE', 'Bernard', 'M.', '73 Rue Crozatier', NULL, NULL, '92600', 'ASNIERES', '05-40-37-69-51', '05-43-24-16-11', '1956-11-09 00:00:00.000', 0.413941, 3000, 'E2392D45-9DAF-48E4-897E-6D29F6CC874E', 6, 2),
(1566, 'FEVRE', 'Batrice', 'Mme.', '76 Rue Marcadet', NULL, NULL, '45500', 'GIEN', '05-35-97-64-21', '05-63-91-66-73', '1948-01-31 00:00:00.000', 0.00563184, 23700, '9402A637-BF2C-472E-8B50-1B041CEA878E', 7, 1),
(1567, 'BODIN', 'Michel', 'M.', '3 Rue Dargaud', NULL, NULL, '73600', 'BRIDES LES BAINS', '02-95-30-70-78', '02-86-68-14-32', '1952-03-04 00:00:00.000', 0.261881, 16200, '543CDCB4-A1D1-473C-A6BC-F6B1294A3776', 6, 2),
(1568, 'DESTRIEUX', 'Franoise', 'Mme.', '36 Rue Bapst', NULL, NULL, '44510', 'LE POULIGUEN', '03-34-04-60-00', '03-41-57-10-70', '1953-12-07 00:00:00.000', 0.0929254, 22900, 'F3CD0773-9820-4B3D-9DC1-9F260F83703E', 6, 1),
(1569, 'BESSON', 'Louis-Franois', 'M.', '52 Quai Lenoir', NULL, NULL, '94210', 'LA VARENNE SAINT HILAIRE', '03-08-69-47-00', '03-20-49-72-11', '1943-08-04 00:00:00.000', 0.439284, NULL, 'BEAE3B5B-B57A-4147-8109-595739A0547A', 6, 2),
(1570, 'CHAUVET', 'Bernard', 'M.', 'Rue Emile Machet', NULL, NULL, '78800', 'HOUILLES', '01-37-65-25-31', '01-54-56-40-03', '1949-02-16 00:00:00.000', 0.171771, 12900, 'F9FD9F4E-A60D-4DF1-8B3D-49B3C699D88C', 6, 2),
(1571, 'HURSON', 'Charles', 'M.', '3 Grande Rue', NULL, NULL, '97400', 'SAINT DENIS', '05-19-34-01-63', '05-53-93-72-44', '1944-05-07 00:00:00.000', 0.799722, 10900, '346E0945-A9DD-4DAB-8962-D4390A1275AB', 6, 2),
(1572, 'AULAGNON', 'Serge', 'M.', '58 Avenue Caffin', NULL, NULL, '56370', 'SARZEAU', '01-00-27-45-75', '01-53-18-34-80', '1938-04-29 00:00:00.000', 0.937702, 5900, '38DCFCCB-4C6D-439A-81FD-6852F4468EC4', 6, 2),
(1573, 'LEFRANC', 'Maryse', 'Mme.', '17 Rue Gabriel Pri', NULL, NULL, '75008', 'PARIS', '00-40-59-53-92', '00-47-89-22-49', '1949-04-19 00:00:00.000', 0.540657, 22100, 'FF81152D-0F4C-4F56-AD6E-37AFF68FB787', 4, 1),
(1574, 'CAMPION', 'Thierry', 'M.', 'Rsidence La Corniche', '8 Rue des Moulins', NULL, '75020', 'PARIS', '00-93-50-75-74', '00-22-95-85-22', '1945-08-17 00:00:00.000', 0.292856, NULL, '2F28A40E-4A0C-4AF0-9AD0-DFE3CAD2C50F', 6, 2),
(1575, 'SOLVET', 'Nicole', 'Mme.', 'Rsidence Les Roches Bleues', 'Rue Saint Vincent', NULL, '78400', 'CHATOU', '03-73-18-17-30', '03-59-06-47-74', '1943-03-25 00:00:00.000', 0.321015, 20300, '56743CE4-392D-42BD-80B6-6137D9DF2ABF', 6, 1),
(1576, 'BRONZINI DE CARAFFA', 'Jacqueline', 'Mme.', '23 Rue d''Anjou', NULL, NULL, '75008', 'PARIS', '03-05-40-45-51', '03-07-13-75-45', '1938-07-25 00:00:00.000', 0.242169, 8400, 'BEEC91DA-C4C9-42F2-9815-8F459D27D685', 6, 1),
(1577, 'BERNASCONI', 'Jean-Pierre', 'M.', '337 Rue des Pyrnes', NULL, NULL, '20200', 'BASTIA', '03-61-21-89-63', '03-98-87-04-07', '1954-01-28 00:00:00.000', 0.495602, 0, '6323CF5D-B604-4256-B0FB-1ABA9903857B', 6, 2),
(1578, 'PALARIC', 'Franois', 'M.', '85 Rue des Sablons', NULL, NULL, '84100', 'ORANGE', '00-04-88-83-75', '00-65-15-37-54', '1946-12-15 00:00:00.000', 0.667374, 7800, '489C84B8-A9F0-4146-8BC3-CB2DC4C44C62', 6, 2),
(1579, 'CLERC', 'Lucien', 'M.', '66 Avenue des Champs Elyses', NULL, NULL, '56100', 'LORIENT', '03-31-63-86-11', '03-76-22-12-98', '1920-01-17 00:00:00.000', 0.0478707, 8700, '66F4030F-C111-4EE6-B697-A7A36E6B1F6D', 6, 2),
(1580, 'BLATIERE', 'Guy', 'M.', '4 Bd Paoli', NULL, NULL, '34280', 'LA GRANDE MOTTE', '01-55-02-68-11', '01-16-77-71-30', '1961-08-09 00:00:00.000', 0.377334, NULL, 'F6145DFD-E85A-4D1C-AF65-417C73D4DF4A', 1, 2),
(1581, 'LAMOTTE', 'Fabien', 'M.', '22 Cours Aristide Briand', NULL, NULL, '75017', 'PARIS', '02-17-25-22-47', '02-98-52-48-25', '1959-03-15 00:00:00.000', 0.27596, 13000, '7FE75DFD-B2AF-48A1-A1F4-1D56A9D78F5B', 6, 2),
(1582, 'LEMOINE', 'Michel', 'M.', '19 Bd Leclerc', NULL, NULL, '38860', 'LES DEUX ALPES', '03-80-58-28-79', '03-56-24-92-90', '1947-03-19 00:00:00.000', 0.242169, 5200, '4DE87108-3BBA-4A4D-9598-60D5C758F394', 6, 2),
(1583, 'DUCOURNEAU', 'Denise', 'Mme.', '252 Rue Frdric Mistral', NULL, NULL, '75006', 'PARIS', NULL, '01-01-46-17-63', '1936-12-07 00:00:00.000', 0.197115, 300, '65C55383-88F9-4B9E-8FBC-4821E6A89C25', 6, 1),
(1584, 'AGUILAR', 'Henri', 'M.', '33 Rue Fortuny', NULL, NULL, '31330', 'GRENADE', NULL, '04-45-40-58-08', '1929-05-24 00:00:00.000', 0.85604, 17700, 'FEFB6BD5-2E4A-42A4-8CF8-75C17A0A2215', 6, 2),
(1585, 'HOUCHOT', 'Antoine', 'M.', 'Les Alpinistes', NULL, NULL, '30000', 'NIMES', '03-38-63-27-46', '03-42-48-03-00', '1943-01-19 00:00:00.000', 0.774379, 11400, 'B3DCD257-B049-4ED1-9FF0-9759D69F5675', 6, 2),
(1586, 'MAGNAN DE BELLEVUE', 'Jean-Pierre', 'M.', '18 Rue des Grands Augustins', NULL, NULL, '31390', 'CARBONNE', '01-14-86-56-41', '01-85-03-10-91', '1945-05-28 00:00:00.000', 0.512498, 10400, '071AEEFF-8C87-4147-A0E9-248BAFE8DDE1', 6, 2),
(1587, 'DE ROSE', 'Mireille', 'Mme.', 'Chemin de Piquette', NULL, NULL, '97400', 'SAINT DENIS', '04-60-34-38-25', '04-64-86-76-05', '1941-07-11 00:00:00.000', 0.382965, 16700, '3FCE7020-A6DF-48B0-9445-053D7858310E', 1, 1),
(1588, 'PAILLARD', 'Alain', 'M.', '1 Rue Pasteur', NULL, NULL, '75116', 'PARIS', '01-30-65-56-38', '01-10-58-28-66', '1950-11-11 00:00:00.000', 0.464627, 24300, '07F47FC6-E68B-4559-948E-FDB73F71C3DC', 6, 2),
(1589, 'BIJASSON', 'Denis', 'M.', '18 Rue Gambetta', NULL, NULL, '31750', 'ESCALQUENS', '01-75-21-43-55', '01-48-31-62-24', '1953-10-23 00:00:00.000', 0.934886, 20300, '141E6908-D466-4C46-A68A-9AAF36ED064D', 6, 2),
(1590, 'RASPINI', 'Jean', 'M.', '138 Rue Jean Chatel', NULL, NULL, '75017', 'PARIS', '01-20-90-66-67', '01-49-68-44-33', '1939-03-22 00:00:00.000', 0.71806, 3400, 'ABED0323-D37D-4540-8DBA-33315D9B85C6', 6, 2),
(1591, 'IZARD', 'Jean-Claude', 'M.', '20 Rue Lonard de Vinci', NULL, NULL, '34500', 'BZIERS', '01-52-82-39-80', '01-58-14-50-63', '1943-12-15 00:00:00.000', 0.979941, 23900, '1DCCB3C5-A3FF-4FCE-9FE2-6DB02A4FF92C', 6, 2),
(1592, 'VIGNON', 'Alain', 'M.', '11 Chemin des Bruyres', NULL, NULL, '64200', 'BIARRITZ', '02-91-76-84-59', '02-18-46-66-39', '1953-06-29 00:00:00.000', 0.433652, 15100, '69528C97-8301-42F8-87D0-010355947A9E', 6, 2),
(1593, 'DE CASTRO MOURAO EPOUSE FASSI', 'Yvette', 'Mme.', '251 Bd Pereire', NULL, NULL, '42400', 'SAINT CHAMOND', '05-11-16-27-39', '05-50-13-98-97', '1939-02-12 00:00:00.000', 0.439284, 24700, 'A0816936-E2E6-46D3-BF0D-E0C99C64C2A9', 6, 1),
(1594, 'BERNERON', 'Isabelle', 'Mme.', '24 Rue de la Citadelle', NULL, NULL, '92200', 'NEUILLY', '04-02-82-28-78', '04-27-63-07-47', NULL, 0.65611, 7200, 'D1499B6B-5EA8-42C2-B1F2-A3799EA96D99', 5, 1),
(1595, 'SALL', 'Christian', 'M.', '5 Rue Marie Hope Vere', NULL, NULL, '33270', 'FLOIRAC', '03-59-03-96-46', '03-08-67-65-54', '1937-06-09 00:00:00.000', 0.810986, 22600, 'AB5F4B72-987C-498D-82FA-47C61631A267', 6, 2),
(1596, 'SOLA', 'Jeanne', 'Mme.', '26 Place de la Libert', NULL, NULL, '28000', 'CHARTRES', '05-74-46-35-25', '05-52-73-93-62', '1946-05-28 00:00:00.000', 0.743403, 8300, 'DA2B9857-22DB-48D6-9FE6-B20D8925F797', 6, 1),
(1597, 'COURSEAU', 'Jean-Claude', 'M.', '5 Bis Rue Parmentier', NULL, NULL, '31200', 'TOULOUSE', '05-00-24-72-92', '05-41-18-67-15', '1951-06-09 00:00:00.000', 0.78001, 600, 'E00D5DE7-7767-48DC-9780-5857D509BC60', 6, 2),
(1598, 'MOREL', 'Rodolphe', 'M.', '25 Cours Gambetta', NULL, NULL, '95220', 'HERBLAY', '02-47-26-53-17', '02-06-07-27-59', '1963-04-07 00:00:00.000', 0.701165, 16900, '9DF159F9-9F85-475E-819B-E5C2066685F2', 6, 2),
(1599, 'BIANCOTTO', 'Pierre', 'M.', '4 Rue Delacroix', NULL, NULL, '75008', 'PARIS', '04-45-77-28-76', '04-31-42-67-76', '1937-09-04 00:00:00.000', 0.439284, 3500, '2B4C43C3-5E79-4385-A7D7-F4474C5F9D37', 6, 2),
(1600, 'COSTES', 'Ren', 'M.', '174 Avenue des Minimes', NULL, NULL, '06700', 'SAINT LAURENT DU VAR', '00-19-74-23-54', '00-53-60-96-00', '1936-02-03 00:00:00.000', 0.985573, 20200, 'CEFC08BF-D42E-47BF-B9AA-94B3B3912C3A', 6, 2),
(1601, 'ALAUX', 'Daniel', 'M.', '18 Bd Oscar Thvenin', NULL, NULL, '31290', 'VILLEFRANCHE DE LAURAGAIS', '03-06-39-34-04', '03-56-01-95-86', '1945-07-29 00:00:00.000', 0.765931, 12800, '38F1332B-8D05-4E5A-8DB2-849ADD69CFD0', 2, 2),
(1602, 'FAURE', 'Jean-Paul', 'M.', '48 Rue de la Bienfaisance', NULL, NULL, '22410', 'SAINT QUAY PORTRIEUX', '02-41-54-78-16', '02-09-49-83-49', '1944-07-31 00:00:00.000', 0.371702, 14200, 'CB9B6ED4-56FE-404D-9FB6-289055805B2E', 6, 2),
(1603, 'MOINE', 'Franoise', 'Mme.', '" Le Santa Lucia "', '1 Rue Anfossi', NULL, '75016', 'PARIS', '03-25-61-84-73', '03-82-95-87-63', '1947-10-11 00:00:00.000', 0.554737, 300, '7D834D6A-274B-4E43-A02C-A1C0B11B3D7C', 6, 1),
(1604, 'AMSELLEM', 'Claude', 'M.', '157 Rue de la Rpublique', NULL, NULL, '58000', 'NEVERS', '01-14-19-77-24', '01-93-24-15-81', '1935-03-16 00:00:00.000', 0.121085, 3700, '28C1D6AE-C2AB-4734-AAB6-5843342CF911', 6, 2),
(1605, 'FEUCHOT', 'Sauveur', 'M.', '28 Bis Quai de la Rpublique', NULL, NULL, '75015', 'PARIS', '03-68-20-55-58', '03-30-05-31-77', '1939-10-08 00:00:00.000', 0.00563184, 24200, '3E098F15-70F5-45E9-A17A-78CE98B7926D', 6, 2),
(1606, 'CHATEL', 'Alain', 'M.', '4 Rue Antoine Roucher', NULL, NULL, '01170', 'GEX', '05-30-03-78-56', '05-73-14-31-98', '1950-10-19 00:00:00.000', 0.912359, 1900, 'DB615E5D-A777-4526-BF41-18DE2783A7AD', 6, 2),
(1607, 'PONCIE', 'Raymond', 'M.', '12 Rue Ferdinand Gambon', NULL, NULL, '69006', 'LYON', '02-87-11-42-31', '02-56-37-16-84', '1939-08-24 00:00:00.000', 0.912359, NULL, 'FB594AC9-93BD-41F6-B605-0488A6CABF69', 6, 2),
(1608, 'AUBE-MARTIN', 'Marie-Jeanne', 'Mme.', '1 Rue Mademoiselle', NULL, NULL, '34300', 'CAP D''AGDE', '02-81-98-00-41', '02-86-09-60-26', '1952-02-19 00:00:00.000', 0.473075, 4700, '37C998E1-05B9-4664-9F6E-48553DB2D8EF', 1, 1),
(1609, 'VILLERET', 'Philippe', 'M.', 'Le Ttras', NULL, NULL, '75008', 'PARIS', '00-07-22-71-23', '00-34-58-55-23', '1951-11-06 00:00:00.000', 0.21401, 20900, '1B875B65-AF95-4CB3-9A01-9EC503B36D47', 6, 2),
(1610, 'SUCH', 'Yvan', 'M.', '61 Rue Bugeaud', NULL, NULL, '22000', 'SAINT BRIEUC', '03-34-12-26-51', '03-26-15-75-77', '1937-03-06 00:00:00.000', 0.360438, 18300, '5838585E-9A0A-4F4B-A56C-69E1F5E2E94A', 6, 2),
(1611, 'CHARQUET', 'Yvette', 'Mme.', '290 Les Terrasses de la Plage', 'Rue du Pacifique', NULL, '06160', 'JUAN LES PINS', '00-27-23-84-78', '00-75-63-86-43', '1942-12-25 00:00:00.000', 0.588528, 21500, '176E533E-5038-4F50-887F-865BB01F6BA7', 6, 1),
(1612, 'CHOHAN', 'Jacqueline', 'Mme.', '67 Bd Haussmann', NULL, NULL, '05100', 'BRIANCON', '02-80-29-97-44', '02-58-55-19-11', '1947-03-31 00:00:00.000', 0.470259, 20200, 'AA2F9984-ADFB-40A1-99BC-76096794452A', 6, 1),
(1613, 'LEBEL', 'Yacoub', 'M.', '23 Rue du Berry', NULL, NULL, '97438', 'SAINTE MARIE', '00-90-29-25-12', '00-58-01-11-50', '1957-10-22 00:00:00.000', 0.529393, 16800, '4890F9C1-5BAB-4048-AC9B-C518ADB6519F', 6, 2),
(1614, 'ANIORTE', 'Dominique', 'M.', '11 Rue de l''Estrel', NULL, NULL, '91000', 'EVRY', '05-35-30-59-92', '05-23-04-16-49', '1950-01-01 00:00:00.000', 0.135164, 1400, 'D2C740B5-761F-430D-9585-2ACD78DD73CE', 6, 2),
(1615, 'LIONARD', 'Pierre', 'M.', '6 Avenue du Dauphin', NULL, NULL, '06800', 'CAGNES SUR MER', '00-76-48-32-18', '00-16-78-39-20', '1949-03-13 00:00:00.000', 0.323831, 22700, 'D32EB8FC-AE67-4F27-9041-1CB7C8058D47', 1, 2),
(1616, 'MALRIEU', 'Yves', 'M.', '47 Rue de la Rpublique', NULL, NULL, '69006', 'LYON', '01-23-00-54-95', '01-35-06-12-84', '1946-03-22 00:00:00.000', 0.177403, 3100, '99CD0F1D-5CBB-4F33-9C1D-2B8DA5392031', 6, 2),
(1617, 'MAIOLO', 'Jacques', 'M.', '19 Bd des Coquibus', NULL, NULL, '30220', 'AIGUES MORTES', '00-17-18-37-52', '00-87-93-65-68', '1946-11-04 00:00:00.000', 0.827881, 7200, 'A1A2A2D2-56BC-48B1-9175-0EE58C94CB78', 6, 2),
(1618, 'CLAIRET', 'Dominique', 'M.', '10 Avenue Victoria', NULL, NULL, '57700', 'HAYANGE', '04-62-17-30-62', '04-31-65-15-01', '1956-02-22 00:00:00.000', 0.948966, 13200, '3D7C7428-EA38-4612-A4AC-A41224A2C487', 6, 2),
(1619, 'BRUN', 'Yvette', 'Mme.', '75 Bis Rue de Sze', NULL, NULL, '75015', 'PARIS', '00-75-76-00-20', '00-64-29-57-72', '1937-01-08 00:00:00.000', 0.985573, 25000, '258C9CD7-BF36-4EC0-B30C-BDB167C99EBC', 6, 1),
(1620, 'RAGOZIN', 'Jean-Marie', 'M.', '1 Bd Diderot', NULL, NULL, '57157', 'MARLY', '04-77-14-12-61', '04-11-09-97-27', '1954-06-01 00:00:00.000', 0.461811, 0, '1228F31E-563A-4AAE-8EF2-56499278537A', 6, 2),
(1621, 'NICOLI', 'Pierre', 'M.', '3 Rue du Gnral De Gaulle', NULL, NULL, '31000', 'TOULOUSE', '05-53-99-70-67', '05-24-98-57-37', '1957-03-15 00:00:00.000', 0.810986, 23900, '736EBEF0-69FE-42D7-8606-758F5C68730D', 6, 2),
(1622, 'DE BARRIN', 'Raymonde', 'Mme.', '51 Rue Brancion', NULL, NULL, '20137', 'PORTO VECCHIO', '02-22-01-02-06', '02-42-97-76-59', '1938-04-05 00:00:00.000', 0.388597, 5100, 'EF4AF029-3580-46B9-A763-5A7BAA356533', 5, 1),
(1623, 'PERRIN', 'Thrse', 'Mme.', '12 Place De Gaulle', NULL, NULL, '75007', 'PARIS', '05-94-96-14-03', '05-86-60-72-60', '1927-08-05 00:00:00.000', 0.847593, NULL, '67D7D67B-3B92-44D2-A851-F91452BE5898', 6, 1),
(1624, 'DEMARS', 'Jean-Paul', 'M.', '4 Place Saint Etienne', NULL, NULL, '84310', 'MORIERES LES AVIGNON', NULL, '02-27-64-94-95', '1965-01-19 00:00:00.000', 0.526577, 14200, 'F49F354E-11DA-4379-AE5C-FD9D1BA79BA8', 6, 2),
(1625, 'PAPADOPOULOS', 'Marie-Claire', 'Mme.', 'Route de Bonifacio', NULL, NULL, '75012', 'PARIS', '04-22-28-78-65', '04-40-84-19-37', '1936-09-24 00:00:00.000', 0.532209, 19100, '9918BE64-7BEE-4CFF-A490-F75AA7EF5A1E', 6, 1),
(1626, 'COSTAGLIOLA', 'Christine', 'Mme.', '115 Rue Saint Dominique', NULL, NULL, '75003', 'PARIS', '02-63-81-81-11', '02-81-09-02-80', '1949-02-27 00:00:00.000', 0.495602, 16800, '432757CD-821F-4F13-B89C-F9BBD9606758', 6, 1),
(1627, 'SAMUEL', 'Jean-Franois', 'M.', '194 Bd Aristide Briand', NULL, NULL, '34980', 'SAINT GELY DU FESC', '03-54-14-61-42', '03-26-01-56-00', '1966-03-06 00:00:00.000', 0.681453, 19900, '20FCB06B-9C81-4445-ACB7-47A62FDC5E5A', 6, 2),
(1628, 'BOIX', 'Nicolas', 'M.', '14 Rue Ernest Lacoste', NULL, NULL, '75002', 'PARIS', '00-66-48-68-02', '00-52-12-52-55', '1965-02-13 00:00:00.000', 0.278776, 11600, 'EC85E369-6FC4-4859-BC39-DE875F5C21C8', 6, 2),
(1629, 'STANITSAS', 'Grard', 'M.', '45 Rue de Turenne', NULL, NULL, '34200', 'SETE', '05-14-84-06-19', '05-83-05-68-56', '1959-01-08 00:00:00.000', 0.244985, 11700, '7EF51AC3-F639-4031-93CE-43D73077520D', 2, 2),
(1630, 'PLICHON', 'Christian', 'M.', '347 Grand''Rue', NULL, NULL, '75009', 'PARIS', '03-91-24-59-61', '03-12-49-61-89', '1944-05-25 00:00:00.000', 0.467443, 3200, 'DB63EC0A-83B4-408C-AA88-FE8B45317AA0', 6, 2),
(1631, 'SCHWAB', 'Roger', 'M.', '25 Bd Bonne Nouvelle', NULL, NULL, '59800', 'LILLE', '05-01-62-65-68', '05-98-37-92-52', '1925-06-17 00:00:00.000', 0.85604, 25000, 'A4E4287E-1442-4CE6-9EA8-2254A2B03110', 6, 2),
(1632, 'KOLOSA', 'Patrice', 'M.', 'Rsidence " Mer et Soleil "', 'Les Plages - Canal des Quilles', NULL, '67000', 'STRASBOURG', '00-48-30-54-13', '00-63-94-25-94', '1961-01-14 00:00:00.000', 0.0140796, 23500, '6999287A-5CC3-4F62-9075-C070E8CC5EBA', 6, 2),
(1633, 'ZACHARY', 'Madeleine', 'Mme.', '159 Rue du Faubourg Poissonnire', NULL, NULL, '43000', 'LE PUY EN VELAY', '04-61-15-87-16', '04-97-08-32-61', '1953-02-11 00:00:00.000', 0.535025, 15900, 'E0AFC85A-5148-4EDA-9F16-D621BFE8411A', 6, 1),
(1634, 'LEJEUNE', 'Jean-Paul', 'M.', '66 Rue du Molinel', NULL, NULL, '57100', 'THIONVILLE', '01-19-54-93-45', '01-92-72-94-47', '1949-02-20 00:00:00.000', 0.168955, 9700, 'B524EFAE-3FED-47CB-B5C1-E4FB296EF9C5', 6, 2),
(1635, 'VAILLAND', 'Marie-Christine', 'Mme.', '3 Rue Saint Maurice', NULL, NULL, '87100', 'LIMOGES', '01-88-84-40-34', '01-36-46-00-11', '1946-11-10 00:00:00.000', 0.560369, 24400, 'E752AE4B-D7A9-479B-83C3-1783199282A5', 6, 1),
(1636, 'DUBEAU', 'Frdric', 'M.', '29 Bd Marchal Joffre', NULL, NULL, '06400', 'CANNES', '02-31-64-07-88', '02-25-85-55-37', '1948-08-09 00:00:00.000', 0.532209, NULL, '425C6A44-44B2-46E5-9B4F-A9BB799F8FC5', 3, 2),
(1637, 'MARILLIER', 'Thierry', 'M.', '1 Rue de la Vieille Porte', NULL, NULL, '18000', 'BOURGES', '00-47-34-50-22', '00-51-82-85-03', '1958-10-24 00:00:00.000', 0.647662, 3800, '3D079380-0796-4239-8214-E2B61FA89477', 6, 2),
(1638, 'CULTY', 'Michel', 'M.', '14 Avenue Adrien Tarrade', NULL, NULL, '78360', 'MONTESSON', '05-35-99-46-78', '05-45-00-81-99', '1946-01-16 00:00:00.000', 0.411125, 22900, 'A84D847C-4095-49C2-9D07-42457ACDB267', 6, 2),
(1639, 'BATISTE', 'Yves', 'M.', '2 Place de l''Etang', NULL, NULL, '75020', 'PARIS', '00-38-26-81-78', '00-49-98-55-69', '1935-03-11 00:00:00.000', 0.309751, 6800, 'E98A3C0D-BAA4-412B-AEA2-FD4A756F4151', 6, 2),
(1640, 'BENEZETH', 'Michel', 'M.', '22 Avenue Jean Jaurs', NULL, NULL, '31000', 'TOULOUSE', '03-41-13-91-29', '03-62-73-10-41', '1940-05-22 00:00:00.000', 0.678637, 13600, '553AB66D-66D8-4345-ADC1-DED244F3A50E', 6, 2),
(1641, 'CAPEYRON', 'Jacques', 'M.', '2 Rue Flix Philippe', NULL, NULL, '34730', 'PRADES LE LEZ', '05-12-28-99-72', '05-78-52-62-62', '1959-02-25 00:00:00.000', 0.571632, 17400, '23E148C2-29AF-45DC-B6C7-26C8543ED05F', 6, 2),
(1642, 'FAUCHARD', 'Monique', 'Mme.', '229 Rue des Pyrnes', 'Le Moulleau', NULL, '33120', 'ARCACHON', '02-42-21-94-85', '02-49-36-48-89', '1942-01-11 00:00:00.000', 0.281592, 15600, '7EA74FBA-A621-44C4-BA90-D9B6F792D38D', 6, 1),
(1643, 'PETRYKOW', 'Stphane', 'M.', '25 Rue Rmusat', NULL, NULL, '75016', 'PARIS', '01-44-82-78-61', '01-50-17-91-85', '1966-03-01 00:00:00.000', 0.301304, 15200, '35982DE8-908C-4CE8-9CEA-490901892025', 7, 2),
(1644, 'WAMBERGUE', 'Marc', 'M.', 'Rsidence La Mandarine', NULL, NULL, '34280', 'LA GRANDE MOTTE', '01-45-81-01-01', '01-07-97-48-17', '1957-03-12 00:00:00.000', 0.861672, 16500, '0248097F-193E-4E6F-B5CA-55DE49994D0F', 6, 2),
(1645, 'DUVAL-FLEURY', 'Fabrice', 'M.', '281 Bd de la Cte d''Argent', NULL, NULL, '78112', 'FOURQUEUX', '00-35-65-10-27', '00-85-14-71-68', '1971-07-24 00:00:00.000', 0.912359, 21700, 'D4052FA4-AC89-46DE-B703-E4E0F8379810', 6, 2),
(1646, 'IMBS', 'Francis', 'M.', '23 Rue Jean Giraudoux', NULL, NULL, '75015', 'PARIS', '02-53-58-21-95', '02-84-97-92-99', '1942-08-26 00:00:00.000', 0.701165, NULL, 'A77345F3-B3FA-4808-9EBB-CD9AF9CA854F', 6, 2),
(1647, 'LASSUS', 'Fabien', 'M.', 'Rsidence du Parc n 2 - Appt 82', 'Avenue Plein Soleil', NULL, '67340', 'INGWILLER', '04-37-12-84-94', '04-97-39-94-93', '1973-01-27 00:00:00.000', 0.71806, 19000, 'F067ACFC-ADA2-44DE-871E-B185DD02E73C', 6, 2),
(1648, 'BRASSAS', 'Josette', 'Mme.', ' 29 Avenue des Pendans', 'd'' Ennemont', NULL, '78200', 'MANTES LA JOLIE', '01-41-25-43-29', '01-23-70-42-72', '1926-01-12 00:00:00.000', 0.132348, 22900, 'A1F28C6E-EC84-4110-8941-1E6FEDE3D99B', 6, 1),
(1649, 'LOMBARD', 'Michel', 'M.', 'Tour Maine Montparnasse', '33 Avenue du Maine', NULL, '91120', 'PALAISEAU', '00-78-79-69-55', '00-44-18-85-99', '1942-10-22 00:00:00.000', 0.551921, 19500, 'BF85BF74-816F-4D7A-A1BF-54B924B46D4D', 6, 2),
(1650, 'UNTERHALT-ROUSSEL', 'Nelson', 'M.', '2 Rue de la Grange aux Dmes', NULL, NULL, '30240', 'LE GRAU DU ROI', NULL, NULL, '1939-11-03 00:00:00.000', 0.382965, 20100, 'E5A154D7-49FD-4BC6-8675-EEAE039E8E36', 4, 2),
(1651, 'ZELIGFELD', 'Michel', 'M.', 'La Belle Cte', 'BOISSY MAUVOISIN', NULL, '78350', 'JOUY EN JOSAS', '03-75-45-56-22', '03-92-31-39-34', NULL, 0.337911, 17000, 'E741C841-05EF-4AA7-A16C-AC5653B15F35', 6, 2),
(1652, 'GEHL-DECHOUX', 'Muriel', 'Mme.', '15 Rue de Paris', NULL, NULL, '75016', 'PARIS', '02-09-99-74-45', '02-35-26-41-80', '1963-04-30 00:00:00.000', 0.982757, 23000, '744226EE-597F-4260-999D-807E5A1DE62E', 6, 1),
(1653, 'CAZENAVE', 'Catherine', 'Mme.', 'Immeuble L''IMPRIAL', 'Rue des Combattants', NULL, '57500', 'SAINT AVOLD', '03-09-64-58-59', '03-30-28-63-76', '1961-01-16 00:00:00.000', 0.129532, 15800, 'CE73ABD9-FB3E-4FEA-B1A5-1A4EDE079B4E', 6, 1),
(1654, 'ANDRE', 'Pierre', 'M.', '24 Rue Oberkampf', NULL, NULL, '57590', 'JUVILLE', '02-32-60-68-60', '02-44-83-63-64', '1944-09-13 00:00:00.000', 0.0422388, 1400, '74CEB958-A9B6-4C73-9D01-29D8D0774010', 6, 2),
(1655, 'CHEMINEL', 'Yves', 'M.', '13 Bd Suchet', NULL, NULL, '75011', 'PARIS', '00-30-52-21-10', '00-79-97-30-77', '1948-04-11 00:00:00.000', 0.785642, 8800, 'C792EF32-300C-48C1-B091-238AF2404BEF', 6, 2),
(1656, 'OZANNE', 'Pierre', 'M.', '14 Place de la Victoire', NULL, NULL, '35400', 'SAINT MALO', '02-97-76-41-18', '02-04-49-37-84', '1945-03-14 00:00:00.000', 0.4421, 17400, '8FBD1ED8-2600-4543-9F62-DC61A28F339F', 6, 2),
(1657, 'COLLIGNON', 'Brigitte', 'Mme.', 'Haut de Beauregard', NULL, NULL, '95610', 'ERAGNY SUR OISE', '04-83-79-37-11', '04-72-11-96-44', '1956-07-11 00:00:00.000', 0.991205, 17200, 'D485CC8A-AA23-46B0-9665-085939671892', 7, 1),
(1658, 'JOUSSELY', 'Marc', 'M.', '17 Avenue Parmentier', NULL, NULL, '59500', 'DOUAI', '00-55-62-23-10', '00-00-35-94-74', '1941-07-22 00:00:00.000', 0.287224, 20600, '539F4291-3E0E-43FC-8BE9-C5329C32BC45', 6, 2),
(1659, 'MARTIGNONI', 'Michle', 'Mme.', '80 Bd de Rochebonne', NULL, NULL, '75015', 'PARIS', '04-13-06-32-49', '04-94-63-58-94', '1950-06-17 00:00:00.000', 0.557553, 5300, '5AFB3C67-1A63-4BA9-9855-7D993448E062', 6, 1),
(1660, 'BREVET', 'Ren', 'M.', 'Centre Commercial "La Challe"', NULL, NULL, '93250', 'VILLEMOMBLE', '03-37-16-75-19', '03-71-48-28-81', '1946-07-06 00:00:00.000', 0.382965, 17700, '043DB78D-5F8C-4718-A177-8B6EC79D2D3F', 6, 2),
(1661, 'CHARBIT', 'Pascal', 'M.', '23 Rue Gambetta', NULL, NULL, '86490', 'BEAUMONT LA TRICHERIE', '02-48-90-26-37', '02-16-03-29-43', '1968-08-08 00:00:00.000', 0.107005, NULL, 'D38D50FD-1921-480E-9988-B6453BE28ED5', 6, 2),
(1662, 'MIRAILLES', 'Guy', 'M.', '128 Rue Lecourbe', NULL, NULL, '06400', 'CANNES', '04-91-36-34-99', '04-04-60-69-22', '1937-04-26 00:00:00.000', 0.734956, 16200, '7CFA6782-16B5-4B6E-8656-5BFD1F877A4F', 6, 2),
(1663, 'MARTINEZ', 'Alain', 'M.', '22 Rue du Raincy', NULL, NULL, '31250', 'REVEL', '01-27-20-22-83', '01-07-78-63-26', '1962-03-28 00:00:00.000', 0.765931, 19900, '2BCE3D8D-05F2-4C7B-B110-47FB02A19F25', 6, 2),
(1664, 'DAVROULT', 'Christophe', 'M.', '29 Rue de la Butte', NULL, NULL, '92300', 'LEVALLOIS PERRET', '03-45-81-01-71', '03-15-04-30-61', '1963-05-14 00:00:00.000', 0.0760299, 2100, 'B6DFB58E-15A4-4EAD-A7F6-784B4CBAE2FD', 4, 2),
(1665, 'GAILLARD-PACINI', 'Andr', 'M.', '45 Bd de la Croisette', NULL, NULL, '91620', 'LA VILLE DU BOIS', '00-88-34-50-66', '00-53-58-65-84', '1930-12-04 00:00:00.000', 0.453363, 1600, 'D39A6BF0-40F6-4FF6-8961-70E26AA8F42E', 6, 2),
(1666, 'VALLE', 'Enguerrand', 'M.', '19 Bd Denfert Rochereau', NULL, NULL, '78860', 'SAINT NOM LA BRETECHE', '00-05-32-59-09', '00-74-35-87-41', '1975-12-05 00:00:00.000', 0.149244, 22600, 'D0A37623-DE9C-4D7B-A5B2-54BF1D78B16A', 6, 2),
(1667, 'CHAGNARD', 'Jean-Claude', 'M.', '15 Rue Trbois', NULL, NULL, '78120', 'GAZERAN', '02-24-35-11-73', '02-92-51-25-45', '1947-07-01 00:00:00.000', 0.996836, 23800, '91EDB3F5-692A-4209-87D8-B9321916E76C', 6, 2),
(1668, 'LEROY', 'Chantal', 'Mme.', '71 Avenue de la Division Leclerc', NULL, NULL, '01380', 'BAG LA VILLE', '00-36-41-29-75', '00-74-20-28-77', '1956-12-05 00:00:00.000', 0.613871, 17600, 'BE8E1C4E-B31A-4B9C-92EC-865DE40E9461', 6, 1),
(1669, 'BARBARISI', 'Philippe', 'M.', '46 Rue Charles De Gaulle', NULL, NULL, '16160', 'LE GOND PONTOUVRE', '02-12-04-95-33', '02-90-05-05-22', '1950-02-19 00:00:00.000', 0.687085, 8300, 'E025827F-6C9D-45C0-9551-E8590C730689', 6, 2),
(1670, 'GONTIER', 'Daniel', 'M.', '11 Avenue du Gnral De Gaulle', NULL, NULL, '34970', 'LATTES', '01-21-05-61-78', '01-24-65-82-02', '1956-09-03 00:00:00.000', 0.537841, 18100, 'D2F2FF4A-9855-4472-A916-3FBC21F268FA', 6, 2),
(1671, 'IDOHOU', 'Jean-Paul', 'M.', 'Le Reponet', NULL, NULL, '26100', 'ROMANS', '03-63-17-04-40', '03-70-52-12-47', '1947-05-05 00:00:00.000', 0.0197115, 9000, '6FE602AA-792F-4209-9052-15783ADC428F', 1, 2),
(1672, 'STRICHARD', 'Mourissilou', 'M.', '200 Route de Paris', NULL, NULL, '94800', 'VILLEJUIF', '01-87-88-87-79', '01-08-13-06-74', '1949-06-29 00:00:00.000', 0.889831, 18900, 'EB442A80-63C2-47E8-9AD1-D28A2E311B96', 6, 2),
(1673, 'BOULAY', 'Charles-Jacques', 'M.', 'Les Palatines', '3 Rue des Jonquilles', NULL, '75017', 'PARIS', '03-64-22-00-86', '03-87-47-40-55', '1937-10-09 00:00:00.000', 0.377334, 4700, 'FA4EE048-8E2A-412D-BCC0-2699BDCECB03', 6, 2),
(1674, 'BORNAND', 'Franoise', 'Mme.', '56 Place Jean Jaurs', NULL, NULL, '92110', 'CLICHY', '04-39-88-10-82', '04-35-12-08-86', '1957-10-03 00:00:00.000', 0.633582, 23500, 'EC8F6492-0728-4C2E-BE28-AFA5ECB78501', 6, 1),
(1675, 'SPARANO', 'Grard', 'M.', '92 Rue Henri Barbusse', NULL, NULL, '05000', 'GAP', '00-42-59-62-55', '00-24-77-58-83', '1954-05-02 00:00:00.000', 0.636398, 9200, '21970C93-EECD-4459-825C-940BB68CD7A8', 6, 2),
(1676, 'LAIGNEAU', 'Franois', 'M.', '11 Bis Avenue Mac Mahon', NULL, NULL, '13013', 'MARSEILLE', '01-00-44-22-16', '01-77-44-36-25', '1936-10-04 00:00:00.000', 0.0760299, 19100, 'DD999D7B-7859-4BB7-843D-813C69C01625', 6, 2),
(1677, 'CLUGNAC', 'Eric', 'M.', '62 Bd Jean Jaurs', NULL, NULL, '75008', 'PARIS', '03-91-75-82-19', '03-04-38-63-23', '1943-02-06 00:00:00.000', 0.0872936, 21800, 'A8CDEC19-EC9D-4786-9C52-682C26BF4B66', 6, 2),
(1678, 'LAGIER', 'Nicole', 'Mme.', 'Le Neptune', '136 Bd Georges Pompidou', NULL, '93150', 'LE BLANC MESNIL', '01-51-92-62-95', '01-80-60-09-36', '1942-12-07 00:00:00.000', 0.247801, 4800, '02A82033-51C1-420C-9560-CC37220AE121', 1, 1),
(1679, 'VASSARD', 'Jean-Luc', 'M.', '40 Traverse Montcault - Bt. A 1', NULL, NULL, '25300', 'PONTARLIER', '05-27-26-33-95', '05-60-51-35-24', '1948-02-28 00:00:00.000', 0.94615, 20900, '07E3AE2B-48B7-46A7-87F1-B7F28407C293', 6, 2),
(1680, 'NICOL', 'Roger', 'M.', '16 Avenue Hoche', NULL, NULL, '93250', 'VILLEMOMBLE', '00-03-66-49-21', '00-60-73-28-05', '1939-09-04 00:00:00.000', 0.51813, 6500, '839DD5CF-57EA-42C2-843D-FA330CED35A1', 6, 2),
(1681, 'CNUDDE', 'Philippe', 'M.', '11 Rue de la Victoire', NULL, NULL, '22410', 'SAINT QUAY PORTRIEUX', '01-88-03-89-53', '01-33-93-34-25', '1961-11-14 00:00:00.000', 0.619503, 5600, '3E4CA5D3-4F21-4B31-B4DF-65B7D2BD826E', 6, 2),
(1682, 'HERITIER', 'Danielle', 'Mme.', '17 Rue du Docteur Grenier', NULL, NULL, '91400', 'ORSAY', '01-16-13-22-49', '01-27-76-09-32', '1945-02-15 00:00:00.000', 0.0535025, 9300, '9931AB50-ADC6-4022-97F5-6058D01699A9', 6, 1),
(1683, 'ROUGIER', 'Marie-Christine', 'Mme.', '53 Avenue du Raincy', NULL, NULL, '42100', 'SAINT TIENNE', '04-39-79-55-85', '04-74-45-81-25', '1957-06-17 00:00:00.000', 0.833513, 21900, '519B56B5-A2C6-4F42-8EA3-55C9E07359B2', 6, 1),
(1684, 'DJANETT', 'Pascal', 'M.', '28 Bis Quai de la Rpublique', NULL, NULL, '77160', 'PROVINS', '02-42-76-21-10', '02-01-97-55-90', '1962-11-30 00:00:00.000', 0.340727, 1700, 'DC9FE865-F969-482F-B3D6-19284AAC280F', 6, 2),
(1685, 'LENTHERIC', 'Robert', 'M.', '4 Rue Verrier', NULL, NULL, '52000', 'CHAUMONT', '05-24-65-27-68', '05-72-37-46-29', '1932-06-01 00:00:00.000', 0.154876, 9300, 'D72EF79B-77F3-4AFB-8085-19F0381BDED2', 5, 2),
(1686, 'BAUDOT', 'Rgine', 'Mme.', '15 Rue Joseph Pupier', NULL, NULL, '30000', 'NIMES', '00-89-96-73-79', '00-99-81-31-66', '1956-02-23 00:00:00.000', 0.802538, 8600, '80C967BA-CC1B-4BBC-BD2B-DBFA50326384', 6, 1),
(1687, 'DASSONVILLE', 'Daniel', 'M.', '6 Place Saint Ayoul', NULL, NULL, '92340', 'BOURG LA REINE', '02-44-14-63-27', NULL, '1946-02-12 00:00:00.000', 0.622319, 5000, '8FE849C0-9A96-47C3-9214-C794785130B2', 6, 2),
(1688, 'ROUY', 'Denise', 'Mme.', '48 Bis Rue Robespierre', NULL, NULL, '71000', 'MACON', '01-09-18-63-68', '01-08-96-59-15', '1947-05-04 00:00:00.000', 0.689901, 12500, 'F7220CAB-D5D4-405D-83AF-CA8ADA61EA08', 6, 1),
(1689, 'AUFFRET', 'Jean-Pierre', 'M.', '70 Bd Gambetta', NULL, NULL, '14360', 'TROUVILLE SUR MER', '04-88-77-48-68', '04-32-93-67-73', '1946-07-10 00:00:00.000', 0.397045, 4500, 'AB06CF25-034E-4EF6-8858-6181BEAE3101', 6, 2),
(1690, 'BERNARD', 'Jean-Philippe', 'M.', '20 Rue de Fontenay', NULL, NULL, '75013', 'PARIS', '00-34-06-74-69', '00-80-56-51-85', '1959-07-22 00:00:00.000', 0.247801, 13200, '860EE01B-C0CC-49ED-B0F8-BFD771D2404C', 6, 2),
(1691, 'SERRIER', 'Claude', 'M.', '35 Rue Gambetta', NULL, NULL, '44000', 'NANTES', '00-37-49-10-05', '00-08-93-06-58', '1944-07-22 00:00:00.000', 0.405493, 13500, 'D3FFCC62-1E54-4DDF-86B3-A4D4AD204FE0', 6, 2),
(1692, 'RAPNOUIL', 'Christian', 'M.', '20 Place du Casino', NULL, NULL, '88000', 'EPINAL', '04-90-12-20-48', '04-48-21-47-81', '1954-11-14 00:00:00.000', 0.397045, 4000, '618200D7-A43E-4B08-87A7-5DD18497FB78', 2, 2),
(1693, 'BARB', 'Monique', 'Mme.', '9 Villa d''Este', 'Appartement 2182', NULL, '33000', 'BORDEAUX', '02-96-05-06-51', '02-01-07-50-43', '1942-04-02 00:00:00.000', 0.380149, 3100, '3D5E54F3-AE07-4889-9F8E-CD9423ADE829', 6, 1),
(1694, 'BONNET', 'Andr', 'M.', '11 Rue Dugommier', NULL, NULL, '92400', 'COURBEVOIE', '04-68-28-43-85', '04-50-75-82-56', '1930-07-06 00:00:00.000', 0.0563184, 7900, 'F0D4803B-7DF6-4018-ACFA-D22F92584C05', 6, 2),
(1695, 'YOU', 'Luc', 'M.', 'Centre des Quatre Nations', '1 Avenue Marchal De Lattre', 'de Tassigny', '78100', 'SAINT GERMAIN EN LAYE', '04-48-57-70-08', NULL, '1963-09-21 00:00:00.000', 0.85604, 14800, 'C744F602-7886-4A01-926E-7ACED8A2A994', 6, 2),
(1696, 'LEROY', 'Reine', 'Mme.', '10 Place Gambetta', NULL, NULL, '79200', 'PARTHENAY', '04-10-17-92-82', '04-54-98-80-79', '1940-06-02 00:00:00.000', 0.788458, 16200, '31F91335-60BD-4C43-97D9-C08571741AB8', 6, 1),
(1697, 'PERINETTO', 'Jol', 'M.', '97/99 Bd St Denis', NULL, NULL, '75015', 'PARIS', '04-87-86-15-85', '04-05-15-39-75', '1961-04-28 00:00:00.000', 0.501234, 19400, '3BFE9CFE-2ABD-48C3-BE45-0556D4A1AE74', 6, 2),
(1698, 'ANGELOTTI', 'Franois', 'M.', '5 Rue de la Rpublique', NULL, NULL, '75017', 'PARIS', '04-86-83-19-84', '04-29-01-55-11', '1970-01-11 00:00:00.000', 0.802538, 25000, '34A0CC3D-39CC-452A-8CC3-A9F177003763', 6, 2),
(1699, 'AUFMAN', 'Louis-Pierre', 'M.', 'Rsidence Beaumanoir', '18 Bd des Sires de Parthenay', NULL, '34500', 'BZIERS', '01-48-33-75-15', '01-58-97-52-46', '1953-08-03 00:00:00.000', 0.520946, NULL, '972E2870-8BDE-4D65-A23F-9E4299BFDFD2', 1, 2),
(1700, 'ENDERS', 'No-Maurice', 'M.', '15 Rue Olivier de Serres', NULL, NULL, '75009', 'PARIS', '03-62-44-23-88', '03-26-31-02-53', '1938-12-11 00:00:00.000', 0.833513, 6900, '7B23258A-FB4D-4061-BCA7-971584CB0E87', 6, 2),
(1701, 'PROVINI', 'Sylvie', 'Mme.', '13 Rue du Docteur Heulin', NULL, NULL, '92100', 'BOULOGNE', '00-76-64-15-44', '00-59-54-92-11', '1945-04-23 00:00:00.000', 0.402677, 10900, '12965B4F-15B3-4822-9910-0CBB15A3F4AD', 6, 1),
(1702, 'BARR', 'Jolle', 'Mme.', '65 Avenue Clmenceau', NULL, NULL, '75012', 'PARIS', '00-80-63-46-67', '00-36-96-76-37', '1955-03-22 00:00:00.000', 0.0394229, 1900, '42092EE6-AEDE-48C3-BA84-688CCF070445', 6, 1),
(1703, 'PITOUT', 'Pierre', 'M.', '21 Rue Le Peletier', NULL, NULL, '31000', 'TOULOUSE', '01-43-94-85-12', '01-67-85-60-91', '1943-03-20 00:00:00.000', 0.185851, 6900, '9574C3B6-4120-4DFF-A79A-332A719AD85B', 6, 2),
(1704, 'GUGENHEIM', 'Frdric', 'M.', '65 Rue des Tilleuls', NULL, NULL, '31240', 'L''UNION', '04-73-21-50-71', '04-15-63-13-35', '1962-11-21 00:00:00.000', 0.673005, 2800, 'D062E463-CB1C-4D7C-86C9-46C7956BA332', 6, 2),
(1705, 'CHESSEL', 'Alain', 'M.', '76 Rue de Wattignies', NULL, NULL, '75017', 'PARIS', '03-80-58-22-07', '03-09-53-24-91', '1946-04-28 00:00:00.000', 0.0929254, 16000, '6BA60B26-CED8-4701-87F6-F271AF748664', 6, 2),
(1706, 'DUBOIS', 'Jacques', 'M.', '54 Bis Rue Alsace-Lorraine', NULL, NULL, '69006', 'LYON', '01-82-26-18-93', NULL, '1944-05-21 00:00:00.000', 0.906727, 22000, '1554EA92-D166-4B7A-9089-2A6CD6302152', 1, 2),
(1707, 'DARANCETTE', 'Louis', 'M.', '55 Avenue de Toulouse', NULL, NULL, '97200', 'FORT DE FRANCE', '04-02-66-89-85', '04-24-63-24-55', '1957-12-03 00:00:00.000', 0.726508, 24900, 'EE074955-EC46-4526-B506-D2C1B50A7EDA', 6, 2),
(1708, 'LEVEN', 'Marie-Thrse', 'Mme.', '58 Avenue de Wagram', NULL, NULL, '94120', 'FONTENAY SOUS BOIS', '00-35-28-01-05', '00-65-45-26-72', '1962-09-04 00:00:00.000', 0.757483, 3000, 'B1D1C917-324E-49F6-A161-CBA29573D604', 6, 1),
(1709, 'MONTAMAT', 'Jos', 'M.', '18 Quai Gnral Sarrail', NULL, NULL, '67000', 'STRASBOURG', '04-68-94-27-14', '04-28-69-16-31', '1955-08-19 00:00:00.000', 0.965861, NULL, '50260BBD-7FFA-4044-934B-F008742303F3', 6, 2),
(1710, 'LAURENTI', 'Eric', 'M.', '66 Bd du Gnral De Gaulle', NULL, NULL, '31150', 'LESPINASSE', '01-12-92-87-83', '01-34-53-22-63', '1966-02-01 00:00:00.000', 0.563184, 9500, '8B4592F3-E871-4151-8EF3-A66A3831560C', 6, 2),
(1711, 'CHEVALIER', 'Alphonse', 'M.', '49 Rue Roublot', NULL, NULL, '06300', 'NICE', '00-90-69-60-98', '00-87-02-94-58', '1912-08-09 00:00:00.000', 0.382965, NULL, '7A0390E2-2BB8-4F69-9B0F-401BE4EAA811', 6, 2),
(1712, 'CHEVALIER', 'Guy', 'M.', '61 Alle de La Robertsau', NULL, NULL, '75018', 'PARIS', '04-32-46-45-48', '04-80-35-45-93', '1941-06-03 00:00:00.000', 0.895463, 18100, 'E8CD3549-65AD-48B4-B8D0-76E3E2CB92AB', 6, 2),
(1713, 'BATAILLE', 'Grard', 'M.', '4 Route de l''Hers', NULL, NULL, '95310', 'SAINT OUEN L''AUMONE', '02-30-12-79-30', '02-36-09-21-52', '1943-10-07 00:00:00.000', 0.898279, 16300, '1C49F02B-B879-4E4A-B0B1-A318E93A2800', 5, 2),
(1714, 'BARD', 'Claude', 'M.', 'Le Porquerolles A', '10 Rue du Bal', NULL, '31000', 'TOULOUSE', '04-23-36-05-58', '04-01-27-75-12', '1947-07-05 00:00:00.000', 0.0281592, 9900, '73CFD092-61B4-4D5F-BAD2-12C916A6854A', 6, 2),
(1715, 'DI LUCA', 'Michel', 'M.', '95 Rue Caulaincourt', NULL, NULL, '69100', 'VILLEURBANNE', '03-17-13-84-46', '03-87-87-64-47', '1938-12-29 00:00:00.000', 0.180219, 22400, 'A9ACCF5A-E234-4190-A608-89C6BBBA11FD', 6, 2),
(1716, 'BILLARD', 'Jacqueline', 'Mme.', '8 Avenue du Gnral Leclerc', NULL, NULL, '66120', 'FONT ROMEU', '03-80-45-31-06', '03-26-32-59-78', '1938-09-13 00:00:00.000', 0.315383, 19900, '7CA82806-E426-4A3E-8FCF-897D8466BDF4', 6, 1),
(1717, 'VISSE', 'Pierre', 'M.', 'Passage Saint Jrme', '18 Rue Maurice Fonvieille', NULL, '74220', 'LA CLUSAZ', '00-94-04-57-81', '00-74-56-20-67', '1961-10-07 00:00:00.000', 0.143612, 16400, '46B6D730-CADC-4392-B794-9B7171D5C73C', 6, 2),
(1718, 'BOLOGNINI', 'Bernard', 'M.', '57 Cours Emile Zola', NULL, NULL, '83700', 'SAINT RAPHAEL', '03-52-84-19-76', '03-75-72-61-02', '1930-08-15 00:00:00.000', 0.771563, NULL, '9C31F5C6-1BDF-4D6F-91A8-EB25EADD1087', 6, 2),
(1719, 'GUITON', 'Danielle', 'Mme.', '27 Rue Maillol', NULL, NULL, '34400', 'LUNEL', '01-39-94-11-00', '01-57-12-51-77', '1946-10-11 00:00:00.000', 0.619503, 6200, 'B6E89FE0-D64B-4E61-BB05-A02CCF6BDB62', 6, 1),
(1720, 'RENARD', 'Jol', 'M.', 'Rsidence la Perrire', NULL, NULL, '71500', 'LOUHANS', '04-48-82-95-36', '04-49-66-81-82', '1951-01-24 00:00:00.000', 0.664558, 2600, '9ED00177-5747-4420-9FF4-A88C11A53EDE', 2, 2),
(1721, 'MARLY', 'Ren', 'M.', 'Parc Santa Lucia', NULL, NULL, '89140', 'PONT SUR YONNE', '05-86-98-07-41', '05-38-08-16-32', '1954-11-28 00:00:00.000', 0.101373, 21600, 'AFB38A75-3C12-44A1-A22C-742FFBF87471', 6, 2),
(1722, 'LE THIES', 'Christian', 'M.', '76 Bd de Strasbourg', NULL, NULL, '06110', 'LE CANNET', '00-63-01-94-33', '00-53-73-93-69', '1955-01-05 00:00:00.000', 0.219642, 21800, '63A69366-E406-4E4D-BE49-81D5EE6EDB2E', 6, 2),
(1723, 'RAMEAU', 'Pierre', 'M.', '8 Rue Edgar Guigot', NULL, NULL, '93100', 'MONTREUIL', '00-46-31-84-80', '00-76-94-45-33', '1950-02-27 00:00:00.000', 0.19993, 11700, 'B999178F-983D-4CC9-92E3-E98AEE4700F3', 6, 2),
(1724, 'BRACKE', 'Jean-Claude', 'M.', '17 Place Eugne Petit', NULL, NULL, '89000', 'AUXERRE', '05-73-80-74-41', '05-25-34-57-07', '1937-09-27 00:00:00.000', 0.853224, 1200, 'E239DC5B-98D2-4B95-9E4B-416A5E0F070E', 6, 2),
(1725, 'THEROND', 'Jacques', 'M.', '6 Rue des Michels', NULL, NULL, '92400', 'COURBEVOIE', '02-67-27-24-62', '02-72-99-43-58', '1948-11-16 00:00:00.000', 0.326647, 15200, '7A9FA5CB-F49D-4120-BF75-AAABB77A7D23', 6, 2),
(1726, 'PREAULT', 'Lionel', 'M.', '49 Rue Etienne Marcel', NULL, NULL, '78500', 'SARTROUVILLE', '02-94-82-59-94', '02-58-43-46-54', '1966-03-27 00:00:00.000', 0.236537, 18500, '86E75157-FA86-4D96-AEBE-6F300A4C4109', 6, 2),
(1727, 'CHEETHAM', 'Jean-Pierre', 'M.', '6 Bis Avenue Gambetta', NULL, NULL, '26000', 'VALENCE', '00-86-03-09-03', '00-12-15-89-32', '1938-04-15 00:00:00.000', 0.118269, 18200, '5AE2C816-AB44-432D-B42F-66EBFBECEDED', 3, 2),
(1728, 'HUDELLET', 'John', 'M.', '85/87 Rue de Bezons', NULL, NULL, '13410', 'LAMBESC', '03-62-36-38-90', '03-21-11-20-72', '1917-10-18 00:00:00.000', 0.453363, 14000, '4A805414-761E-457D-96DB-300B238ADA8B', 6, 2),
(1729, 'BRUN', 'Pierre', 'M.', '7 Avenue de la Rpublique', NULL, NULL, '66000', 'PERPIGNAN', '05-34-03-30-56', '05-98-97-21-27', '1946-02-21 00:00:00.000', 0.0844777, 6000, 'D144DFFD-EF78-4A8C-A84A-F1C66A4681BB', 6, 2),
(1730, 'PICARD', 'Guy', 'M.', 'Immeuble CIME', '471 Avenue Victor Hugo', NULL, '83140', 'SIX FOURS LES PLAGES', '05-91-36-37-12', '05-72-80-29-33', '1938-12-17 00:00:00.000', 0.546289, 21600, 'C9152DD3-FAD5-4A51-90C7-7FC40A29E6E8', 6, 2),
(1731, 'BOURBON', 'Jacqueline', 'Mme.', '2 Route d''Aix en Provence', NULL, NULL, '77610', 'FONTENAY TRESIGNY', '00-86-55-74-46', '00-64-01-16-59', '1924-11-28 00:00:00.000', 0.487155, 10100, 'D5CB0F78-1C91-4B8B-8785-5B5C7ECE6D50', 6, 1),
(1732, 'MARIN', 'Sbastien', 'M.', '15 Bis Rue Rempart Villeneuve', NULL, NULL, '01210', 'FERNEY VOLTAIRE', '05-06-25-07-22', '05-34-08-76-47', '1972-08-02 00:00:00.000', 0.301304, NULL, 'FF40C707-CC4C-47A6-8D14-1BF5555005A8', 6, 2),
(1733, 'ALOISI', 'Laurent', 'M.', '1884 Avenue de la Mer', NULL, NULL, '64600', 'ANGLET', NULL, NULL, '1968-12-10 00:00:00.000', 0.340727, 11900, 'DA3FC713-A003-41B6-A14D-551BC1E71AA1', 6, 2),
(1734, 'ANTOINE', 'Jean-Pierre', 'M.', '3 Bd Etienne Hardy', NULL, NULL, '83300', 'DRAGUIGNAN', '02-70-81-24-69', '02-57-42-33-80', '1950-12-15 00:00:00.000', 0.79409, 12700, '0F6683C0-F365-49CA-82BD-50F87B361847', 7, 2),
(1735, 'AUMEUNIER', 'Jean-Christophe', 'M.', 'Centre Commercial de la Poterie', 'Chemin de la Brunette', NULL, '83120', 'SAINTE MAXIME', '00-50-09-62-00', '00-39-27-21-65', '1961-06-08 00:00:00.000', 0.391413, 200, '6751489B-CB88-4A74-AC48-8830991D259B', 6, 1),
(1736, 'DUBOIS', 'Pierre', 'M.', '12 Rue Hausseguy', NULL, NULL, '39000', 'LONS LE SAUNIER', '01-67-55-74-98', '01-32-16-72-22', '1942-11-16 00:00:00.000', 0.701165, 5100, '2AF07069-F64D-4CE3-A610-46F653045837', 6, 2),
(1737, 'BARDOU', 'Jean-Marc', 'M.', '18 Bd Georges Clmenceau', NULL, NULL, '69290', 'SAINT GENIS LES OLLIERES', '00-16-66-77-62', '00-56-89-95-83', '1944-03-22 00:00:00.000', 0.709612, 15400, 'E8AAF5E8-15F8-4074-8B88-1F03216E5E92', 6, 2),
(1738, 'DE VALUKHOFF', 'Charles', 'M.', '"Le Splendid Azur B"', 'Bd De Lattre de Tassigny', NULL, '78100', 'SAINT GERMAIN EN LAYE', NULL, '01-02-71-71-56', NULL, 0.906727, 1600, 'E1A1943D-CCA9-4E6B-9BE9-CFBB02F34FAB', 6, 2),
(1739, 'BARBERET', 'Alex', 'M.', '11 Rue Lafayette', NULL, NULL, '74440', 'MORILLON', '03-70-75-88-48', '03-48-99-88-39', '1966-12-18 00:00:00.000', 0.171771, 2800, 'F2D7F992-65F6-4BB5-9678-5684293EBE82', 6, 2),
(1740, 'CHUZEL', 'Hlne', 'Mme.', '8 Place Georges Pompidou', NULL, NULL, '75008', 'PARIS', '05-76-75-58-69', '05-32-55-94-32', '1947-07-26 00:00:00.000', 0.0197115, 21900, '2D905CFA-E408-40FF-9C19-48DC76819B36', 6, 1),
(1741, 'SALOMON', 'Daniel', 'M.', '5/7 Rue du Vieux March', NULL, NULL, '38142', 'AURIS EN OISANS', '01-09-50-26-91', '01-14-86-41-10', '1948-11-10 00:00:00.000', 0.909543, 1400, 'C06E21E7-E49E-4AF7-A571-033AFB667441', 4, 2),
(1742, 'SACKREUTER', 'Yvonne', 'Mme.', 'Les Esserts', NULL, NULL, '06400', 'CANNES', '03-27-17-68-76', '03-41-35-68-42', '1932-09-22 00:00:00.000', 0.273144, 3200, '98EA1645-A7E1-4104-B472-F5F2F5DEBF4D', 6, 1),
(1743, 'BRARD', 'Rodolphe', 'M.', 'SDM Artisans Contact', '38 Rue de Berri', NULL, '67000', 'STRASBOURG', '05-20-10-28-06', '05-38-61-10-08', '1943-01-31 00:00:00.000', 0.506866, 14400, 'D7519924-39CB-49DE-AE78-E767E7E613EE', 6, 2),
(1744, 'FOULON', 'Dominique', 'M.', 'Les Balcons de l''Oisans', NULL, NULL, '05100', 'BRIANCON', '05-79-69-49-95', '05-64-31-87-91', '1956-09-07 00:00:00.000', 0.242169, 4400, '3E078FF7-7C9E-4204-A357-1D4A12C5DC3C', 6, 2),
(1745, 'CHOMBART', 'Jean', 'M.', '17 Rue Rouaze', NULL, NULL, '60600', 'CLERMONT', '04-21-11-97-15', '04-82-15-91-02', '1949-01-15 00:00:00.000', 0.892647, 9600, 'BF427E4C-F2DB-4BB1-90BA-771ABF6EBD49', 6, 2),
(1746, 'RIFFIOD', 'Etienne', 'M.', '85 Avenue des Vosges', NULL, NULL, '59273', 'FRETIN', '01-33-51-80-19', '01-84-43-68-40', '1938-09-28 00:00:00.000', 0.991205, 11700, '071C2A4E-A565-494C-8BD0-C63DBC09A040', 6, 2),
(1747, 'ERKER', 'Alain', 'M.', '13 Avenue Maurice Petsche', NULL, NULL, '39000', 'LONS LE SAUNIER', '00-06-85-40-67', '00-66-93-75-05', '1949-06-06 00:00:00.000', 0.864488, 19200, 'FD2D2181-7156-42BA-B722-1A23818B92B9', 6, 2),
(1748, 'SARRAZIN', 'Robert', 'M.', '55 Ter Rue de Paris', NULL, NULL, '06330', 'ROQUEFORT LES PINS', '02-02-84-45-44', NULL, NULL, 0.211194, 5800, 'C387F293-F323-47C3-9B80-B950251B67D8', 7, 2),
(1749, 'ARANEGA', 'Chantal', 'Mme.', 'Centre de Gros n1', 'Rue des Famards', NULL, '84220', 'CABRIERES D''AVIGNON', '02-21-00-12-12', '02-57-30-17-16', '1945-10-11 00:00:00.000', 0.917991, 8200, 'E38DCF3A-1340-46F2-9862-0CC83AEABF71', 6, 1),
(1750, 'COURT-DEMBA', 'Vronique', 'Mme.', '18 Rue Lafayette', NULL, NULL, '69230', 'SAINT GENIS LAVAL', '02-37-13-67-16', NULL, '1958-01-16 00:00:00.000', 0.881384, 22100, '8837C0CF-28D9-4E8B-8404-4E542CE775C8', 6, 1),
(1751, 'BOUVET', 'Myriam', 'Mme.', 'Route de Valbonne', NULL, NULL, '26200', 'MONTELIMAR', '05-87-96-20-79', '05-53-79-26-08', '1967-05-08 00:00:00.000', 0.867304, 24100, '00EA69A3-2D06-4475-8A9A-CBCEC7F52DFC', 6, 1),
(1752, 'GAZEAU', 'Vincent', 'M.', 'Place de l''Ancienne Mairie', NULL, NULL, '75008', 'PARIS', '05-79-00-49-20', '05-70-53-03-82', '1961-08-13 00:00:00.000', 0.8842, NULL, '4C54574E-FC24-4E2E-87D4-04FEDAE8F7DB', 6, 2),
(1753, 'LEVY', 'Alain', 'M.', '128 Avenue Georges Clmenceau', NULL, NULL, '18000', 'BOURGES', '02-78-17-91-34', '02-72-43-70-47', '1949-12-12 00:00:00.000', 0.0478707, 3600, '702A07A1-D3F4-478C-91B5-D55B9E67D2C1', 6, 2),
(1754, 'JAMES', 'Georges', 'M.', '21 Rue Pierre Julien', NULL, NULL, '06600', 'ANTIBES', '00-81-12-34-31', '00-92-93-47-25', '1947-09-29 00:00:00.000', 0.867304, 5200, 'F83C84A8-3118-4A39-94DC-D7908E34D05D', 6, 2),
(1755, 'DURAND', 'Jean', 'M.', '30 Rue de Saint Petersbourg', NULL, NULL, '92160', 'ANTONY', NULL, '02-19-49-59-24', '1945-11-05 00:00:00.000', 0.160508, 15100, 'BC6291BC-73EA-444C-8BC2-34E2B9F25024', 4, 2),
(1756, 'DENNER', 'Marc', 'M.', '19 Bd de la Rpublique', NULL, NULL, '95150', 'TAVERNY', '02-47-51-71-21', '02-90-50-26-31', '1956-02-16 00:00:00.000', 0.202746, 2700, '80ACBD87-F4B8-4AC8-A88F-FDCD898C6600', 6, 2),
(1757, 'PARDINEILLE', 'Chantal', 'Mme.', '13 Cours Massna', NULL, NULL, '67000', 'STRASBOURG', '04-50-23-22-85', '04-24-97-37-07', '1953-11-17 00:00:00.000', 0.760299, 0, '406DD0F0-01AB-4B99-A0EB-222E184ADDC9', 6, 1),
(1758, 'KERHERV', 'Bernadette', 'Mme.', '47 Bis Avenue Aristide Briand', NULL, NULL, '66420', 'LE BARCARES', '02-27-12-82-21', '02-43-37-60-90', '1945-11-02 00:00:00.000', 0.810986, 6200, 'C0CD20AE-4984-4D5C-8CC5-9D4ECCCC440E', 6, 1),
(1759, 'BERGUIG', 'Ren', 'M.', '4 Place de la Gare', NULL, NULL, '83400', 'HYERES', '01-97-21-70-00', '01-31-75-72-39', '1948-06-23 00:00:00.000', 0.920807, 12200, 'EBBFBA68-C5BC-4C30-AF65-C3530023F5B0', 6, 2),
(1760, 'PILA', 'Roger', 'M.', '4 Quai Rouget de Lisle', NULL, NULL, '75017', 'PARIS', '03-37-87-20-20', '03-72-36-61-14', '1949-04-07 00:00:00.000', 0.278776, 15800, '77772D4A-20D4-4938-A824-A753D5131383', 6, 2),
(1761, 'GRENON', 'Grard', 'M.', 'Rsidence Le Parc de la Mer', NULL, NULL, '69002', 'LYON', '03-52-08-44-72', '03-59-36-91-99', '1938-02-26 00:00:00.000', 0.109821, 600, '0F5DA961-2EB6-4FD9-9CDF-9DA65433ABE9', 6, 2),
(1762, 'EDERY', 'Loc', 'M.', '505 Chemin des Rougires', NULL, NULL, '85160', 'SAINT JEAN DE MONTS', '03-77-04-28-58', '03-46-25-28-03', '1947-08-27 00:00:00.000', 0.101373, NULL, 'F2AAB56B-6826-497B-A031-E0CF767BD16B', 1, 2),
(1763, 'BERNIE', 'Jacques', 'M.', '14 Rue Jouffroy d''Abbans', NULL, NULL, '93250', 'VILLEMOMBLE', '01-61-33-80-16', '01-31-61-31-10', '1940-12-04 00:00:00.000', 0.999652, 4000, 'CB8FA09B-5EA6-4B33-BE0C-153A30F24CE3', 6, 2),
(1764, 'TAJETTI', 'Jean-Luc', 'M.', '29 Quai Saint Antoine', NULL, NULL, '75008', 'PARIS', '02-77-41-38-68', '02-63-50-61-08', '1951-03-10 00:00:00.000', 0.157692, 22700, '85B4F063-4242-4B55-9D2E-2DD54AB96AFA', 6, 2),
(1765, 'HANGARD', 'Bernard', 'M.', '67 Esplanade de la Mer', NULL, NULL, '54700', 'PONT A MOUSSON', '02-76-82-94-51', '02-57-42-39-73', '1958-02-21 00:00:00.000', 0.619503, 5000, '1273348A-E2CD-4B07-9B7A-5C2F687057AA', 6, 2),
(1766, 'BONAN', 'Jacky', 'M.', '2 Bd Andr', NULL, NULL, '60600', 'CLERMONT', '02-75-04-75-98', '02-67-35-11-87', '1950-03-28 00:00:00.000', 0.19993, 16400, '1099FD25-F957-4064-9C83-07BFFB8E5227', 6, 2),
(1767, 'COGIS', 'Elise', 'Mme.', '11 Rue Marbeuf', NULL, NULL, '92340', 'BOURG LA REINE', '01-34-69-55-99', '01-05-80-06-92', '1936-05-07 00:00:00.000', 0.999652, 24100, '6A22790A-874B-410D-8ADF-0F63A0C38CA6', 6, 1),
(1768, 'SPRIET', 'Christian', 'M.', '3 Rue du 26 me BCP', NULL, NULL, '28410', 'ABONDANT', '04-62-77-88-56', '04-86-51-31-42', '1928-10-15 00:00:00.000', 0.481523, 2200, 'EA826921-F746-4DB7-97A9-888D5B81F955', 6, 2),
(1769, 'MALCOEFFE', 'Michel', 'M.', '28 Rue du Gnral De Gaulle', NULL, NULL, '84550', 'MORNAS', '04-00-08-80-71', '04-42-37-83-12', '1934-11-09 00:00:00.000', 0.872936, 12300, 'FAE472A9-B4B2-48C6-8CDA-5C1F5AE63B1E', 1, 2),
(1770, 'MAHISTRE', 'Philippe', 'M.', '155 Avenue du Gnral Leclerc', NULL, NULL, '74200', 'THONON LES BAINS', '04-51-15-25-78', '04-26-34-04-45', '1951-05-28 00:00:00.000', 0.0197115, 17700, '7251C1C1-C349-4AE4-B497-BA8408D43F9F', 6, 2),
(1771, 'MERCIER', 'Pierre', 'M.', '2 Rue des Glands', NULL, NULL, '75011', 'PARIS', '02-07-98-37-04', '02-49-53-73-18', '1942-02-19 00:00:00.000', 0.0816617, 13200, '9094ADEB-2FED-4C71-84B1-A1BD84F8E939', 6, 2),
(1772, 'BELLAICHE', 'Michel', 'M.', 'Quartier Bourganen', NULL, NULL, '66750', 'SAINT CYPRIEN PLAGE', '01-99-94-18-17', '01-89-69-42-85', '1938-09-28 00:00:00.000', 0.419572, 14900, '1CF81D45-8D5D-4ABE-9445-A1DA0DAD1EE9', 6, 2),
(1773, 'DEFOULOUNOUX', 'Patrick', 'M.', '5 Rue de Lort', NULL, NULL, '75017', 'PARIS', '03-83-47-04-35', '03-15-12-78-94', '1944-09-26 00:00:00.000', 0.450548, 11300, 'D1CEEFD9-0B2A-41DB-AE99-5956D310726C', 6, 2),
(1774, 'FESTOR', 'Christian', 'M.', '119 Rue de Montreuil', NULL, NULL, '69007', 'LYON', '00-04-23-46-23', NULL, '1953-06-06 00:00:00.000', 0.382965, 15300, '1D4DBF0C-E1D3-42A5-9DF1-3C9C3B0BD113', 6, 2),
(1775, 'VASSEUR', 'Charles', 'M.', '14 Bd Maillol', NULL, NULL, '75008', 'PARIS', '05-68-96-34-35', '05-71-84-01-44', '1954-03-22 00:00:00.000', 0.115453, 3300, '742A4C91-7D32-4D0E-A985-0D00C8E2CADB', 6, 2),
(1776, 'COHEN', 'Jean-Jacques', 'M.', '5 Rue de Logelbach', NULL, NULL, '66190', 'COLLIOURE', '04-87-85-70-38', '04-76-73-09-81', '1951-03-31 00:00:00.000', 0.636398, 22100, '557FC6BC-BEC0-4D59-931A-BF793831C77D', 5, 2),
(1777, 'FAURE', 'Joan', 'Mme.', '94 Rue Bechevelin', NULL, NULL, '92300', 'LEVALLOIS PERRET', '04-70-53-53-26', '04-45-96-56-48', '1970-02-08 00:00:00.000', 0.810986, 14100, '01280400-67CB-40E2-94D1-520B8B1C8188', 6, 1),
(1778, 'DUFFOUX', 'Francette', 'Mme.', '34 Avenue George V', NULL, NULL, '75019', 'PARIS', '04-35-80-54-09', '04-11-51-24-21', '1943-02-08 00:00:00.000', 0.0760299, 9300, 'A91E180F-B9D1-421A-92C5-41C4F955E76A', 6, 1),
(1779, 'PARROT', 'Alain', 'M.', '4 Rue du Temple', NULL, NULL, '75008', 'PARIS', '00-82-06-01-86', '00-75-48-37-97', '1961-02-15 00:00:00.000', 0.202746, 8300, '6550CD25-F2F0-4044-9983-511AC5196E9F', 6, 2),
(1780, 'GONIN', 'Bernard', 'M.', '87 Rue Louis Rouquier', NULL, NULL, '23300', 'LA SOUTERRAINE', '04-38-34-96-86', '04-84-82-81-88', '1950-08-20 00:00:00.000', 0.382965, NULL, '08080252-95B1-43C3-BE52-7F6D8681BD47', 6, 2),
(1781, 'CASENAVE', 'Edm', 'M.', '152 Rue de Flandre', NULL, NULL, '38000', 'GRENOBLE', '05-74-03-63-62', '05-47-28-50-95', '1948-08-03 00:00:00.000', 0.281592, NULL, '21DE9086-A889-4A05-AA40-291C0BF12289', 6, 2),
(1782, 'BOILEAU', 'Hubert', 'M.', '73 Bd Malesherbes', NULL, NULL, '31000', 'TOULOUSE', '02-85-89-62-13', '02-27-93-20-90', '1925-04-20 00:00:00.000', 0.768747, 8200, 'F07B31E3-73D8-465B-9DC6-D8160539CAC2', 6, 2),
(1783, 'COIFFARD', 'Pascal', 'M.', '10 Rue Font Froide', NULL, NULL, '74700', 'SALLANCHES', '05-93-68-64-67', '05-25-44-54-65', '1940-08-30 00:00:00.000', 0.968677, NULL, '9830B042-1151-4C70-8C6B-DAB8E89444B4', 2, 2),
(1784, 'DESNOTS', 'Lyliane', 'Mme.', '63 Cours Jean Jaurs', NULL, NULL, '84200', 'CARPENTRAS', '02-64-64-64-87', '02-95-88-37-82', '1951-10-13 00:00:00.000', 0.0591344, 7600, '1BC6CA21-665A-40D9-83B1-E3F18DA20BEE', 6, 1),
(1785, 'LAGLEYRE', 'Dominique', 'M.', '5 Bis Rue Gabriel Pri', NULL, NULL, '28000', 'CHARTRES', '03-12-73-27-88', '03-69-59-53-68', '1946-09-26 00:00:00.000', 0.625135, 16800, '71E82CB5-BEB9-4435-A971-4095EB79E50D', 6, 2),
(1786, 'BONNAFOUX', 'Colette', 'Mme.', '89 Rue de la Rpublique', NULL, NULL, '33700', 'MERIGNAC', '01-15-02-90-60', '01-22-72-52-27', '1930-04-17 00:00:00.000', 0.872936, 22600, '78D144AB-A816-403F-99E7-F539CC0CE7C8', 6, 1),
(1787, 'WEBRE', 'Franck', 'M.', '276 Cours de la Pyramide', NULL, NULL, '35400', 'SAINT MALO', '00-07-58-53-73', '00-75-96-09-92', '1967-10-30 00:00:00.000', 0.94615, 13300, '23954E70-DA0B-4830-911B-252574E1FBEE', 6, 2),
(1788, 'RIES', 'Roger', 'M.', '16 Place des Epars', NULL, NULL, '14000', 'CAEN', '05-14-59-88-76', '05-10-01-31-92', '1951-09-12 00:00:00.000', 0.861672, 3500, '03740576-FD5A-4E9A-949C-D834386302B2', 6, 2),
(1789, 'LENY', 'Pierre', 'M.', '40 Rue de la Libration', NULL, NULL, '33120', 'ARCACHON', '00-77-54-92-24', '00-67-12-13-56', '1944-09-25 00:00:00.000', 0.506866, 8600, '7F94BF04-323F-444A-AA3D-DD33BEB8B4A5', 6, 2),
(1790, 'POLIZZI', 'Francis', 'M.', '3 Rue Gouin de Beauchesne', NULL, NULL, '33000', 'BORDEAUX', '05-73-77-97-35', '05-99-96-95-23', '1953-08-07 00:00:00.000', 0.50405, NULL, 'AED2578F-E4A4-4C16-BF6B-1A1BF0C01B01', 1, 2),
(1791, 'BATTAREL-FLAUTRE', 'Marcel', 'M.', '8 Rue Saint Pierre', NULL, NULL, '13460', 'LES SAINTES MARIES DE LA MER', '01-65-55-54-66', '01-04-89-16-46', '1949-09-23 00:00:00.000', 0.765931, 3000, '952E9417-4BA0-47FE-A759-DBE48CC06EC7', 6, 2),
(1792, 'BONNET', 'Batrice', 'Mme.', '41 Avenue Gnral De Gaulle', NULL, NULL, '06140', 'VENCE', '04-12-98-79-97', '04-17-99-65-16', '1955-04-25 00:00:00.000', 0.391413, 17900, '98896807-EF15-457C-B804-B484C044CD48', 6, 1),
(1793, 'BOUSQUET', 'Luc', 'M.', '24 Cours de l''Intendance', NULL, NULL, '75014', 'PARIS', '00-10-64-49-52', '00-17-89-45-49', '1963-09-21 00:00:00.000', 0.439284, 2400, '97D0D01A-C931-49B4-A10F-B5F5052E965D', 6, 2),
(1794, 'ROSE-ROSETTE', 'Guy', 'M.', '7 Place Honor Pioch', NULL, NULL, '92100', 'BOULOGNE', '05-20-35-82-68', '05-33-99-40-88', '1945-02-26 00:00:00.000', 0.729324, 12500, '98AB50DB-74E6-487C-81E6-C0CBAB8774D3', 6, 2),
(1795, 'RIVERA', 'Daniel', 'M.', '2509 Route de Grasse', NULL, NULL, '97200', 'FORT DE FRANCE', '03-05-13-09-35', '03-67-45-49-50', '1945-05-14 00:00:00.000', 0.380149, 14200, 'D81920A6-8A3A-4EFC-9413-DD43D829CC96', 6, 2),
(1796, 'GUILLEUX', 'Michel', 'M.', '47 Rue Boulard', NULL, NULL, '06600', 'ANTIBES', '04-72-38-28-27', '04-22-23-57-91', '1952-03-10 00:00:00.000', 0.0929254, 16900, '99ADB259-8E9C-4ED8-91B4-0887877AFA72', 6, 2),
(1797, 'DUCHET', 'Daniel', 'M.', '13 Rue du Parchamp', NULL, NULL, '35330', 'MAURE DE BRETAGNE', '00-86-44-73-84', '00-60-60-38-71', '1950-05-26 00:00:00.000', 0.841961, 22600, '7D41EF0B-3515-4FE7-898F-3E25E3D4758B', 1, 2),
(1798, 'LE FUR', 'Denis', 'M.', '44 Rue Garnier Pages', NULL, NULL, '41000', 'BLOIS', NULL, '02-08-76-93-21', '1958-04-07 00:00:00.000', 0.430836, 18500, '68628038-262F-40C1-AF05-28AB5BD3E99C', 6, 2),
(1799, 'AMOROS', 'Michel', 'M.', 'Immeuble L''Anjou', '51 Bd Foch', NULL, '33000', 'BORDEAUX', '03-02-83-58-01', '03-86-80-75-75', '1956-10-18 00:00:00.000', 0.585712, 2300, '47EE6DBB-3659-4CDA-82C0-16D17E7179ED', 6, 2),
(1800, 'BONDI', 'Patricia', 'Mme.', '68 Rue de Guer', NULL, NULL, '34000', 'MONTPELLIER', '05-94-30-56-03', '05-33-62-67-46', '1952-04-28 00:00:00.000', 0.703981, 16700, '96C8C733-2116-480F-9106-EB19EA5A2A12', 6, 1);
SET IDENTITY_INSERT T_EMPLOYEE_EMP OFF;
CHECKPOINT;
GO

INSERT INTO dbo.T_EMPLOYEE_EMP
SELECT LEFT(E1.EMP_NOM, LEN(E1.EMP_NOM) / 2) + RIGHT(RTRIM(E2.EMP_NOM), LEN(RTRIM(E2.EMP_NOM)) / 2),
       E2.EMP_PRENOM, E2.EMP_TITRE, 
       E1.EMP_ADRESSE1, E1.EMP_ADRESSE2, E1.EMP_ADRESSE3,
       E2.EMP_CP, E2.EMP_VILLE, E2.EMP_GSM, E1.EMP_TEL,
       E2.EMP_DATE_ENTREE, E1.EMP_INDICE, E2.EMP_SALAIRE,
       NEWID(), E1.SRV_ID, E2.SEX_ID
FROM   dbo.T_EMPLOYEE_EMP E1
       CROSS JOIN dbo.T_EMPLOYEE_EMP E2
WHERE  E1.EMP_ID < E2.EMP_ID;

CHECKPOINT;

DELETE FROM dbo.T_EMPLOYEE_EMP
WHERE  EMP_ID > 1800
AND    EMP_ID % 5 = 0;

CHECKPOINT;

CREATE INDEX X_EMP_SRV ON T_EMPLOYEE_EMP (SRV_ID);

CREATE INDEX X_EMP_SEX ON T_EMPLOYEE_EMP (SEX_ID);

SET STATISTICS TIME ON;

-- Test sans forage
SELECT E.*
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_SERVICE_SRV AS SR
             ON E.SRV_ID = SR.SRV_ID
       INNER JOIN T_SEX AS SX
             ON E.SEX_ID = SX.SEX_ID
WHERE  SRV_LIBELLE = 'Direction'
  AND  SEX_LIBELLE = 'Femme';

-- Test avec forage
SELECT E.*
FROM T_EMPLOYEE_EMP AS E WITH (INDEX(X_EMP_SRV, X_EMP_SRV), FORCESEEK)
INNER JOIN T_SERVICE_SRV AS SR
ON E.SRV_ID = SR.SRV_ID
INNER JOIN T_SEX AS SX
ON E.SEX_ID = SX.SEX_ID
WHERE SRV_LIBELLE = 'Direction'
AND SEX_LIBELLE = 'Femme';

--> NOTA : une erreur de mise en page s'est glisse dans la version  imprime. 4 lignes ont t rptes  partir de "-- Test avec forage" (ligne incluse). Le prsent script rectifie cette erreur.